/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdAlign
extends Cmd {
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    protected int direction;

    protected static String wordFor(int n) {
        switch (n) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Lefts";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "Horizontal Centers";
            }
            case 6: {
                return "Vertical Centers";
            }
            case 7: {
                return "To Grid";
            }
        }
        return "";
    }

    public void doIt() {
        int n;
        Editor editor = Globals.curEditor();
        Vector vector = (Vector)this.getArg("figs");
        if (vector == null) {
            SelectionManager selectionManager = editor.getSelectionManager();
            if (selectionManager.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            vector = selectionManager.getFigs();
        }
        if ((n = vector.size()) == 0) {
            return;
        }
        Rectangle rectangle = ((Fig)vector.elementAt(0)).getBounds();
        int n2 = 1;
        while (n2 < n) {
            rectangle.add(((Fig)vector.elementAt(n2)).getBounds());
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Fig fig = (Fig)vector.elementAt(n2);
            fig.startTrans();
            fig.align(rectangle, this.direction, editor);
            fig.endTrans();
            ++n2;
        }
    }

    public void undoIt() {
    }

    public CmdAlign(int n) {
        super("Align " + CmdAlign.wordFor(n));
        this.direction = n;
    }
}

