/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdSave
extends Cmd
implements FilenameFilter {
    public void doIt() {
        try {
            Editor editor = Globals.curEditor();
            FileDialog fileDialog = new FileDialog(editor.findFrame(), "Save Diagram", 1);
            fileDialog.setFilenameFilter(this);
            fileDialog.setDirectory(Globals.getLastDirectory());
            fileDialog.show();
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            Globals.setLastDirectory(string2);
            if (string != null) {
                Globals.showStatus("Writing " + string2 + string + "...");
                FileOutputStream fileOutputStream = new FileOutputStream(string2 + string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                System.out.println("Cmd save...");
                editor.preSave();
                objectOutputStream.writeObject(editor);
                editor.postSave();
                System.out.println("save done");
                Globals.showStatus("Wrote " + string2 + string);
                fileOutputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
        }
    }

    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }

    public CmdSave() {
        super("Save...", false);
    }

    public CmdSave(String string) {
        this();
        this.setArg("filterPattern", string);
    }
}

