/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.FileDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.ocl.OCLExpander;
import org.tigris.gef.ocl.TemplateReader;

public class CmdSavePGML
extends Cmd
implements FilenameFilter {
    protected static Hashtable _templates = new Hashtable();
    protected static OCLExpander _expander = null;

    public void doIt() {
        _templates = TemplateReader.readFile("/org/tigris/gef/xml/dtd/PGML.tee");
        _expander = new OCLExpander(_templates);
        try {
            Editor editor = Globals.curEditor();
            Diagram diagram = new Diagram("junk", editor.getGraphModel(), (LayerPerspective)editor.getLayerManager().getActiveLayer());
            FileDialog fileDialog = new FileDialog(editor.findFrame(), "Save Diagram in PGML format", 1);
            fileDialog.setFilenameFilter(this);
            fileDialog.setDirectory(Globals.getLastDirectory());
            fileDialog.show();
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            Globals.setLastDirectory(string2);
            if (string != null) {
                Globals.showStatus("Writing " + string2 + string + "...");
                FileWriter fileWriter = new FileWriter(string2 + string);
                System.out.println("Cmd save in PGML...");
                _expander.expand(fileWriter, diagram, "", "");
                System.out.println("save done");
                Globals.showStatus("Wrote " + string2 + string);
                fileWriter.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
            iOException.printStackTrace();
        }
    }

    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSave");
    }

    public CmdSavePGML() {
        super("Save as PGML...", false);
    }

    public CmdSavePGML(String string) {
        this();
        this.setArg("filterPattern", string);
    }

    static {
        _templates = TemplateReader.readFile("/org/tigris/gef/xml/dtd/PGML.tee");
        _expander = new OCLExpander(_templates);
    }
}

