/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

public class CmdSequence
extends Cmd {
    private Vector _cmds;

    public void add(Cmd cmd) {
        this._cmds.addElement(cmd);
    }

    public String dbgString() {
        String string = "Seq: ";
        Enumeration enumeration = this._cmds.elements();
        while (enumeration.hasMoreElements()) {
            Cmd cmd = (Cmd)enumeration.nextElement();
            string = string + cmd.getName();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ", ";
        }
        return string;
    }

    public void doIt() {
        Editor editor = Globals.curEditor();
        Enumeration enumeration = this._cmds.elements();
        while (enumeration.hasMoreElements()) {
            Cmd cmd = (Cmd)enumeration.nextElement();
            editor.executeCmd(cmd, null);
        }
    }

    public void undoIt() {
        int n = this._cmds.size() - 1;
        while (n >= 0) {
            ((Cmd)this._cmds.elementAt(n)).undoIt();
            --n;
        }
    }

    public CmdSequence() {
        super("Sequence of Commands");
    }

    public CmdSequence(String string) {
        super(string);
    }

    public CmdSequence(Cmd cmd, String string) {
        super(string);
        this.add(cmd);
    }

    public CmdSequence(Cmd cmd, Cmd cmd2, String string) {
        super(string);
        this.add(cmd);
        this.add(cmd2);
    }

    public CmdSequence(Cmd cmd, Cmd cmd2, Cmd cmd3, String string) {
        super(string);
        this.add(cmd);
        this.add(cmd2);
        this.add(cmd3);
    }
}

