/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Prefs;

public class PrefsEditor
extends Frame {
    private Checkbox _tryOffScreenCB;
    private Checkbox _printGridCB;
    private Checkbox _printBackgroundCB;
    private Button _moreRepaints;
    private Button _fewerRepaints;
    private Button _close;

    public void close() {
        this.dispose();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                if (event.target != this) break;
                this.close();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        Prefs prefs = Globals.getPrefs();
        if (event.target == this._tryOffScreenCB) {
            prefs.setTryOffScreen(!prefs.getTryOffScreen());
            this._tryOffScreenCB.setState(prefs.getTryOffScreen());
            return true;
        }
        if (event.target == this._moreRepaints) {
            return true;
        }
        if (event.target == this._fewerRepaints) {
            return true;
        }
        if (event.target == this._close) {
            this.close();
            return true;
        }
        if (event.target == this._printGridCB) {
            prefs.setPrintGrid(!prefs.getPrintGrid());
            this._printGridCB.setState(prefs.getPrintGrid());
            return true;
        }
        if (event.target == this._printBackgroundCB) {
            prefs.setPrintBackground(!prefs.getPrintBackground());
            this._printBackgroundCB.setState(prefs.getPrintBackground());
            return true;
        }
        return false;
    }

    public PrefsEditor() {
        this.setTitle("Prefs");
        ((Component)this).setBackground(Color.lightGray);
        this._tryOffScreenCB = new Checkbox("Flicker-free repaint");
        this._moreRepaints = new Button("More Repaints");
        this._fewerRepaints = new Button("Fewer Repaints");
        this._printGridCB = new Checkbox("Print Grid");
        this._printBackgroundCB = new Checkbox("Print Background");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(6, 1));
        this._tryOffScreenCB.setState(Globals.getPrefs().getTryOffScreen());
        this._printGridCB.setState(Globals.getPrefs().getPrintGrid());
        this._printBackgroundCB.setState(Globals.getPrefs().getPrintBackground());
        panel.add(this._tryOffScreenCB);
        panel.add(this._moreRepaints);
        panel.add(this._fewerRepaints);
        panel.add(this._printGridCB);
        panel.add(this._printBackgroundCB);
        this.add("Center", panel);
        this._close = new Button("Close");
        Panel panel2 = new Panel();
        panel2.add("Center", this._close);
        this.add("South", panel2);
        this.pack();
    }
}

