/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionLowerRight;
import org.tigris.gef.base.SelectionMove;
import org.tigris.gef.base.SelectionNoop;
import org.tigris.gef.base.SelectionReshape;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.event.GraphSelectionEvent;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.util.VetoableChangeEventSource;

public class SelectionManager
implements Serializable,
KeyListener,
MouseListener,
MouseMotionListener {
    protected Vector _selections = new Vector();
    protected Editor _editor;
    protected EventListenerList _listeners = new EventListenerList();
    private static /* synthetic */ Class class$Lorg$tigris$gef$event$GraphSelectionListener;

    protected void addSelection(Selection selection) {
        this._selections.addElement(selection);
    }

    protected void addFig(Fig fig) {
        this._selections.addElement(SelectionManager.makeSelectionFor(fig));
    }

    protected void addAllFigs(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addFig((Fig)enumeration.nextElement());
        }
    }

    protected void removeAllElements() {
        this._selections.removeAllElements();
    }

    protected void removeSelection(Selection selection) {
        if (selection != null) {
            this._selections.removeElement(selection);
        }
    }

    protected void removeFig(Fig fig) {
        Selection selection = this.findSelectionFor(fig);
        if (selection != null) {
            this._selections.removeElement(selection);
        }
    }

    protected void allDamaged() {
        this._editor.damaged(this.getBounds());
    }

    public void select(Fig fig) {
        this.allDamaged();
        this.removeAllElements();
        this.addFig(fig);
        this._editor.damaged(fig);
        this.fireSelectionChanged();
    }

    public void deselect(Fig fig) {
        if (this.containsFig(fig)) {
            this.removeFig(fig);
            this._editor.damaged(fig);
            this.fireSelectionChanged();
        }
    }

    public void toggle(Fig fig) {
        this._editor.damaged(fig);
        if (this.containsFig(fig)) {
            this.removeFig(fig);
        } else {
            this.addFig(fig);
        }
        this._editor.damaged(fig);
        this.fireSelectionChanged();
    }

    public void deselectAll() {
        Rectangle rectangle = this.getBounds();
        this.removeAllElements();
        this._editor.damaged(rectangle);
        this.fireSelectionChanged();
    }

    public void select(Vector vector) {
        this.allDamaged();
        this.removeAllElements();
        this.addAllFigs(vector);
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public void toggle(Vector vector) {
        this.allDamaged();
        Enumeration enumeration = ((Vector)vector.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (this.containsFig(fig)) {
                this.removeFig(fig);
                continue;
            }
            this.addFig(fig);
        }
        this.allDamaged();
        this.fireSelectionChanged();
    }

    public Selection findSelectionFor(Fig fig) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            if (!selection.contains(fig)) continue;
            return selection;
        }
        return null;
    }

    public Selection findSelectionAt(int n, int n2) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            if (!selection.contains(n, n2)) continue;
            return selection;
        }
        return null;
    }

    public boolean contains(Selection selection) {
        return this._selections.contains(selection);
    }

    public boolean containsFig(Fig fig) {
        return this.findSelectionFor(fig) != null;
    }

    public boolean getLocked() {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Selection)enumeration.nextElement()).getLocked()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this._selections.size();
    }

    public Vector selections() {
        return this._selections;
    }

    public Vector getFigs() {
        Vector<Fig> vector = new Vector<Fig>(this._selections.size());
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Selection)enumeration.nextElement()).getContent());
        }
        return vector;
    }

    public void startTrans() {
        Vector vector = new Vector();
        int n = this._selections.size();
        int n2 = 0;
        while (n2 < n) {
            Selection selection = (Selection)this._selections.elementAt(n2);
            this.addEnclosed(vector, selection.getContent());
            ++n2;
        }
        n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Fig fig = (Fig)vector.elementAt(n3);
            fig.startTrans();
            ++n3;
        }
    }

    public void endTrans() {
        Vector vector = new Vector();
        int n = this._selections.size();
        int n2 = 0;
        while (n2 < n) {
            Selection selection = (Selection)this._selections.elementAt(n2);
            this.addEnclosed(vector, selection.getContent());
            ++n2;
        }
        n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Fig fig = (Fig)vector.elementAt(n3);
            fig.endTrans();
            ++n3;
        }
    }

    public void paint(Graphics graphics) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            ((Selection)enumeration.nextElement()).paint(graphics);
        }
    }

    public void damage() {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            ((Selection)enumeration.nextElement()).damage();
        }
    }

    public boolean contains(int n, int n2) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Selection)enumeration.nextElement()).contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean hit(Rectangle rectangle) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Selection)enumeration.nextElement()).hit(rectangle)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        int n = this._selections.size();
        if (n == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = ((Selection)this._selections.elementAt(0)).getBounds();
        int n2 = 1;
        while (n2 < n) {
            Selection selection = (Selection)this._selections.elementAt(n2);
            rectangle.add(selection.getBounds());
            ++n2;
        }
        return rectangle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rectangle getContentBounds() {
        Rectangle rectangle = null;
        Enumeration enumeration = this._selections.elements();
        if (!enumeration.hasMoreElements()) return new Rectangle(0, 0, 0, 0);
        rectangle = ((Selection)enumeration.nextElement()).getContentBounds();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            rectangle.add(selection.getContentBounds());
        }
        return rectangle;
    }

    public void reorder(int n, Layer layer) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            ((Selection)enumeration.nextElement()).reorder(n, layer);
        }
    }

    public void translate(int n, int n2) {
        Cloneable cloneable;
        Fig fig;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector<FigNode> vector4 = new Vector<FigNode>();
        int n3 = this._selections.size();
        int n4 = 0;
        while (n4 < n3) {
            Selection selection = (Selection)this._selections.elementAt(n4);
            this.addEnclosed(vector, selection.getContent());
            ++n4;
        }
        n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            Fig fig2 = (Fig)vector.elementAt(n5);
            if (!(fig2 instanceof FigNode)) {
                fig2.translate(n, n2);
            } else {
                fig = (FigNode)fig2;
                vector4.addElement((FigNode)fig);
                ((FigNode)fig).superTranslate(n, n2);
                cloneable = ((FigNode)fig).getFigEdges();
                int n6 = ((Vector)cloneable).size();
                int n7 = 0;
                while (n7 < n6) {
                    Object e = ((Vector)cloneable).elementAt(n7);
                    if (vector2.contains(e) && !vector3.contains(e)) {
                        vector3.addElement(e);
                    } else {
                        vector2.addElement(e);
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        n5 = vector3.size();
        int n8 = 0;
        while (n8 < n5) {
            fig = (FigEdge)vector3.elementAt(n8);
            ((FigEdge)fig).translateEdge(n, n2);
            ++n8;
        }
        n8 = vector4.size();
        int n9 = 0;
        while (n9 < n8) {
            cloneable = (FigNode)vector4.elementAt(n9);
            ((FigNode)cloneable).updateEdges();
            ++n9;
        }
    }

    protected void addEnclosed(Vector vector, Fig fig) {
        if (!vector.contains(fig)) {
            vector.addElement(fig);
            Vector vector2 = fig.getEnclosedFigs();
            if (vector2 != null) {
                int n = vector2.size();
                int n2 = 0;
                while (n2 < n) {
                    this.addEnclosed(vector, (Fig)vector2.elementAt(n2));
                    ++n2;
                }
            }
        }
    }

    public void hitHandle(Rectangle rectangle, Handle handle) {
        if (this.size() == 1) {
            ((Selection)this._selections.firstElement()).hitHandle(rectangle, handle);
        } else {
            handle.index = -1;
        }
    }

    public void dragHandle(int n, int n2, int n3, int n4, Handle handle) {
        if (this.size() != 1) {
            return;
        }
        Selection selection = (Selection)this._selections.firstElement();
        selection.dragHandle(n, n2, n3, n4, handle);
    }

    public void cleanUp() {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            Fig fig = selection.getContent();
            fig.cleanUp();
        }
    }

    public void delete() {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((Selection)enumeration.nextElement()).delete();
        }
    }

    public void dispose() {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            Fig fig = selection.getContent();
            Object object = fig.getOwner();
            if (!(object instanceof VetoableChangeEventSource)) continue;
            Vector vector = (Vector)((VetoableChangeEventSource)object).getVetoableChangeListeners().clone();
            Enumeration enumeration2 = vector.elements();
            enumeration2 = vector.elements();
            Object var7_7 = null;
            boolean bl = true;
            while (enumeration2.hasMoreElements()) {
                Object e = enumeration2.nextElement();
                if (!(e instanceof Fig)) continue;
                if (bl) {
                    var7_7 = e;
                    bl = false;
                    continue;
                }
                ((Fig)e).delete();
            }
            ((Fig)var7_7).dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !keyEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).keyTyped(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !keyEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).keyPressed(keyEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseMoved(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Enumeration enumeration = this._selections.elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseDragged(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseReleased(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseExited(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Enumeration enumeration = ((Vector)this._selections.clone()).elements();
        while (enumeration.hasMoreElements() && !mouseEvent.isConsumed()) {
            ((Selection)enumeration.nextElement()).mouseEntered(mouseEvent);
        }
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._listeners.add(class$Lorg$tigris$gef$event$GraphSelectionListener != null ? class$Lorg$tigris$gef$event$GraphSelectionListener : (class$Lorg$tigris$gef$event$GraphSelectionListener = SelectionManager.class$("org.tigris.gef.event.GraphSelectionListener")), graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._listeners.remove(class$Lorg$tigris$gef$event$GraphSelectionListener != null ? class$Lorg$tigris$gef$event$GraphSelectionListener : (class$Lorg$tigris$gef$event$GraphSelectionListener = SelectionManager.class$("org.tigris.gef.event.GraphSelectionListener")), graphSelectionListener);
    }

    protected void fireSelectionChanged() {
        Object[] objectArray = this._listeners.getListenerList();
        GraphSelectionEvent graphSelectionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$Lorg$tigris$gef$event$GraphSelectionListener != null ? class$Lorg$tigris$gef$event$GraphSelectionListener : SelectionManager.class$("org.tigris.gef.event.GraphSelectionListener"))) {
                if (graphSelectionEvent == null) {
                    graphSelectionEvent = new GraphSelectionEvent(this._editor, this.getFigs());
                }
                ((GraphSelectionListener)objectArray[n + 1]).selectionChanged(graphSelectionEvent);
            }
            n -= 2;
        }
        this.updatePropertySheet();
    }

    public void updatePropertySheet() {
    }

    public static Selection makeSelectionFor(Fig fig) {
        Selection selection = fig.makeSelection();
        if (selection != null) {
            return selection;
        }
        if (fig.isReshapable()) {
            return new SelectionReshape(fig);
        }
        if (fig.isLowerRightResizable()) {
            return new SelectionLowerRight(fig);
        }
        if (fig.isResizable()) {
            return new SelectionResize(fig);
        }
        if (fig.isMovable()) {
            return new SelectionMove(fig);
        }
        return new SelectionNoop(fig);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SelectionManager(Editor editor) {
        this._editor = editor;
    }
}

