/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class PostscriptWriter
extends Graphics {
    private static final String ellipseDef = "%%BeginProcSet: ellipse 1.0 0 \n/ellipsedict 8 dict def \nellipsedict /mtrx matrix put \n/ellipse { ellipsedict begin \n/endangle exch def \n/startangle exch def \n/yrad exch def \n/xrad exch def \n/y exch def \n/x exch def \n/savematrix mtrx currentmatrix def \nx y translate \nxrad yrad scale \n0 0 1 0 360 arc \nsavematrix setmatrix end } def \n%%EndProcSet: ellipse 1.0 0 \n";
    private static final String reencodeDef = "%%BeginProcSet: reencode 1.0 0 \n/RE \n{  findfont begin \n  currentdict dup length dict begin \n  {1 index /FID ne {def} {pop pop} ifelse} forall \n  /FontName exch def dup length 0 ne \n  { /Encoding Encoding 256 array copy def \n      0 exch \n      { dup type /nametype eq \n        { Encoding 2 index 2 index put \n          pop 1 add \n        } \n        { exch pop \n        } ifelse \n      } forall \n  } if pop \n  currentdict dup end end \n  /FontName get exch definefont pop \n    } bind def \n%%EndProcSet: reencode 1.0 0 \n";
    private static final String isolatin1encoding = "/isolatin1encoding \n[ 32 /space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quoteright \n /parenleft /parenright /asterisk /plus /comma /hyphen /period /slash /zero /one \n /two /three /four /five /six /seven /eight /nine /colon /semicolon \n /less /equal /greater /question /at /A /B /C /D /E \n /F /G /H /I /J /K /L /M /N /O \n /P /Q /R /S /T /U /V /W /X /Y \n /Z /bracketleft /backslash /bracketright /asciicircum /underscore /quoteleft /a /b /c \n /d /e /f /g /h /i /j /k /l /m \n /n /o /p /q /r /s /t /u /v /w \n /x /y /z /braceleft /bar /braceright /asciitilde /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /space /exclamdown /cent /sterling /currency /yen /brokenbar /section /dieresis /copyright \n /ordfeminine /guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior \n /acute /mu /paragraph /periodcentered /cedilla /onesuperior /ordmasculine /guillemotright /onequarter /onehalf \n /threequarters /questiondown /Agrave /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Ccedilla \n /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute /Icircumflex /Idieresis /Eth /Ntilde \n /Ograve /Oacute /Ocircumflex /Otilde /Odieresis /multiply /Oslash /Ugrave /Uacute /Ucircumflex \n /Udieresis /Yacute /Thorn /germandbls /agrave /aacute /acircumflex /atilde /adieresis /aring \n /ae /ccedilla /egrave /eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis \n /eth /ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide /oslash /ugrave \n /uacute /ucircumflex /udieresis /yacute /thorn /ydieresis] def \n";
    private PrintWriter p;
    private boolean autoClose = false;
    private Color fColor = null;
    private Font fFont = null;
    private Rectangle clip;
    private Hashtable fontmap = new Hashtable();
    private Hashtable colormap = new Hashtable();

    public Graphics create() {
        return this;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        return this;
    }

    public void dispose() {
        this.p.println("showpage");
        this.p.println("%%Trailer");
        if (this.autoClose) {
            this.p.close();
        } else {
            this.p.flush();
        }
    }

    public void setColorConversion(Color color, Color color2) {
        this.colormap.put(color, color2);
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
        Color color2 = (Color)this.colormap.get(color);
        if (color2 != null) {
            color = color2;
        }
        if (color.equals(this.fColor)) {
            return;
        }
        this.fColor = color;
        float f = 255.0f;
        this.p.print((float)color.getRed() / 255.0f + " ");
        this.p.print((float)color.getGreen() / 255.0f + " ");
        this.p.print((float)color.getBlue() / 255.0f + " ");
        this.p.println("setrgbcolor");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        if (!font.equals(this.fFont)) {
            this.fFont = font;
            FontMetrics fontMetrics = this.getFontMetrics();
            String string = font.getName();
            if (this.fontmap.containsKey(string)) {
                string = (String)this.fontmap.get(string);
            }
            if (font.isBold() || font.isItalic()) {
                string = string + "-";
                if (font.isBold()) {
                    string = string + "Bold";
                }
                if (font.isItalic()) {
                    string = string + "Oblique";
                }
            }
            this.p.println("isolatin1encoding /_" + string + " /" + string + " RE");
            this.p.println("/_" + string + " findfont");
            this.p.println(font.getSize() + " scalefont setfont");
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.fFont);
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.clip;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    private void handlesinglepixel(int n, int n2, int n3) {
        if ((n3 >> 24 & 0xFF) == 0) {
            n3 = 0xFFFFFF;
        }
        this.p.print(Integer.toHexString(n3 >> 20 & 0xF) + Integer.toHexString(n3 >> 12 & 0xF) + Integer.toHexString(n3 >> 4 & 0xF));
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        int n5 = image.getWidth(imageObserver);
        int n6 = image.getHeight(imageObserver);
        this.p.println("gsave");
        this.writeCoords(n, n2 + n4);
        this.p.println("translate");
        this.writeCoords(n3, -n4);
        this.p.println("scale");
        this.p.println("/DatenString " + n5 + " string def");
        this.writeCoords(n5, -n6);
        this.p.println("4 [" + n5 + " 0 0 " + -n6 + " 0 " + n6 + "]");
        this.p.println("{currentfile DatenString readhexstring pop} bind");
        this.p.println("false 3 colorimage");
        int[] nArray = new int[n5 * n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n5, n6, nArray, 0, n5);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                this.handlesinglepixel(n8, n7, nArray[n7 * n5 + n8]);
                ++n8;
            }
            if (n5 % 2 == 1) {
                this.p.print("0");
            }
            this.p.println();
            ++n7;
        }
        if (n6 % 2 == 1) {
            n7 = 0;
            while (n7 < 3 * (n5 + n5 % 2)) {
                this.p.print("0");
                ++n7;
            }
            this.p.println();
        }
        this.p.println("grestore");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    private void writeCoords(int n, int n2) {
        this.p.print(n + " " + -n2 + " ");
    }

    private void writeRectanglePath(int n, int n2, int n3, int n4) {
        this.p.println("newpath");
        this.writeCoords(n, n2);
        this.p.println("moveto");
        this.writeCoords(n3 - 1, 0);
        this.p.println("rlineto");
        this.writeCoords(0, n4 - 1);
        this.p.println("rlineto");
        this.writeCoords(-(n3 - 1), 0);
        this.p.println("rlineto");
        this.p.println("closepath");
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.writeRectanglePath(n, n2, n3 + 1, n4 + 1);
        this.p.println("stroke");
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.writeRectanglePath(n, n2, n3, n4);
        this.p.println("eofill");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.writeRectanglePath(n, n2, n3, n4);
        this.setColor(Color.white);
        this.p.println("eofill");
    }

    private void writeEllipsePath(int n, int n2, int n3, int n4, int n5, int n6) {
        this.p.println("newpath");
        int n7 = n3 / 2;
        int n8 = n4 / 2;
        this.writeCoords(n + n7, n2 + n8);
        this.writeCoords(n7, n8);
        this.writeCoords(n5, -(n5 + n6));
        this.p.println("ellipse");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.writeEllipsePath(n, n2, n3 + 1, n4 + 1, 0, 360);
        this.p.println("stroke");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.writeEllipsePath(n, n2, n3, n4, 0, 360);
        this.p.println("eofill");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeEllipsePath(n, n2, n3 + 1, n4 + 1, n5, n6);
        this.p.println("stroke");
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeEllipsePath(n, n2, n3, n4, n5, n6);
        this.p.println("eofill");
    }

    private void writeRoundRectPath(int n, int n2, int n3, int n4, int n5, int n6) {
        String string = Math.min(n5, n6) + " arcto 4 {pop} repeat";
        this.p.println("newpath");
        this.writeCoords(n, n2 + n6);
        this.p.println("moveto");
        this.writeCoords(n, n2);
        this.writeCoords(n + n5, n2);
        this.p.println(string);
        this.writeCoords(n + n3, n2);
        this.writeCoords(n + n3, n2 + n6);
        this.p.println(string);
        this.writeCoords(n + n3, n2 + n4);
        this.writeCoords(n + n3 - n5, n2 + n4);
        this.p.println(string);
        this.writeCoords(n, n2 + n4);
        this.writeCoords(n, n2 + n4 - n6);
        this.p.println(string);
        this.p.println("closepath");
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeRoundRectPath(n, n2, n3 + 1, n4 + 1, n5, n6);
        this.p.println("stroke");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.writeRoundRectPath(n, n2, n3, n4, n5, n6);
        this.p.println("eofill");
    }

    private void writePolyLinePath(int[] nArray, int[] nArray2, int n) {
        this.p.println("newpath");
        int n2 = 0;
        while (n2 < n) {
            this.writeCoords(nArray[n2], nArray2[n2]);
            if (n2 == 0) {
                this.p.println("moveto");
            } else {
                this.p.println("lineto");
            }
            ++n2;
        }
    }

    public void writePolygonPath(int[] nArray, int[] nArray2, int n) {
        this.writePolyLinePath(nArray, nArray2, n);
        this.p.println("closepath");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.writePolygonPath(nArray, nArray2, n);
        this.p.println("stroke");
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.writePolygonPath(nArray, nArray2, n);
        this.p.println("eofill");
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.writePolyLinePath(nArray, nArray2, n);
        this.p.println("stroke");
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.p.println("newpath");
        this.writeCoords(n, n2);
        this.p.println("moveto");
        this.writeCoords(n3, n4);
        this.p.println("lineto");
        this.p.println("stroke");
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.clip = new Rectangle(n, n2, n3, n4);
        this.writeRectanglePath(n, n2, n3, n4);
        this.p.println("clip");
    }

    public void setClip(Shape shape) {
        this.setClip(shape.getBounds());
    }

    public void translate(int n, int n2) {
        this.writeCoords(n, -n2);
        this.p.println("translate");
    }

    public void scale(double d, double d2) {
        this.p.println(d + " " + d2 + " scale");
    }

    public void drawString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n3);
            if (c >= '\u00c0' && c < '\u0100') {
                stringBuffer.setCharAt(n3, '\\');
                String string2 = Integer.toOctalString(c);
                stringBuffer.insert(n3 + 1, string2);
                n3 += string2.length();
            } else if (c == '\\' || c == '(' || c == ')') {
                stringBuffer.insert(n3++, '\\');
            }
            ++n3;
        }
        this.writeCoords(n, n2);
        this.p.println("moveto");
        this.p.println("(" + stringBuffer.toString() + ") show");
    }

    public void comment(String string) {
        this.p.println("% " + string);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        throw new RuntimeException("Not supported.");
    }

    public PostscriptWriter(String string) throws IOException {
        this(string, null);
    }

    public PostscriptWriter(String string, Rectangle rectangle) throws IOException {
        this(new FileOutputStream(string), rectangle);
        this.autoClose = true;
    }

    public PostscriptWriter(OutputStream outputStream) throws IOException {
        this(outputStream, null);
    }

    public PostscriptWriter(OutputStream outputStream, Rectangle rectangle) throws IOException {
        this.fontmap.put("Dialog", "Helvetica");
        this.fontmap.put("SansSerif", "Helvetica");
        this.fontmap.put("DialogInput", "Monospaced");
        this.p = new PrintWriter(outputStream);
        if (rectangle == null) {
            this.p.println("%!PS-Adobe-3.0");
        } else {
            this.p.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.p.println("%%BoundingBox: " + rectangle.x + " " + rectangle.y + " " + (rectangle.x + rectangle.width) + " " + (rectangle.y + rectangle.height));
        }
        this.p.print(reencodeDef);
        this.p.print(ellipseDef);
        this.p.println("%%EndProlog");
        this.p.println("%%BeginSetup");
        this.p.print(isolatin1encoding);
        this.p.println("%%EndSetup");
        this.p.println("1 setlinewidth");
        this.setFont(new Font("Helvetica", 0, 12));
        this.setColor(Color.black);
        if (rectangle != null) {
            this.translate(0, rectangle.height + 2 * rectangle.y);
        }
    }
}

