/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGWriter
extends Graphics {
    private PrintWriter p;
    Document svg;
    Element root;
    private Color fColor = Color.black;
    private Font fFont = new Font("Helvetica", 0, 12);
    private Rectangle clip;
    private int xOffset = 0;
    private int yOffset = 0;
    private double xScale = 1.0;
    private double yScale = 1.0;

    public Graphics create() {
        return this;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        return this;
    }

    public void dispose() {
        this.svg.appendChild(this.root);
        this.printDOMTree(this.svg);
        this.p.close();
    }

    public void printDOMTree(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.p.println("<?xml version=\"1.0\" ?>");
                this.p.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000303 Stylable//EN\" \"svg-20000303-stylable.dtd\">");
                this.printDOMTree(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                this.p.print("<");
                this.p.print(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    this.p.print(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                    ++n;
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() > 0) {
                    this.p.println(">");
                    int n2 = nodeList.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        this.printDOMTree(nodeList.item(n3));
                        ++n3;
                    }
                    this.p.print("</");
                    this.p.print(node.getNodeName());
                    this.p.println('>');
                    break;
                }
                this.p.println("/>");
                break;
            }
            case 5: {
                this.p.print("&");
                this.p.print(node.getNodeName());
                this.p.print(";");
                break;
            }
            case 4: {
                this.p.print("<![CDATA[");
                this.p.print(node.getNodeValue());
                this.p.print("]]>");
                break;
            }
            case 3: {
                this.p.print(node.getNodeValue());
                break;
            }
            case 7: {
                this.p.print("<?");
                this.p.print(node.getNodeName());
                String string = node.getNodeValue();
                this.p.print("");
                this.p.print(string);
                this.p.print("?>");
                break;
            }
        }
    }

    public Color getColor() {
        return this.fColor;
    }

    public void setColor(Color color) {
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.clip;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.clip;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    private int scaleX(int n) {
        return (int)((double)n * this.xScale);
    }

    private int scaleY(int n) {
        return (int)((double)n * this.yScale);
    }

    private int transformX(int n) {
        return this.scaleX(n) + this.xOffset;
    }

    private int transformY(int n) {
        return this.scaleY(n) + this.yOffset;
    }

    private void drawRect(int n, int n2, int n3, int n4, String string) {
        Element element = this.svg.createElement("rect");
        element.setAttribute("x", "" + this.transformX(n));
        element.setAttribute("y", "" + this.transformY(n2));
        element.setAttribute("width", "" + this.scaleX(n3));
        element.setAttribute("height", "" + this.scaleY(n4));
        element.setAttribute("style", string);
        this.root.appendChild(element);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawRect(n, n2, n3, n4, "fill:white; stroke:black; stroke-width:1");
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.drawRect(n, n2, n3, n4, "fill:black; stroke:black; stroke-width:1");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.drawRect(n, n2, n3, n4, "fill:white; stroke:white; stroke-width:1");
    }

    private void writeEllipsePath(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private void drawOval(int n, int n2, int n3, int n4, String string) {
        Element element = this.svg.createElement("ellipse");
        element.setAttribute("cx", "" + this.transformX(n));
        element.setAttribute("cy", "" + this.transformY(n2));
        element.setAttribute("rx", "" + (double)this.scaleX(n3) / 2.0);
        element.setAttribute("ry", "" + (double)this.scaleY(n4) / 2.0);
        element.setAttribute("style", string);
        this.root.appendChild(element);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawOval(n, n2, n3, n4, "fill:white; stroke:black; stroke-width:1");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.drawOval(n, n2, n3, n4, "fill:black; stroke:black; stroke-width:1");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    private void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        Element element = this.svg.createElement("rect");
        element.setAttribute("x", "" + this.transformX(n));
        element.setAttribute("y", "" + this.transformY(n2));
        element.setAttribute("width", "" + this.scaleX(n3));
        element.setAttribute("height", "" + this.scaleY(n4));
        element.setAttribute("rx", "" + this.scaleX(n5));
        element.setAttribute("ry", "" + this.scaleY(n6));
        element.setAttribute("style", string);
        this.root.appendChild(element);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(n, n2, n3, n4, n5, n6, "fill:white; stroke:black; stroke-width:1");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(n, n2, n3, n4, n5, n6, "fill:black; stroke:black; stroke-width:1");
    }

    private void drawPolygon(int[] nArray, int[] nArray2, int n, String string) {
        Element element = this.svg.createElement("polygon");
        element.setAttribute("style", string);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("" + this.transformX(nArray[n2]) + "," + this.transformY(nArray2[n2]));
            ++n2;
        }
        element.setAttribute("points", stringBuffer.toString());
        this.root.appendChild(element);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(nArray, nArray2, n, "fill:white; stroke:black; stroke-width:1");
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(nArray, nArray2, n, "fill:black; stroke:black; stroke-width:1");
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Element element = this.svg.createElement("polyline");
        element.setAttribute("style", "fill:white; stroke:black; stroke-width:1");
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("" + this.transformX(nArray[n2]) + "," + this.transformY(nArray2[n2]));
            ++n2;
        }
        element.setAttribute("points", stringBuffer.toString());
        this.root.appendChild(element);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        Element element = this.svg.createElement("line");
        element.setAttribute("x1", "" + this.transformX(n));
        element.setAttribute("y1", "" + this.transformY(n2));
        element.setAttribute("x2", "" + this.transformX(n3));
        element.setAttribute("y2", "" + this.transformY(n4));
        element.setAttribute("style", "fill:black; stroke:black; stroke-width:1");
        this.root.appendChild(element);
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public void setClip(Shape shape) {
        this.setClip(shape.getBounds());
    }

    public void translate(int n, int n2) {
        this.xOffset = n;
        this.yOffset = n2;
    }

    public void scale(double d, double d2) {
        this.xScale = d;
        this.yScale = d2;
    }

    public void drawString(String string, int n, int n2) {
        Element element = this.svg.createElement("text");
        element.setAttribute("x", "" + this.transformX(n));
        element.setAttribute("y", "" + this.transformY(n2));
        element.appendChild(this.svg.createTextNode(string));
        this.root.appendChild(element);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    public void drawString(CharacterIterator characterIterator, int n, int n2) {
    }

    public SVGWriter(OutputStream outputStream) throws IOException, Exception {
        this.p = new PrintWriter(outputStream);
        this.svg = (Document)Class.forName("com.ibm.xml.dom.DocumentImpl").newInstance();
        this.root = this.svg.createElement("svg");
        this.root.setAttribute("width", "600");
        this.root.setAttribute("height", "600");
    }
}

