/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.BitSet;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class FigSpline
extends FigPoly {
    protected int[] _xknots = new int[5];
    protected int[] _yknots = new int[5];
    protected int _nknots;
    protected Polygon _curve;
    protected int _threshold = 5;
    protected int SPLINE_THRESH = 2;
    protected int ARR_WIDTH = 5;
    protected int ARR_HEIGHT = 16;
    protected double _junc_t;
    protected double _delta0;
    protected double _delta1;
    protected double _denom;
    protected double _d_curve_length;
    protected int _juncX;
    protected int _juncY;
    protected int _pattern = -2004318072;
    protected BitSet _style = new BitSet(32);

    public void addPoint(int n, int n2) {
        super.addPoint(n, n2);
        this.setCount();
        this.setSpline();
    }

    public void appendTwoPoints() {
        super.appendTwoPoints();
        this.setCount();
        this.setSpline();
    }

    public void cleanUp() {
    }

    private double dist(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    private double dist(int n, int n2, int n3, int n4) {
        double d = n - n3;
        double d2 = n2 - n4;
        return Math.sqrt(d * d + d2 * d2);
    }

    protected void drawBezier(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n + n3) / 2;
        int n8 = (n2 + n4) / 2;
        int n9 = (n3 + n5) / 2;
        int n10 = (n4 + n6) / 2;
        int n11 = (n7 + n9) / 2;
        int n12 = (n8 + n10) / 2;
        int n13 = (n + n11) / 2;
        int n14 = (n2 + n12) / 2;
        if (Math.abs(n7 - n13) + Math.abs(n8 - n14) > this.SPLINE_THRESH) {
            this.drawBezier(graphics, n, n2, n7, n8, n11, n12);
        } else {
            graphics.drawLine(n, n2, n11, n12);
            this._curve.addPoint(n11, n12);
        }
        n13 = (n5 + n11) / 2;
        n14 = (n6 + n12) / 2;
        if (Math.abs(n9 - n13) + Math.abs(n10 - n14) > this.SPLINE_THRESH) {
            this.drawBezier(graphics, n11, n12, n9, n10, n5, n6);
        } else {
            graphics.drawLine(n11, n12, n5, n6);
            this._curve.addPoint(n5, n6);
        }
    }

    protected void drawCurve(Graphics graphics) {
        int n = this._npoints - 2;
        this._curve = new Polygon();
        graphics.setColor(this._lineColor);
        int n2 = 0;
        while (n2 <= n - 1) {
            this.drawBezier(graphics, this._xknots[2 * n2], this._yknots[2 * n2], this._xknots[2 * n2 + 1], this._yknots[2 * n2 + 1], this._xknots[2 * n2 + 2], this._yknots[2 * n2 + 2]);
            ++n2;
        }
        if (this._filled) {
            graphics.setColor(this._fillColor);
            graphics.fillPolygon(this._curve);
            graphics.setColor(this._lineColor);
            graphics.drawPolyline(this._curve.xpoints, this._curve.ypoints, this._curve.npoints);
        }
    }

    protected void drawStraight(Graphics graphics) {
        graphics.setColor(this._lineColor);
        graphics.drawLine(this._xknots[0], this._yknots[0], this._xknots[1], this._yknots[1]);
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] nArray = new int[this._npoints * 2];
            System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
            this._xpoints = nArray;
            nArray = new int[this._npoints * 2];
            System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
            this._ypoints = nArray;
            nArray = new int[this._npoints * 4 - 1];
            System.arraycopy(this._xknots, 0, nArray, 0, this._nknots);
            this._xknots = nArray;
            nArray = new int[this._npoints * 4 - 1];
            System.arraycopy(this._yknots, 0, nArray, 0, this._nknots);
            this._yknots = nArray;
        }
    }

    public void insertPoint(int n, int n2, int n3) {
        super.insertPoint(n, n2, n3);
        this.setCount();
        this.setSpline();
    }

    public void moveVertex(Handle handle, int n, int n2, boolean bl) {
        super.moveVertex(handle, n, n2, bl);
        this.setSpline();
    }

    public void paint(Graphics graphics) {
        if (this._npoints == 2) {
            this.drawStraight(graphics);
        } else {
            this.drawCurve(graphics);
        }
    }

    public void prependTwoPoints() {
        super.prependTwoPoints();
        this.setCount();
        this.setSpline();
    }

    public void removePoint(int n) {
        super.removePoint(n);
        this.setCount();
        this.setSpline();
    }

    protected void setCount() {
        if (this._npoints == 2) {
            this._nknots = 2;
        } else if (this._npoints == 3) {
            this._nknots = 3;
        }
        this._nknots = 2 * this._npoints - 3;
    }

    protected void setJunctionPoint(int n, int n2, int n3, int n4, int n5, int n6) {
        this._delta0 = this.dist(n, n2, n3, n4);
        this._delta1 = this.dist(n3, n4, n5, n6);
        this._denom = this._delta0 + this._delta1;
        this._junc_t = this._denom <= (double)this._threshold ? 0.0 : this._delta1 / this._denom;
        this._juncX = (int)(this._junc_t * (double)n3 + (1.0 - this._junc_t) * (double)n5);
        this._juncY = (int)(this._junc_t * (double)n4 + (1.0 - this._junc_t) * (double)n6);
    }

    protected void setSpline() {
        block4: {
            block3: {
                if (this._npoints < 4) break block3;
                this._xknots[0] = this._xpoints[0];
                this._yknots[0] = this._ypoints[0];
                this._xknots[this._nknots - 1] = this._xpoints[this._npoints - 1];
                this._yknots[this._nknots - 1] = this._ypoints[this._npoints - 1];
                int n = 0;
                while (n <= this._npoints - 4) {
                    this.setJunctionPoint(this._xpoints[n], this._ypoints[n], this._xpoints[n + 1], this._ypoints[n + 1], this._xpoints[n + 2], this._ypoints[n + 2]);
                    this._xknots[2 * (n + 1)] = this._juncX;
                    this._yknots[2 * (n + 1)] = this._juncY;
                    ++n;
                }
                n = 1;
                while (n <= this._npoints - 2) {
                    this._xknots[2 * n - 1] = this._xpoints[n];
                    this._yknots[2 * n - 1] = this._ypoints[n];
                    ++n;
                }
                break block4;
            }
            if (this._npoints >= 4) break block4;
            int n = 0;
            while (n < this._npoints) {
                this._xknots[n] = this._xpoints[n];
                this._yknots[n] = this._ypoints[n];
                ++n;
            }
        }
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.setSpline();
    }

    public FigSpline() {
    }

    public FigSpline(int n, int n2) {
        this.addPoint(n, n2);
    }

    public FigSpline(Color color) {
        super(color);
    }

    public FigSpline(Color color, Color color2) {
        super(color, color2);
    }
}

