/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigris.gef.properties.ui.PropSheet;
import org.tigris.gef.properties.ui.PropSheetCategory;

public class TabPropFrame
extends JFrame
implements ChangeListener,
ActionListener {
    private PropSheet _lastPropSheet = null;
    private int _lastTab = -1;
    private Vector _sheets = new Vector();
    private JTabbedPane tabPanel;
    private Panel choicePanel;
    private PropSheetCategory PropSheetCategory1;
    private PropSheetCategory PropSheetCategory2;
    private PropSheetCategory PropSheetCategory3;
    private PropSheetCategory PropSheetCategory4;
    private PropSheetCategory PropSheetCategory5;
    private JPanel buttonPanel;
    private JCheckBox autoApplyCheckbox;
    private JButton applyButton;
    private JButton revertButton;
    private JButton closeButton;
    protected Object _selection = null;

    public Component getCurrentSheet() {
        return this.tabPanel.getSelectedComponent();
    }

    public void addPropSheet(PropSheet propSheet) {
        if (this.tabPanel == null) {
            return;
        }
        int n = this.tabPanel.getTabCount();
        this.tabPanel.addTab(propSheet.getTabName(), propSheet);
        this.tabPanel.setEnabledAt(n, propSheet.canEdit(this._selection));
        String string = propSheet.getTabName();
        this._sheets.addElement(propSheet);
    }

    public synchronized void setVisible(boolean bl) {
        ((Component)this).setLocation(50, 50);
        super.setVisible(bl);
    }

    public void select(Object object) {
        if (object != this._selection) {
            this._selection = object;
            this.updateTabs();
            this.updateCurSheet();
            this.setTitle("Properties - " + (object == null ? "(nothing)" : object.toString()));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.closeButton_Clicked(actionEvent);
        }
        if (object == this.applyButton) {
            this.applyButton_Clicked(actionEvent);
        }
        if (object == this.revertButton) {
            this.revertButton_Clicked(actionEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.autoApplyCheckbox) {
            this.autoApplyCheckbox_Action(changeEvent);
        }
        if (object == this.tabPanel) {
            this.updateCurSheet();
        }
    }

    void tabPanel_Action(Event event) {
        this.updateCurSheet();
    }

    protected void autoApplyCheckbox_Action(ChangeEvent changeEvent) {
        this.applyButton.setEnabled(!this.autoApplyCheckbox.isSelected());
        this.revertButton.setEnabled(!this.autoApplyCheckbox.isSelected());
        Component component = this.getCurrentSheet();
        if (component instanceof PropSheet) {
            ((PropSheet)component).setAutoApply(this.autoApplyCheckbox.isSelected());
        }
    }

    void closeButton_Clicked(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    void applyButton_Clicked(ActionEvent actionEvent) {
        Component component = this.getCurrentSheet();
        if (component instanceof PropSheet) {
            ((PropSheet)component).apply();
        }
    }

    void revertButton_Clicked(ActionEvent actionEvent) {
        Component component = this.getCurrentSheet();
        if (component instanceof PropSheet) {
            ((PropSheet)component).revert();
        }
    }

    public void updateTabs() {
        try {
            int n = -1;
            int n2 = this.tabPanel.getTabCount();
            int n3 = 0;
            while (n3 < n2) {
                if (this.updateTabEnabled(n3) && n == -1) {
                    n = n3;
                }
                ++n3;
            }
            n3 = this.tabPanel.getSelectedIndex();
            if (n3 < 0 && n != -1) {
                this.tabPanel.setSelectedIndex(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean updateTabEnabled(int n) {
        try {
            Component component = this.tabPanel.getComponentAt(n);
            boolean bl = component instanceof PropSheet ? ((PropSheet)component).canEdit(this._selection) : true;
            this.tabPanel.setEnabledAt(n, bl);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void updateCurSheet() {
        int n = this.tabPanel.getSelectedIndex();
        Component component = this.tabPanel.getSelectedComponent();
        if (component instanceof PropSheet) {
            PropSheet propSheet = (PropSheet)component;
            propSheet.setSelection(this._selection);
            if (this._lastPropSheet != propSheet && this._lastPropSheet != null) {
                this._lastPropSheet.setSelection(null);
            }
            this._lastTab = n;
            this._lastPropSheet = propSheet;
        }
    }

    public static void main(String[] stringArray) {
        TabPropFrame tabPropFrame = new TabPropFrame();
        tabPropFrame.setVisible(true);
    }

    public TabPropFrame() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.addNotify();
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + 300, insets.top + insets.bottom + 406);
        this.getContentPane().setFont(new Font("Dialog", 0, 10));
        this.getContentPane().setBackground(new Color(0xC0C0C0));
        this.tabPanel = new JTabbedPane();
        this.tabPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.tabPanel, "Center");
        this.PropSheetCategory1 = new PropSheetCategory(this);
        this.PropSheetCategory1.setBounds(12, 33, 276, 307);
        this.PropSheetCategory2 = new PropSheetCategory(this);
        this.PropSheetCategory2.setBounds(12, 33, 276, 307);
        this.PropSheetCategory3 = new PropSheetCategory(this);
        this.PropSheetCategory3.setBounds(12, 33, 276, 307);
        this.PropSheetCategory4 = new PropSheetCategory(this);
        this.PropSheetCategory4.setBounds(12, 33, 276, 307);
        this.PropSheetCategory5 = new PropSheetCategory(this);
        this.PropSheetCategory5.setBounds(12, 33, 276, 307);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.buttonPanel.setBounds(this.getInsets().left, this.getInsets().top + 375, 300, 31);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.autoApplyCheckbox = new JCheckBox("AutoApply");
        this.autoApplyCheckbox.setBounds(66, 5, 78, 21);
        this.autoApplyCheckbox.setSelected(true);
        this.autoApplyCheckbox.addChangeListener(this);
        this.buttonPanel.add(this.autoApplyCheckbox);
        this.applyButton = new JButton("Apply");
        this.applyButton.setBounds(149, 5, 40, 21);
        this.applyButton.setEnabled(false);
        this.buttonPanel.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.revertButton = new JButton("Revert");
        this.revertButton.setBounds(149, 5, 40, 21);
        this.revertButton.setEnabled(false);
        this.revertButton.addActionListener(this);
        this.revertButton.setEnabled(false);
        this.buttonPanel.add(this.revertButton);
        this.closeButton = new JButton("Close");
        this.closeButton.setBounds(194, 5, 40, 21);
        this.closeButton.addActionListener(this);
        this.setTitle("Props");
        this.PropSheetCategory1.setCategory("Geometry");
        this.PropSheetCategory2.setCategory("Text");
        this.PropSheetCategory3.setCategory("Style");
        this.PropSheetCategory4.setCategory("Model");
        this.PropSheetCategory5.setCategory("All");
        this.addPropSheet(this.PropSheetCategory4);
        this.addPropSheet(this.PropSheetCategory1);
        this.addPropSheet(this.PropSheetCategory2);
        this.addPropSheet(this.PropSheetCategory3);
        this.addPropSheet(this.PropSheetCategory5);
        this.tabPanel.setSelectedIndex(0);
    }

    public TabPropFrame(String string) {
        this();
        this.setTitle(string);
    }
}

