/*
 * Decompiled with CFR 0.152.
 */
package bibTEP;

import bibTEP.Alphas;
import bibTEP.CpGeneralisee;
import bibTEP.ELVComposition;
import bibTEP.EnthalpieEntropie;
import bibTEP.Modeles;
import bibTEP.MonoPhaseException;
import bibTEP.ResultatCardan;
import bibTEP.SolutionR;
import bibTEP.TEPbibSubstance;
import extThopt.Util;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MixTEPbibSubstance
extends TEPbibSubstance {
    double PaToBar = 100000.0;
    double fact2 = 100000.0;
    double hl;
    double hv;
    double sl;
    double sv;
    double Vl;
    double Vv;
    double epsiMinpack = 1.0E-6;
    double paramValue;

    public MixTEPbibSubstance() {
    }

    public MixTEPbibSubstance(String systName, String systFile) {
        super(systName, systFile);
    }

    public double getSatPressure(double T, double x) throws MonoPhaseException {
        try {
            if (x == 0.0) {
                this.bubblePointP(this.fract_mol, T, this.k);
            } else if (x == 1.0) {
                this.dewPointP(this.fract_mol, T, this.k);
            } else {
                String message = "Watch out! the quality must be 0 or 1";
                JOptionPane.showMessageDialog(new JFrame(), message);
            }
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        return this.Pparam * 100000.0;
    }

    public double getSatTemperature(double P, double x) {
        try {
            if (x == 0.0) {
                this.bubblePointT(this.fract_mol, P / 100000.0, this.k);
            } else if (x == 1.0) {
                this.dewPointT(this.fract_mol, P / 100000.0, this.k);
            } else {
                String message = "Watch out! the quality must be 0 or 1";
                JOptionPane.showMessageDialog(new JFrame(), message);
            }
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        return this.Tparam;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        super.fcn(mm, n, x, fvec, iflag);
        double PP = 1.0;
        double TT = 300.0;
        double ratioV = 0.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("sumy")) {
            TT = this.Tparam;
            PP = x[1];
            fvec[1] = this.sumy(TT, PP);
            this.callFunction = "sumy";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.Pparam = x[1];
        }
        if (this.callFunction.equals("sumx")) {
            TT = this.Tparam;
            PP = x[1];
            fvec[1] = this.sumx(TT, PP);
            this.callFunction = "sumx";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.Pparam = x[1];
        }
        if (this.callFunction.equals("sumyP")) {
            PP = this.Pparam;
            TT = x[1];
            fvec[1] = this.sumy(TT, PP);
            this.callFunction = "sumyP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.Tparam = x[1];
        }
        if (this.callFunction.equals("sumxP")) {
            PP = this.Pparam;
            TT = x[1];
            fvec[1] = this.sumx(TT, PP);
            this.callFunction = "sumxP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.Tparam = x[1];
        }
        if (this.callFunction.equals("liqsplit")) {
            fvec[1] = this.liqSplit(x[1]);
            this.callFunction = "liqsplit";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1] + "  Pparam: " + this.Pparam);
            }
        }
        if (this.callFunction.equals("invhPL")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, 0.0);
            this.callFunction = "invhPL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhP")) {
            TT = x[1];
            PP = this.PPparam;
            ratioV = this.Rparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, ratioV);
            this.callFunction = "invhP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhPV")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, 1.0);
            this.callFunction = "invhPV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsPL")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, 0.0);
            this.callFunction = "invsPL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsP")) {
            TT = x[1];
            PP = this.PPparam;
            ratioV = this.Rparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, ratioV);
            this.callFunction = "invsP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsPV")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, 1.0);
            this.callFunction = "invsPV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhTL")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, 0.0);
            this.callFunction = "invhTL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhT")) {
            TT = this.TTparam;
            PP = x[1];
            ratioV = this.Rparam;
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, ratioV);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhTV")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, 1.0);
            this.callFunction = "invhTV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsTL")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, 0.0);
            this.callFunction = "invsTL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsT")) {
            TT = this.TTparam;
            PP = x[1];
            ratioV = this.Rparam;
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, ratioV);
            this.callFunction = "invsT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsTV")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, 1.0);
            this.callFunction = "invsTV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    public double sumx(double T, double P_bar) {
        double P = P_bar;
        double[] ZZ = this.Z(P, T, this.zz, this.k);
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double sx = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            fugv[i] = ZZ[i + 4];
            ++i;
        }
        double sdx2 = 0.0;
        int kk = 0;
        while (kk < 15) {
            ZZ = this.Z(P, T, this.xx, this.k);
            sx = 0.0;
            int i2 = 0;
            while (i2 < this.nbComponents) {
                fugl[i2] = ZZ[i2 + 4 + this.nbComponents];
                double xprime = this.xx[i2] * fugv[i2] / fugl[i2];
                sdx2 += (this.xx[i2] - xprime) * (this.xx[i2] - xprime);
                this.xx[i2] = xprime;
                sx += this.xx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nbComponents) {
                this.xx[i2] = this.xx[i2] / sx;
                ++i2;
            }
            if (sdx2 < 1.0E-7) break;
            ++kk;
        }
        return sx - 1.0;
    }

    public double sumy(double T, double P_bar) {
        double P = P_bar;
        double[] ZZ = this.Z(P, T, this.zz, this.k);
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double sy = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            fugl[i] = ZZ[i + 4 + this.nbComponents];
            ++i;
        }
        double sdy2 = 0.0;
        int kk = 0;
        while (kk < 15) {
            ZZ = this.Z(P, T, this.yy, this.k);
            sy = 0.0;
            int i2 = 0;
            while (i2 < this.nbComponents) {
                fugv[i2] = ZZ[i2 + 4];
                double yprime = this.yy[i2] * fugl[i2] / fugv[i2];
                sdy2 += (this.yy[i2] - yprime) * (this.yy[i2] - yprime);
                this.yy[i2] = yprime;
                sy += this.yy[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.nbComponents) {
                this.yy[i2] = this.yy[i2] / sy;
                ++i2;
            }
            if (sdy2 < 1.0E-7) break;
            ++kk;
        }
        return sy - 1.0;
    }

    public double[] calcSubstance(double T, double P_Pa, double x) {
        double p = P_Pa;
        double[] res = new double[6 + 2 * this.nbComponents];
        double h = 0.0;
        double s = 0.0;
        double Tbulle = this.getSatTemperature(p, 0.0);
        double Trosee = this.getSatTemperature(p, 1.0);
        if (T < Tbulle || T > Trosee) {
            double[] devP = this.Z(p / 100000.0, T, this.fract_mol, this.k);
            if (this.debug) {
                System.out.println("Racines de la cubique : ");
                System.out.println("Zvap " + this.ZZ[0]);
                System.out.println("Z2 " + this.ZZ[1]);
                System.out.println("Zliq " + this.ZZ[2]);
                int n = 4;
                System.out.println("fugacit\u00e9s : ");
                System.out.println("h : " + devP[0] + " / s : " + devP[1]);
                System.out.println("fg1 : " + devP[n] + " / fl1 : " + devP[n + 2]);
                System.out.println("fg2 : " + devP[n + 1] + " / fl2 : " + devP[n + 3]);
            }
            double vV = this.ZZ[0] * 8.314472471 * T / p * 100000.0;
            double vL = this.ZZ[2] * 8.314472471 * T / p * 100000.0;
            if (T < Tbulle) {
                this.v = vL;
                h = devP[2];
                s = devP[3];
                x = 0.0;
            } else {
                this.v = vV;
                h = devP[0];
                s = devP[1];
                x = 1.0;
            }
        } else {
            ELVComposition elv = this.flashAdiab(p, T);
            double titre = (elv.x[0] - this.fract_mol[0]) / (elv.x[0] - elv.y[0]);
            double liqM = this.getMixMolarmass(elv.x);
            double vapM = this.getMixMolarmass(elv.y);
            titre = (elv.x[0] * this.compProp[0].M / liqM - this.fract_mol[0] * this.compProp[0].M / this.mixM) / (elv.x[0] * this.compProp[0].M / liqM - elv.y[0] * this.compProp[0].M / vapM);
            h = this.hv * titre + (1.0 - titre) * this.hl;
            s = this.sv * titre + (1.0 - titre) * this.sl;
            x = titre;
            int i = 0;
            while (i < this.nbComponents) {
                res[6 + i] = elv.x[i];
                res[6 + this.nbComponents + i] = elv.y[i];
                ++i;
            }
        }
        res[0] = h;
        res[1] = this.v / 100.0 / this.mixM;
        res[2] = 0.0;
        res[3] = x;
        res[4] = res[0] - (p * res[1] - this.mixu0) / 100.0;
        res[5] = s;
        return res;
    }

    protected double getMixMolarmass(double[] z) {
        double molarMass = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            molarMass += this.compProp[i].M * z[i];
            ++i;
        }
        return molarMass;
    }

    public double[] ai(double T) {
        int nbComponents = this.compProp.length;
        double[] Zc = new double[nbComponents];
        double[] $a = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            double $Tr = T / this.compProp[i].Tc;
            Zc[i] = 0.329032 - 0.076799 * this.compProp[i].omega + 0.0211947 * this.compProp[i].omega * this.compProp[i].omega;
            Modeles mod = this.modeleUtilise(this.nbmodele, this.compProp[i].omega, this.compProp[i].Tc, this.compProp[i].Pc, Zc[i]);
            Alphas alphas = this.alphaUtilise(this.nbalpha, this.compProp[i].omega, $Tr, this.compProp[i].c1, this.compProp[i].c2, this.compProp[i].c3);
            double $a0 = mod.omegaa * this.PaToBar * 69.13045247101685 * (this.compProp[i].Tc * this.compProp[i].Tc) / this.compProp[i].Pc;
            double $fw = alphas.m;
            double $lambda = alphas.alpha;
            $a[i] = $a0 * $lambda;
            ++i;
        }
        return $a;
    }

    public double[] bi(double T) {
        int nbComponents = this.compProp.length;
        double[] $a = new double[nbComponents];
        double[] Zc = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            Zc[i] = 0.329032 - 0.076799 * this.compProp[i].omega + 0.0211947 * this.compProp[i].omega * this.compProp[i].omega;
            this.mod = this.modeleUtilise(this.nbmodele, this.compProp[i].omega, this.compProp[i].Tc, this.compProp[i].Pc, Zc[i]);
            $a[i] = this.mod.omegab * this.fact2 * 8.314472471 * this.compProp[i].Tc / this.compProp[i].Pc;
            ++i;
        }
        return $a;
    }

    public double amix(double[] x, double[] a, double[][] k) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            int j = 0;
            while (j < nbComponents) {
                am += x[i] * x[j] * Math.pow(a[i] * a[j], 0.5) * (1.0 - k[i][j]);
                ++j;
            }
            ++i;
        }
        return am;
    }

    public double bmix(double[] x, double[] b) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            am += x[i] * b[i];
            ++i;
        }
        return am;
    }

    public double saxi(double[] x, double[] a, int i, double[][] k) {
        int nbComponents = x.length;
        double ai = a[i];
        double am = 0.0;
        int j = 0;
        while (j < nbComponents) {
            am += x[j] * Math.pow(a[j] * ai, 0.5) * (1.0 - k[i][j]);
            ++j;
        }
        return am;
    }

    public double[] dai(double T) {
        int nbComponents = this.compProp.length;
        double[] Zc = new double[nbComponents];
        double[] $a = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            double $Tr = T / this.compProp[i].Tc;
            Zc[i] = 0.329032 - 0.076799 * this.compProp[i].omega + 0.0211947 * this.compProp[i].omega * this.compProp[i].omega;
            Modeles mod = this.modeleUtilise(this.nbmodele, this.compProp[i].omega, this.compProp[i].Tc, this.compProp[i].Pc, Zc[i]);
            Alphas alphas = this.alphaUtilise(this.nbalpha, this.compProp[i].omega, $Tr, this.compProp[i].c1, this.compProp[i].c2, this.compProp[i].c3);
            double $a0 = mod.omegaa * 69.13045247101685 * (this.compProp[i].Tc * this.compProp[i].Tc) / this.compProp[i].Pc * this.PaToBar;
            double $fw = alphas.m;
            double $mu = ($fw * $fw - $fw * (1.0 + $fw) / Math.pow($Tr, 0.5)) / this.compProp[i].Tc;
            $a[i] = $a0 * $mu;
            ++i;
        }
        return $a;
    }

    public double damix(double[] x, double[] a, double[] da, double[][] k) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            int j = 0;
            while (j < nbComponents) {
                am += x[i] * x[j] / 2.0 / Math.pow(a[i] * a[j], 0.5) * (a[j] * da[i] + a[i] * da[j]) * (1.0 - k[i][j]);
                ++j;
            }
            ++i;
        }
        return am;
    }

    public double $AA(double am, double p, double T) {
        return am * p / 69.13045247101685 / (T * T);
    }

    public double $BB(double bm, double p, double T) {
        return bm * p / 8.314472471 / T;
    }

    double calcD(double P_bar, double T, double[] x, double[][] k) {
        double p = P_bar;
        double[] $a1 = this.ai(T);
        double[] $b1 = this.bi(T);
        double am1 = this.amix(x, $a1, k);
        double bm1 = this.bmix(x, $b1);
        double $AA = this.$AA(am1, p, T);
        double $BB = this.$BB(bm1, p, T);
        double $b0 = $BB - 1.0;
        double $c0 = $AA - 3.0 * ($BB * $BB) - 2.0 * $BB;
        double $d0 = -$AA * $BB + $BB * $BB + $BB * $BB * $BB;
        double $mm = (3.0 * $c0 - $b0 * $b0) / 9.0;
        double $n = -(0.07407407407407407 * $b0 * $b0 * $b0 - $b0 * $c0 / 3.0 + $d0) / 2.0;
        double $d = $mm * $mm * $mm + $n * $n;
        return $d;
    }

    public double[] Z(double P_bar, double T, double[] x, double[][] k) {
        double p = P_bar;
        int nbComponents = x.length;
        double[] $a1 = this.ai(T);
        double[] $b1 = this.bi(T);
        double[] $da1 = this.dai(T);
        double[] $saxi = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            $saxi[i] = this.saxi(x, $a1, i, k);
            ++i;
        }
        double[] dev = new double[2 * nbComponents + 4];
        double am1 = this.amix(x, $a1, k);
        double bm1 = this.bmix(x, $b1);
        double dam1 = this.damix(x, $a1, $da1, k);
        double $A1 = this.$AA(am1, p, T);
        double $B1 = this.$BB(bm1, p, T);
        this.ZZ = this.ZPeng($A1, $B1);
        double[] uw = this.uw(this.nbmodele);
        SolutionR r12 = this.r1r2(uw[0], uw[1]);
        int ii = 0;
        int jj = 0;
        while (jj < 2) {
            ii = jj * 2;
            double $Ds1 = 8.314472471 * Math.log(this.ZZ[ii] - $B1);
            double $g = (this.ZZ[ii] - $B1 * r12.r1) / (this.ZZ[ii] - $B1 * r12.r2);
            double $Ds2 = -dam1 / bm1 / (r12.r1 - r12.r2) * Math.log($g);
            double $Ds = $Ds1 + $Ds2;
            double $Dh1 = 8.314472471 * T * (this.ZZ[ii] - 1.0);
            double $Dh2 = 0.0;
            double $Dh3 = -(dam1 * T - am1) / (r12.r1 - r12.r2) / bm1 * Math.log($g);
            double $Dh = $Dh1 + $Dh2 + $Dh3;
            double hid = 0.0;
            double sid = 0.0;
            double Mvap = 0.0;
            int i2 = 0;
            while (i2 < nbComponents) {
                double $Df1 = $b1[i2] / bm1 * (this.ZZ[ii] - 1.0) - Math.log(this.ZZ[ii] - $B1);
                double $Df2 = $A1 / $B1 / (r12.r1 - r12.r2) * Math.log($g) * (2.0 * $saxi[i2] / am1 - $b1[i2] / bm1);
                double $Df = $Df1 + $Df2;
                dev[4 + i2 + nbComponents * jj] = $Df = p * x[i2] * Math.exp($Df);
                if (this.compProp[i2].codeCp == 1) {
                    hid += x[i2] * (this.compProp[i2].h_gaz_mol(T) / this.compProp[i2].M + this.compProp[i2].h0);
                    sid += x[i2] * (this.compProp[i2].s_gaz_mol(T, p) / this.compProp[i2].M + this.compProp[i2].s0);
                } else {
                    this.hSIdeal = new EnthalpieEntropie();
                    double p_pascal = p;
                    this.hSIdeal = this.mThs(i2, 200, this.compProp[i2].Tref, T, p_pascal);
                    hid += x[i2] * (this.hSIdeal.h / this.compProp[i2].M + this.compProp[i2].h0);
                    sid += x[i2] * (this.hSIdeal.s / this.compProp[i2].M + this.compProp[i2].s0);
                }
                Mvap += x[i2] * this.compProp[i2].M;
                ++i2;
            }
            dev[ii] = $Dh / Mvap + hid;
            dev[ii + 1] = $Ds / Mvap + sid;
            ++jj;
        }
        return dev;
    }

    public double[] ZPeng(double $AA, double $BB) {
        double $b0 = $BB - 1.0;
        double $c0 = $AA - 3.0 * ($BB * $BB) - 2.0 * $BB;
        double $d0 = -$AA * $BB + $BB * $BB + $BB * $BB * $BB;
        double $mm = (3.0 * $c0 - $b0 * $b0) / 9.0;
        double $n = -(0.07407407407407407 * $b0 * $b0 * $b0 - $b0 * $c0 / 3.0 + $d0) / 2.0;
        double $m2 = Math.abs($mm);
        double $d = $mm * $mm * $mm + $n * $n;
        double[] Z = new double[3];
        if ($d < 0.0) {
            double $phi;
            double $rr = Math.pow($m2, 0.5);
            double $cosf = $n / ($rr * $rr * $rr);
            double $sinf = $cosf != 1.0 ? Math.pow(1.0 - $cosf * $cosf, 0.5) : 0.0;
            if ($cosf != 0.0) {
                double $tanf = $sinf / $cosf;
                $phi = Math.atan($tanf);
            } else {
                $phi = TEPbibSubstance.PI / 2.0;
            }
            double $teta = $phi;
            Z[0] = 2.0 * $rr * Math.cos($teta / 3.0) - $b0 / 3.0;
            Z[1] = 2.0 * $rr * Math.cos($teta / 3.0 + 4.0 * TEPbibSubstance.PI / 3.0) - $b0 / 3.0;
            Z[2] = 2.0 * $rr * Math.cos($teta / 3.0 + 8.0 * TEPbibSubstance.PI / 3.0) - $b0 / 3.0;
        } else if ($d == 0.0) {
            double $s = Math.pow($n, 0.3333333333333333);
            Z[0] = 2.0 * $s - $b0 / 3.0;
            Z[1] = -$s - $b0 / 3.0;
            Z[2] = -$s - $b0 / 3.0;
        } else {
            double $dum = $n + ($d = Math.pow($d, 0.5));
            double $s = $dum >= 0.0 ? Math.pow($dum, 0.3333333333333333) : -Math.pow(-$dum, 0.3333333333333333);
            $dum = $n - $d;
            double $t = $dum >= 0.0 ? Math.pow($dum, 0.3333333333333333) : -Math.pow(-$dum, 0.3333333333333333);
            Z[0] = $s + $t - $b0 / 3.0;
            Z[1] = Z[0];
            Z[2] = Z[0];
        }
        double[] Zs = new double[3];
        Vector<String> vZ = new Vector<String>();
        int k = 0;
        while (k < 3) {
            vZ.addElement(Util.aff_d((double)Z[k]));
            ++k;
        }
        Zs = MixTEPbibSubstance.trie_d(vZ, false);
        return Zs;
    }

    public static double[] trie_d(Vector v, boolean increasing) {
        double[] a = new double[v.size()];
        int j = 0;
        while (j < v.size()) {
            a[j] = Util.lit_d((String)((String)v.elementAt(j)));
            ++j;
        }
        double[] b = new double[v.size()];
        int j2 = 0;
        while (j2 < v.size()) {
            double sup = a[0];
            int isup = 0;
            int k = 0;
            while (k < a.length) {
                if (increasing) {
                    if (sup > a[k]) {
                        sup = a[k];
                        isup = k;
                    }
                } else if (sup < a[k]) {
                    sup = a[k];
                    isup = k;
                }
                ++k;
            }
            double[] c = new double[a.length - 1];
            int i = -1;
            k = 0;
            while (k < a.length) {
                if (k != isup) {
                    c[++i] = a[k];
                }
                ++k;
            }
            a = new double[c.length];
            a = c;
            b[j2] = sup;
            ++j2;
        }
        return b;
    }

    public void bubblePointP(double[] z, double T, double[][] k) throws MonoPhaseException {
        this.nbComponents = z.length;
        this.k = k;
        double[] PS = new double[this.nbComponents];
        double[] K = new double[this.nbComponents];
        this.yy = new double[this.nbComponents];
        this.xx = new double[this.nbComponents];
        this.zz = new double[this.nbComponents];
        this.xx = z;
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double P = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            PS[i] = this.compProp[i].psat_T(T) / 100000.0;
            if (PS[i] > this.compProp[i].Pc / 100000.0) {
                PS[i] = this.compProp[i].Pc / 100000.0;
            }
            P += z[i] * PS[i];
            this.zz[i] = z[i];
            ++i;
        }
        i = 0;
        while (i < this.nbComponents) {
            K[i] = PS[i] / P;
            this.yy[i] = K[i] * this.zz[i];
            ++i;
        }
        double[] init = new double[2];
        this.Pparam = P;
        this.Tparam = T;
        this.callFunction = "sumy";
        init[1] = this.Pparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.Pparam = P = result[1];
        if (P == 0.0) {
            throw new MonoPhaseException("bubblePoint");
        }
        double[] devP = this.Z(P, T, this.zz, k);
        int i2 = 0;
        while (i2 < this.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.nbComponents];
            ++i2;
        }
        devP = this.Z(P, T, this.yy, k);
        i2 = 0;
        while (i2 < this.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            K[i2] = this.yy[i2] / this.zz[i2];
            this.xx[i2] = this.zz[i2];
            ++i2;
        }
        this.hl = devP[2];
        this.sl = devP[3];
        this.Vl = this.ZZ[2] * 8.314472471 * T / P;
    }

    public void dewPointP(double[] z, double T, double[][] k) throws MonoPhaseException {
        this.nbComponents = z.length;
        this.k = k;
        double[] PS = new double[this.nbComponents];
        double[] K = new double[this.nbComponents];
        this.xx = new double[this.nbComponents];
        this.yy = new double[this.nbComponents];
        this.zz = new double[this.nbComponents];
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double P = 0.0;
        double sp = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            PS[i] = this.compProp[i].psat_T(T) / 100000.0;
            if (PS[i] > this.compProp[i].Pc / 100000.0) {
                PS[i] = this.compProp[i].Pc / 100000.0;
            }
            sp += z[i] / PS[i];
            this.zz[i] = z[i];
            ++i;
        }
        P = 1.0 / sp;
        i = 0;
        while (i < this.nbComponents) {
            K[i] = PS[i] / P;
            this.xx[i] = z[i] / K[i];
            ++i;
        }
        double[] init = new double[2];
        this.Pparam = P;
        this.Tparam = T;
        this.callFunction = "sumx";
        init[1] = this.Pparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.Pparam = P = result[1];
        if (P == 0.0) {
            throw new MonoPhaseException("dewPoint");
        }
        double[] devP = this.Z(P, T, this.zz, k);
        int i2 = 0;
        while (i2 < this.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            ++i2;
        }
        devP = this.Z(P, T, this.xx, k);
        i2 = 0;
        while (i2 < this.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.nbComponents];
            K[i2] = this.zz[i2] / this.xx[i2];
            this.yy[i2] = this.xx[i2] * K[i2];
            ++i2;
        }
        this.hv = devP[0];
        this.sv = devP[1];
        this.Vv = this.ZZ[0] * 8.314472471 * T / P;
    }

    public void dewPointT(double[] z, double P_bar, double[][] k) throws MonoPhaseException {
        double P = P_bar;
        this.nbComponents = z.length;
        this.k = k;
        double[] K = new double[this.nbComponents];
        this.xx = new double[this.nbComponents];
        this.yy = new double[this.nbComponents];
        this.zz = new double[this.nbComponents];
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double Trosee = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            Trosee += this.compProp[i].Tsat_P(P * 100000.0);
            this.xx[i] = z[i];
            this.zz[i] = z[i];
            ++i;
        }
        double[] init = new double[2];
        this.Pparam = P;
        this.Tparam = Trosee /= (double)this.nbComponents;
        this.callFunction = "sumxP";
        init[1] = this.Tparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.Tparam = Trosee = result[1];
        double[] devP = this.Z(P, Trosee, this.zz, k);
        int i2 = 0;
        while (i2 < this.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            ++i2;
        }
        devP = this.Z(P, Trosee, this.xx, k);
        i2 = 0;
        while (i2 < this.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.nbComponents];
            K[i2] = this.zz[i2] / this.xx[i2];
            this.yy[i2] = this.xx[i2] * K[i2];
            ++i2;
        }
        this.hv = devP[0];
        this.sv = devP[1];
        this.Vv = this.ZZ[0] * 8.314472471 * Trosee / P;
    }

    public void bubblePointT(double[] z, double P_bar, double[][] k) throws MonoPhaseException {
        double P = P_bar;
        this.nbComponents = z.length;
        this.k = k;
        this.yy = new double[this.nbComponents];
        this.xx = new double[this.nbComponents];
        this.zz = new double[this.nbComponents];
        double[] K = new double[this.nbComponents];
        double[] fugl = new double[this.nbComponents];
        double[] fugv = new double[this.nbComponents];
        double Tbulle = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            Tbulle += this.compProp[i].Tsat_P(P * 100000.0);
            this.yy[i] = z[i];
            this.zz[i] = z[i];
            ++i;
        }
        double[] init = new double[2];
        this.Pparam = P;
        this.Tparam = Tbulle /= (double)this.nbComponents;
        this.callFunction = "sumyP";
        init[1] = this.Tparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.Tparam = Tbulle = result[1];
        if (Tbulle == 0.0) {
            throw new MonoPhaseException("bubblePoint");
        }
        double[] devP = this.Z(P, Tbulle, this.zz, k);
        int i2 = 0;
        while (i2 < this.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.nbComponents];
            ++i2;
        }
        devP = this.Z(P, Tbulle, this.yy, k);
        i2 = 0;
        while (i2 < this.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            K[i2] = this.yy[i2] / this.zz[i2];
            this.xx[i2] = this.zz[i2];
            ++i2;
        }
        this.hl = devP[2];
        this.sl = devP[3];
        this.Vl = this.ZZ[2] * 8.314472471 * Tbulle / P;
    }

    public ELVComposition flashAdiab(double P_Pa, double T) {
        this.nbComponents = this.zz.length;
        ELVComposition elv = new ELVComposition(this.nbComponents);
        this.zz = this.fract_mol;
        double[] DT = new double[this.nbComponents];
        double[] DT2 = new double[this.nbComponents];
        double[] PS = new double[this.nbComponents];
        double[] K = new double[this.nbComponents];
        double[] y = new double[this.nbComponents];
        double[] x = new double[this.nbComponents];
        this.KK = new double[this.nbComponents];
        double[] DZ = new double[this.nbComponents];
        double[] Delta = new double[this.nbComponents];
        double P = P_Pa / 100000.0;
        int i = 0;
        while (i < this.nbComponents) {
            PS[i] = this.compProp[i].psat_T(T) / 100000.0;
            if (PS[i] > this.compProp[i].Pc / 100000.0) {
                PS[i] = this.compProp[i].Pc / 100000.0;
            }
            ++i;
        }
        double L = 0.5;
        int i2 = 0;
        while (i2 < this.nbComponents) {
            this.KK[i2] = PS[i2] / P;
            x[i2] = this.zz[i2] / (L + this.KK[i2] * (1.0 - L));
            y[i2] = this.KK[i2] * x[i2];
            ++i2;
        }
        double sx = 0.0;
        double sy = 0.0;
        int i3 = 0;
        while (i3 < this.nbComponents) {
            sx += x[i3];
            sy += y[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nbComponents) {
            x[i3] = x[i3] / sx;
            y[i3] = y[i3] / sy;
            if (this.debug) {
                System.out.println("flash : x " + x[i3] + " y " + y[i3] + "  KK " + this.KK[i3] + "  PS " + PS[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.nbComponents) {
            DZ[i3] = this.KK[i3];
            ++i3;
        }
        int k = 0;
        while (k < 10) {
            elv = this.eLVComp(P, T);
            double sum = 0.0;
            int i4 = 0;
            while (i4 < this.nbComponents) {
                Delta[i4] = elv.fugLiq[i4] / elv.fugVap[i4];
                DZ[i4] = DZ[i4] * Delta[i4];
                sum += Math.abs(1.0 - Delta[i4]);
                ++i4;
            }
            if (this.debug) {
                System.out.println(" somme rapport fugacit\u00e9s " + sum);
            }
            if (sum < 1.0E-6) break;
            i4 = 0;
            while (i4 < this.nbComponents) {
                this.KK[i4] = DZ[i4];
                ++i4;
            }
            if (this.debug) {
                System.out.println("\n k " + k + "\n " + " elv.L " + elv.L);
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.x " + elv.x[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.y " + elv.y[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.fugLiq " + elv.fugLiq[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.fugVap " + elv.fugVap[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < this.nbComponents) {
                    System.out.println("KK " + this.KK[i4]);
                    ++i4;
                }
            }
            ++k;
        }
        return elv;
    }

    public ELVComposition eLVComp(double P_bar, double T) {
        double LL0;
        ELVComposition elv = new ELVComposition(this.nbComponents);
        double[] x = new double[this.nbComponents];
        double[] y = new double[this.nbComponents];
        this.zz = this.fract_mol;
        this.callFunction = "liqsplit";
        double[] init = new double[2];
        init[1] = 0.5;
        double[] res = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        elv.L = LL0 = res[1];
        int i = 0;
        while (i < this.nbComponents) {
            elv.x[i] = this.zz[i] / (LL0 + this.KK[i] * (1.0 - LL0));
            x[i] = elv.x[i];
            elv.y[i] = x[i] * this.KK[i];
            y[i] = elv.y[i];
            ++i;
        }
        double[] ZZ = this.Z(P_bar, T, x, this.k);
        int i2 = 0;
        while (i2 < this.nbComponents) {
            elv.fugLiq[i2] = ZZ[i2 + 4 + this.nbComponents];
            ++i2;
        }
        ZZ = this.Z(P_bar, T, y, this.k);
        i2 = 0;
        while (i2 < this.nbComponents) {
            elv.fugVap[i2] = ZZ[i2 + 4];
            ++i2;
        }
        return elv;
    }

    private double liqSplit(double L) {
        double somme = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            somme += (1.0 - this.KK[i]) * this.zz[i] / (L + this.KK[i] * (1.0 - L));
            ++i;
        }
        return somme;
    }

    public SolutionR r1r2(double u, double w) {
        SolutionR solR = new SolutionR();
        solR.r1 = (-u + Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        solR.r2 = (-u - Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        return solR;
    }

    public Modeles modeleUtilise(int n, double omega, double Tc, double Pc, double Zc) {
        Modeles mod = new Modeles();
        switch (n) {
            case 0: {
                mod.u = 0.0;
                mod.w = 0.0;
                mod.omegaa = 0.421875;
                mod.omegab = 0.125;
                break;
            }
            case 1: {
                mod.u = 1.0;
                mod.w = 0.0;
                mod.omegaa = 0.42748;
                mod.omegab = 0.08664;
                break;
            }
            case 2: {
                mod.u = 2.0;
                mod.w = -1.0;
                double truc = 0.3333333333333333 * (-1.0 + Math.pow(6.0 * Math.sqrt(2.0) + 8.0, 0.3333333333333333) - Math.pow(6.0 * Math.sqrt(2.0) - 8.0, 0.3333333333333333));
                mod.omegaa = 8.0 * (5.0 * truc + 1.0) / (49.0 - 37.0 * truc);
                mod.omegab = truc / (truc + 3.0);
                break;
            }
            case 3: {
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = MixTEPbibSubstance.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = 1.0 - 3.0 * Zc;
                double b2 = mod.omegab * 8.314472471 * Tc / Pc;
                double c2 = mod.omegac * 8.314472471 * Tc / Pc;
                mod.u = 1.0 + c2 / b2;
                mod.w = -c2 / b2;
                break;
            }
            case 4: {
                double c2;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = MixTEPbibSubstance.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = (1.0 - 3.0 * Zc + mod.omegab) / mod.omegab;
                double b2 = mod.omegab * 8.314472471 * Tc / Pc;
                mod.u = c2 = mod.omegac * 8.314472471 * Tc / Pc;
                mod.w = -c2 + 1.0;
                break;
            }
            case 5: {
                double Zcc = 0.3333333333333333;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zcc + 1.0;
                double c1 = 3.0 * Zcc * Zcc;
                double d1 = -Math.pow(Zcc, 3.0);
                ResultatCardan omegaB = MixTEPbibSubstance.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zcc * (1.0 - Zcc) + 3.0 * (1.0 - 2.0 * Zcc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.u = 1.0;
                mod.w = 0.0;
            }
        }
        return mod;
    }

    public Alphas alphaUtilise(int n, double omega, double Tr, double c1, double c2, double c3) {
        Alphas fonctionalpha = new Alphas();
        switch (n) {
            case 0: {
                fonctionalpha.m = 0.48 + 1.574 * omega - 0.175 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 1: {
                fonctionalpha.m = 0.4783 + 1.6337 * omega - 0.317 * Math.pow(omega, 2.0) + 0.76 * Math.pow(omega, 3.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 2: {
                fonctionalpha.m = 0.37464 + 1.54226 * omega - 0.26992 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 3: {
                if (omega < 0.4) {
                    fonctionalpha.m = 0.418 + 1.58 * omega - 0.58 * Math.pow(omega, 2.0);
                    fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                    break;
                }
                fonctionalpha.m = 0.212 + 2.2 * omega - 0.831 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                break;
            }
            case 4: {
                if (Tr <= 1.0) {
                    double L0 = 0.125283;
                    double M0 = 0.911807;
                    double N0 = 1.948153;
                    double L1 = 0.511614;
                    double M1 = 0.784054;
                    double N1 = 2.812522;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.401219;
                double M0 = 4.963075;
                double N0 = -2.0;
                double L1 = 0.024955;
                double M1 = 1.248088;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 5: {
                if (Tr <= 1.0) {
                    double L0 = 0.141599;
                    double M0 = 0.919422;
                    double N0 = 2.496441;
                    double L1 = 0.500315;
                    double M1 = 0.799457;
                    double N1 = 3.29179;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.441411;
                double M0 = 6.500018;
                double N0 = -2.0;
                double L1 = 0.03258;
                double M1 = 1.289098;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 6: {
                double c0 = 0.378893 + 1.4897153 * omega - 0.17131848 * omega * omega + 0.0196554 * Math.pow(omega, 3.0);
                fonctionalpha.m = c0 + c1 * (1.0 + Math.pow(Tr, 0.5) * (0.7 - Tr));
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
            }
            case 7: {
                if (Tr <= 1.0) {
                    fonctionalpha.alpha = Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)) + c2 * Math.pow(1.0 - Math.pow(Tr, 0.5), 2.0) + c3 * Math.pow(1.0 - Math.pow(Tr, 0.5), 3.0), 2.0);
                    break;
                }
                fonctionalpha.alpha = Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)), 2.0);
                break;
            }
            case 8: {
                fonctionalpha.m = 0.452413 + 1.30982 * omega - 0.296937 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
            }
        }
        return fonctionalpha;
    }

    public static ResultatCardan cubique(double a, double b, double c, double d) {
        ResultatCardan resultat = new ResultatCardan();
        double p = c / a - Math.pow(b, 2.0) / (3.0 * Math.pow(a, 2.0));
        double q = 2.0 * Math.pow(b, 3.0) / (27.0 * Math.pow(a, 3.0)) - b * c / (3.0 * Math.pow(a, 2.0)) + d / a;
        double gDelta = 4.0 * Math.pow(p, 3.0) + 27.0 * Math.pow(q, 2.0);
        double m = -q / 2.0 + 0.5 * Math.sqrt(gDelta / 27.0);
        double n = -q / 2.0 - 0.5 * Math.sqrt(gDelta / 27.0);
        double u = Math.pow(Math.abs(m), 0.3333333333333333);
        double v = Math.pow(Math.abs(n), 0.3333333333333333);
        if (gDelta > 0.0) {
            if (m < 0.0) {
                u = -u;
            }
            if (n < 0.0) {
                v = -v;
            }
            double x = u + v;
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = x;
            return resultat;
        }
        if (gDelta == 0.0) {
            if (b == 0.0 & c == 0.0 && d == 0.0) {
                resultat.ZL = 0.0;
                resultat.ZI = 0.0;
                resultat.ZV = 0.0;
                return resultat;
            }
            double x = 3.0 * q / p;
            double y = -3.0 * q / (2.0 * p);
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = y += -b / (3.0 * a);
            return resultat;
        }
        double k = 3.0 * q / (2.0 * p * Math.sqrt(-p / 3.0));
        double theta = Math.acos(k);
        double x = 2.0 * Math.sqrt(-p / 3.0) * Math.cos(theta / 3.0);
        double y = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 2) / 3.0);
        double z = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 4) / 3.0);
        resultat.ZV = x += -b / (3.0 * a);
        resultat.ZI = z += -b / (3.0 * a);
        resultat.ZL = y += -b / (3.0 * a);
        return resultat;
    }

    public double[] uw(int n) {
        double[] uw = new double[2];
        switch (n) {
            case 0: {
                uw[0] = 0.0;
                uw[1] = 0.0;
                break;
            }
            case 1: {
                uw[0] = 1.0;
                uw[1] = 0.0;
                break;
            }
            case 2: {
                uw[0] = 2.0;
                uw[1] = -1.0;
            }
        }
        return uw;
    }

    public double[] getT_from_hP(double h, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.HHparam = h;
        this.PPparam = P;
        double Tbulle = 300.0;
        double Trosee = 300.0;
        Tbulle = this.getSatTemperature(P, 0.0);
        Trosee = this.getSatTemperature(P, 1.0);
        if (this.debug) {
            System.out.println("Tbulle: " + Tbulle + "Trosee: " + Trosee + "  Tc: " + this.mixTc);
        }
        double hl = 0.0;
        double hv = 0.0;
        double[] res2 = this.calcSubstance(Tbulle, P, 0.0);
        hl = res2[0];
        double[] res3 = this.calcSubstance(Trosee, P, 1.0);
        hv = res3[0];
        if (this.debug) {
            System.out.println("hl: " + hl + "  hv: " + hv);
        }
        this.Rparam = (h - hl) / (hv - hl);
        if (h >= hl && h <= hv) {
            double xx;
            res[1] = xx = (h - hl) / (hv - hl);
            init[1] = (Tbulle + Trosee) / 2.0;
            this.callFunction = "invhP";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            if (this.debug) {
                System.out.println("h: " + h + "  xx: " + xx);
            }
            double[] miaou = this.getP_from_hT(h, res[0]);
            return res;
        }
        if (h < hl) {
            res[1] = 0.0;
            init[1] = (this.Tmini + Tbulle) / 2.0;
            this.callFunction = "invhPL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            double[] miaou = this.getP_from_hT(h, res[0]);
            return res;
        }
        init[1] = (Trosee + this.Tmaxi) / 2.0;
        this.callFunction = "invhPV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        double[] miaou = this.getP_from_hT(h, res[0]);
        return res;
    }

    protected double getEnthalpyResidual(double h, double PP, double[] x, double xx) {
        double[] res = this.calcSubstance(x[1], PP, xx);
        double critere = h - res[0];
        return critere;
    }

    public double[] getT_from_sP(double s, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.SSparam = s;
        this.PPparam = P;
        double Tbulle = 300.0;
        double Trosee = 300.0;
        Tbulle = this.getSatTemperature(P, 0.0);
        Trosee = this.getSatTemperature(P, 1.0);
        if (this.debug) {
            System.out.println("Tbulle: " + Tbulle + "Trosee: " + Trosee + "  Tc: " + this.mixTc);
        }
        double sl = 0.0;
        double sv = 0.0;
        double[] res2 = this.calcSubstance(Tbulle, P, 0.0);
        sl = res2[5];
        double[] res3 = this.calcSubstance(Trosee, P, 1.0);
        sv = res3[5];
        if (this.debug) {
            System.out.println("hl: " + sl + "  hv: " + sv);
        }
        this.Rparam = (s - sl) / (sv - sl);
        if (s >= sl && s <= sv) {
            double xx;
            res[1] = xx = (s - sl) / (sv - sl);
            init[1] = (Tbulle + Trosee) / 2.0;
            this.callFunction = "invsP";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            if (this.debug) {
                System.out.println("h: " + s + "  xx: " + xx);
            }
            return res;
        }
        if (s < sl) {
            res[1] = 0.0;
            init[1] = (this.Tmini + Tbulle) / 2.0;
            this.callFunction = "invsPL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            double[] miaou = this.getP_from_sT(s, res[0]);
            return res;
        }
        init[1] = (Trosee + this.Tmaxi) / 2.0;
        this.callFunction = "invsPV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    protected double getEntropyResidual(double s, double PP, double[] x, double xx) {
        double[] res = this.calcSubstance(x[1], PP, xx);
        double critere = s - res[5];
        return critere;
    }

    public double[] getP_from_hT(double h, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.HHparam = h;
        this.TTparam = T;
        double Pbulle = 1.0;
        double Prosee = 1.0;
        try {
            Pbulle = this.getSatPressure(T, 0.0);
            Prosee = this.getSatPressure(T, 1.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Pbulle: " + Pbulle + "Prosee: " + Prosee);
        }
        double hl = 0.0;
        double hv = 0.0;
        double[] res2 = this.calcSubstance(T, Pbulle, 0.0);
        hl = res2[0];
        double[] res3 = this.calcSubstance(T, Prosee, 1.0);
        hv = res3[0];
        if (this.debug) {
            System.out.println("hl: " + hl + "  hv: " + hv);
        }
        this.Rparam = (h - hl) / (hv - hl);
        if (h >= hl && h <= hv) {
            double xx;
            res[1] = xx = (h - hl) / (hv - hl);
            init[1] = (Pbulle + Prosee) / 2.0;
            this.callFunction = "invhT";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + h + "  xx: " + xx);
            }
            return res;
        }
        if (h < hl) {
            res[1] = 0.0;
            init[1] = (this.Pmaxi + Pbulle) / 2.0;
            this.callFunction = "invhTL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + h + "  xx: " + this.xx);
            }
            return res;
        }
        init[1] = Prosee / 2.0;
        this.callFunction = "invhTV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    protected double getEnthalpyResidual2(double h, double TT, double[] x, double xx) {
        double[] res = this.calcSubstance(TT, x[1], xx);
        double critere = h - res[0];
        return critere;
    }

    public double[] getP_from_sT(double s, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.SSparam = s;
        this.TTparam = T;
        double Pbulle = 10.0;
        double Prosee = 10.0;
        try {
            Pbulle = this.getSatPressure(T, 0.0);
            Prosee = this.getSatPressure(T, 1.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Pbulle: " + Pbulle + "Prosee: " + Prosee);
        }
        double sl = 0.0;
        double sv = 0.0;
        double[] res2 = this.calcSubstance(T, Pbulle, 0.0);
        sl = res2[5];
        double[] res3 = this.calcSubstance(T, Prosee, 1.0);
        sv = res3[5];
        if (this.debug) {
            System.out.println("sl: " + sl + "  sv: " + sv);
        }
        this.Rparam = (s - sl) / (sv - sl);
        if (s >= sl && s <= sv) {
            double xx;
            res[1] = xx = (s - sl) / (sv - sl);
            init[1] = (Pbulle + Prosee) / 2.0;
            this.callFunction = "invsT";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + s + "  xx: " + xx);
            }
            return res;
        }
        if (s < sl) {
            res[1] = 0.0;
            init[1] = (Pbulle + this.Pmaxi) / 2.0;
            this.callFunction = "invsTL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("s: " + s + "  xx: " + this.xx);
            }
            return res;
        }
        init[1] = Prosee / 2.0;
        this.callFunction = "invsTV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    protected double getEntropyResidual2(double s, double TT, double[] x, double xx) {
        double[] res = this.calcSubstance(TT, x[1], xx);
        double critere = s - res[5];
        return critere;
    }

    public EnthalpieEntropie mThs(int ii, int nbtrapezes, double x1, double x2, double P) {
        CpGeneralisee f1 = new CpGeneralisee();
        CpGeneralisee f2 = new CpGeneralisee();
        EnthalpieEntropie hs = new EnthalpieEntropie();
        double pas = (x2 - x1) / (double)nbtrapezes;
        double aireh = 0.0;
        double aires = 0.0;
        int i = 0;
        while (i < nbtrapezes) {
            double borneinf = x1 + (double)i * pas;
            double bornesup = borneinf + pas;
            f1.Cp = (this.compProp[ii].A + this.compProp[ii].B * Math.pow(this.compProp[ii].C / borneinf / Math.sinh(this.compProp[ii].C / borneinf), 2.0) + this.compProp[ii].D * Math.pow(this.compProp[ii].E / borneinf / Math.cosh(this.compProp[ii].E / borneinf), 2.0)) / 1000.0;
            f2.Cp = (this.compProp[ii].A + this.compProp[ii].B * Math.pow(this.compProp[ii].C / bornesup / Math.sinh(this.compProp[ii].C / bornesup), 2.0) + this.compProp[ii].D * Math.pow(this.compProp[ii].E / bornesup / Math.cosh(this.compProp[ii].E / bornesup), 2.0)) / 1000.0;
            f1.CpT = f1.Cp / borneinf;
            f2.CpT = f2.Cp / bornesup;
            aireh += pas * (f1.Cp + f2.Cp) / 2.0;
            aires += pas * (f1.CpT + f2.CpT) / 2.0;
            ++i;
        }
        hs.h = aireh;
        hs.s = aires - 8.314472471 * Math.log(P);
        return hs;
    }
}

