/*
 * Decompiled with CFR 0.152.
 */
import extThopt.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RefPropData {
    public static double Tref;
    public static double P0;
    public static double Pref;
    public static double Pc;
    public static double Tc;
    public static double Zc;
    public static double Vc;
    public static double omega;
    public static double Tr;
    public static double Trref;
    public static double h0;
    public static double s0;
    public static double u0;
    public static double M;
    public static double Tb;
    public static double dipole;
    static String name;
    static String fullName;

    static {
        name = "";
        fullName = "";
    }

    public static void main(String[] args) {
        try {
            File fich = new File("output.txt");
            fich.delete();
            fich = new File("error.txt");
            fich.delete();
        }
        catch (SecurityException sexception) {
            sexception.printStackTrace();
            String msg = "Error deleting output or error file. Check your security privileges";
            msg = String.valueOf(msg) + "\nor install the Thermoptim security access pack.";
            JOptionPane.showMessageDialog(new JFrame(), msg);
        }
        try {
            System.setOut(new PrintStream(new FileOutputStream("output.txt", true)));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream("error.txt", true)));
        }
        catch (IOException ioexception1) {
            ioexception1.printStackTrace();
        }
        RefPropData.saveXml();
    }

    public static void litData(String fichName) {
        try {
            File fich = new File(fichName);
            FileReader flux_fich = new FileReader(fich);
            BufferedReader flux_tamp = new BufferedReader(flux_fich);
            String ligne_data = flux_tamp.readLine();
            StringTokenizer st = new StringTokenizer(ligne_data, "!");
            name = st.nextToken().trim();
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            fullName = st.nextToken().trim();
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            M = Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            Tref = Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            Tb = Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            Tc = Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            Pc = Util.lit_d((String)st.nextToken().trim()) * 1000.0;
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            Vc = 0.001 / Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            omega = Util.lit_d((String)st.nextToken().trim());
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "!");
            dipole = Util.lit_d((String)st.nextToken().trim());
            flux_tamp.close();
            flux_fich.close();
        }
        catch (IOException e) {
            String message = "fich_data_mal_conf";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
    }

    public static void saveXml() {
        Element root = new Element("stylesheet", "xsl", "http://www.w3.org/1999/XSL/Transform");
        root.setAttribute("version", "1.0");
        Document doc = new Document(root);
        File fichier = new File("D:/Refprop9/fluides/");
        fichier.isDirectory();
        try {
            String[] list = fichier.list();
            Element seanceXml = new Element("DATABASE");
            int i = 0;
            while (i < list.length) {
                RefPropData.litData("D:/Refprop9/fluides/" + list[i]);
                Element component = new Element("COMPONENT");
                component.setAttribute("Name", name);
                component.setAttribute("FullName", fullName);
                Element comp = new Element("GENERAL");
                Comment comment = new Comment("T (K), Pc (Pa), Vc (m3/mol), M (kg/kmol)");
                comp.addContent((Content)comment);
                comp.setAttribute("Tc", Util.aff_d((double)Tc));
                comp.setAttribute("Pc", Util.aff_d((double)Pc));
                comp.setAttribute("Vc", Util.aff_d((double)Vc));
                comp.setAttribute("M", Util.aff_d((double)M));
                comp.setAttribute("omega", Util.aff_d((double)omega));
                comp.setAttribute("dipole", Util.aff_d((double)dipole));
                comp.setAttribute("Tb", Util.aff_d((double)Tb));
                comp.setAttribute("Tmini", Util.aff_d((double)(Tref + 0.1)));
                component.addContent((Content)comp);
                seanceXml.addContent((Content)component);
                ++i;
            }
            doc = new Document(seanceXml);
        }
        catch (Exception e) {
            System.out.println(e + " Name " + name);
            e.printStackTrace();
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(doc, (OutputStream)new FileOutputStream("RefpropData.xml"));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

