/*
 * Decompiled with CFR 0.152.
 */
package bibCTP;

import bibCTP.CompProperties;
import bibCTP.MonoPhaseException;
import bibCTP.cubic.Ede;
import bibCTP.cubic.SolutionR;
import bibCTP.model.FluidModel;
import bibCTP.trapp.Huber96_mix;
import bibCTP.trapp.Huber96_pur;
import bibCTP.util.CpGeneralisee;
import bibCTP.util.EnthalpieEntropie;
import extThopt.Util;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class CTPbibSubstance
implements Lmdif_fcn {
    public double Tr;
    public double Trref;
    public double v;
    public double x;
    public double Rho;
    public double m;
    public double volumetampon;
    public double mixTref;
    public double mixP0;
    public double mixPref;
    public double mixPc;
    public double mixTc;
    public double mixZc;
    public double mixomega;
    public double mixM;
    public double mixh0;
    public double mixs0;
    public double mixu0;
    public double Tmini;
    public double Tmaxi;
    public double Pmaxi;
    public static final double R = 8.314472471;
    public CompProperties[] compProp;
    public String[] comp;
    public double[] fract_mol;
    public double[] fract_mass;
    public SolutionR solR;
    public Ede equationdEtat;
    CpGeneralisee h0S0;
    public EnthalpieEntropie hS;
    public EnthalpieEntropie hSIdeal;
    public EnthalpieEntropie hSRes;
    public int fluide;
    public int nbtrapezes = 1000;
    public int nbTrapp;
    public String systemName;
    public String trappModel;
    double satPressure = 0.0;
    public double satValue = 0.0;
    int nfev = 0;
    int njev = 0;
    String callFunction = "";
    String selectedFile = "";
    public double Tparam;
    public double TinitEst = 0.0;
    public double PinitEst = 0.0;
    public double Pparam;
    double Hparam;
    double Sparam;
    double Rparam;
    double PPparam;
    double TTparam;
    double HHparam;
    double SSparam;
    double Xparam;
    File fich;
    public int nbComponents = 1;
    public double[] initProp;
    public boolean debug = false;
    public boolean simplified_ELV_calc = false;
    public FluidModel fluidModel;
    public double[][] k = new double[][]{{0.03, 0.0}, {0.0, 0.03}};
    public double[] KK;
    public double[] zz;
    public double[] xx;
    public double[] yy;
    static double PI = 3.141592654;
    double kij;
    Huber96_pur huberPur;
    Huber96_mix huberMix;

    public CTPbibSubstance() {
    }

    public CTPbibSubstance(String systName, String systFile) {
        this.selectedFile = systFile;
        this.systemName = systName;
        try {
            this.ChargerSysteme(this.selectedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void ChargerSysteme(String systFileName) throws Exception {
        this.readXml(systFileName);
        this.huberPur = new Huber96_pur(this);
        this.huberMix = new Huber96_mix(this);
    }

    public void setParameters(Vector v) {
        this.fluidModel.setParameters(v);
    }

    public String getClassDescription() {
        if (this.fluidModel != null) {
            return this.fluidModel.getClassDescription();
        }
        return "";
    }

    public boolean isMolarFraction() {
        return this.fluidModel.isMolarFraction();
    }

    public double[] getMolarWeights() {
        return this.fluidModel.getMolarWeights();
    }

    public void updateComp(String[] comp, double[] fract_mol) {
        this.fluidModel.updateComp(comp, fract_mol);
    }

    public void calcMixProps() {
        this.mixTref = 0.0;
        this.mixP0 = 0.0;
        this.mixPref = 0.0;
        this.mixPc = 0.0;
        this.mixTc = 0.0;
        this.mixZc = 0.0;
        this.mixomega = 0.0;
        this.mixM = 0.0;
        this.mixh0 = 0.0;
        this.mixs0 = 0.0;
        this.mixu0 = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            this.mixM += this.compProp[i].M * this.fract_mol[i];
            ++i;
        }
        this.initProp[0] = this.mixM;
        i = 0;
        while (i < this.nbComponents) {
            this.fract_mass[i] = this.compProp[i].M * this.fract_mol[i] / this.mixM;
            ++i;
        }
        i = 0;
        while (i < this.nbComponents) {
            this.mixTref += this.compProp[i].Tref * this.fract_mass[i];
            this.mixP0 += this.compProp[i].P0 * this.fract_mass[i];
            this.mixPref += this.compProp[i].Pref;
            this.mixPc += this.compProp[i].Pc;
            this.mixTc += this.compProp[i].Tc;
            this.mixZc += this.compProp[i].Zc;
            this.mixomega += this.compProp[i].omega * this.fract_mol[i];
            this.mixh0 += this.compProp[i].h0 * this.fract_mol[i];
            this.mixs0 += (this.compProp[i].s0 + 8.314472471 * Math.log(this.compProp[i].Pref)) * this.fract_mol[i];
            this.mixu0 += this.compProp[i].u0 * this.fract_mol[i];
            ++i;
        }
        this.fluidModel.calcMixProps();
    }

    protected double[] solveWithMinPack(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec = new double[mm + 1];
        double[] x = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            x[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn(mm, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        this.nfev = 0;
        this.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)this, (int)mm, (int)n, (double[])x, (double[])fvec, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        if (this.debug) {
            System.out.println();
        }
        if (this.debug) {
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
        }
        if (this.debug) {
            System.out.println("Final L2 norm of the residuals: " + residu1);
        }
        if (this.debug) {
            System.out.println("Number of function evaluations: " + this.nfev);
        }
        if (this.debug) {
            System.out.println("Number of Jacobian evaluations: " + this.njev);
        }
        if (this.debug) {
            System.out.println("Info value: " + info[1]);
        }
        if (this.debug) {
            System.out.println("Final approximate solution: " + callFunction + "   " + x[1]);
        }
        if (this.debug) {
            System.out.println();
        }
        return x;
    }

    public double[] getInitializationProperties() {
        return this.initProp;
    }

    public int numeroCas(String xxx) {
        int cas = 2;
        if (xxx.equalsIgnoreCase("R245fa")) {
            cas = 2;
        }
        if (xxx.equalsIgnoreCase("cyclopentane")) {
            cas = 4;
        }
        if (xxx.equalsIgnoreCase("R600")) {
            cas = 5;
        }
        if (xxx.equalsIgnoreCase("R40")) {
            cas = 6;
        }
        if (xxx.equalsIgnoreCase("NO2")) {
            cas = 7;
        }
        if (xxx.equalsIgnoreCase("R161")) {
            cas = 8;
        }
        if (xxx.equalsIgnoreCase("R1216")) {
            cas = 9;
        }
        if (xxx.equalsIgnoreCase("R610")) {
            cas = 10;
        }
        if (xxx.equalsIgnoreCase("R365mfc")) {
            cas = 11;
        }
        if (xxx.equalsIgnoreCase("toluene")) {
            cas = 12;
        }
        if (xxx.equalsIgnoreCase("R236ea")) {
            cas = 13;
        }
        if (xxx.equalsIgnoreCase("NH3")) {
            cas = 14;
        }
        if (xxx.equalsIgnoreCase("Dimethylether")) {
            cas = 15;
        }
        if (xxx.equalsIgnoreCase("R227ea")) {
            cas = 16;
        }
        if (xxx.equalsIgnoreCase("R1234yf")) {
            cas = 17;
        }
        if (xxx.equalsIgnoreCase("R152a")) {
            cas = 18;
        }
        if (xxx.equalsIgnoreCase("R143a")) {
            cas = 19;
        }
        return cas;
    }

    public CpGeneralisee fonctionCp(int n, double T) {
        CpGeneralisee Cp = new CpGeneralisee();
        switch (n) {
            case 0: {
                Cp.Cp = 83.15 - 1863.0 / Math.pow(T, 0.5) + 17445.0 / T;
                Cp.CpT = (83.15 - 1863.0 / Math.pow(T, 0.5) + 17445.0 / T) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 1: {
                Cp.Cp = 18.036 - 4.474 * Math.pow(10.0, -5.0) * T + 158.08 / Math.pow(T, 0.5);
                Cp.CpT = (18.036 - 4.474 * Math.pow(10.0, -5.0) * T + 158.08 / Math.pow(T, 0.5)) / T;
                Cp.h0 = 22301.0;
                Cp.s0 = 120.7;
                break;
            }
            case 2: {
                Cp.Cp = 4.0 + 5.5728 / (T * T) * Math.exp(-222.0 / T) + 10.385 / (T * T) * Math.exp(-1010.0 / T) + 12.554 / (T * T) * Math.exp(-2450.0 / T);
                Cp.CpT = (4.0 + 5.5728 / (T * T) * Math.exp(-222.0 / T) + 10.385 / (T * T) * Math.exp(-1010.0 / T) + 12.554 / (T * T) * Math.exp(-2450.0 / T)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 3: {
                Cp.Cp = -39.09957 + 0.7222719 * T - 6.516371E-4 * T * T;
                Cp.CpT = (-39.09957 + 0.7222719 * T - 6.516371E-4 * T * T) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 4: {
                Cp.Cp = (41600.0 + 301400.0 * Math.pow(1461.7 / T / this.sinh(1461.7 / T), 2.0) + 180950.0 * Math.pow(-668.8 / T / this.cosh(-668.8 / T), 2.0)) / 1000.0;
                Cp.CpT = (41600.0 + 301400.0 * (1461.7 / T / this.sinh(1461.7 / T)) + 180950.0 * (-668.8 / T / this.cosh(-668.8 / T))) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 5: {
                Cp.Cp = (71340.0 + 243000.0 * Math.pow(1630.0 / T / this.sinh(1630.0 / T), 2.0) + 150330.0 * Math.pow(730.42 / T / this.cosh(730.42 / T), 2.0)) / 1000.0;
                Cp.CpT = (71340.0 + 243000.0 * Math.pow(1630.0 / T / this.sinh(1630.0 / T), 2.0) + 150330.0 * Math.pow(730.42 / T / this.cosh(730.42 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 6: {
                Cp.Cp = (34090.0 + 72460.0 * Math.pow(1723.0 / T / this.sinh(1723.0 / T), 2.0) + 44800.0 * Math.pow(780.5 / T / this.cosh(780.5 / T), 2.0)) / 1000.0;
                Cp.CpT = (34090.0 + 72460.0 * Math.pow(1723.0 / T / this.sinh(1723.0 / T), 2.0) + 44800.0 * Math.pow(780.5 / T / this.cosh(780.5 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 7: {
                Cp.Cp = (33261.0 + 24919.0 * Math.pow(1112.2 / T / this.sinh(1112.2 / T), 2.0) + 9253.4 * Math.pow(559.2 / T / this.cosh(559.2 / T), 2.0)) / 1000.0;
                Cp.CpT = (33261.0 + 24919.0 * Math.pow(1112.2 / T / this.sinh(1112.2 / T), 2.0) + 9253.4 * Math.pow(559.2 / T / this.cosh(559.2 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 8: {
                Cp.Cp = (44373.0 + 131190.0 * Math.pow(1642.2 / T / this.sinh(1642.2 / T), 2.0) + 85441.0 * Math.pow(738.77 / T / this.cosh(738.77 / T), 2.0)) / 1000.0;
                Cp.CpT = (44373.0 + 131190.0 * Math.pow(1642.2 / T / this.sinh(1642.2 / T), 2.0) + 85441.0 * Math.pow(738.77 / T / this.cosh(738.77 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 9: {
                Cp.Cp = (45769.0 + 203850.0 * Math.pow(665.82 / T / this.sinh(665.82 / T), 2.0) + 134740.0 * Math.pow(277.6 / T / this.cosh(277.6 / T), 2.0)) / 1000.0;
                Cp.CpT = (45769.0 + 203850.0 * Math.pow(665.82 / T / this.sinh(665.82 / T), 2.0) + 134740.0 * Math.pow(277.6 / T / this.cosh(277.6 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 10: {
                Cp.Cp = (122300.0 + 198400.0 * Math.pow(797.82 / T / this.sinh(797.82 / T), 2.0) + 94756.0 * Math.pow(408.2 / T / this.cosh(408.2 / T), 2.0)) / 1000.0;
                Cp.CpT = (122300.0 + 198400.0 * Math.pow(797.82 / T / this.sinh(797.82 / T), 2.0) + 94756.0 * Math.pow(408.2 / T / this.cosh(408.2 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 11: {
                Cp.Cp = 8.314472 * (4.0 + 17.47 * (569.0 / T) * (569.0 / T) * Math.exp(569.0 / T) / Math.pow(Math.exp(569.0 / T) - 1.0, 2.0) + 16.29 * (2232.0 / T) * (2232.0 / T) * Math.exp(2232.0 / T) / Math.pow(Math.exp(2232.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (4.0 + 17.47 * (569.0 / T) * (569.0 / T) * Math.exp(569.0 / T) / Math.pow(Math.exp(569.0 / T) - 1.0, 2.0) + 16.29 * (2232.0 / T) * (2232.0 / T) * Math.exp(2232.0 / T) / Math.pow(Math.exp(2232.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 12: {
                Cp.Cp = (58140.0 + 286300.0 * Math.pow(1440.6 / T / this.sinh(1440.6 / T), 2.0) + 189800.0 * Math.pow(-650.43 / T / this.cosh(-650.43 / T), 2.0)) / 1000.0;
                Cp.CpT = (58140.0 + 286300.0 * Math.pow(1440.6 / T / this.sinh(1440.6 / T), 2.0) + 189800.0 * Math.pow(-650.43 / T / this.cosh(-650.43 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 13: {
                Cp.Cp = 5.3 + 0.03973 * T - 1.859E-5 * (T * T);
                Cp.CpT = (5.3 + 0.03973 * T - 1.859E-5 * (T * T)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 14: {
                Cp.Cp = (33427.0 + 48980.0 * Math.pow(2036.0 / T / this.sinh(2036.0 / T), 2.0) + 22560.0 * Math.pow(882.0 / T / this.cosh(882.0 / T), 2.0)) / 1000.0;
                Cp.CpT = (33427.0 + 48980.0 * Math.pow(2036.0 / T / this.sinh(2036.0 / T), 2.0) + 22560.0 * Math.pow(882.0 / T / this.cosh(882.0 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 15: {
                Cp.Cp = (51480.0 + 144200.0 * Math.pow(1603.4 / T / this.sinh(1603.4 / T), 2.0) + 77470.0 * Math.pow(725.4 / T / this.cosh(725.4 / T), 2.0)) / 1000.0;
                Cp.CpT = (51480.0 + 144200.0 * Math.pow(1603.4 / T / this.sinh(1603.4 / T), 2.0) + 77470.0 * Math.pow(725.4 / T / this.cosh(725.4 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 16: {
                Cp.Cp = 8.314472 * (4.0 + 11.43 * (403.0 / T) * (403.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(403.0 / T) - 1.0, 2.0) + 12.83 * (1428.0 / T) * (1428.0 / T) * Math.exp(1428.0 / T) / Math.pow(Math.exp(1428.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (4.0 + 11.43 * (403.0 / T) * (403.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(403.0 / T) - 1.0, 2.0) + 12.83 * (1428.0 / T) * (1428.0 / T) * Math.exp(1428.0 / T) / Math.pow(Math.exp(1428.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 17: {
                Cp.Cp = 8.314472 * (5.944 + 7.549 * (718.0 / T) * (718.0 / T) * Math.exp(718.0 / T) / Math.pow(Math.exp(718.0 / T) - 1.0, 2.0) + 1.537 * (877.0 / T) * (877.0 / T) * Math.exp(877.0 / T) / Math.pow(Math.exp(877.0 / T) - 1.0, 2.0) + 2.03 * (4465.0 / T) * (4465.0 / T) * Math.exp(4465.0 / T) / Math.pow(Math.exp(4465.0 / T) - 1.0, 2.0) + 7.455 * (1755.0 / T) * (1755.0 / T) * Math.exp(1755.0 / T) / Math.pow(Math.exp(1755.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (5.944 + 7.549 * (718.0 / T) * (718.0 / T) * Math.exp(718.0 / T) / Math.pow(Math.exp(718.0 / T) - 1.0, 2.0) + 1.537 * (877.0 / T) * (877.0 / T) * Math.exp(877.0 / T) / Math.pow(Math.exp(877.0 / T) - 1.0, 2.0) + 2.03 * (4465.0 / T) * (4465.0 / T) * Math.exp(4465.0 / T) / Math.pow(Math.exp(4465.0 / T) - 1.0, 2.0) + 7.455 * (1755.0 / T) * (1755.0 / T) * Math.exp(1755.0 / T) / Math.pow(Math.exp(1755.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 18: {
                Cp.Cp = 27.89465 + 0.09134686 * T + 2.079961E-4 * T * T - 2.317613E-7 * T * T * T;
                Cp.CpT = (27.89465 + 0.09134686 * T + 2.079961E-4 * T * T - 2.317613E-7 * T * T * T) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
            }
            case 19: {
                Cp.Cp = 8.314472 * (1.0578 * Math.pow(T, 0.33) + 4.44402 * (1791.0 / T) * (1791.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(1791.0 / T) - 1.0, 2.0) + 3.7515 * (823.0 / T) * (823.0 / T) * Math.exp(823.0 / T) / Math.pow(Math.exp(823.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (1.0578 * Math.pow(T, 0.33) + 4.44402 * (1791.0 / T) * (1791.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(1791.0 / T) - 1.0, 2.0) + 3.7515 * (823.0 / T) * (823.0 / T) * Math.exp(823.0 / T) / Math.pow(Math.exp(823.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
            }
        }
        return Cp;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
    }

    public double[] calcSubstance(double T, double P, double x) {
        double[] res = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        return res;
    }

    public double[] getT_from_hP(double h, double P) {
        double[] res = new double[]{300.0, 1.0};
        return res;
    }

    public double[] getT_from_sP(double s, double P) {
        double[] res = new double[]{300.0, 1.0};
        return res;
    }

    public double[] getP_from_sT(double s, double T) {
        double[] res = new double[]{500000.0, 1.0};
        return res;
    }

    public double[] getP_from_hT(double h, double T) {
        double[] res = new double[]{500000.0, 1.0};
        return res;
    }

    public double[] getTPx_from_hs(double h, double s) {
        double[] res = new double[]{500000.0, 300.0, 1.0};
        return res;
    }

    public double getSatPressure(double T, double x) throws MonoPhaseException {
        return 1.0;
    }

    public double getSatTemperature(double P, double x) throws MonoPhaseException {
        return 300.0;
    }

    public double[] getTransportProperties(double T, double ro) {
        if (this.nbComponents == 1) {
            return this.huberPur.CalcViscosityConductivity(T, ro);
        }
        return this.huberMix.CalcViscosityConductivity(T, ro);
    }

    public double[] getCriticalParameters() {
        double[] props = new double[4];
        if (this.nbComponents == 1) {
            props[0] = this.compProp[0].Tc;
            props[1] = this.compProp[0].Pc / 100000.0;
            props[2] = this.compProp[0].Vc;
            props[3] = this.compProp[0].M;
        } else if (this.zz != null) {
            props[0] = this.CalcTcMix();
            props[1] = this.CalcPcMix() / 100000.0;
            props[2] = this.CalcVcMix();
            props[3] = this.CalcMMix();
        }
        return props;
    }

    public void setSubstanceParameters(double[] params) {
        System.out.println("CTPbibSubstance setSubstanceParameters 0 " + params[0] + " 1 " + params[1]);
    }

    protected double CalcPcMix() {
        double Pcm = 0.0;
        double Tcm = this.CalcTcMix();
        double sommeZc = 0.0;
        double sommeVc = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            double Zci = this.compProp[i].Pc * this.compProp[i].Vc / (this.compProp[i].Tc * 8.314472471);
            sommeZc += this.zz[i] * Zci;
            sommeVc += this.zz[i] * this.compProp[i].Vc;
            ++i;
        }
        Pcm = 8.314472471 * Tcm * sommeZc / sommeVc;
        return Pcm;
    }

    protected double CalcMMix() {
        double Mm = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            Mm += this.compProp[i].M * this.zz[i];
            ++i;
        }
        return Mm;
    }

    protected double CalcVcMix() {
        double vcm = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            vcm += this.compProp[i].Vc * this.zz[i];
            ++i;
        }
        return vcm;
    }

    protected double CalcTcMix() {
        double Tcm = 0.0;
        int i = 0;
        while (i < this.nbComponents) {
            if (this.debug) {
                System.out.println("systemName " + this.systemName + " compProp[i].Tc " + this.compProp[i].Tc);
            }
            if (this.debug) {
                System.out.println("systemName " + this.systemName + " zz[i] " + this.zz[i]);
            }
            Tcm += this.compProp[i].Tc * this.zz[i];
            ++i;
        }
        return Tcm;
    }

    public void readXml(String systFileName) {
        this.selectedFile = systFileName;
        if (!this.selectedFile.equals("")) {
            String fileName = String.valueOf(System.getProperty("user.dir")) + File.separator + "mixtures" + File.separator + "CTPLib_MEL" + File.separator + this.selectedFile;
            try {
                String value;
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(fileName);
                Element element = document.getRootElement();
                if (this.debug) {
                    System.out.println();
                }
                if (this.debug) {
                    System.out.println("Structure du fichier " + this.selectedFile);
                }
                if (this.debug) {
                    System.out.println();
                }
                String code = "cubic";
                code = value = element.getAttributeValue("Model");
                this.fluidModel = this.getFluidModel(code);
                System.out.println("code fluide: " + code);
                value = element.getAttributeValue("Transport");
                if (value != null) {
                    this.nbTrapp = Util.lit_i((String)value);
                }
                if ((value = element.getAttributeValue("TrappRefFluid")) != null && value.equals("R134a")) {
                    this.nbTrapp = 0;
                }
                if (value != null && value.equals("propane")) {
                    this.nbTrapp = 1;
                }
                if (this.debug) {
                    System.out.println("code TRAPP: " + this.nbTrapp);
                }
                if ((value = element.getAttributeValue("TinitEst")) != null) {
                    this.TinitEst = Util.lit_d((String)value);
                }
                if ((value = element.getAttributeValue("PinitEst")) != null) {
                    this.PinitEst = Util.lit_d((String)value);
                }
                if ((value = element.getAttributeValue("simplified_ELV_calc")) != null) {
                    this.simplified_ELV_calc = Util.lit_b((String)value);
                }
                List listComponents = element.getChildren();
                Iterator itt = listComponents.iterator();
                Vector<Element> vComp = new Vector<Element>();
                while (itt.hasNext()) {
                    Element component = new Element("TEST");
                    component = (Element)itt.next();
                    if (this.debug) {
                        System.out.println();
                    }
                    if (this.debug) {
                        System.out.println(component.getName());
                    }
                    if (component.getName().equals("FLUID_MODEL")) {
                        this.fluidModel.fluid_Model = component;
                        if (this.debug) {
                            System.out.println("ajout\u00e9 \u00e0 fluid_Model " + this.fluidModel.fluid_Model.getName());
                        }
                    }
                    if (component.getName().equals("MIXRULES")) {
                        if (this.debug) {
                            System.out.println("ajout\u00e9 \u00e0 mixRules " + component.getName());
                        }
                        this.fluidModel.mixRules = component;
                        if (this.debug) {
                            System.out.println("ajout\u00e9 \u00e0 mixRules " + this.fluidModel.mixRules.getName());
                        }
                    }
                    if (!component.getName().equals("COMPONENT")) continue;
                    vComp.add(component);
                }
                if (this.debug) {
                    System.out.println("nb de composants: " + vComp.size());
                }
                this.nbComponents = vComp.size();
                this.initProp = new double[4 * this.nbComponents + 1];
                this.compProp = new CompProperties[this.nbComponents];
                this.fract_mass = new double[this.nbComponents];
                this.zz = new double[this.nbComponents];
                this.k = new double[this.nbComponents][this.nbComponents];
                this.fluidModel.component = new Element[vComp.size()];
                int i = 0;
                while (i < vComp.size()) {
                    this.fluidModel.component[i] = (Element)vComp.elementAt(i);
                    if (this.debug) {
                        System.out.println("ajout\u00e9 \u00e0 component " + this.fluidModel.component[i].getName());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fluidModel.readXml();
        }
    }

    protected FluidModel getFluidModel(String code) {
        FluidModel fm = null;
        Class<?> obj = null;
        String className = "bibCTP.model." + code;
        try {
            obj = Class.forName(className);
            fm = (FluidModel)obj.newInstance();
            fm.tbs = this;
            fm.init();
        }
        catch (ClassNotFoundException e) {
            String message = "Watch out! the class has not been found: " + code + "\nCheck your classpath";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            String message = "Watch out! the class could not be instantiated: " + code;
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            String message = "Watch out! the class " + code + " threw an IllegalAccessException: ";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        return fm;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }
}

