/*
 * Decompiled with CFR 0.152.
 */
package bibCTP;

public class CompProperties {
    public double Tref = 0.0;
    public double P0 = 0.0;
    public double Pref = 0.0;
    public double Pc = 0.0;
    public double Tc = 0.0;
    public double Zc = 0.0;
    public double Vc;
    public double omega = 0.0;
    public double Tr;
    public double Trref;
    public double h0 = 0.0;
    public double s0 = 0.0;
    public double u0 = 0.0;
    public double M = 0.0;
    public double Tb;
    public double dipole = 0.0;
    public double A;
    public double B;
    public double C;
    public double D;
    public double E;
    public double F;
    public double G;
    public double K;
    public double psat_A;
    public double psat_B;
    public double psat_C;
    public double psat_D;
    public double psat_E;
    public double Ts_A;
    public double Ts_B;
    public double Ts_C;
    public double Ts_D;
    public double Ts_E;
    public String name;
    public int codeCp = 0;
    public int codePsat = 0;
    public int codeTsat = 0;
    public int nbexp = 150;
    public int ajustMC = 0;
    protected double[] Texp = new double[150];
    protected double[] Pexp = new double[150];
    protected double[] VsatL_exp = new double[150];
    protected double[] Hvap_exp = new double[150];
    protected double[] xexp;
    protected double[] yexp;
    protected double[] titrexp;

    public double h_gaz_mol(double T) {
        double $T = T / 1000.0;
        double $h = this.A * ($T - 0.298) + this.B / 2.0 * ($T * $T - 0.088804) + this.C / 3.0 * ($T * $T * $T - 0.026463591999999998);
        $h = $h + this.D / 4.0 * ($T * $T * $T * $T - 0.007886150415999998) + this.E / 5.0 * ($T * $T * $T * $T * $T - 0.0023500728239679992);
        $h = $h - this.G * (1.0 / $T - 3.3557046979865772) + this.K * Math.log($T / 0.298);
        return $h * 1000.0;
    }

    public double s_gaz_mol(double $T, double $p) {
        double $s = this.A * Math.log(($T /= 1000.0) / 0.298) + this.B * ($T - 0.298) + this.C / 2.0 * ($T * $T - 0.088804);
        $s = $s + this.D / 3.0 * ($T * $T * $T - 0.026463591999999998) + this.E / 4.0 * ($T * $T * $T * $T - 0.007886150415999998);
        $s = $s - this.G / 2.0 * (1.0 / ($T * $T) - 11.260754020089186) - this.K * (1.0 / $T - 3.3557046979865772);
        return $s - 8.314472471 * Math.log($p);
    }

    public double u_gaz_mol(double T) {
        double $h = this.h_gaz_mol(T);
        double $u = $h - 8.314472471 * (T - 298.0);
        return $u;
    }

    public double Tsat_P(double p) {
        return this.TsatEstimated(this.Tc, this.Pc, this.omega, p);
    }

    public double PsatEstimated(double TCritic, double PCritic, double w, double Temperature) {
        double Tr = Temperature / TCritic;
        return PCritic * Math.exp(5.92714 - 6.09648 / Tr - 1.28862 * Math.log(Tr) + 0.169347 * Math.pow(Tr, 6.0) + w * (15.2518 - 15.6875 / Tr - 13.4721 * Math.log(Tr) + 0.43577 * Math.pow(Tr, 6.0)));
    }

    public double TsatEstimated(double TCritic, double PCritic, double w, double Pressure) {
        double Tmax = 0.99 * TCritic;
        double Tmin = 0.01 * TCritic;
        double Tmid = (Tmax + Tmin) / 2.0;
        while (Tmax - Tmin > 0.1) {
            Tmid = (Tmax + Tmin) / 2.0;
            if ((this.PsatEstimated(TCritic, PCritic, w, Tmid) - Pressure) * (this.PsatEstimated(TCritic, PCritic, w, Tmax) - Pressure) > 0.0) {
                Tmax = Tmid;
                continue;
            }
            Tmin = Tmid;
        }
        return (Tmax + Tmin) / 2.0;
    }

    public double psat_T(double T) {
        return this.PsatEstimated(this.Tc, this.Pc, this.omega, T);
    }
}

