/*
 * Decompiled with CFR 0.152.
 */
package bibCTP;

import bibCTP.CTPbibSubstance;
import bibCTP.MonoPhaseException;

public class MixCTPbibSubstance
extends CTPbibSubstance {
    double PaToBar = 100000.0;
    double fact2 = 100000.0;
    double epsiMinpack = 1.0E-6;
    double paramValue;

    public MixCTPbibSubstance() {
    }

    public MixCTPbibSubstance(String systName, String systFile) {
        super(systName, systFile);
    }

    public double getSatPressure(double T, double x) throws MonoPhaseException {
        return this.fluidModel.getSatPressure(T, x);
    }

    public double getSatTemperature(double P, double x) {
        return this.fluidModel.getSatTemperature(P, x);
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        super.fcn(mm, n, x, fvec, iflag);
        double PP = 1.0;
        double TT = 300.0;
        double ratioV = 0.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("invhPL")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, 0.0);
            this.callFunction = "invhPL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhP")) {
            TT = x[1];
            PP = this.PPparam;
            ratioV = this.Rparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, ratioV);
            this.callFunction = "invhP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhPV")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEnthalpyResidual(this.HHparam, PP, x, 1.0);
            this.callFunction = "invhPV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsPL")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, 0.0);
            this.callFunction = "invsPL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsP")) {
            TT = x[1];
            PP = this.PPparam;
            ratioV = this.Rparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, ratioV);
            this.callFunction = "invsP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsPV")) {
            TT = x[1];
            PP = this.PPparam;
            fvec[1] = this.getEntropyResidual(this.SSparam, PP, x, 1.0);
            this.callFunction = "invsPV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhTL")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, 0.0);
            this.callFunction = "invhTL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhT")) {
            TT = this.TTparam;
            PP = x[1];
            ratioV = this.Rparam;
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, ratioV);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhTV")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEnthalpyResidual2(this.HHparam, TT, x, 1.0);
            this.callFunction = "invhTV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsTL")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, 0.0);
            this.callFunction = "invsTL";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsT")) {
            TT = this.TTparam;
            PP = x[1];
            ratioV = this.Rparam;
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, ratioV);
            this.callFunction = "invsT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsTV")) {
            TT = this.TTparam;
            PP = x[1];
            fvec[1] = this.getEntropyResidual2(this.SSparam, TT, x, 1.0);
            this.callFunction = "invsTV";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    public double[] calcSubstance(double T, double P_Pa, double x) {
        return this.fluidModel.calcSubstance(T, P_Pa, x);
    }

    public double[] getT_from_hP(double h, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.HHparam = h;
        this.PPparam = P;
        System.out.println("simplified_ELV_calc: " + this.simplified_ELV_calc);
        double Tbulle = 300.0;
        double Trosee = 300.0;
        Tbulle = this.getSatTemperature(P, 0.0);
        Trosee = this.getSatTemperature(P, 1.0);
        if (this.debug) {
            System.out.println("Tbulle: " + Tbulle + "Trosee: " + Trosee + "  Tc: " + this.mixTc);
        }
        double hl = 0.0;
        double hv = 0.0;
        double[] res2 = this.calcSubstance(Tbulle - 0.1, P, 0.0);
        hl = res2[0];
        double[] res3 = this.calcSubstance(Trosee + 0.1, P, 1.0);
        hv = res3[0];
        if (this.debug) {
            System.out.println("hl: " + hl + "  hv: " + hv);
        }
        this.Rparam = (h - hl) / (hv - hl);
        if (h >= hl && h <= hv) {
            double xx;
            res[1] = xx = (h - hl) / (hv - hl);
            init[1] = (Tbulle + Trosee) / 2.0;
            if (!this.simplified_ELV_calc) {
                this.callFunction = "invhP";
                double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
                res[0] = result[1];
            } else {
                res[0] = init[1];
            }
            System.out.println("h: " + h + "  xx: " + xx + " simplified_ELV_calc : " + this.simplified_ELV_calc);
            return res;
        }
        if (h < hl) {
            res[1] = 0.0;
            init[1] = (this.Tmini + Tbulle) / 2.0;
            this.callFunction = "invhPL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            return res;
        }
        init[1] = (Trosee + this.Tmaxi) / 2.0;
        this.callFunction = "invhPV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    protected double getEnthalpyResidual(double h, double PP, double[] x, double xx) {
        double[] res = this.calcSubstance(x[1], PP, xx);
        double critere = h - res[0];
        return critere;
    }

    public double[] getT_from_sP(double s, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.SSparam = s;
        this.PPparam = P;
        double Tbulle = 300.0;
        double Trosee = 300.0;
        Tbulle = this.getSatTemperature(P, 0.0);
        Trosee = this.getSatTemperature(P, 1.0);
        if (this.debug) {
            System.out.println("Tbulle: " + Tbulle + "Trosee: " + Trosee + "  Tc: " + this.mixTc);
        }
        double sl = 0.0;
        double sv = 0.0;
        double[] res2 = this.calcSubstance(Tbulle - 0.1, P, 0.0);
        sl = res2[5];
        double[] res3 = this.calcSubstance(Trosee + 0.1, P, 1.0);
        sv = res3[5];
        if (this.debug) {
            System.out.println("hl: " + sl + "  hv: " + sv);
        }
        this.Rparam = (s - sl) / (sv - sl);
        if (s >= sl && s <= sv) {
            double xx;
            res[1] = xx = (s - sl) / (sv - sl);
            init[1] = (Tbulle + Trosee) / 2.0;
            this.callFunction = "invsP";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            if (this.debug) {
                System.out.println("h: " + s + "  xx: " + xx);
            }
            return res;
        }
        if (s < sl) {
            res[1] = 0.0;
            init[1] = (this.Tmini + Tbulle) / 2.0;
            this.callFunction = "invsPL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1];
            return res;
        }
        init[1] = (Trosee + this.Tmaxi) / 2.0;
        this.callFunction = "invsPV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    protected double getEntropyResidual(double s, double PP, double[] x, double xx) {
        double[] res = this.calcSubstance(x[1], PP, xx);
        double critere = s - res[5];
        return critere;
    }

    public double[] getP_from_hT(double h, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.HHparam = h;
        this.TTparam = T;
        double Pbulle = 1.0;
        double Prosee = 1.0;
        try {
            Pbulle = this.getSatPressure(T, 0.0);
            Prosee = this.getSatPressure(T, 1.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Pbulle: " + Pbulle + "Prosee: " + Prosee);
        }
        double hl = 0.0;
        double hv = 0.0;
        double[] res2 = this.calcSubstance(T - 0.1, Pbulle, 0.0);
        hl = res2[0];
        double[] res3 = this.calcSubstance(T + 0.1, Prosee, 1.0);
        hv = res3[0];
        if (this.debug) {
            System.out.println("hl: " + hl + "  hv: " + hv);
        }
        this.Rparam = (h - hl) / (hv - hl);
        if (h >= hl && h <= hv) {
            double xx;
            res[1] = xx = (h - hl) / (hv - hl);
            init[1] = (Pbulle + Prosee) / 2.0;
            this.callFunction = "invhT";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + h + "  xx: " + xx);
            }
            return res;
        }
        if (h < hl) {
            res[1] = 0.0;
            init[1] = (this.Pmaxi + Pbulle) / 2.0;
            this.callFunction = "invhTL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + h + "  xx: " + this.xx);
            }
            return res;
        }
        init[1] = Prosee / 2.0;
        this.callFunction = "invhTV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    protected double getEnthalpyResidual2(double h, double TT, double[] x, double xx) {
        double[] res = this.calcSubstance(TT, x[1], xx);
        double critere = h - res[0];
        return critere;
    }

    public double[] getP_from_sT(double s, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.SSparam = s;
        this.TTparam = T;
        double Pbulle = 10.0;
        double Prosee = 10.0;
        try {
            Pbulle = this.getSatPressure(T, 0.0);
            Prosee = this.getSatPressure(T, 1.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Pbulle: " + Pbulle + "Prosee: " + Prosee);
        }
        double sl = 0.0;
        double sv = 0.0;
        double[] res2 = this.calcSubstance(T, Pbulle, 0.0);
        sl = res2[5];
        double[] res3 = this.calcSubstance(T, Prosee, 1.0);
        sv = res3[5];
        if (this.debug) {
            System.out.println("sl: " + sl + "  sv: " + sv);
        }
        this.Rparam = (s - sl) / (sv - sl);
        if (s >= sl && s <= sv) {
            double xx;
            res[1] = xx = (s - sl) / (sv - sl);
            init[1] = (Pbulle + Prosee) / 2.0;
            this.callFunction = "invsT";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("h: " + s + "  xx: " + xx);
            }
            return res;
        }
        if (s < sl) {
            res[1] = 0.0;
            init[1] = (Pbulle + this.Pmaxi) / 2.0;
            this.callFunction = "invsTL";
            double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
            res[0] = result[1] / 100000.0;
            if (this.debug) {
                System.out.println("s: " + s + "  xx: " + this.xx);
            }
            return res;
        }
        init[1] = Prosee / 2.0;
        this.callFunction = "invsTV";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    protected double getEntropyResidual2(double s, double TT, double[] x, double xx) {
        double[] res = this.calcSubstance(TT, x[1], xx);
        double critere = s - res[5];
        return critere;
    }
}

