/*
 * Decompiled with CFR 0.152.
 */
package bibCTP;

import bibCTP.CTPbibSubstance;
import bibCTP.MonoPhaseException;
import bibCTP.util.CpGeneralisee;
import bibCTP.util.EnthalpieEntropie;

public class PureCTPbibSubstance
extends CTPbibSubstance {
    public PureCTPbibSubstance() {
    }

    public PureCTPbibSubstance(String systName, String systFile) {
        super(systName, systFile);
    }

    public double getSatPressure(double T, double x) throws MonoPhaseException {
        return this.fluidModel.getSatPressure(T, x);
    }

    public double getSatTemperature(double P, double x) throws MonoPhaseException {
        return this.fluidModel.getSatTemperature(P, x);
    }

    protected double getFugacityEquality(String callFunction, double param, int i) {
        double PP;
        double TT;
        double[] init = new double[2];
        this.callFunction = callFunction;
        if (callFunction.equals("Psat")) {
            TT = this.Tparam = param;
            if (this.compProp[i].codePsat == 1) {
                init[1] = PP = this.compProp[i].psat_T(this.Tparam);
            } else {
                this.Tr = this.Tparam / this.compProp[0].Tc;
                double INT = 5.92714 - 6.09648 / this.Tr - 1.28862 * Math.log(this.Tr) + 0.169347 * Math.pow(this.Tr, 6.0) + this.compProp[i].omega * (15.2518 - 15.6875 / this.Tr - 13.4721 * Math.log(this.Tr) + 0.43577 * Math.pow(this.Tr, 6.0));
                init[1] = PP = Math.exp(INT) * this.compProp[i].Pc;
            }
        }
        if (callFunction.equals("Tsat")) {
            PP = this.Pparam = param;
            init[1] = TT = this.compProp[i].Tsat_P(this.Pparam);
        }
        double[] result = this.solveWithMinPack(1, callFunction, init, 1.0E-6);
        return result[1];
    }

    public double[] getT_from_hP(double h, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Hparam = h;
        this.Pparam = P;
        double Tsat = 300.0;
        try {
            Tsat = this.getSatTemperature(P, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Tsat: " + Tsat + "  Tc: " + this.mixTc);
        }
        double hl = 0.0;
        double hv = 0.0;
        if (Tsat < this.mixTc) {
            double[] res2 = this.calcSubstance(Tsat, P, 0.0);
            hl = res2[0];
            res2 = this.calcSubstance(Tsat, P, 1.0);
            hv = res2[0];
            if (this.debug) {
                System.out.println("hl: " + hl + "  hv: " + hv);
            }
            if (h >= hl && h <= hv) {
                double xx = (h - hl) / (hv - hl);
                res[0] = Tsat;
                res[1] = xx;
                if (this.debug) {
                    System.out.println("h: " + h + "  xx: " + xx);
                }
                return res;
            }
            init[1] = (this.mixTc + this.Tmini) / 2.0;
        } else {
            init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        }
        if (this.TinitEst != 0.0) {
            init[1] = this.TinitEst;
        }
        this.callFunction = "invhP";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    public double[] getT_from_sP(double s, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Sparam = s;
        this.Pparam = P;
        double Tsat = 300.0;
        try {
            Tsat = this.getSatTemperature(P, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Tsat: " + Tsat + "  Tc: " + this.mixTc);
        }
        double sl = 0.0;
        double sv = 0.0;
        if (Tsat < this.mixTc) {
            double[] res2 = this.calcSubstance(Tsat, P, 0.0);
            sl = res2[5];
            res2 = this.calcSubstance(Tsat, P, 1.0);
            sv = res2[5];
            if (this.debug) {
                System.out.println("sl: " + sl + "  sv: " + sv);
            }
            if (s >= sl && s <= sv) {
                res[0] = Tsat;
                res[1] = (s - sl) / (sv - sl);
                return res;
            }
            init[1] = (this.mixTc + this.Tmini) / 2.0;
        } else {
            init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        }
        if (this.TinitEst != 0.0) {
            init[1] = this.TinitEst;
        }
        this.callFunction = "invsP";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    public double[] getP_from_sT(double s, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Sparam = s;
        this.Tparam = T;
        double Psat = 100000.0;
        try {
            Psat = this.getSatPressure(T, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Psat: " + Psat + "Pc: " + this.mixPc);
        }
        double sl = 0.0;
        double sv = 0.0;
        if (Psat < this.mixPc) {
            double[] res2 = this.calcSubstance(T, Psat, 0.0);
            sl = res2[5];
            res2 = this.calcSubstance(T, Psat, 1.0);
            sv = res2[5];
            if (this.debug) {
                System.out.println("sl: " + sl + "  sv: " + sv);
            }
            if (s >= sl && s <= sv) {
                res[0] = Psat / 100000.0;
                res[1] = (s - sl) / (sv - sl);
                return res;
            }
            init[1] = this.mixPc / 2.0;
        } else {
            init[1] = (this.mixPc + this.Pmaxi) / 2.0;
        }
        if (this.PinitEst != 0.0) {
            init[1] = this.PinitEst;
        }
        this.callFunction = "invsT";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    public double[] getP_from_hT(double h, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Hparam = h;
        this.Tparam = T;
        double Psat = 100000.0;
        try {
            Psat = this.getSatPressure(T, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Psat: " + Psat + "Pc: " + this.mixPc);
        }
        double hl = 0.0;
        double hv = 0.0;
        if (Psat < this.mixPc) {
            double[] res2 = this.calcSubstance(T, Psat, 0.0);
            hl = res2[0];
            res2 = this.calcSubstance(T, Psat, 1.0);
            hv = res2[0];
            if (this.debug) {
                System.out.println("hl: " + hl + "  hv: " + hv);
            }
            if (h >= hl && h <= hv) {
                double xx = (h - hl) / (hv - hl);
                res[0] = Psat;
                res[1] = xx;
                return res;
            }
            init[1] = this.mixPc / 2.0;
        } else {
            init[1] = (this.mixPc + this.Pmaxi) / 2.0;
        }
        if (this.PinitEst != 0.0) {
            init[1] = this.PinitEst;
        }
        this.callFunction = "invhT";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    public double[] getTPx_from_hs(double h, double s) {
        double[] res = new double[3 * this.nbComponents + 1];
        double[] init = new double[3];
        this.Hparam = h;
        this.Sparam = s;
        init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        init[2] = this.mixPc / 2.0;
        if (this.TinitEst != 0.0) {
            init[1] = this.TinitEst;
        }
        if (this.PinitEst != 0.0) {
            init[2] = this.PinitEst;
        }
        this.callFunction = "invhs";
        double[] result = this.solveWithMinPack(2, this.callFunction, init, 1.0E-6);
        res[0] = result[2];
        res[1] = result[1];
        res[2] = 1.0;
        return res;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        super.fcn(mm, n, x, fvec, iflag);
        double PP = 1.0;
        double TT = 300.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("invhP")) {
            TT = x[1];
            PP = this.Pparam;
            fvec[1] = this.getEnthalpyResidual(this.Hparam, PP, x);
            this.callFunction = "invhP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsP")) {
            TT = x[1];
            PP = this.Pparam;
            fvec[1] = this.getEntropyResidual(this.Sparam, PP, x);
            this.callFunction = "invsP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsT")) {
            PP = x[1];
            TT = this.Tparam;
            fvec[1] = this.getEntropyResidual2(this.Sparam, x, TT);
            this.callFunction = "invsT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhT")) {
            PP = x[1];
            TT = this.Tparam;
            fvec[1] = this.getEnthalpyResidual2(this.Hparam, x, TT);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhs")) {
            TT = x[1];
            PP = x[2];
            fvec[1] = this.getEnthalpyResidual3(this.Hparam, x);
            fvec[2] = this.getEntropyResidual3(this.Sparam, x);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            if (this.debug) {
                System.out.println("fvec[2]: " + fvec[2] + "  x[2]: " + x[2]);
            }
        }
        if (this.callFunction.equals("adjustmentMC")) {
            fvec[2] = 0.0;
            fvec[3] = 0.0;
            this.callFunction = "adjustmentMC";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            if (this.debug) {
                System.out.println("x[2]: " + x[2] + "  x[3]: " + x[3]);
            }
        }
        if (this.callFunction.equals("searchForFCoef")) {
            TT = this.Tparam;
            double vv = this.volumetampon;
            this.callFunction = "searchForFCoef";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            if (this.debug) {
                System.out.println("fvec[2]: " + fvec[2] + "  x[2]: " + x[2]);
            }
        }
    }

    protected double getEnthalpyResidual(double h, double PP, double[] x) {
        double[] res = this.calcSubstance(x[1], PP, 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEnthalpyResidual2(double h, double[] x, double TT) {
        double[] res = this.calcSubstance(TT, x[1], 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEnthalpyResidual3(double h, double[] x) {
        double[] res = this.calcSubstance(x[1], x[2], 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEntropyResidual(double s, double PP, double[] x) {
        double[] res = this.calcSubstance(x[1], PP, 1.0);
        double critere = s - res[5];
        return critere;
    }

    protected double getEntropyResidual2(double s, double[] x, double TT) {
        double[] res = this.calcSubstance(TT, x[1], 1.0);
        double critere = s - res[5];
        return critere;
    }

    protected double getEntropyResidual3(double s, double[] x) {
        double[] res = this.calcSubstance(x[1], x[2], 1.0);
        double critere = s - res[5];
        return critere;
    }

    public double[] calcSubstance(double T, double P, double x) {
        return this.fluidModel.calcSubstance(T, P, x);
    }

    protected EnthalpieEntropie methodeTrapezes(int nbtrapezes, double x1, double x2, double P) {
        CpGeneralisee f1 = new CpGeneralisee();
        CpGeneralisee f2 = new CpGeneralisee();
        EnthalpieEntropie hs = new EnthalpieEntropie();
        double pas = (x2 - x1) / (double)nbtrapezes;
        double aireh = 0.0;
        double aires = 0.0;
        int cas = this.numeroCas(this.compProp[0].name);
        if (this.compProp[0].codeCp == 2) {
            int i = 0;
            while (i < nbtrapezes) {
                double borneinf = x1 + (double)i * pas;
                double bornesup = borneinf + pas;
                f1.Cp = (this.compProp[0].A + this.compProp[0].B * Math.pow(this.compProp[0].C / borneinf / this.sinh(this.compProp[0].C / borneinf), 2.0) + this.compProp[0].D * Math.pow(this.compProp[0].E / borneinf / this.cosh(this.compProp[0].E / borneinf), 2.0)) / 1000.0;
                f2.Cp = (this.compProp[0].A + this.compProp[0].B * Math.pow(this.compProp[0].C / bornesup / this.sinh(this.compProp[0].C / bornesup), 2.0) + this.compProp[0].D * Math.pow(this.compProp[0].E / bornesup / this.cosh(this.compProp[0].E / bornesup), 2.0)) / 1000.0;
                f1.CpT = f1.Cp / borneinf;
                f2.CpT = f2.Cp / bornesup;
                aireh += pas * (f1.Cp + f2.Cp) / 2.0;
                aires += pas * (f1.CpT + f2.CpT) / 2.0;
                ++i;
            }
            hs.h = aireh;
            hs.s = aires - 8.314472471 * Math.log(P);
        } else {
            int i = 0;
            while (i < nbtrapezes) {
                double borneinf = x1 + (double)i * pas;
                double bornesup = borneinf + pas;
                f1 = this.fonctionCp(cas, borneinf);
                f2 = this.fonctionCp(cas, bornesup);
                aireh += pas * (f1.Cp + f2.Cp) / 2.0;
                aires += pas * (f1.CpT + f2.CpT) / 2.0;
                ++i;
            }
            hs.h = aireh;
            hs.s = aires - 8.314472471 * Math.log(P);
        }
        return hs;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }
}

