/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.alpha;

import bibCTP.cubic.alpha.AlphaFunction;
import bibCTP.cubic.alpha.Alphas;
import bibCTP.model.FluidModel;

public class TwuPR
extends AlphaFunction {
    public TwuPR(FluidModel fm) {
        super(fm);
        this.type = "TwuPR";
        this.nAlpha = 5;
    }

    public Alphas alphaUtilise(double omega, double Tr, double c1, double c2, double c3) {
        if (Tr <= 1.0) {
            double L0 = 0.141599;
            double M0 = 0.919422;
            double N0 = 2.496441;
            double L1 = 0.500315;
            double M1 = 0.799457;
            double N1 = 3.29179;
            double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
            double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
            this.fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
        } else {
            double L0 = 0.441411;
            double M0 = 6.500018;
            double N0 = -2.0;
            double L1 = 0.03258;
            double M1 = 1.289098;
            double N1 = -8.0;
            double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
            double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
            this.fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
        }
        return this.fonctionalpha;
    }
}

