/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.alpha;

import bibCTP.cubic.alpha.AlphaFunction;
import bibCTP.cubic.alpha.Alphas;
import bibCTP.model.FluidModel;

public class TwuSRK
extends AlphaFunction {
    public TwuSRK(FluidModel fm) {
        super(fm);
        this.type = "TwuSRK";
        this.nAlpha = 4;
    }

    public Alphas alphaUtilise(double omega, double Tr, double c1, double c2, double c3) {
        if (Tr <= 1.0) {
            double L0 = 0.125283;
            double M0 = 0.911807;
            double N0 = 1.948153;
            double L1 = 0.511614;
            double M1 = 0.784054;
            double N1 = 2.812522;
            double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
            double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
            this.fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
        } else {
            double L0 = 0.401219;
            double M0 = 4.963075;
            double N0 = -2.0;
            double L1 = 0.024955;
            double M1 = 1.248088;
            double N1 = -8.0;
            double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
            double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
            this.fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
        }
        return this.fonctionalpha;
    }
}

