/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.cpa;

import bibCTP.cubic.cpa.FlashMethodCPA_base;
import bibCTP.model.CPA;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class FlashMethodCPA_1Boucle
extends FlashMethodCPA_base {
    public FlashMethodCPA_1Boucle(CPA cpa, String type, double Temperature, double P_Pa, double[] zz) {
        super(cpa, type, Temperature, P_Pa, zz);
        double sumEqualF;
        double eps = 1.0E-6;
        this.phiV = new double[this.ncomp];
        this.phiL = new double[this.ncomp];
        double[] PS = new double[this.ncomp];
        int i = 0;
        while (i < this.ncomp) {
            System.out.println("i " + this.TCritic[i]);
            System.out.println("i " + this.PCritic[i]);
            System.out.println("i " + this.TCritic[i] + " PCritic[i " + this.PCritic[i] + " w[i " + this.w[i]);
            PS[i] = cpa.PsatEstimated(this.TCritic[i], this.PCritic[i], this.w[i], Temperature);
            ++i;
        }
        this.L = 0.5;
        this.Ki = new double[this.ncomp];
        i = 0;
        while (i < this.ncomp) {
            this.Ki[i] = PS[i] / P_Pa;
            this.x[i] = zz[i] / (this.L + this.Ki[i] * (1.0 - this.L));
            this.y[i] = this.Ki[i] * this.x[i];
            ++i;
        }
        double sx = 0.0;
        double sy = 0.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            sx += this.x[i2];
            sy += this.y[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            this.x[i2] = this.x[i2] / sx;
            this.y[i2] = this.y[i2] / sy;
            ++i2;
        }
        this.count = 0;
        do {
            ++this.count;
            this.callFunction = "liqsplit";
            double[] init = new double[2];
            if (this.L <= 0.0) {
                this.L = 0.0;
            }
            if (this.L >= 1.0) {
                this.L = this.count > 10 ? 0.5 : 1.0;
            }
            init[1] = this.L;
            double[] res = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
            this.L = res[1];
            this.rhoV = cpa.calcRho(Temperature, P_Pa, 1.0, this.y);
            this.phiV = cpa.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoV, this.y);
            this.rhoL = cpa.calcRho(Temperature, P_Pa, 0.0, this.x);
            this.phiL = cpa.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoL, this.x);
            int i3 = 0;
            while (i3 < this.ncomp) {
                this.Ki[i3] = this.phiL[i3] / this.phiV[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < this.ncomp) {
                this.x[i3] = zz[i3] / (this.L + this.Ki[i3] * (1.0 - this.L));
                this.y[i3] = this.Ki[i3] * this.x[i3];
                ++i3;
            }
            sx = 0.0;
            sy = 0.0;
            i3 = 0;
            while (i3 < this.ncomp) {
                sx += this.x[i3];
                sy += this.y[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < this.ncomp) {
                this.x[i3] = this.x[i3] / sx;
                this.y[i3] = this.y[i3] / sy;
                ++i3;
            }
        } while ((sumEqualF = this.equalF(this.phiL, this.phiV, this.x, this.y, this.ncomp)) > eps && this.count < 50);
        if (this.count > 49) {
            System.out.println("FlashMethod 1 : sumEqualF " + sumEqualF);
            System.out.println("FlashMethod 1 : rhoV " + this.rhoV + " phiV[0] " + this.phiV[0] + "  rhoL " + this.rhoL + "  phiL[0] " + this.phiL[0] + " phiV[1] " + this.phiV[1] + "  phiL[1] " + this.phiL[1]);
            String message = "Watch out! The Flash algorithm did not converge";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        if (cpa.debug) {
            System.out.println("Sorti FlashMethod x1=" + this.x[0] + " y1=" + this.y[0] + " P=" + P_Pa + " isoT=" + Temperature);
        }
    }

    protected double equalF(double[] phiL, double[] phiV, double[] x, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += Math.abs(x[i] * phiL[i] - y[i] * phiV[i]);
            ++i;
        }
        return sum;
    }

    private double liqSplit(double L) {
        if (this.cpa.debug) {
            System.out.println("Temperature : " + this.Temperature + " L " + L);
        }
        if (L <= 0.0) {
            L = 0.0;
        }
        if (L >= 1.0) {
            L = this.count > 5 ? 0.5 : 1.0;
        }
        int i = 0;
        while (i < this.ncomp) {
            this.x[i] = this.zz[i] / (L + this.Ki[i] * (1.0 - L));
            this.y[i] = this.Ki[i] * this.x[i];
            ++i;
        }
        double sx = 0.0;
        double sy = 0.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            sx += this.x[i2];
            sy += this.y[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            this.x[i2] = this.x[i2] / sx;
            this.y[i2] = this.y[i2] / sy;
            ++i2;
        }
        double somme = 0.0;
        int i3 = 0;
        while (i3 < this.ncomp) {
            somme += (1.0 - this.Ki[i3]) * this.zz[i3] / (L + this.Ki[i3] * (1.0 - L));
            ++i3;
        }
        return somme;
    }

    public void fcn(int mm, int n, double[] xx, double[] fvec, int[] iflag) {
        double PP = 1.0;
        double TT = 300.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("liqsplit")) {
            if (xx[1] < 0.0) {
                xx[1] = -xx[1];
            }
            if (xx[1] > 1.0) {
                xx[1] = 1.0;
            }
            fvec[1] = this.liqSplit(xx[1]);
            if (this.cpa.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  xx[1]: " + xx[1] + "  Ki[0]: " + this.Ki[0]);
            }
        }
    }

    protected double[] solveWithMinPack(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec = new double[mm + 1];
        double[] xx = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            xx[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn(mm, n, xx, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        this.nfev = 0;
        this.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)this, (int)mm, (int)n, (double[])xx, (double[])fvec, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        if (this.cpa.debug) {
            System.out.println();
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
            System.out.println("Final L2 norm of the residuals: " + residu1);
            System.out.println("Number of function evaluations: " + this.nfev);
            System.out.println("Number of Jacobian evaluations: " + this.njev);
            System.out.println("Info value: " + info[1]);
            System.out.println("Final approximate solution: " + callFunction + "   " + xx[1]);
            System.out.println();
        }
        return xx;
    }
}

