/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.cpa;

import bibCTP.cubic.cpa.FlashMethodCPA_base;
import bibCTP.model.CPA;

public class FlashMethodCPA_BubbleDew
extends FlashMethodCPA_base {
    public FlashMethodCPA_BubbleDew(CPA cpa, String type, double Temperature, double P_Pa, double[] zz) {
        super(cpa, type, Temperature, P_Pa, zz);
        this.callFunction = "xBubble";
        double[] init = new double[2];
        this.xBubble[0] = zz[0] / 2.0;
        init[1] = this.xBubble[0];
        this.xBubble[1] = 1.0 - this.xBubble[0];
        double[] res = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.x = this.xBubble;
        this.callFunction = "yDew";
        init = new double[2];
        this.yDew[0] = (zz[0] + 1.0) / 2.0;
        init[1] = this.yDew[0];
        this.yDew[1] = 1.0 - this.yDew[0];
        res = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.y = this.yDew;
        this.L = (zz[0] - this.y[0]) / (this.x[0] - this.y[0]);
        if (cpa.debug) {
            System.out.println("sorti FlashMethodCPA_BubbleDew y[0]\t" + this.y[0] + " L\t" + this.L);
        }
        this.rhoV = cpa.calcRho(Temperature, P_Pa, 1.0, this.y);
        this.rhoL = cpa.calcRho(Temperature, P_Pa, 0.0, this.x);
        if (cpa.debug) {
            System.out.println("Sorti FlashMethod x1=" + this.x[0] + " y1=" + this.y[0] + " P=" + P_Pa + " isoT=" + Temperature);
        }
    }

    public void fcn(int mm, int n, double[] xx, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("xBubble")) {
            if (xx[1] <= 0.0) {
                xx[1] = 1.0E-5;
            }
            if (xx[1] >= 1.0) {
                xx[1] = 0.99999;
            }
            this.xBubble[0] = xx[1];
            this.xBubble[1] = 1.0 - this.xBubble[0];
            double Tbulle = this.cpa.getBubblePointTemperature(this.type, this.P_Pa, this.xBubble);
            fvec[1] = (this.Temperature - Tbulle) / 2.0 / this.Temperature;
            if (this.cpa.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  xx[1]: " + xx[1] + "  Tbulle: " + Tbulle);
            }
        }
        if (this.callFunction.equals("yDew")) {
            if (xx[1] <= 0.0) {
                xx[1] = 1.0E-5;
            }
            if (xx[1] >= 1.0) {
                xx[1] = 0.99999;
            }
            this.yDew[0] = xx[1];
            this.yDew[1] = 1.0 - this.yDew[0];
            double Trosee = this.cpa.getDewPointTemperature(this.type, this.P_Pa, this.yDew);
            fvec[1] = (this.Temperature - Trosee) / 2.0 / this.Temperature;
            if (this.cpa.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  xx[1]: " + xx[1] + "  Trosee: " + Trosee);
            }
        }
    }
}

