/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.model;

import bibCTP.cubic.model.CubicModel;
import bibCTP.cubic.model.GeneralizedCubicEOSparameters;
import bibCTP.model.FluidModel;

public class HarmensKnapp
extends CubicModel {
    public HarmensKnapp(FluidModel fm) {
        super(fm);
        this.type = "HarmensKnapp";
        this.nModel = 4;
    }

    public GeneralizedCubicEOSparameters modeleUtilise(double Tc, double Pc, double Zc) {
        this.a1 = 1.0;
        this.b1 = 1.0 - 3.0 * Zc + 1.0;
        this.c1 = 3.0 * Zc * Zc;
        this.d1 = -Math.pow(Zc, 3.0);
        this.omegaB = this.fm.cubique(this.a1, this.b1, this.c1, this.d1);
        this.mod.omegab = this.omegaB.ZV;
        this.mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * this.mod.omegab + Math.pow(this.mod.omegab, 2.0);
        this.mod.omegac = (1.0 - 3.0 * Zc + this.mod.omegab) / this.mod.omegab;
        this.b2 = this.mod.omegab * 8.314472471 * Tc / Pc;
        this.mod.u = this.c2 = this.mod.omegac * 8.314472471 * Tc / Pc;
        this.mod.w = -this.c2 + 1.0;
        return this.mod;
    }
}

