/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.cubic.model;

import bibCTP.cubic.model.CubicModel;
import bibCTP.cubic.model.GeneralizedCubicEOSparameters;
import bibCTP.model.FluidModel;

public class PatelTeja
extends CubicModel {
    public PatelTeja(FluidModel fm) {
        super(fm);
        this.type = "PatelTeja";
        this.nModel = 3;
    }

    public GeneralizedCubicEOSparameters modeleUtilise(double Tc, double Pc, double Zc) {
        this.a1 = 1.0;
        this.b1 = 1.0 - 3.0 * Zc + 1.0;
        this.c1 = 3.0 * Zc * Zc;
        this.d1 = -Math.pow(Zc, 3.0);
        this.omegaB = this.fm.cubique(this.a1, this.b1, this.c1, this.d1);
        this.mod.omegab = this.omegaB.ZV;
        this.mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * this.mod.omegab + Math.pow(this.mod.omegab, 2.0);
        this.mod.omegac = 1.0 - 3.0 * Zc;
        this.b2 = this.mod.omegab * 8.314472471 * Tc / Pc;
        this.c2 = this.mod.omegac * 8.314472471 * Tc / Pc;
        this.mod.u = 1.0 + this.c2 / this.b2;
        this.mod.w = -this.c2 / this.b2;
        return this.mod;
    }
}

