/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.fit;

import bibCTP.MixCTPbibSubstance;
import bibCTP.MonoPhaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class FitCPAPure
implements Lmdif_fcn {
    static final double epsmch = 2.22044604926E-6;
    int nfev = 0;
    int njev = 0;
    static Vector vData;
    static double[][] data;
    static double[] h;
    static double[] p;
    static double[] s;
    static double[] Tval;
    static double[] v;
    static String[] titreData;
    static int nbval;
    String[] component = new String[1];
    int ncomp = 1;
    static int[][] siteType;
    static double[] TCritic;
    static double[] Pcritic;
    static double[] wCPA;
    static double[] a0;
    static double[] c1;
    static double[] bCPA;
    static double[] epsPure;
    static double[] betaPure;
    static MixCTPbibSubstance mel;

    static {
        siteType = new int[][]{new int[2]};
        TCritic = new double[]{407.81};
        Pcritic = new double[]{3629000.0};
        wCPA = new double[]{0.184};
        a0 = new double[]{1.323136};
        c1 = new double[]{0.718519};
        bCPA = new double[]{7.44575E-5};
        epsPure = new double[]{0.0};
        betaPure = new double[]{0.0};
    }

    public static void main(String[] args) {
        try {
            File fich = new File("output.txt");
            fich.delete();
            fich = new File("error.txt");
            fich.delete();
        }
        catch (SecurityException sexception) {
            sexception.printStackTrace();
            String msg = "Error deleting output or error file. Check your security privileges";
            msg = String.valueOf(msg) + "\nor install the Thermoptim security access pack.";
            JOptionPane.showMessageDialog(new JFrame(), msg);
        }
        try {
            System.setOut(new PrintStream(new FileOutputStream("output.txt", true)));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream("error.txt", true)));
        }
        catch (IOException ioexception1) {
            ioexception1.printStackTrace();
        }
        FitCPAPure.litData();
        try {
            mel = new MixCTPbibSubstance("isobutane", "isobutaneCPA.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double[] fract_mol = new double[]{1.0};
        String[] comp = new String[]{"isobutane"};
        mel.readXml("isobutaneCPA.xml");
        mel.updateComp(comp, fract_mol);
        FitCPAPure lmFitTest = new FitCPAPure();
        int[] info = new int[2];
        int m = 2 * nbval;
        int n = 5;
        int[] iflag = new int[2];
        double[] fvec = new double[m + 1];
        double[] x = new double[n + 1];
        System.out.print("\n\n\n\n\n problem dimensions:  " + n + "  " + m + "\n");
        x[1] = a0[0];
        x[2] = c1[0];
        x[3] = bCPA[0];
        x[4] = epsPure[0];
        x[5] = betaPure[0];
        iflag[1] = 0;
        lmFitTest.fcn(m, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)m, (double[])fvec);
        lmFitTest.nfev = 0;
        lmFitTest.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)lmFitTest, (int)m, (int)n, (double[])x, (double[])fvec, (double)2.22044604926E-6, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)m, (double[])fvec);
        System.out.println("\n Initial L2 norm of the residuals: " + residu0 + "\n Final L2 norm of the residuals: " + residu1 + "\n Number of function evaluations: " + lmFitTest.nfev + "\n Number of Jacobian evaluations: " + lmFitTest.njev + "\n Info value: " + info[1]);
        System.out.println();
        System.out.println("precision: \t" + residu1);
        int i = 1;
        while (i <= n) {
            System.out.print("\tx[" + i + "]=" + x[i] + ";");
            ++i;
        }
    }

    public void fcn(int m, int n, double[] x, double[] fvec, int[] iflag) {
        int i = 1;
        while (i <= n) {
            if (x[i] < 0.0) {
                x[i] = -x[i];
            }
            ++i;
        }
        FitCPAPure.a0[0] = x[1];
        FitCPAPure.c1[0] = x[2];
        FitCPAPure.bCPA[0] = x[3];
        FitCPAPure.epsPure[0] = x[4];
        FitCPAPure.betaPure[0] = x[5];
        Vector<double[]> vProp = new Vector<double[]>();
        vProp.addElement(a0);
        vProp.addElement(c1);
        vProp.addElement(bCPA);
        vProp.addElement(epsPure);
        vProp.addElement(betaPure);
        mel.setParameters(vProp);
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        double test = 0.0;
        double alpha_h = 1.0;
        double alpha_s = 1.0;
        double alpha_p = 0.001;
        double alpha_v = 0.1;
        int k = 0;
        while (k < nbval) {
            double Psat = 100.0;
            try {
                Psat = k < nbval / 2 ? mel.getSatPressure(Tval[k], 0.0) : mel.getSatPressure(Tval[k], 1.0);
            }
            catch (MonoPhaseException e) {
                e.printStackTrace();
            }
            double[] res = k < nbval / 2 ? mel.calcSubstance(Tval[k] - 0.01, Psat, 0.0) : mel.calcSubstance(Tval[k] + 0.01, Psat, 1.0);
            double hCPA = res[0];
            double sCPA = res[5];
            double vCPA = res[1];
            System.out.println("T\t" + Tval[k] + "\tPsat\t" + Psat / 100000.0 + "\t p[k] \t" + p[k] + "\t h[k] \t" + h[k] + "\t hCPA \t" + hCPA + "\t s[k] \t" + s[k] + "\t sCPA \t" + sCPA + "\t v[k] \t" + v[k] + "\t vCPA \t" + vCPA);
            double delta = alpha_h * Math.abs(h[k] - hCPA) / 300.0 + alpha_s * Math.abs(s[k] - sCPA) + alpha_p * Math.abs(p[k] * 100000.0 - Psat);
            delta = alpha_p * Math.abs(p[k] * 100000.0 - Psat);
            test += delta;
            fvec[k] = delta;
            delta = alpha_h * Math.abs(h[k] - hCPA) / 300.0 + alpha_s * Math.abs(s[k] - sCPA) + alpha_v * Math.abs(1.0 / v[k] - 1.0 / vCPA);
            fvec[k + FitCPAPure.nbval] = delta = alpha_v * Math.abs(1.0 / v[k] - 1.0 / vCPA);
            test += delta;
            ++k;
        }
        System.out.println("FitCPA " + this.nfev + " test " + test);
        int l = 1;
        while (l <= n) {
            System.out.print("\tx[" + l + "] \t" + x[l]);
            ++l;
        }
        System.out.println();
    }

    public static void litData() {
        String ligne_data;
        vData = new Vector();
        try {
            File fich = new File("propSubstIsoButane.txt");
            FileReader flux_fich = new FileReader(fich);
            BufferedReader flux_tamp = new BufferedReader(flux_fich);
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            titreData = new String[5];
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitCPAPure.titreData[0] = st.nextToken();
            FitCPAPure.titreData[1] = st.nextToken();
            FitCPAPure.titreData[2] = st.nextToken();
            FitCPAPure.titreData[3] = st.nextToken();
            FitCPAPure.titreData[4] = st.nextToken();
            ligne_data = flux_tamp.readLine();
            while (ligne_data != null) {
                vData.addElement(ligne_data);
                ligne_data = flux_tamp.readLine();
            }
            flux_tamp.close();
            flux_fich.close();
        }
        catch (IOException e) {
            String message = "fich_data_mal_conf";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        nbval = vData.size() - 1;
        data = new double[5][nbval];
        h = new double[nbval];
        p = new double[nbval];
        s = new double[nbval];
        Tval = new double[nbval];
        v = new double[nbval];
        int i = 0;
        while (i < vData.size() - 1) {
            ligne_data = (String)vData.elementAt(i);
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitCPAPure.data[0][i] = FitCPAPure.lit_d(st.nextToken());
            FitCPAPure.Tval[i] = data[0][i];
            FitCPAPure.data[1][i] = FitCPAPure.lit_d(st.nextToken());
            FitCPAPure.p[i] = data[1][i];
            FitCPAPure.data[2][i] = FitCPAPure.lit_d(st.nextToken());
            FitCPAPure.v[i] = data[2][i];
            FitCPAPure.h[i] = 0.0;
            FitCPAPure.s[i] = 0.0;
            FitCPAPure.data[3][i] = 0.0;
            FitCPAPure.h[i] = data[3][i];
            FitCPAPure.data[4][i] = 0.0;
            FitCPAPure.s[i] = data[4][i];
            ++i;
        }
    }

    public static double lit_d(String s) {
        try {
            Double DD = Double.valueOf(s);
            return DD;
        }
        catch (NumberFormatException nfe) {
            String message = "Watch out! the number format is inadequate.";
            JOptionPane.showMessageDialog(new JFrame(), message);
            return 0.0;
        }
    }
}

