/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.fit;

import bibCTP.MixCTPbibSubstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class FitCPA_Array
implements Lmdif_fcn {
    static final double epsmch = 2.22044604926E-6;
    int nfev = 0;
    int njev = 0;
    static Vector vData;
    static double[][] data;
    static double[] h;
    static double[] p;
    static double[] s;
    static double[] Tval;
    static double[] v;
    static String[] titreData;
    static int nbval;
    String[] component = new String[2];
    static double[] TCritic;
    static double[] Pcritic;
    static double[] epsPure;
    static double[] betaPure;
    static double[] wCPA;
    int ncomp = 2;
    static double kij;
    static double[][] kijCPA;
    static double[][] Tbubble;
    static double[][] Tdew;
    static int[][] siteType;
    static double[] a0;
    static double[] c1;
    static double[] bCPA;
    static int nbTemp;
    static int nbPress;
    static MixCTPbibSubstance mel;

    static {
        TCritic = new double[]{405.65, 647.13};
        Pcritic = new double[]{1.128E7, 2.205500745E7};
        epsPure = new double[]{20000.0, 10000.0};
        betaPure = new double[]{0.07, 0.01};
        wCPA = new double[]{0.252608, 0.3442};
        kij = -5.469E-4;
        kijCPA = new double[][]{{0.0, kij}, {kij, 0.0}};
        siteType = new int[][]{{2, 1}, {2, 1}};
        a0 = new double[]{0.62992, 0.93833};
        c1 = new double[]{0.831, 0.833};
        bCPA = new double[]{7.144E-5, 6.74E-5};
        nbTemp = 20;
        nbPress = 20;
    }

    public static void main(String[] args) {
        try {
            File fich = new File("output.txt");
            fich.delete();
            fich = new File("error.txt");
            fich.delete();
        }
        catch (SecurityException sexception) {
            sexception.printStackTrace();
            String msg = "Error deleting output or error file. Check your security privileges";
            msg = String.valueOf(msg) + "\nor install the Thermoptim security access pack.";
            JOptionPane.showMessageDialog(new JFrame(), msg);
        }
        try {
            System.setOut(new PrintStream(new FileOutputStream("output.txt", true)));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream("error.txt", true)));
        }
        catch (IOException ioexception1) {
            ioexception1.printStackTrace();
        }
        FitCPA_Array.litData();
        try {
            mel = new MixCTPbibSubstance("R410ACPA", "R410A_CPA.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double[] fract_mol = new double[]{0.6993, 0.3007};
        String[] comp = new String[]{"R32", "R125"};
        mel.updateComp(comp, fract_mol);
        mel.readXml("R410A_CPA.xml");
        FitCPA_Array lmFitTest = new FitCPA_Array();
        int[] info = new int[2];
        int m = nbval;
        int n = 6;
        int[] iflag = new int[2];
        double[] fvec = new double[m + 1];
        double[] x = new double[n + 1];
        System.out.print("\n\n\n\n\n problem dimensions:  " + n + "  " + m + "\n");
        x[1] = c1[0];
        x[2] = bCPA[0];
        x[3] = c1[1];
        x[4] = bCPA[1];
        x[5] = a0[0];
        x[6] = a0[1];
        iflag[1] = 0;
        lmFitTest.fcn(m, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)m, (double[])fvec);
        lmFitTest.nfev = 0;
        lmFitTest.njev = 0;
        double epsfcn = 1.0E-4;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)lmFitTest, (int)m, (int)n, (double[])x, (double[])fvec, (double)2.22044604926E-6, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)m, (double[])fvec);
        System.out.println("\n Initial L2 norm of the residuals: " + residu0 + "\n Final L2 norm of the residuals: " + residu1 + "\n Number of function evaluations: " + lmFitTest.nfev + "\n Number of Jacobian evaluations: " + lmFitTest.njev + "\n Info value: " + info[1]);
        System.out.println();
        System.out.println("precision: \t" + residu1);
        int i = 1;
        while (i <= n) {
            System.out.print("\tx[" + i + "] \t" + x[i]);
            ++i;
        }
    }

    public void fcn(int m, int n, double[] x, double[] fvec, int[] iflag) {
        int l = 1;
        while (l <= n) {
            if (x[l] < 0.0) {
                x[l] = -x[l];
            }
            if (x[l] > 1.0) {
                x[l] = 1.0;
            }
            ++l;
        }
        FitCPA_Array.c1[0] = x[1];
        FitCPA_Array.bCPA[0] = x[2];
        FitCPA_Array.c1[1] = x[3];
        FitCPA_Array.bCPA[1] = x[4];
        FitCPA_Array.a0[0] = x[5];
        FitCPA_Array.a0[1] = x[6];
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        Vector<double[]> vProp = new Vector<double[]>();
        vProp.addElement(c1);
        vProp.addElement(bCPA);
        vProp.addElement(a0);
        mel.setParameters(vProp);
        int k = 1;
        double test = 0.0;
        double alpha_h = 1.0;
        double alpha_s = 1.0;
        double alpha_p = 1.0E-5;
        double alpha_v = 1.0;
        int i = 0;
        while (i < nbval) {
            double delta;
            double T = Tval[i];
            k = i;
            T = Tval[k];
            double[] res = mel.calcSubstance(Tval[k], p[k] * 100000.0, 0.0);
            double hCPA = res[0];
            double sCPA = res[5];
            double vCPA = res[1];
            fvec[i] = delta = alpha_h * Math.abs(h[k] - hCPA) / 300.0 + alpha_s * Math.abs(s[k] - sCPA) + alpha_v * Math.abs(1.0 / v[k] - 1.0 / vCPA);
            test += delta;
            ++i;
        }
        System.out.println("FitCPA " + this.nfev + " test " + test);
        int l2 = 1;
        while (l2 <= n) {
            System.out.print("\tx[" + l2 + "] \t" + x[l2]);
            ++l2;
        }
        System.out.println();
    }

    public static void litData() {
        String ligne_data;
        vData = new Vector();
        try {
            File fich = new File("propSubstMel.txt");
            FileReader flux_fich = new FileReader(fich);
            BufferedReader flux_tamp = new BufferedReader(flux_fich);
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            titreData = new String[5];
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitCPA_Array.titreData[0] = st.nextToken();
            FitCPA_Array.titreData[1] = st.nextToken();
            FitCPA_Array.titreData[2] = st.nextToken();
            FitCPA_Array.titreData[3] = st.nextToken();
            FitCPA_Array.titreData[4] = st.nextToken();
            ligne_data = flux_tamp.readLine();
            while (ligne_data != null) {
                vData.addElement(ligne_data);
                ligne_data = flux_tamp.readLine();
            }
            flux_tamp.close();
            flux_fich.close();
        }
        catch (IOException e) {
            String message = "fich_data_mal_conf";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        nbval = vData.size() - 1;
        data = new double[5][nbval];
        h = new double[nbval];
        p = new double[nbval];
        s = new double[nbval];
        Tval = new double[nbval];
        v = new double[nbval];
        int i = 0;
        while (i < vData.size() - 1) {
            ligne_data = (String)vData.elementAt(i);
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitCPA_Array.data[0][i] = FitCPA_Array.lit_d(st.nextToken());
            FitCPA_Array.Tval[i] = data[0][i];
            FitCPA_Array.data[1][i] = FitCPA_Array.lit_d(st.nextToken());
            FitCPA_Array.p[i] = data[1][i];
            FitCPA_Array.data[2][i] = FitCPA_Array.lit_d(st.nextToken());
            FitCPA_Array.v[i] = data[2][i];
            FitCPA_Array.data[3][i] = FitCPA_Array.lit_d(st.nextToken());
            FitCPA_Array.h[i] = data[3][i];
            FitCPA_Array.data[4][i] = FitCPA_Array.lit_d(st.nextToken());
            FitCPA_Array.s[i] = data[4][i];
            ++i;
        }
    }

    public static double lit_d(String s) {
        try {
            Double DD = Double.valueOf(s);
            return DD;
        }
        catch (NumberFormatException nfe) {
            String message = "Watch out! the number format is inadequate.";
            JOptionPane.showMessageDialog(new JFrame(), message);
            return 0.0;
        }
    }

    double getProp(int index, Vector v) {
        Double prop = (Double)v.elementAt(index);
        return prop;
    }

    double[] getPropArray(int index, Vector v) {
        double[] res = (double[])v.elementAt(index);
        return res;
    }
}

