/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.fit;

import Jama.Matrix;
import Jama.QRDecomposition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FitCp {
    private final int N;
    private final int p;
    private final Matrix beta;
    private double SSE;
    private double SST;
    static Vector vData;
    static double[] Cpval;
    static double[] Tval;
    static String[] titreData;
    static int nbval;
    static double molarMass;

    public FitCp(double[][] x, double[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("dimensions don't agree");
        }
        this.N = y.length;
        this.p = x[0].length;
        Matrix X = new Matrix(x);
        Matrix Y = new Matrix(y, this.N);
        QRDecomposition qr = new QRDecomposition(X);
        this.beta = qr.solve(Y);
        double sum = 0.0;
        int i = 0;
        while (i < this.N) {
            sum += y[i];
            ++i;
        }
        double mean = sum / (double)this.N;
        int i2 = 0;
        while (i2 < this.N) {
            double dev = y[i2] - mean;
            this.SST += dev * dev;
            ++i2;
        }
        Matrix residuals = X.times(this.beta).minus(Y);
        this.SSE = residuals.norm2() * residuals.norm2();
    }

    public double beta(int j) {
        return this.beta.get(j, 0);
    }

    public double R2() {
        return 1.0 - this.SSE / this.SST;
    }

    public static void main(String[] args) {
        FitCp.litData();
        double[][] x = new double[nbval][7];
        int k = 0;
        while (k < nbval) {
            x[k][0] = 1.0;
            x[k][1] = Tval[k] / 1000.0;
            x[k][2] = x[k][1] * x[k][1];
            x[k][3] = x[k][2] * x[k][1];
            x[k][4] = x[k][2] * x[k][2];
            x[k][6] = 1.0 / x[k][1];
            x[k][5] = x[k][6] * x[k][6];
            ++k;
        }
        FitCp regression = new FitCp(x, Cpval);
        int k2 = 0;
        while (k2 < 7) {
            System.out.println("beta[" + k2 + "]\t" + regression.beta(k2));
            ++k2;
        }
        System.out.println("R^2 = " + regression.R2() + " molarMass = " + molarMass);
        System.out.println("<CP Model=\"1\" Cpa=\"" + regression.beta(0) * molarMass + "\" Cpb=\"" + regression.beta(1) * molarMass + "\" Cpc=\"" + regression.beta(2) * molarMass + "\" Cpd=\"" + regression.beta(3) * molarMass + "\" Cpe=\"" + regression.beta(4) * molarMass + "\" Cpg=\"" + regression.beta(5) * molarMass + "\" Cpk=\"" + regression.beta(6) * molarMass + "\" />");
    }

    public static void litData() {
        String ligne_data;
        vData = new Vector();
        try {
            File fich = new File("CpValues.txt");
            FileReader flux_fich = new FileReader(fich);
            BufferedReader flux_tamp = new BufferedReader(flux_fich);
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            st.nextToken();
            molarMass = FitCp.lit_d(st.nextToken());
            titreData = new String[2];
            ligne_data = flux_tamp.readLine();
            st = new StringTokenizer(ligne_data, "\t");
            FitCp.titreData[0] = st.nextToken();
            FitCp.titreData[1] = st.nextToken();
            ligne_data = flux_tamp.readLine();
            while (ligne_data != null) {
                vData.addElement(ligne_data);
                ligne_data = flux_tamp.readLine();
            }
            flux_tamp.close();
            flux_fich.close();
        }
        catch (IOException e) {
            String message = "fich_data_mal_conf";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        nbval = vData.size() - 1;
        Tval = new double[nbval];
        Cpval = new double[nbval];
        int i = 0;
        while (i < vData.size() - 1) {
            ligne_data = (String)vData.elementAt(i);
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitCp.Tval[i] = FitCp.lit_d(st.nextToken());
            FitCp.Cpval[i] = FitCp.lit_d(st.nextToken());
            ++i;
        }
    }

    public static double lit_d(String s) {
        try {
            Double DD = Double.valueOf(s);
            return DD;
        }
        catch (NumberFormatException nfe) {
            String message = "Watch out! the number format is inadequate.";
            JOptionPane.showMessageDialog(new JFrame(), message);
            return 0.0;
        }
    }
}

