/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.fit;

import bibCTP.MixCTPbibSubstance;
import bibCTP.MonoPhaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class FitPCSaftPureCubic
implements Lmdif_fcn {
    static final double epsmch = 2.22044604926E-6;
    int nfev = 0;
    int njev = 0;
    static Vector vData;
    static double[][] data;
    static double[] h;
    static double[] p;
    static double[] s;
    static double[] Tval;
    static double[] v;
    static String[] titreData;
    static int nbval;
    String[] component = new String[1];
    static double[] TCritic;
    static double[] Pcritic;
    static double[] m;
    static double[] sigmaPure;
    static double[] epsI;
    static double[] w;
    int ncomp = 1;
    static MixCTPbibSubstance mel;

    static {
        TCritic = new double[]{460.35};
        Pcritic = new double[]{3378000.0};
        m = new double[]{2.6896};
        sigmaPure = new double[]{3.7729};
        epsI = new double[]{231.2};
        w = new double[]{0.2274};
    }

    public static void main(String[] args) {
        try {
            File fich = new File("output.txt");
            fich.delete();
            fich = new File("error.txt");
            fich.delete();
        }
        catch (SecurityException sexception) {
            sexception.printStackTrace();
            String msg = "Error deleting output or error file. Check your security privileges";
            msg = String.valueOf(msg) + "\nor install the Thermoptim security access pack.";
            JOptionPane.showMessageDialog(new JFrame(), msg);
        }
        try {
            System.setOut(new PrintStream(new FileOutputStream("output.txt", true)));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream("error.txt", true)));
        }
        catch (IOException ioexception1) {
            ioexception1.printStackTrace();
        }
        FitPCSaftPureCubic.litData();
        try {
            mel = new MixCTPbibSubstance("R407c", "R407c.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double[] fract_mol = new double[]{0.38111, 0.17956, 0.43933};
        String[] comp = new String[]{"R32", "R125", "R134A"};
        mel.readXml("R407c.xml");
        mel.updateComp(comp, fract_mol);
        FitPCSaftPureCubic lmFitTest = new FitPCSaftPureCubic();
        int[] info = new int[2];
        int mm = 2 * nbval;
        int n = 3;
        int[] iflag = new int[2];
        double[] fvec = new double[mm + 1];
        double[] x = new double[n + 1];
        System.out.print("\n\n\n\n\n problem dimensions:  " + n + "  " + m + "\n");
        x[1] = -0.001;
        x[2] = -0.001;
        x[3] = -0.001;
        iflag[1] = 0;
        lmFitTest.fcn(mm, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        lmFitTest.nfev = 0;
        lmFitTest.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)lmFitTest, (int)mm, (int)n, (double[])x, (double[])fvec, (double)2.22044604926E-6, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        System.out.println("\n Initial L2 norm of the residuals: " + residu0 + "\n Final L2 norm of the residuals: " + residu1 + "\n Number of function evaluations: " + lmFitTest.nfev + "\n Number of Jacobian evaluations: " + lmFitTest.njev + "\n Info value: " + info[1]);
        System.out.println();
        System.out.println("precision: \t" + residu1);
        int i = 1;
        while (i <= n) {
            System.out.print("\tx[" + i + "]=" + x[i] + ";");
            ++i;
        }
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        int i = 1;
        while (i <= n) {
            if (x[i] > 0.0) {
                x[i] = -x[i];
            }
            ++i;
        }
        FitPCSaftPureCubic.m[0] = x[1];
        FitPCSaftPureCubic.sigmaPure[0] = x[2];
        FitPCSaftPureCubic.epsI[0] = x[3];
        Vector<double[]> vProp = new Vector<double[]>();
        vProp.addElement(m);
        vProp.addElement(sigmaPure);
        vProp.addElement(epsI);
        mel.setParameters(vProp);
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        double test = 0.0;
        double alpha_h = 0.0;
        double alpha_s = 0.0;
        double alpha_p = 0.001;
        double alpha_v = 1.0;
        int k = 0;
        while (k < nbval) {
            double Psat = 100.0;
            try {
                Psat = k < nbval / 2 + 1 ? mel.getSatPressure(Tval[k], 0.0) : mel.getSatPressure(Tval[k], 1.0);
            }
            catch (MonoPhaseException e) {
                e.printStackTrace();
            }
            double[] res = k < nbval / 2 + 1 ? mel.calcSubstance(Tval[k] - 0.01, Psat, 0.0) : mel.calcSubstance(Tval[k] + 0.01, Psat, 1.0);
            double hCPA = res[0];
            double sCPA = res[5];
            double vCPA = res[1];
            System.out.println("T\t" + Tval[k] + "\tPsat\t" + Psat / 100000.0 + "\t p[k] \t" + p[k] + "\t h[k] \t" + h[k] + "\t hCPA \t" + hCPA + "\t s[k] \t" + s[k] + "\t sCPA \t" + sCPA + "\t v[k] \t" + v[k] + "\t vCPA \t" + vCPA);
            double delta = alpha_h * Math.abs(h[k] - hCPA) / 300.0 + alpha_s * Math.abs(s[k] - sCPA) + alpha_p * Math.abs(p[k] * 100000.0 - Psat);
            test += delta;
            fvec[k] = delta;
            fvec[k + FitPCSaftPureCubic.nbval] = delta = alpha_h * Math.abs(h[k] - hCPA) / 300.0 + alpha_s * Math.abs(s[k] - sCPA) + alpha_v * Math.abs(1.0 / v[k] - 1.0 / vCPA);
            test += delta;
            ++k;
        }
        System.out.println("FitPCSaft " + this.nfev + " test " + test);
        int l = 1;
        while (l <= n) {
            System.out.print("\tx[" + l + "] \t" + x[l]);
            ++l;
        }
        System.out.println();
    }

    public static void litData() {
        String ligne_data;
        vData = new Vector();
        try {
            File fich = new File("propSubstR407c.txt");
            FileReader flux_fich = new FileReader(fich);
            BufferedReader flux_tamp = new BufferedReader(flux_fich);
            ligne_data = flux_tamp.readLine();
            ligne_data = flux_tamp.readLine();
            titreData = new String[5];
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitPCSaftPureCubic.titreData[0] = st.nextToken();
            FitPCSaftPureCubic.titreData[1] = st.nextToken();
            FitPCSaftPureCubic.titreData[2] = st.nextToken();
            FitPCSaftPureCubic.titreData[3] = st.nextToken();
            FitPCSaftPureCubic.titreData[4] = st.nextToken();
            ligne_data = flux_tamp.readLine();
            while (ligne_data != null) {
                vData.addElement(ligne_data);
                ligne_data = flux_tamp.readLine();
            }
            flux_tamp.close();
            flux_fich.close();
        }
        catch (IOException e) {
            String message = "fich_data_mal_conf";
            JOptionPane.showMessageDialog(new JFrame(), message);
            e.printStackTrace();
        }
        nbval = vData.size() - 1;
        data = new double[5][nbval];
        h = new double[nbval];
        p = new double[nbval];
        s = new double[nbval];
        Tval = new double[nbval];
        v = new double[nbval];
        int i = 0;
        while (i < vData.size() - 1) {
            ligne_data = (String)vData.elementAt(i);
            StringTokenizer st = new StringTokenizer(ligne_data, "\t");
            FitPCSaftPureCubic.data[0][i] = FitPCSaftPureCubic.lit_d(st.nextToken());
            FitPCSaftPureCubic.Tval[i] = data[0][i];
            FitPCSaftPureCubic.data[1][i] = FitPCSaftPureCubic.lit_d(st.nextToken());
            FitPCSaftPureCubic.p[i] = data[1][i];
            FitPCSaftPureCubic.data[2][i] = FitPCSaftPureCubic.lit_d(st.nextToken());
            FitPCSaftPureCubic.v[i] = data[2][i];
            FitPCSaftPureCubic.data[3][i] = 0.0;
            FitPCSaftPureCubic.h[i] = data[3][i];
            FitPCSaftPureCubic.data[4][i] = 0.0;
            FitPCSaftPureCubic.s[i] = data[4][i];
            ++i;
        }
    }

    public static double lit_d(String s) {
        try {
            Double DD = Double.valueOf(s);
            return DD;
        }
        catch (NumberFormatException nfe) {
            String message = "Watch out! the number format is inadequate.";
            JOptionPane.showMessageDialog(new JFrame(), message);
            return 0.0;
        }
    }
}

