/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.cubic.cpa.FlashMethodCPA_1Boucle;
import bibCTP.model.CubicEOS;
import extThopt.Util;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Element;

public class CPA
extends CubicEOS {
    public double[] epsPure;
    public double[] betaPure;
    public double[] a0;
    public double[] c1;
    public double[] bCPA;
    public double[] wCPA;
    public double kij = -0.45;
    public double[][] kijCPA = new double[][]{{0.0, this.kij}, {this.kij, 0.0}};
    public int[][] siteType;
    public double[] TCritic;
    public double[] PCritic;
    public double[] w;
    public double hid = 0.0;
    public double sid = 0.0;
    protected final double constantNav = 6.02214179E23;
    protected int n = 0;
    public int ncomp;
    protected final double constantR = 8.314472;
    protected double[] XSite;
    protected double eps = 1.0E-6;
    protected double Pressure;
    protected double dPressureZeta;
    protected double u1;
    protected double u2;
    public double bMixBis;
    int nsite;
    double[] bCPAExt;
    double[][] epsSite;
    double[][] betaSite;
    double[] xRho;
    double[] phiV;
    double[] phiL;
    public double rhoV = 0.0;
    public double rhoL = 0.0;
    protected String AnNum = "An";

    public CPA() {
    }

    public CPA(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "CPA";
        this.debug = false;
    }

    public String getType() {
        return "CPA";
    }

    public void readXml() {
        super.readXml();
        this.TCritic = new double[this.component.length];
        this.PCritic = new double[this.component.length];
        this.w = new double[this.component.length];
        this.siteType = new int[this.component.length][2];
        this.epsPure = new double[this.component.length];
        this.betaPure = new double[this.component.length];
        this.a0 = new double[this.component.length];
        this.c1 = new double[this.component.length];
        this.bCPA = new double[this.component.length];
        this.wCPA = new double[this.component.length];
        this.ncomp = this.component.length;
        int i = 0;
        while (i < this.component.length) {
            Element xmlFragment = this.component[i];
            List listChildren = xmlFragment.getChildren("MODEL");
            Element el = (Element)listChildren.get(0);
            listChildren = el.getChildren("CPA");
            Element courant = (Element)listChildren.get(0);
            String value = courant.getAttributeValue("epsPure");
            this.epsPure[i] = Util.lit_d((String)value);
            System.out.println("epsPure: " + value);
            value = courant.getAttributeValue("betaPure");
            System.out.println("betaPure: " + value);
            this.betaPure[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("a0");
            System.out.println("a0: " + value);
            this.a0[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("c1");
            System.out.println("c1: " + value);
            this.c1[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("bCPA");
            System.out.println("bCPA: " + value);
            this.bCPA[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("wCPA");
            System.out.println("wCPA: " + value);
            this.wCPA[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("siteType0");
            System.out.println("siteType0: " + value);
            this.siteType[i][0] = Util.lit_i((String)value);
            value = courant.getAttributeValue("siteType1");
            System.out.println("siteType1: " + value);
            this.siteType[i][1] = Util.lit_i((String)value);
            this.TCritic[i] = this.tbs.compProp[i].Tc;
            this.PCritic[i] = this.tbs.compProp[i].Pc;
            this.w[i] = this.wCPA[i];
            this.kijCPA = this.tbs.k;
            this.tbs.zz = this.tbs.fract_mol;
            this.nsite = this.nSite();
            this.bCPAExt = this.ConstrExt(this.bCPA);
            this.epsSite = this.ConstrEpsSite();
            this.betaSite = this.ConstrBetaSite();
            double aSRK = 29.55188247418739 * this.TCritic[i] * this.TCritic[i] / this.PCritic[i];
            double bSRK = 0.72036585408 * this.TCritic[i] / this.PCritic[i];
            double cSRK = 0.37464 + 1.54226 * this.wCPA[i] - 0.26992 * this.wCPA[i] * this.wCPA[i];
            System.out.println("Param\u00e8tres cubique : aSRK " + aSRK + " bSRK " + bSRK + " cSRK " + cSRK);
            ++i;
        }
    }

    public void setParameters(Vector v) {
        this.a0 = this.getPropArray(0, v);
        this.c1 = this.getPropArray(1, v);
        this.bCPA = this.getPropArray(2, v);
        this.epsPure = this.getPropArray(3, v);
        this.betaPure = this.getPropArray(4, v);
    }

    public double getSatPressure(double T, double x) {
        double Psat = 0.0;
        if (x == 0.0) {
            Psat = this.getBubblePointPressure("SRK", T, this.tbs.fract_mol);
        } else if (x == 1.0) {
            Psat = this.getDewPointPressure("SRK", T, this.tbs.fract_mol);
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Psat;
    }

    public double getSatTemperature(double P, double quality) {
        double Tsat = 0.0;
        if (quality == 0.0) {
            Tsat = this.getBubblePointTemperature("SRK", P, this.tbs.fract_mol);
        } else if (quality == 1.0) {
            Tsat = this.getDewPointTemperature("SRK", P, this.tbs.fract_mol);
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Tsat;
    }

    public double[] calcSubstance(double T, double P_Pa, double quality) {
        double p = P_Pa;
        double h = 0.0;
        double s = 0.0;
        double titre = quality;
        this.tbs.zz = this.tbs.fract_mol;
        this.calcHsIdeal(T, P_Pa);
        double rho = 0.0;
        double hResL = 0.0;
        double sResL = 0.0;
        double hResV = 0.0;
        double sResV = 0.0;
        this.bMixBis = this.bMix(this.tbs.fract_mol);
        double[] res = new double[6 + 2 * this.tbs.nbComponents];
        double Tbulle = this.getSatTemperature(p, 0.0);
        double Trosee = this.getSatTemperature(p, 1.0);
        if (this.debug) {
            System.out.println("Tbulle " + Tbulle + " Trosee " + Trosee);
        }
        if (T < Tbulle || T > Trosee) {
            if (T < Tbulle) {
                quality = 0.0;
                rho = this.calcRho(T, P_Pa, quality, this.tbs.fract_mol);
                double rhoL = 0.0;
                double[] HS_devL = this.getHSdeviations("SRK", T, rho, this.tbs.fract_mol);
                h = (HS_devL[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
                s = (HS_devL[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
                if (this.debug) {
                    System.out.println("hResL " + hResL + " sResL " + sResL + " rhoL " + rho + " rhoLdew " + rhoL + " h " + h + " s " + s);
                }
            } else {
                quality = 1.0;
                rho = this.calcRho(T, P_Pa, quality, this.tbs.fract_mol);
                double rhoV = 0.0;
                double[] HS_devV = this.getHSdeviations("SRK", T, rho, this.tbs.fract_mol);
                h = (HS_devV[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
                s = (HS_devV[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
                if (this.debug) {
                    System.out.println("hResV " + hResV + " sResV " + sResV + " rhoV " + rho + " rhoVbubble " + rhoV + " h " + h + " s " + s);
                }
            }
            this.tbs.v = 1.0 / rho;
        } else {
            double vv;
            double vl;
            double[] HS_devV;
            double[] HS_devL;
            if (this.component.length > 1) {
                FlashMethodCPA_1Boucle fm = new FlashMethodCPA_1Boucle(this, "SRK", T, P_Pa, this.tbs.fract_mol);
                titre = (fm.x[0] - this.tbs.fract_mol[0]) / (fm.x[0] - fm.y[0]);
                double qual = fm.L / this.tbs.mixM;
                if (this.debug) {
                    System.out.println("titre: " + titre + "  qual: " + qual);
                }
                int i = 0;
                while (i < this.tbs.nbComponents) {
                    res[6 + i] = fm.x[i];
                    res[6 + this.tbs.nbComponents + i] = fm.y[i];
                    ++i;
                }
                double liqM = this.getMixMolarmass(fm.x);
                double vapM = this.getMixMolarmass(fm.y);
                titre = (fm.x[0] * this.tbs.compProp[0].M / liqM - this.tbs.fract_mol[0] * this.tbs.compProp[0].M / this.tbs.mixM) / (fm.x[0] * this.tbs.compProp[0].M / liqM - fm.y[0] * this.tbs.compProp[0].M / vapM);
                if (this.debug) {
                    System.out.println("titre 2: " + titre);
                }
                HS_devL = this.getHSdeviations("SRK", T, fm.rhoL, fm.x);
                HS_devV = this.getHSdeviations("SRK", T, fm.rhoV, fm.y);
                vl = 1.0 / fm.rhoL;
                vv = 1.0 / fm.rhoV;
                if (this.debug) {
                    System.out.println("apr\u00e8s loi m\u00e9lange phases liqM " + liqM + " vapM " + vapM);
                }
            } else {
                titre = quality;
                rho = this.calcRho(T, P_Pa, 0.0, this.tbs.fract_mol);
                vl = 1.0 / rho;
                HS_devL = this.getHSdeviations("SRK", T, rho, this.tbs.fract_mol);
                rho = this.calcRho(T, P_Pa, 1.0, this.tbs.fract_mol);
                vv = 1.0 / rho;
                HS_devV = this.getHSdeviations("SRK", T, rho, this.tbs.fract_mol);
            }
            this.hl = (HS_devL[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
            this.sl = (HS_devL[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
            this.hv = (HS_devV[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
            this.sv = (HS_devV[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
            h = this.hv * titre + (1.0 - titre) * this.hl;
            s = this.sv * titre + (1.0 - titre) * this.sl;
            this.tbs.v = vv * titre + (1.0 - titre) * vl;
            quality = titre;
        }
        res[0] = h;
        res[1] = this.tbs.v / this.tbs.mixM * 1000.0;
        res[2] = 0.0;
        res[3] = quality;
        res[4] = res[0] - (p / 100000.0 * res[1] - this.tbs.mixu0);
        res[5] = s;
        return res;
    }

    public double calcRho(double T, double P_Pa, double quality, double[] x) {
        double[] init = new double[2];
        this.xRho = x;
        this.tbs.Pparam = P_Pa;
        this.tbs.Tparam = T;
        this.callFunction = "calcRho";
        init[1] = quality == 0.0 ? 0.95 / this.bMixBis : P_Pa / T / 8.314472471;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        return result[1];
    }

    void calcHsIdeal(double T, double P_Pa) {
        double p = P_Pa;
        this.hid = 0.0;
        this.sid = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.hid += this.tbs.fract_mol[i] * (this.tbs.compProp[i].h_gaz_mol(T) / this.tbs.compProp[i].M + this.tbs.compProp[i].h0);
            this.sid += this.tbs.fract_mol[i] * (this.tbs.compProp[i].s_gaz_mol(T, p) / this.tbs.compProp[i].M + this.tbs.compProp[i].s0);
            ++i;
        }
    }

    public double CompFacHelmCPA(String type, String AnNum, double Temperature, double rho, double[] x) {
        if (AnNum == "An" || AnNum == "Num") {
            double arCub = this.aR_rhoCub(type, AnNum, Temperature, rho, x);
            double arAss = this.aR_rhoAss(AnNum, Temperature, rho, x);
            return 1.0 + rho * (arCub + arAss);
        }
        System.out.println("CompFacHelmCPA error!");
        return 0.0;
    }

    public double[] PhiHelmCPA(String type, String AnNum, double Temperature, double rho, double[] x) {
        double[] Phi = new double[this.ncomp];
        if (!(type != "PR" && type != "SRK" || AnNum != "An" && AnNum != "Num")) {
            double Z = this.CompFacHelmCPA(type, AnNum, Temperature, rho, x);
            double aRCubBis = this.aRCub(type, Temperature, rho, x);
            double[] naR_niCubBis = this.naR_niCub(type, AnNum, Temperature, rho, x);
            double[] AR_niAssBis = this.AR_niAss(AnNum, Temperature, rho, x);
            int i = 0;
            while (i < this.ncomp) {
                Phi[i] = Math.exp(-Math.log(Z) + (aRCubBis + naR_niCubBis[i] + AR_niAssBis[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.ncomp) {
                System.out.println("PhiHelm error!");
                Phi[i] = 0.0;
                ++i;
            }
        }
        return Phi;
    }

    public double KeqWil(double TCritic, double PCritic, double w, double P, double Temperature) {
        return Math.exp(Math.log(PCritic / P) + 5.373 * (1.0 + w) * (1.0 - TCritic / Temperature));
    }

    public double PsatEstimated(double TCritic, double PCritic, double w, double Temperature) {
        double Tr = Temperature / TCritic;
        return PCritic * Math.exp(5.92714 - 6.09648 / Tr - 1.28862 * Math.log(Tr) + 0.169347 * Math.pow(Tr, 6.0) + w * (15.2518 - 15.6875 / Tr - 13.4721 * Math.log(Tr) + 0.43577 * Math.pow(Tr, 6.0)));
    }

    public double TsatEstimated(double TCritic, double PCritic, double w, double Pressure) {
        double Tmax = 0.99 * TCritic;
        double Tmin = 0.01 * TCritic;
        double Tmid = (Tmax + Tmin) / 2.0;
        while (Tmax - Tmin > 0.1) {
            Tmid = (Tmax + Tmin) / 2.0;
            if ((this.PsatEstimated(TCritic, PCritic, w, Tmid) - Pressure) * (this.PsatEstimated(TCritic, PCritic, w, Tmax) - Pressure) > 0.0) {
                Tmax = Tmid;
                continue;
            }
            Tmin = Tmid;
        }
        return (Tmax + Tmin) / 2.0;
    }

    public double[] ParameterU(String type) {
        double[] U = new double[2];
        if (type.equals("PR")) {
            U[0] = 1.0 + Math.sqrt(2.0);
            U[1] = 1.0 - Math.sqrt(2.0);
        } else if (type.equals("SRK")) {
            U[0] = 1.0;
            U[1] = 0.0;
        } else {
            U[0] = 0.0;
            U[1] = 0.0;
            System.out.println("error ParameterU");
        }
        return U;
    }

    public double[] aCPA(double Temperature) {
        double[] a = new double[this.ncomp];
        int i = 0;
        while (i < this.ncomp) {
            a[i] = this.a0[i] * Math.pow(1.0 + this.c1[i] * (1.0 - Math.sqrt(Temperature / this.TCritic[i])), 2.0);
            ++i;
        }
        return a;
    }

    public double[][] aij(double Temperature) {
        double[][] aijBis = new double[this.ncomp][this.ncomp];
        double[] aCPABis = this.aCPA(Temperature);
        int i = 0;
        while (i < this.ncomp) {
            int j = 0;
            while (j < this.ncomp) {
                aijBis[i][j] = Math.sqrt(aCPABis[i] * aCPABis[j]) * (1.0 - this.kijCPA[i][j]);
                ++j;
            }
            ++i;
        }
        return aijBis;
    }

    public double aMix(double Temperature, double[] x) {
        double a = 0.0;
        double[][] aijBis = this.aij(Temperature);
        int i = 0;
        while (i < this.ncomp) {
            int j = 0;
            while (j < this.ncomp) {
                a += x[i] * x[j] * aijBis[i][j];
                ++j;
            }
            ++i;
        }
        return a;
    }

    public double bMix(double[] x) {
        double b = 0.0;
        int i = 0;
        while (i < this.ncomp) {
            b += x[i] * this.bCPA[i];
            ++i;
        }
        return b;
    }

    public double Rdf(double rho, double[] x) {
        this.bMixBis = this.bMix(x);
        double eta = this.bMixBis * rho / 4.0;
        return 1.0 / (1.0 - 1.9 * eta);
    }

    public int nSite() {
        int sum = 0;
        int i = 0;
        while (i < this.ncomp) {
            sum += this.siteType[i][0];
            ++i;
        }
        return sum;
    }

    public double[] ConstrExt(double[] A) {
        int i = 0;
        double[] AExt = new double[this.nsite];
        int j = 0;
        while (j < this.ncomp) {
            int k = 0;
            while (k < this.siteType[j][0]) {
                AExt[i] = A[j];
                ++i;
                ++k;
            }
            ++j;
        }
        return AExt;
    }

    public double[][] ConstrEpsSite() {
        int l;
        int k;
        int ij = 0;
        int ik = 0;
        double[][] epsSite = new double[this.nsite][this.nsite];
        int j = 0;
        while (j < this.nsite) {
            k = 0;
            while (k < this.nsite) {
                epsSite[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < this.ncomp) {
            k = 0;
            while (k < this.siteType[j][0]) {
                l = 0;
                while (l < this.siteType[j][0]) {
                    if (k > this.siteType[j][1] - 1 ^ l > this.siteType[j][1] - 1) {
                        epsSite[ik + k][ik + l] = this.epsPure[j];
                    }
                    ++l;
                }
                ++k;
            }
            ik += this.siteType[j][0];
            ++j;
        }
        j = 0;
        while (j < this.ncomp - 1) {
            ij = 0;
            int x = 0;
            while (x < j) {
                ij += this.siteType[x][0];
                ++x;
            }
            k = j + 1;
            while (k < this.ncomp) {
                ik = 0;
                int y = 0;
                while (y < k) {
                    ik += this.siteType[y][0];
                    ++y;
                }
                l = 0;
                while (l < this.siteType[j][0]) {
                    int m = 0;
                    while (m < this.siteType[k][0]) {
                        if (l > this.siteType[j][1] - 1 ^ m > this.siteType[k][1] - 1) {
                            epsSite[ij + l][ik + m] = (this.epsPure[j] + this.epsPure[k]) / 2.0;
                            epsSite[ik + m][ij + l] = epsSite[ij + l][ik + m];
                        }
                        ++m;
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return epsSite;
    }

    public double[][] ConstrBetaSite() {
        int l;
        int k;
        int ij = 0;
        int ik = 0;
        double[][] betaSite = new double[this.nsite][this.nsite];
        int j = 0;
        while (j < this.nsite) {
            k = 0;
            while (k < this.nsite) {
                betaSite[j][k] = 0.0;
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < this.ncomp) {
            k = 0;
            while (k < this.siteType[j][0]) {
                l = 0;
                while (l < this.siteType[j][0]) {
                    if (k > this.siteType[j][1] - 1 ^ l > this.siteType[j][1] - 1) {
                        betaSite[ik + k][ik + l] = this.betaPure[j];
                    }
                    ++l;
                }
                ++k;
            }
            ik += this.siteType[j][0];
            ++j;
        }
        j = 0;
        while (j < this.ncomp - 1) {
            ij = 0;
            int x = 0;
            while (x < j) {
                ij += this.siteType[x][0];
                ++x;
            }
            k = j + 1;
            while (k < this.ncomp) {
                ik = 0;
                int y = 0;
                while (y < k) {
                    ik += this.siteType[y][0];
                    ++y;
                }
                l = 0;
                while (l < this.siteType[j][0]) {
                    int m = 0;
                    while (m < this.siteType[k][0]) {
                        if (l > this.siteType[j][1] - 1 ^ m > this.siteType[k][1] - 1) {
                            betaSite[ij + l][ik + m] = Math.sqrt(this.betaPure[j] * this.betaPure[k]);
                            betaSite[ik + m][ij + l] = betaSite[ij + l][ik + m];
                        }
                        ++m;
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return betaSite;
    }

    public double[][] deltaSite(double Temperature, double rho, double[] x) {
        double[][] deltaSiteBis = new double[this.nsite][this.nsite];
        double g = this.Rdf(rho, x);
        int i = 0;
        while (i < this.nsite) {
            int j = 0;
            while (j < this.nsite) {
                deltaSiteBis[i][j] = g * (Math.exp(this.epsSite[i][j] / 8.314472 / Temperature) - 1.0) * ((this.bCPAExt[i] + this.bCPAExt[j]) / 2.0) * this.betaSite[i][j];
                ++j;
            }
            ++i;
        }
        return deltaSiteBis;
    }

    public double[] XSite(double Temperature, double rho, double[] x) {
        int j;
        double sum = 0.0;
        double[] xExt = this.ConstrExt(x);
        double[] XSiteNew = new double[this.nsite];
        double[] XSiteOld = new double[this.nsite];
        double[][] deltaSiteBis = this.deltaSite(Temperature, rho, x);
        double[][] Kmn = new double[this.nsite][this.nsite];
        int i = 0;
        while (i < this.nsite) {
            j = 0;
            while (j < this.nsite) {
                Kmn[i][j] = xExt[i] * xExt[j] * deltaSiteBis[i][j] * rho;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nsite) {
            XSiteOld[i] = 0.5;
            XSiteNew[i] = 0.6;
            ++i;
        }
        while (this.testVect(XSiteNew, XSiteOld) > 1.0E-8) {
            i = 0;
            while (i < this.nsite) {
                XSiteOld[i] = XSiteNew[i];
                ++i;
            }
            i = 0;
            while (i < this.nsite) {
                sum = 0.0;
                j = 0;
                while (j < this.nsite) {
                    sum += Kmn[i][j] * XSiteOld[j];
                    ++j;
                }
                XSiteNew[i] = sum == 0.0 ? 1.0 : xExt[i] / (xExt[i] + sum);
                ++i;
            }
        }
        return XSiteNew;
    }

    public double CPAP(String type, double Temperature, double rho, double[] x) {
        this.u1 = this.ParameterU(type)[0];
        this.u2 = this.ParameterU(type)[1];
        double sum = 0.0;
        double aMixBis = this.aMix(Temperature, x);
        this.bMixBis = this.bMix(x);
        double[] XSiteBis = this.XSite(Temperature, rho, x);
        double[] xExt = this.ConstrExt(x);
        double eta = this.bMixBis * rho / 4.0;
        double lnRdf = 1.9 * eta / (1.0 - 1.9 * eta);
        int i = 0;
        while (i < this.nsite) {
            sum += xExt[i] * (1.0 - XSiteBis[i]);
            ++i;
        }
        return 8.314472 * Temperature / (1.0 / rho - this.bMixBis) - aMixBis / ((1.0 / rho + this.u1 * this.bMixBis) * (1.0 / rho + this.u2 * this.bMixBis)) - 8.314472 * Temperature * rho / 2.0 * (1.0 + lnRdf) * sum;
    }

    public double aRCub(String type, double Temperature, double rho, double[] x) {
        if (type == "PR" || type == "SRK") {
            this.u1 = this.ParameterU(type)[0];
            this.u2 = this.ParameterU(type)[1];
            double aMixBis = this.aMix(Temperature, x);
            double bMixBis = this.bMix(x);
            return Math.log(1.0 / rho / (1.0 / rho - bMixBis)) + aMixBis / 8.314472 / Temperature / bMixBis / (this.u1 - this.u2) * Math.log((1.0 / rho + this.u2 * bMixBis) / (1.0 / rho + this.u1 * bMixBis));
        }
        System.out.println("aRCub error!");
        return 0.0;
    }

    protected double aR_rhoCub(String type, String AnNum, double Temperature, double rho, double[] x) {
        if (type == "PR" || type == "SRK") {
            this.u1 = this.ParameterU(type)[0];
            this.u2 = this.ParameterU(type)[1];
            if (AnNum == "An") {
                double aMixBis = this.aMix(Temperature, x);
                double bMixBis = this.bMix(x);
                return bMixBis / (1.0 - bMixBis * rho) + aMixBis / (8.314472 * Temperature * bMixBis * (this.u1 - this.u2)) * (this.u2 * bMixBis / (1.0 + this.u2 * bMixBis * rho) - this.u1 * bMixBis / (1.0 + this.u1 * bMixBis * rho));
            }
            if (AnNum == "Num") {
                double h = rho * 1.0E-5;
                double rhoUp = rho + h;
                double rhoDown = rho - h;
                return (this.aRCub(type, Temperature, rhoUp, x) - this.aRCub(type, Temperature, rhoDown, x)) / 2.0 / h;
            }
            System.out.println("aR_rhoCub error!");
            return 0.0;
        }
        System.out.println("aR_rhoCub error!");
        return 0.0;
    }

    protected double[] naR_niCub(String type, String AnNum, double Temperature, double rho, double[] x) {
        double[] naR_niBis = new double[this.ncomp];
        if (type == "PR" || type == "SRK") {
            this.u1 = this.ParameterU(type)[0];
            this.u2 = this.ParameterU(type)[1];
            double[][] aijBis = this.aij(Temperature);
            double sum = 0.0;
            double aMixBis = this.aMix(Temperature, x);
            this.bMixBis = this.bMix(x);
            int i = 0;
            while (i < this.ncomp) {
                if (AnNum == "An") {
                    sum = 0.0;
                    int j = 0;
                    while (j < this.ncomp) {
                        sum += x[j] * aijBis[i][j];
                        ++j;
                    }
                    naR_niBis[i] = this.bCPA[i] * rho / (1.0 - this.bMixBis * rho) + aMixBis / (8.314472 * Temperature * this.bMixBis * (this.u1 - this.u2)) * ((2.0 * sum - aMixBis) / aMixBis - this.bCPA[i] / this.bMixBis) * Math.log((1.0 + this.u2 * this.bMixBis * rho) / (1.0 + this.u1 * this.bMixBis * rho)) + aMixBis * rho / (8.314472 * Temperature * this.bMixBis * (this.u1 - this.u2)) * (this.u2 * this.bCPA[i] / (1.0 + this.u2 * this.bMixBis * rho) - this.u1 * this.bCPA[i] / (1.0 + this.u1 * this.bMixBis * rho));
                } else if (AnNum == "Num") {
                    double h = x[i] * 1.0E-4;
                    double rhoUp = (1.0 + h) * rho;
                    double rhoDown = (1.0 - h) * rho;
                    double[] xUp = new double[this.ncomp];
                    double[] xDown = new double[this.ncomp];
                    int j = 0;
                    while (j < this.ncomp) {
                        if (j == i) {
                            xUp[j] = (x[j] + h) / (1.0 + h);
                            xDown[j] = (x[j] - h) / (1.0 - h);
                        } else {
                            xUp[j] = x[j] / (1.0 + h);
                            xDown[j] = x[j] / (1.0 - h);
                        }
                        ++j;
                    }
                    naR_niBis[i] = (this.aRCub(type, Temperature, rhoUp, xUp) - this.aRCub(type, Temperature, rhoDown, xDown)) / 2.0 / h;
                } else {
                    System.out.println("aR_niCub error!");
                    naR_niBis[i] = 0.0;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.ncomp) {
                System.out.println("aR_niCub error!");
                naR_niBis[i] = 0.0;
                ++i;
            }
        }
        return naR_niBis;
    }

    public double aRAss(double Temperature, double rho, double[] x) {
        double sum = 0.0;
        double[] XSiteBis = this.XSite(Temperature, rho, x);
        double[] xExt = this.ConstrExt(x);
        int i = 0;
        while (i < this.nsite) {
            sum += xExt[i] * (Math.log(XSiteBis[i]) - XSiteBis[i] / 2.0 + 0.5);
            ++i;
        }
        return sum;
    }

    public double aR_rhoAss(String AnNum, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double sum = 0.0;
            double bMixBis = this.bMix(x);
            double eta = bMixBis * rho / 4.0;
            double rholnRdf = 1.9 * eta / (1.0 - 1.9 * eta);
            double[] XSiteBis = this.XSite(Temperature, rho, x);
            double[] xExt = this.ConstrExt(x);
            int i = 0;
            while (i < this.nsite) {
                sum += xExt[i] * (1.0 - XSiteBis[i]);
                ++i;
            }
            return -(1.0 + rholnRdf) * sum / 2.0 / rho;
        }
        if (AnNum == "Num") {
            double h = rho * 1.0E-5;
            double rhoUp = rho + h;
            double rhoDown = rho - h;
            return (this.aRAss(Temperature, rhoUp, x) - this.aRAss(Temperature, rhoDown, x)) / 2.0 / h;
        }
        System.out.println("aR_rhoAss error!");
        return 0.0;
    }

    protected double[] AR_niAss(String AnNum, double Temperature, double rho, double[] x) {
        int n = 0;
        double[] AR_niBis = new double[this.ncomp];
        double sum1 = 0.0;
        double sum2 = 0.0;
        double bMixBis = this.bMix(x);
        double eta = bMixBis * rho / 4.0;
        double[] XSiteBis = this.XSite(Temperature, rho, x);
        double[] xExt = this.ConstrExt(x);
        double[] lnRdf_ni = new double[this.ncomp];
        int i = 0;
        while (i < this.ncomp) {
            lnRdf_ni[i] = 0.475 * rho * this.bCPA[i] / (1.0 - 1.9 * eta);
            ++i;
        }
        i = 0;
        while (i < this.ncomp) {
            if (AnNum == "An") {
                sum1 = 0.0;
                int j = 0;
                while (j < this.siteType[i][0]) {
                    sum1 += Math.log(XSiteBis[n + j]);
                    ++j;
                }
                n += this.siteType[i][0];
                sum2 = 0.0;
                j = 0;
                while (j < this.nsite) {
                    sum2 += xExt[j] * (1.0 - XSiteBis[j]);
                    ++j;
                }
                AR_niBis[i] = sum1 - lnRdf_ni[i] * sum2 / 2.0;
            } else if (AnNum == "Num") {
                double h = x[i] * 1.0E-4;
                double rhoUp = (1.0 + h) * rho;
                double rhoDown = (1.0 - h) * rho;
                double[] xUp = new double[this.ncomp];
                double[] xDown = new double[this.ncomp];
                int j = 0;
                while (j < this.ncomp) {
                    if (j == i) {
                        xUp[j] = (x[j] + h) / (1.0 + h);
                        xDown[j] = (x[j] - h) / (1.0 - h);
                    } else {
                        xUp[j] = x[j] / (1.0 + h);
                        xDown[j] = x[j] / (1.0 - h);
                    }
                    ++j;
                }
                AR_niBis[i] = (this.aRAss(Temperature, rhoUp, xUp) - this.aRAss(Temperature, rhoDown, xDown)) / 2.0 / h;
            } else {
                System.out.println("aR_niAss error!");
                AR_niBis[i] = 0.0;
            }
            ++i;
        }
        return AR_niBis;
    }

    protected double testVect(double[] A, double[] B) {
        double sum = 0.0;
        int i = 0;
        while (i < A.length) {
            sum += Math.abs(A[i] - B[i]);
            ++i;
        }
        return sum;
    }

    public double getPressure() {
        return this.Pressure;
    }

    public double getdPressureZeta() {
        return this.dPressureZeta;
    }

    public double getEntropyDeviation(String type, double Temperature, double rho, double[] x) {
        double S_Dev = 0.0;
        double aR_TCub = this.aR_TCub(type, Temperature, rho, x);
        double aR_TAss = this.aR_TAss(Temperature, rho, x);
        S_Dev = -aR_TAss - aR_TCub;
        return S_Dev;
    }

    public double getEnthalpyDeviation(String type, double Temperature, double rho, double[] x) {
        double H_Dev = 0.0;
        double aRCub = 8.314472 * Temperature * this.aRCub(type, Temperature, rho, x);
        double aRAss = 8.314472 * Temperature * this.aRAss(Temperature, rho, x);
        double Hdev1 = aRCub + aRAss;
        double Hdev2 = Temperature * this.getEntropyDeviation(type, Temperature, rho, x);
        H_Dev = Hdev1 + Hdev2;
        double Z = this.CPAP(type, Temperature, rho, x);
        Z = Z / rho / 8.314472 / Temperature;
        double Hdev3 = 8.314472 * Temperature * (Z - 1.0);
        return H_Dev += Hdev3;
    }

    public double[] getHSdeviations(String type, double Temperature, double rho, double[] x) {
        double[] res = new double[2];
        double S_Dev = 0.0;
        double aR_TCub = this.aR_TCub(type, Temperature, rho, x);
        double aR_TAss = this.aR_TAss(Temperature, rho, x);
        double Z = this.CPAP(type, Temperature, rho, x);
        Z = Z / rho / 8.314472 / Temperature;
        S_Dev = -aR_TAss - aR_TCub + 8.314472 * Math.log(Z);
        double H_Dev = 0.0;
        double aRCub = 8.314472 * Temperature * this.aRCub(type, Temperature, rho, x);
        double aRAss = 8.314472 * Temperature * this.aRAss(Temperature, rho, x);
        double Hdev1 = aRCub + aRAss;
        double Hdev2 = Temperature * (S_Dev - 8.314472 * Math.log(Z));
        H_Dev = Hdev1 + Hdev2;
        double Hdev3 = 8.314472 * Temperature * (Z - 1.0);
        res[0] = H_Dev += Hdev3;
        res[1] = S_Dev;
        return res;
    }

    public double aR_TAss(double Temperature, double rho, double[] x) {
        double h = Temperature * 1.0E-5;
        double temperatureUp = Temperature + h;
        double temperatureDown = Temperature - h;
        return (8.314472 * temperatureUp * this.aRAss(temperatureUp, rho, x) - 8.314472 * temperatureDown * this.aRAss(temperatureDown, rho, x)) / 2.0 / h;
    }

    protected double aR_TCub(String type, double Temperature, double rho, double[] x) {
        if (type == "PR" || type == "SRK") {
            double h = Temperature * 1.0E-5;
            double temperatureUp = Temperature + h;
            double temperatureDown = Temperature - h;
            return (8.314472 * temperatureUp * this.aRCub(type, temperatureUp, rho, x) - 8.314472 * temperatureDown * this.aRCub(type, temperatureDown, rho, x)) / 2.0 / h;
        }
        System.out.println("aR_TCub error!");
        return 0.0;
    }

    protected double a_TMix(double[] x, double[] a_CPA, double[] a_TCPA, double[][] k) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            int j = 0;
            while (j < nbComponents) {
                am += x[i] * x[j] / 2.0 / Math.pow(a_CPA[i] * a_CPA[j], 0.5) * (a_CPA[j] * a_TCPA[i] + a_CPA[i] * a_TCPA[j]) * (1.0 - k[i][j]);
                ++j;
            }
            ++i;
        }
        return am;
    }

    public double[] a_TCPA(double[] a0, double[] c1, int ncomp, double Temperature) {
        double[] a_T = new double[ncomp];
        int i = 0;
        while (i < ncomp) {
            double mu = (c1[i] * c1[i] - c1[i] * (1.0 + c1[i]) / Math.pow(Temperature / this.TCritic[i], 0.5)) / this.TCritic[i];
            a_T[i] = a0[i] * mu;
            ++i;
        }
        return a_T;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        double TT = 300.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("calcRho")) {
            TT = this.tbs.Tparam;
            if (x[1] < 0.0) {
                x[1] = -x[1];
            }
            double epsi = 1.0E-7;
            this.bMixBis = this.bMix(this.xRho);
            double lim = (1.0 - epsi) / this.bMixBis;
            if (x[1] > lim) {
                x[1] = lim;
            }
            double rho = x[1];
            fvec[1] = this.rhoResidual(TT, rho);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    double rhoResidual(double T, double rho) {
        double Pcalc = this.CPAP("SRK", T, rho, this.xRho);
        if (this.debug) {
            System.out.println("Pcalc: " + Pcalc + "  tbs.Pparam: " + this.tbs.Pparam);
        }
        return this.tbs.Pparam - Pcalc;
    }

    public double getBubblePointTemperature(String type, double Pressure, double[] x) {
        double[] y = new double[this.ncomp];
        double[] phiV = new double[this.ncomp];
        double[] phiL = new double[this.ncomp];
        double[] Tboiling = new double[this.ncomp];
        int i = 0;
        while (i < this.ncomp) {
            Tboiling[i] = this.TsatEstimated(this.TCritic[i], this.PCritic[i], this.wCPA[i], Pressure);
            ++i;
        }
        double T = 0.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            T += x[i2] * Tboiling[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            y[i2] = x[i2];
            ++i2;
        }
        do {
            this.rhoV = this.calcRho(T, Pressure, 1.0, y);
            phiV = this.PhiHelmCPA(type, this.AnNum, T, this.rhoV, y);
            this.rhoL = this.calcRho(T, Pressure, 0.0, x);
            phiL = this.PhiHelmCPA(type, this.AnNum, T, this.rhoL, x);
            double sumX = this.sumX(phiL, phiV, x, this.ncomp);
            this.sumY(phiL, phiV, y, this.ncomp);
            T *= Math.pow(sumX, -0.0625);
            int i3 = 0;
            while (i3 < this.ncomp) {
                y[i3] = x[i3] * phiL[i3] / phiV[i3] / sumX;
                ++i3;
            }
        } while (this.equalF(phiL, phiV, x, y, this.ncomp) > this.eps);
        return T;
    }

    public double getBubblePointPressure(String type, double Temperature, double[] x) {
        double[] y = new double[this.ncomp];
        double[] phiV = new double[this.ncomp];
        double[] phiL = new double[this.ncomp];
        double[] Psat = new double[this.ncomp];
        int[] siteI = new int[2];
        int i = 0;
        while (i < this.ncomp) {
            siteI[0] = this.siteType[i][0];
            siteI[1] = this.siteType[i][1];
            Psat[i] = this.PsatEstimated(this.TCritic[i], this.PCritic[i], this.wCPA[i], Temperature);
            ++i;
        }
        double P = 0.0;
        double PInt = 10000.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            P += x[i2] * Psat[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            y[i2] = x[i2];
            ++i2;
        }
        do {
            this.rhoV = this.calcRho(Temperature, P, 1.0, y);
            phiV = this.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoV, y);
            this.rhoL = this.calcRho(Temperature, P, 0.0, x);
            phiL = this.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoL, x);
            PInt = P;
            double sumX = this.sumX(phiL, phiV, x, this.ncomp);
            this.sumY(phiL, phiV, y, this.ncomp);
            P *= sumX;
            int i3 = 0;
            while (i3 < this.ncomp) {
                y[i3] = x[i3] * phiL[i3] / phiV[i3] / sumX;
                ++i3;
            }
        } while (this.equalF(phiL, phiV, x, y, this.ncomp) > this.eps || Math.abs(PInt - P) / P > this.eps);
        return P;
    }

    public double getDewPointTemperature(String type, double Pressure, double[] y) {
        double[] x = new double[this.ncomp];
        double[] phiV = new double[this.ncomp];
        double[] phiL = new double[this.ncomp];
        double[] Tboiling = new double[this.ncomp];
        int i = 0;
        while (i < this.ncomp) {
            Tboiling[i] = this.TsatEstimated(this.TCritic[i], this.PCritic[i], this.wCPA[i], Pressure);
            ++i;
        }
        double T = 0.0;
        double TInt = 0.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            T += y[i2] * Tboiling[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            x[i2] = y[i2];
            ++i2;
        }
        do {
            this.rhoV = this.calcRho(T, Pressure, 1.0, y);
            phiV = this.PhiHelmCPA(type, this.AnNum, T, this.rhoV, y);
            this.rhoL = this.calcRho(T, Pressure, 0.0, x);
            phiL = this.PhiHelmCPA(type, this.AnNum, T, this.rhoL, x);
            TInt = T;
            double sumX = this.sumX(phiL, phiV, x, this.ncomp);
            double sumY = this.sumY(phiL, phiV, y, this.ncomp);
            T *= Math.pow(sumX, -0.0625);
            int i3 = 0;
            while (i3 < this.ncomp) {
                x[i3] = y[i3] * phiV[i3] / phiL[i3] / sumY;
                ++i3;
            }
        } while (this.equalF(phiL, phiV, x, y, this.ncomp) > this.eps || Math.abs(TInt - T) / T > this.eps);
        return T;
    }

    public double getDewPointPressure(String type, double Temperature, double[] y) {
        double[] x = new double[this.ncomp];
        double[] phiV = new double[this.ncomp];
        double[] phiL = new double[this.ncomp];
        double[] Psat = new double[this.ncomp];
        int[] siteI = new int[2];
        int i = 0;
        while (i < this.ncomp) {
            siteI[0] = this.siteType[i][0];
            siteI[1] = this.siteType[i][1];
            Psat[i] = this.PsatEstimated(this.TCritic[i], this.PCritic[i], this.wCPA[i], Temperature);
            ++i;
        }
        double P = 0.0;
        double PInt = 10000.0;
        int i2 = 0;
        while (i2 < this.ncomp) {
            P += y[i2] * Psat[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ncomp) {
            x[i2] = y[i2];
            ++i2;
        }
        do {
            this.rhoV = this.calcRho(Temperature, P, 1.0, y);
            phiV = this.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoV, y);
            this.rhoL = this.calcRho(Temperature, P, 0.0, x);
            phiL = this.PhiHelmCPA(type, this.AnNum, Temperature, this.rhoL, x);
            PInt = P;
            double sumX = this.sumX(phiL, phiV, x, this.ncomp);
            double sumY = this.sumY(phiL, phiV, y, this.ncomp);
            P *= sumX;
            int i3 = 0;
            while (i3 < this.ncomp) {
                x[i3] = y[i3] * phiV[i3] / phiL[i3] / sumY;
                ++i3;
            }
        } while (this.equalF(phiL, phiV, x, y, this.ncomp) > this.eps || Math.abs(PInt - P) / P > this.eps);
        return P;
    }

    protected double equalF(double[] phiL, double[] phiV, double[] x, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += Math.abs(x[i] * phiL[i] - y[i] * phiV[i]);
            ++i;
        }
        return sum;
    }

    protected double sumY(double[] phiL, double[] phiV, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += y[i] * phiV[i] / phiL[i];
            ++i;
        }
        return sum;
    }

    protected double sumX(double[] phiL, double[] phiV, double[] x, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += x[i] * phiL[i] / phiV[i];
            ++i;
        }
        return sum;
    }
}

