/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.MonoPhaseException;
import bibCTP.cubic.Ede;
import bibCTP.cubic.ResultatCardan;
import bibCTP.cubic.SolutionR;
import bibCTP.cubic.alpha.AlphaFunction;
import bibCTP.cubic.alpha.Alphas;
import bibCTP.cubic.alpha.Daridon;
import bibCTP.cubic.alpha.GeneraliseePR;
import bibCTP.cubic.alpha.GeneraliseeSRK;
import bibCTP.cubic.alpha.MathiasCopeman;
import bibCTP.cubic.alpha.Soave;
import bibCTP.cubic.alpha.StryjeckVera;
import bibCTP.cubic.alpha.TwuPR;
import bibCTP.cubic.alpha.TwuSRK;
import bibCTP.cubic.model.CubicCompProperties;
import bibCTP.cubic.model.CubicModel;
import bibCTP.cubic.model.GeneralizedCubicEOSparameters;
import bibCTP.cubic.model.HarmensKnapp;
import bibCTP.cubic.model.PatelTeja;
import bibCTP.cubic.model.PengRobinson;
import bibCTP.cubic.model.SRK;
import bibCTP.cubic.model.SRKControle;
import bibCTP.cubic.model.VanDerWaals;
import bibCTP.model.FluidModel;
import bibCTP.util.CpGeneralisee;
import bibCTP.util.ELVComposition;
import bibCTP.util.EnthalpieEntropie;
import extThopt.Util;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CubicEOS
extends FluidModel {
    public CubicModel cubicModel;
    public AlphaFunction alphaFunction;
    public int nbmodele;
    public int nbalpha;
    public Alphas fonctionalphas;
    public double mixa;
    public double mixaref;
    public double mixdadt;
    public double mixac;
    public double mixb;
    public double mixc1;
    public double mixc2;
    public double mixc3;
    public double mixalpha;
    public double mixalpharef;
    public CubicCompProperties[] cubicCompProp;
    double hl;
    double hv;
    double sl;
    double sv;
    double Vl;
    double Vv;
    public GeneralizedCubicEOSparameters mod;
    public double[] ZZ;
    double am1;
    double bm1;

    public CubicEOS() {
    }

    public CubicEOS(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "CubicEOS";
    }

    public String getType() {
        return "CubicEOS";
    }

    public void readXml() {
        super.readXml();
        Element xmlFragment = this.fluid_Model;
        int nbmodele = -1;
        int nbalpha = -1;
        System.out.println("xmlFragment " + xmlFragment);
        List listChildren = xmlFragment.getChildren("CUBIC");
        Element courant = (Element)listChildren.get(0);
        String value = courant.getAttributeValue("CubicModel");
        nbmodele = Util.lit_i((String)value);
        if (this.debug) {
            System.out.println("code CubicModel: " + nbmodele);
        }
        value = courant.getAttributeValue("Alpha");
        nbalpha = Util.lit_i((String)value);
        if (this.debug) {
            System.out.println("code nbalpha: " + nbalpha);
        }
        this.cubicModel = this.getCubicModel(nbmodele, this);
        this.alphaFunction = this.getAlphaFunction(nbalpha);
        Vector<Object> args = new Vector<Object>();
        args.addElement(new Integer(nbmodele));
        args.addElement(new Integer(nbalpha));
        this.cubicCompProp = new CubicCompProperties[this.tbs.nbComponents];
        int i = 0;
        while (i < this.component.length) {
            xmlFragment = this.component[i];
            listChildren = xmlFragment.getChildren("MODEL");
            Element el = (Element)listChildren.get(0);
            listChildren = el.getChildren("ALPHA");
            courant = (Element)listChildren.get(0);
            this.cubicCompProp[i] = new CubicCompProperties();
            value = courant.getAttributeValue("c1");
            this.cubicCompProp[i].c1 = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("c1: " + value + "\ti: " + i);
            }
            args.addElement(value);
            value = courant.getAttributeValue("c2");
            if (this.debug) {
                System.out.println("c2: " + value);
            }
            this.cubicCompProp[i].c2 = Util.lit_d((String)value);
            args.addElement(value);
            value = courant.getAttributeValue("c3");
            args.addElement(value);
            if (this.debug) {
                System.out.println("c3: " + value);
            }
            this.cubicCompProp[i].c3 = Util.lit_d((String)value);
            ++i;
        }
        value = "";
        if (this.tbs.nbComponents > 1) {
            i = 0;
            while (i < this.tbs.nbComponents) {
                int j = 0;
                while (j < this.tbs.nbComponents) {
                    String attName = "k" + Util.aff_i((int)i) + Util.aff_i((int)j);
                    value = this.mixRules.getAttributeValue(attName);
                    this.tbs.k[i][j] = Util.lit_d((String)value);
                    if (this.debug) {
                        System.out.println("k[i][j] " + this.tbs.k[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setParameters(Vector v) {
        this.cubicCompProp[0].c1 = this.getPropArray(0, v)[0];
        this.cubicCompProp[0].c2 = this.getPropArray(0, v)[1];
        this.cubicCompProp[0].c3 = this.getPropArray(0, v)[2];
        this.calcMixProps();
    }

    public double[] calcSubstance(double T, double P_Pa, double x) {
        double p = P_Pa;
        double[] res = new double[6 + 2 * this.tbs.nbComponents];
        double h = 0.0;
        double s = 0.0;
        if (this.tbs.nbComponents > 1) {
            double Tbulle = this.getSatTemperature(p, 0.0);
            double Trosee = this.getSatTemperature(p, 1.0);
            if (T < Tbulle || T > Trosee) {
                double[] devP = this.getDeviations(p / 100000.0, T, this.tbs.fract_mol, this.tbs.k);
                if (this.debug) {
                    System.out.println("Racines de la cubique : ");
                    System.out.println("Zvap " + this.ZZ[0]);
                    System.out.println("Z2 " + this.ZZ[1]);
                    System.out.println("Zliq " + this.ZZ[2]);
                    int n = 4;
                    System.out.println("fugacit\u00e9s : ");
                    System.out.println("h : " + devP[0] + " / s : " + devP[1]);
                    System.out.println("fg1 : " + devP[n] + " / fl1 : " + devP[n + 2]);
                    System.out.println("fg2 : " + devP[n + 1] + " / fl2 : " + devP[n + 3]);
                    System.out.println("Tbulle : " + Tbulle + " / Trosee : " + Trosee);
                }
                double vV = this.ZZ[0] * 8.314472471 * T / p * 100000.0;
                double vL = this.ZZ[2] * 8.314472471 * T / p * 100000.0;
                if (T < Tbulle) {
                    this.tbs.v = vL;
                    h = devP[2];
                    s = devP[3];
                    x = 0.0;
                } else {
                    this.tbs.v = vV;
                    h = devP[0];
                    s = devP[1];
                    x = 1.0;
                }
            } else if (!this.tbs.simplified_ELV_calc) {
                ELVComposition elv = this.flashIsoTherm(p, T);
                double titre = (elv.x[0] - this.tbs.fract_mol[0]) / (elv.x[0] - elv.y[0]);
                double liqM = this.getMixMolarmass(elv.x);
                double vapM = this.getMixMolarmass(elv.y);
                titre = (elv.x[0] * this.tbs.compProp[0].M / liqM - this.tbs.fract_mol[0] * this.tbs.compProp[0].M / this.tbs.mixM) / (elv.x[0] * this.tbs.compProp[0].M / liqM - elv.y[0] * this.tbs.compProp[0].M / vapM);
                h = this.hv * titre + (1.0 - titre) * this.hl;
                s = this.sv * titre + (1.0 - titre) * this.sl;
                x = titre;
                System.out.println("hl : " + this.hl + " / hv : " + this.hv + " / titre : " + titre);
                int i = 0;
                while (i < this.tbs.nbComponents) {
                    res[6 + i] = elv.x[i];
                    res[6 + this.tbs.nbComponents + i] = elv.y[i];
                    ++i;
                }
            } else {
                double[] devPl = this.getDeviations(p / 100000.0, Tbulle - 0.1, this.tbs.fract_mol, this.tbs.k);
                this.tbs.v = this.ZZ[2] * 8.314472471 * T / p * 100000.0;
                this.hl = devPl[2];
                this.sl = devPl[3];
                System.out.println("h devPl[0]: " + devPl[0] + "  devPl[2]: " + devPl[2] + " simplified_ELV_calc liq: " + this.tbs.simplified_ELV_calc);
                double[] devPv = this.getDeviations(p / 100000.0, Trosee + 0.1, this.tbs.fract_mol, this.tbs.k);
                this.tbs.v = this.ZZ[0] * 8.314472471 * T / p * 100000.0;
                System.out.println("h devPv[0]: " + devPv[0] + "  devPv[2]: " + devPv[2] + " simplified_ELV_calc vap: " + this.tbs.simplified_ELV_calc);
                this.hv = devPv[0];
                this.sv = devPv[1];
                h = this.hv * x + (1.0 - x) * this.hl;
                s = this.sv * x + (1.0 - x) * this.sl;
                System.out.println("h: " + h + "  x: " + x + " simplified_ELV_calc cubicEOS: " + this.tbs.simplified_ELV_calc);
            }
            res[0] = h;
            res[1] = this.tbs.v / 100.0 / this.tbs.mixM;
            res[2] = 0.0;
            res[3] = x;
            res[4] = res[0] - (p * res[1] - this.tbs.mixu0) / 100.0;
            res[5] = s;
            return res;
        }
        double P = P_Pa;
        double[] volumes = this.getVlVv(P, T);
        double vV = volumes[1] * 8.314472471 * T / P;
        double vL = volumes[0] * 8.314472471 * T / P;
        if (this.debug) {
            System.out.println("vV : " + vV + "\tvL : " + vL);
        }
        double Psat = 1.0;
        if (T <= this.tbs.mixTc) {
            Psat = this.getSatPressure(T, 0.0);
            if (P > Psat * 1.001) {
                this.tbs.v = vL;
                x = 0.0;
            } else if (P < Psat * 0.999) {
                this.tbs.v = vV;
                x = 1.0;
            } else {
                this.tbs.v = vL + x * (vV - vL);
            }
        } else {
            this.tbs.v = vL;
            x = 0.0;
        }
        this.tbs.Rho = 1.0 / this.tbs.v;
        this.tbs.hSIdeal = new EnthalpieEntropie();
        if (this.debug) {
            System.out.println("compProp[0].codeCp : " + this.tbs.compProp[0].codeCp);
        }
        if (this.tbs.compProp[0].codeCp == 1) {
            this.tbs.hSIdeal.h = this.tbs.compProp[0].h_gaz_mol(T);
            this.tbs.hSIdeal.s = this.tbs.compProp[0].s_gaz_mol(T, P);
        } else {
            String message = "Watch out! the Cp code must be 1\nPlease change your Cp model for " + this.tbs.systemName;
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        if (this.debug) {
            System.out.println("hSIdeal : " + this.tbs.hSIdeal.h + "\tPsat : " + Psat);
        }
        if (this.debug) {
            System.out.println("mixTc : " + this.tbs.mixTc + "\t");
        }
        this.tbs.hSRes = this.getHsResidual(P, T, x, vL, vV, Psat);
        if (this.debug) {
            System.out.println("hSRes : " + this.tbs.hSRes.h + "\t" + "hSRes s : " + this.tbs.hSRes.s);
        }
        this.tbs.hS = new EnthalpieEntropie();
        this.tbs.hS.h = this.tbs.hSIdeal.h + this.tbs.hSRes.h + this.tbs.mixh0;
        this.tbs.hS.s = this.tbs.hSIdeal.s + this.tbs.hSRes.s + this.tbs.mixs0;
        if (this.debug) {
            System.out.print("T : " + T + "\t");
            System.out.print("P : " + P + "\t");
            System.out.print("v : " + this.tbs.v + "\t");
            System.out.print("Rho : " + this.tbs.Rho + "\t");
            System.out.print("x : " + x + "\t");
            System.out.print("h : " + this.tbs.hS.h + "\t");
            System.out.print("s : " + this.tbs.hS.s + "\t");
            System.out.println("h0 " + this.tbs.mixh0 + " s0 " + this.tbs.mixs0);
            System.out.println(" ");
        }
        res[0] = this.tbs.hS.h / this.tbs.mixM;
        res[1] = 1000.0 / this.tbs.Rho / this.tbs.mixM;
        res[2] = 0.0;
        res[3] = x;
        res[4] = res[0] - (P * res[1] - this.tbs.mixu0) / 100.0;
        res[5] = this.tbs.hS.s / this.tbs.mixM;
        return res;
    }

    public double getSatTemperature(double P, double x) {
        if (this.tbs.nbComponents > 1) {
            try {
                if (x == 0.0) {
                    this.bubblePointT(this.tbs.fract_mol, P / 100000.0, this.tbs.k);
                } else if (x == 1.0) {
                    this.dewPointT(this.tbs.fract_mol, P / 100000.0, this.tbs.k);
                } else {
                    String message = "Watch out! the quality must be 0 or 1";
                    JOptionPane.showMessageDialog(new JFrame(), message);
                }
            }
            catch (MonoPhaseException e) {
                e.printStackTrace();
            }
            return this.tbs.Tparam;
        }
        return this.getFugacityEquality("Tsat", P, 0);
    }

    public double getSatPressure(double T, double x) {
        if (this.tbs.nbComponents > 1) {
            try {
                if (x == 0.0) {
                    this.bubblePointP(this.tbs.fract_mol, T, this.tbs.k);
                } else if (x == 1.0) {
                    this.dewPointP(this.tbs.fract_mol, T, this.tbs.k);
                } else {
                    String message = "Watch out! the quality must be 0 or 1";
                    JOptionPane.showMessageDialog(new JFrame(), message);
                }
            }
            catch (MonoPhaseException e) {
                e.printStackTrace();
            }
            return this.tbs.Pparam * 100000.0;
        }
        double Psat = this.getFugacityEquality("Psat", T, 0);
        return Psat;
    }

    public void calcMixProps() {
        this.mixa = 0.0;
        this.mixaref = 0.0;
        this.mixdadt = 0.0;
        this.mixac = 0.0;
        this.mixb = 0.0;
        this.mixalpha = 0.0;
        this.mixalpharef = 0.0;
        this.mixc1 = 0.0;
        this.mixc2 = 0.0;
        this.mixc3 = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.mixa += this.cubicCompProp[i].a * this.tbs.fract_mol[i];
            this.mixaref += this.cubicCompProp[i].aref * this.tbs.fract_mol[i];
            this.mixdadt += this.cubicCompProp[i].dadt * this.tbs.fract_mol[i];
            this.mixac += this.cubicCompProp[i].ac * this.tbs.fract_mol[i];
            this.mixb += this.cubicCompProp[i].b * this.tbs.fract_mol[i];
            this.mixalpha += this.cubicCompProp[i].alpha * this.tbs.fract_mol[i];
            this.mixalpharef += this.cubicCompProp[i].alpharef * this.tbs.fract_mol[i];
            this.mixc1 += this.cubicCompProp[i].c1 * this.tbs.fract_mol[i];
            this.mixc2 += this.cubicCompProp[i].c2 * this.tbs.fract_mol[i];
            this.mixc3 += this.cubicCompProp[i].c3 * this.tbs.fract_mol[i];
            ++i;
        }
    }

    public ResultatCardan cubique(double a, double b, double c, double d) {
        ResultatCardan resultat = new ResultatCardan();
        double p = c / a - Math.pow(b, 2.0) / (3.0 * Math.pow(a, 2.0));
        double q = 2.0 * Math.pow(b, 3.0) / (27.0 * Math.pow(a, 3.0)) - b * c / (3.0 * Math.pow(a, 2.0)) + d / a;
        double gDelta = 4.0 * Math.pow(p, 3.0) + 27.0 * Math.pow(q, 2.0);
        double m = -q / 2.0 + 0.5 * Math.sqrt(gDelta / 27.0);
        double n = -q / 2.0 - 0.5 * Math.sqrt(gDelta / 27.0);
        double u = Math.pow(Math.abs(m), 0.3333333333333333);
        double v = Math.pow(Math.abs(n), 0.3333333333333333);
        if (gDelta > 0.0) {
            if (m < 0.0) {
                u = -u;
            }
            if (n < 0.0) {
                v = -v;
            }
            double x = u + v;
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = x;
            return resultat;
        }
        if (gDelta == 0.0) {
            if (b == 0.0 & c == 0.0 && d == 0.0) {
                resultat.ZL = 0.0;
                resultat.ZI = 0.0;
                resultat.ZV = 0.0;
                return resultat;
            }
            double x = 3.0 * q / p;
            double y = -3.0 * q / (2.0 * p);
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = y += -b / (3.0 * a);
            return resultat;
        }
        double k = 3.0 * q / (2.0 * p * Math.sqrt(-p / 3.0));
        double theta = Math.acos(k);
        double x = 2.0 * Math.sqrt(-p / 3.0) * Math.cos(theta / 3.0);
        double y = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 2) / 3.0);
        double z = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 4) / 3.0);
        resultat.ZV = x += -b / (3.0 * a);
        resultat.ZI = z += -b / (3.0 * a);
        resultat.ZL = y += -b / (3.0 * a);
        return resultat;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        double PP = 1.0;
        double TT = 300.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("sumy")) {
            TT = this.tbs.Tparam;
            PP = x[1];
            fvec[1] = this.sumy(TT, PP);
            this.callFunction = "sumy";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.tbs.Pparam = x[1];
        }
        if (this.callFunction.equals("sumx")) {
            TT = this.tbs.Tparam;
            PP = x[1];
            fvec[1] = this.sumx(TT, PP);
            this.callFunction = "sumx";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.tbs.Pparam = x[1];
        }
        if (this.callFunction.equals("sumyP")) {
            PP = this.tbs.Pparam;
            TT = x[1];
            fvec[1] = this.sumy(TT, PP);
            this.callFunction = "sumyP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.tbs.Tparam = x[1];
        }
        if (this.callFunction.equals("sumxP")) {
            PP = this.tbs.Pparam;
            TT = x[1];
            fvec[1] = this.sumx(TT, PP);
            this.callFunction = "sumxP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            this.tbs.Tparam = x[1];
        }
        if (this.callFunction.equals("liqsplit")) {
            fvec[1] = this.liqSplit(x[1]);
            this.callFunction = "liqsplit";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1] + "  Pparam: " + this.tbs.Pparam);
            }
        }
        if (this.callFunction.equals("Tsat")) {
            TT = x[1];
            PP = this.tbs.Pparam;
            fvec[1] = this.getFugacityResidual(PP, TT, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("Psat")) {
            PP = x[1];
            TT = this.tbs.Tparam;
            fvec[1] = this.getFugacityResidual(PP, TT, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    protected double $AA(double am, double p, double T) {
        return am * p / 69.13045247101685 / (T * T);
    }

    protected double $BB(double bm, double p, double T) {
        return bm * p / 8.314472471 / T;
    }

    protected double getFugacityEquality(String callFunction, double param, int i) {
        double PP;
        double TT;
        double[] init = new double[2];
        this.callFunction = callFunction;
        if (callFunction.equals("Psat")) {
            TT = this.tbs.Tparam = param;
            if (this.tbs.compProp[i].codePsat == 1) {
                init[1] = PP = this.tbs.compProp[i].psat_T(this.tbs.Tparam);
            } else {
                this.tbs.Tr = this.tbs.Tparam / this.tbs.compProp[0].Tc;
                double INT = 5.92714 - 6.09648 / this.tbs.Tr - 1.28862 * Math.log(this.tbs.Tr) + 0.169347 * Math.pow(this.tbs.Tr, 6.0) + this.tbs.compProp[i].omega * (15.2518 - 15.6875 / this.tbs.Tr - 13.4721 * Math.log(this.tbs.Tr) + 0.43577 * Math.pow(this.tbs.Tr, 6.0));
                init[1] = PP = Math.exp(INT) * this.tbs.compProp[i].Pc;
            }
        }
        if (callFunction.equals("Tsat")) {
            PP = this.tbs.Pparam = param;
            init[1] = TT = this.tbs.compProp[i].Tsat_P(this.tbs.Pparam);
        }
        double[] result = this.solveWithMinPack(1, callFunction, init, 1.0E-6);
        return result[1];
    }

    protected void bubblePointT(double[] z, double P_bar, double[][] k) throws MonoPhaseException {
        double P = P_bar;
        this.tbs.nbComponents = z.length;
        this.tbs.k = k;
        this.tbs.yy = new double[this.tbs.nbComponents];
        this.tbs.xx = new double[this.tbs.nbComponents];
        this.tbs.zz = new double[this.tbs.nbComponents];
        double[] K = new double[this.tbs.nbComponents];
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double Tbulle = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            Tbulle += this.tbs.compProp[i].Tsat_P(P * 100000.0);
            this.tbs.yy[i] = z[i];
            this.tbs.zz[i] = z[i];
            ++i;
        }
        double[] init = new double[2];
        this.tbs.Pparam = P;
        this.tbs.Tparam = Tbulle /= (double)this.tbs.nbComponents;
        this.callFunction = "sumyP";
        init[1] = this.tbs.Tparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.tbs.Tparam = Tbulle = result[1];
        if (Tbulle == 0.0) {
            throw new MonoPhaseException("bubblePoint");
        }
        double[] devP = this.getDeviations(P, Tbulle, this.tbs.zz, k);
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.tbs.nbComponents];
            ++i2;
        }
        devP = this.getDeviations(P, Tbulle, this.tbs.yy, k);
        i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            K[i2] = this.tbs.yy[i2] / this.tbs.zz[i2];
            this.tbs.xx[i2] = this.tbs.zz[i2];
            ++i2;
        }
        this.hl = devP[2];
        this.sl = devP[3];
        this.Vl = this.ZZ[2] * 8.314472471 * Tbulle / P;
    }

    protected void dewPointT(double[] z, double P_bar, double[][] k) throws MonoPhaseException {
        double P = P_bar;
        this.tbs.nbComponents = z.length;
        this.tbs.k = k;
        double[] K = new double[this.tbs.nbComponents];
        this.tbs.xx = new double[this.tbs.nbComponents];
        this.tbs.yy = new double[this.tbs.nbComponents];
        this.tbs.zz = new double[this.tbs.nbComponents];
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double Trosee = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            Trosee += this.tbs.compProp[i].Tsat_P(P * 100000.0);
            this.tbs.xx[i] = z[i];
            this.tbs.zz[i] = z[i];
            ++i;
        }
        double[] init = new double[2];
        this.tbs.Pparam = P;
        this.tbs.Tparam = Trosee /= (double)this.tbs.nbComponents;
        this.callFunction = "sumxP";
        init[1] = this.tbs.Tparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.tbs.Tparam = Trosee = result[1];
        double[] devP = this.getDeviations(P, Trosee, this.tbs.zz, k);
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            ++i2;
        }
        devP = this.getDeviations(P, Trosee, this.tbs.xx, k);
        i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.tbs.nbComponents];
            K[i2] = this.tbs.zz[i2] / this.tbs.xx[i2];
            this.tbs.yy[i2] = this.tbs.xx[i2] * K[i2];
            ++i2;
        }
        this.hv = devP[0];
        this.sv = devP[1];
        this.Vv = this.ZZ[0] * 8.314472471 * Trosee / P;
    }

    protected void bubblePointP(double[] z, double T, double[][] k) throws MonoPhaseException {
        this.tbs.nbComponents = z.length;
        this.tbs.k = k;
        double[] PS = new double[this.tbs.nbComponents];
        double[] K = new double[this.tbs.nbComponents];
        this.tbs.yy = new double[this.tbs.nbComponents];
        this.tbs.xx = new double[this.tbs.nbComponents];
        this.tbs.zz = new double[this.tbs.nbComponents];
        this.tbs.xx = z;
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double P = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            if (this.tbs.compProp[i].codePsat == 1) {
                PS[i] = this.tbs.compProp[i].psat_T(T) / 100000.0;
            } else {
                double INT = 5.92714 - 6.09648 / (T / this.tbs.compProp[i].Tc) - 1.28862 * Math.log(T / this.tbs.compProp[i].Tc) + 0.169347 * Math.pow(T / this.tbs.compProp[i].Tc, 6.0) + this.tbs.compProp[i].omega * (15.2518 - 15.6875 / (T / this.tbs.compProp[i].Tc) - 13.4721 * Math.log(T / this.tbs.compProp[i].Tc) + 0.43577 * Math.pow(T / this.tbs.compProp[i].Tc, 6.0));
                PS[i] = Math.exp(INT) * this.tbs.compProp[i].Pc / 100000.0;
            }
            if (PS[i] > this.tbs.compProp[i].Pc / 100000.0) {
                PS[i] = this.tbs.compProp[i].Pc / 100000.0;
            }
            P += z[i] * PS[i];
            this.tbs.zz[i] = z[i];
            ++i;
        }
        i = 0;
        while (i < this.tbs.nbComponents) {
            K[i] = PS[i] / P;
            this.tbs.yy[i] = K[i] * this.tbs.zz[i];
            ++i;
        }
        double[] init = new double[2];
        this.tbs.Pparam = P;
        this.tbs.Tparam = T;
        this.callFunction = "sumy";
        init[1] = this.tbs.Pparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.tbs.Pparam = P = result[1];
        if (P == 0.0) {
            throw new MonoPhaseException("bubblePoint");
        }
        double[] devP = this.getDeviations(P, T, this.tbs.zz, k);
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.tbs.nbComponents];
            ++i2;
        }
        devP = this.getDeviations(P, T, this.tbs.yy, k);
        i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            K[i2] = this.tbs.yy[i2] / this.tbs.zz[i2];
            this.tbs.xx[i2] = this.tbs.zz[i2];
            ++i2;
        }
        this.hl = devP[2];
        this.sl = devP[3];
        this.Vl = this.ZZ[2] * 8.314472471 * T / P;
    }

    protected void dewPointP(double[] z, double T, double[][] k) throws MonoPhaseException {
        this.tbs.nbComponents = z.length;
        this.tbs.k = k;
        double[] PS = new double[this.tbs.nbComponents];
        double[] K = new double[this.tbs.nbComponents];
        this.tbs.xx = new double[this.tbs.nbComponents];
        this.tbs.yy = new double[this.tbs.nbComponents];
        this.tbs.zz = new double[this.tbs.nbComponents];
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double P = 0.0;
        double sp = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            if (this.tbs.compProp[i].codePsat == 1) {
                PS[i] = this.tbs.compProp[i].psat_T(T) / 100000.0;
            } else {
                double INT = 5.92714 - 6.09648 / (T / this.tbs.compProp[i].Tc) - 1.28862 * Math.log(T / this.tbs.compProp[i].Tc) + 0.169347 * Math.pow(T / this.tbs.compProp[i].Tc, 6.0) + this.tbs.compProp[i].omega * (15.2518 - 15.6875 / (T / this.tbs.compProp[i].Tc) - 13.4721 * Math.log(T / this.tbs.compProp[i].Tc) + 0.43577 * Math.pow(T / this.tbs.compProp[i].Tc, 6.0));
                PS[i] = Math.exp(INT) * this.tbs.compProp[i].Pc / 100000.0;
            }
            if (PS[i] > this.tbs.compProp[i].Pc / 100000.0) {
                PS[i] = this.tbs.compProp[i].Pc / 100000.0;
            }
            sp += z[i] / PS[i];
            this.tbs.zz[i] = z[i];
            ++i;
        }
        P = 1.0 / sp;
        i = 0;
        while (i < this.tbs.nbComponents) {
            K[i] = PS[i] / P;
            this.tbs.xx[i] = z[i] / K[i];
            ++i;
        }
        double[] init = new double[2];
        this.tbs.Pparam = P;
        this.tbs.Tparam = T;
        this.callFunction = "sumx";
        init[1] = this.tbs.Pparam;
        double[] result = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        this.tbs.Pparam = P = result[1];
        if (P == 0.0) {
            throw new MonoPhaseException("dewPoint");
        }
        double[] devP = this.getDeviations(P, T, this.tbs.zz, k);
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugv[i2] = devP[i2 + 4];
            ++i2;
        }
        devP = this.getDeviations(P, T, this.tbs.xx, k);
        i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            fugl[i2] = devP[i2 + 4 + this.tbs.nbComponents];
            K[i2] = this.tbs.zz[i2] / this.tbs.xx[i2];
            this.tbs.yy[i2] = this.tbs.xx[i2] * K[i2];
            ++i2;
        }
        this.hv = devP[0];
        this.sv = devP[1];
        this.Vv = this.ZZ[0] * 8.314472471 * T / P;
    }

    protected ELVComposition flashIsoTherm(double P_Pa, double T) {
        this.tbs.nbComponents = this.tbs.zz.length;
        ELVComposition elv = new ELVComposition(this.tbs.nbComponents);
        this.tbs.zz = this.tbs.fract_mol;
        double[] PS = new double[this.tbs.nbComponents];
        double[] y = new double[this.tbs.nbComponents];
        double[] x = new double[this.tbs.nbComponents];
        this.tbs.KK = new double[this.tbs.nbComponents];
        double[] DZ = new double[this.tbs.nbComponents];
        double[] Delta = new double[this.tbs.nbComponents];
        double P = P_Pa / 100000.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            double INT = 5.92714 - 6.09648 / (this.tbs.Tparam / this.tbs.compProp[i].Tc) - 1.28862 * Math.log(this.tbs.Tparam / this.tbs.compProp[i].Tc) + 0.169347 * Math.pow(this.tbs.Tparam / this.tbs.compProp[i].Tc, 6.0) + this.tbs.compProp[i].omega * (15.2518 - 15.6875 / (this.tbs.Tparam / this.tbs.compProp[i].Tc) - 13.4721 * Math.log(this.tbs.Tparam / this.tbs.compProp[i].Tc) + 0.43577 * Math.pow(this.tbs.Tparam / this.tbs.compProp[i].Tc, 6.0));
            PS[i] = Math.exp(INT) * this.tbs.compProp[i].Pc / 100000.0;
            if (PS[i] > this.tbs.compProp[i].Pc / 100000.0) {
                PS[i] = this.tbs.compProp[i].Pc / 100000.0;
            }
            ++i;
        }
        double L = 0.5;
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            this.tbs.KK[i2] = PS[i2] / P;
            x[i2] = this.tbs.zz[i2] / (L + this.tbs.KK[i2] * (1.0 - L));
            y[i2] = this.tbs.KK[i2] * x[i2];
            ++i2;
        }
        double sx = 0.0;
        double sy = 0.0;
        int i3 = 0;
        while (i3 < this.tbs.nbComponents) {
            sx += x[i3];
            sy += y[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < this.tbs.nbComponents) {
            x[i3] = x[i3] / sx;
            y[i3] = y[i3] / sy;
            if (this.debug) {
                System.out.println("flash : x " + x[i3] + " y " + y[i3] + "  KK " + this.tbs.KK[i3] + "  PS " + PS[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.tbs.nbComponents) {
            DZ[i3] = this.tbs.KK[i3];
            ++i3;
        }
        int k = 0;
        while (k < 10) {
            elv = this.eLVComp(P, T);
            double sum = 0.0;
            int i4 = 0;
            while (i4 < this.tbs.nbComponents) {
                Delta[i4] = elv.fugLiq[i4] / elv.fugVap[i4];
                DZ[i4] = DZ[i4] * Delta[i4];
                sum += Math.abs(1.0 - Delta[i4]);
                ++i4;
            }
            if (this.debug) {
                System.out.println(" somme rapport fugacit\u00e9s " + sum);
            }
            if (sum < 1.0E-6) break;
            i4 = 0;
            while (i4 < this.tbs.nbComponents) {
                this.tbs.KK[i4] = DZ[i4];
                ++i4;
            }
            if (this.debug) {
                System.out.println("\n k " + k + "\n " + " elv.L " + elv.L);
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.x " + elv.x[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.y " + elv.y[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.fugLiq " + elv.fugLiq[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < elv.fugLiq.length) {
                    System.out.println(" i " + i4 + " elv.fugVap " + elv.fugVap[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < this.tbs.nbComponents) {
                    System.out.println("KK " + this.tbs.KK[i4]);
                    ++i4;
                }
            }
            ++k;
        }
        return elv;
    }

    protected ELVComposition eLVComp(double P_bar, double T) {
        double LL0;
        ELVComposition elv = new ELVComposition(this.tbs.nbComponents);
        double[] x = new double[this.tbs.nbComponents];
        double[] y = new double[this.tbs.nbComponents];
        this.tbs.zz = this.tbs.fract_mol;
        this.callFunction = "liqsplit";
        double[] init = new double[2];
        init[1] = 0.5;
        double[] res = this.solveWithMinPack(1, this.callFunction, init, this.epsiMinpack);
        elv.L = LL0 = res[1];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            elv.x[i] = this.tbs.zz[i] / (LL0 + this.tbs.KK[i] * (1.0 - LL0));
            x[i] = elv.x[i];
            elv.y[i] = x[i] * this.tbs.KK[i];
            y[i] = elv.y[i];
            ++i;
        }
        double[] ZZ = this.getDeviations(P_bar, T, x, this.tbs.k);
        int i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            elv.fugLiq[i2] = ZZ[i2 + 4 + this.tbs.nbComponents];
            ++i2;
        }
        ZZ = this.getDeviations(P_bar, T, y, this.tbs.k);
        i2 = 0;
        while (i2 < this.tbs.nbComponents) {
            elv.fugVap[i2] = ZZ[i2 + 4];
            ++i2;
        }
        return elv;
    }

    protected CubicModel getCubicModel(int n, FluidModel fluidModel) {
        CubicModel cm = null;
        switch (n) {
            case 0: {
                cm = new VanDerWaals(fluidModel);
                break;
            }
            case 1: {
                cm = new SRK(fluidModel);
                break;
            }
            case 2: {
                cm = new PengRobinson(fluidModel);
                break;
            }
            case 3: {
                cm = new PatelTeja(fluidModel);
                break;
            }
            case 4: {
                cm = new HarmensKnapp(fluidModel);
                break;
            }
            case 5: {
                cm = new SRKControle(fluidModel);
            }
        }
        return cm;
    }

    protected AlphaFunction getAlphaFunction(int n) {
        AlphaFunction af = null;
        switch (n) {
            case 0: {
                af = new Soave(this);
                break;
            }
            case 1: {
                af = new GeneraliseeSRK(this);
                break;
            }
            case 2: {
                af = new GeneraliseePR(this);
                break;
            }
            case 3: {
                af = new Daridon(this);
                break;
            }
            case 4: {
                af = new TwuSRK(this);
                break;
            }
            case 5: {
                af = new TwuPR(this);
                break;
            }
            case 6: {
                af = new StryjeckVera(this);
                break;
            }
            case 7: {
                af = new MathiasCopeman(this);
            }
        }
        return af;
    }

    protected double[] ai(double T) {
        int nbComponents = this.tbs.compProp.length;
        double[] Zc = new double[nbComponents];
        double[] $a = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            double $Tr = T / this.tbs.compProp[i].Tc;
            Alphas alphas = null;
            Zc[i] = 0.329032 - 0.076799 * this.tbs.compProp[i].omega + 0.0211947 * this.tbs.compProp[i].omega * this.tbs.compProp[i].omega;
            GeneralizedCubicEOSparameters mod = this.cubicModel.modeleUtilise(this.tbs.compProp[i].Tc, this.tbs.compProp[i].Pc, Zc[i]);
            alphas = this.alphaFunction.alphaUtilise(this.tbs.compProp[i].omega, $Tr, this.cubicCompProp[i].c1, this.cubicCompProp[i].c2, this.cubicCompProp[i].c3);
            double $a0 = mod.omegaa * this.PaToBar * 69.13045247101685 * (this.tbs.compProp[i].Tc * this.tbs.compProp[i].Tc) / this.tbs.compProp[i].Pc;
            double $fw = 0.37464 + 1.54226 * this.tbs.compProp[i].omega - 0.26992 * (this.tbs.compProp[i].omega * this.tbs.compProp[i].omega);
            double $lambda = (1.0 + $fw * (1.0 - Math.pow($Tr, 0.5))) * (1.0 + $fw * (1.0 - Math.pow($Tr, 0.5)));
            $a[i] = $a0 * $lambda;
            ++i;
        }
        return $a;
    }

    protected double[] bi(double T) {
        int nbComponents = this.tbs.compProp.length;
        double[] $b = new double[nbComponents];
        double[] Zc = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            Zc[i] = 0.329032 - 0.076799 * this.tbs.compProp[i].omega + 0.0211947 * this.tbs.compProp[i].omega * this.tbs.compProp[i].omega;
            this.mod = this.cubicModel.modeleUtilise(this.tbs.compProp[i].Tc, this.tbs.compProp[i].Pc, Zc[i]);
            $b[i] = this.mod.omegab * this.fact2 * 8.314472471 * this.tbs.compProp[i].Tc / this.tbs.compProp[i].Pc;
            ++i;
        }
        return $b;
    }

    protected double amix(double[] x, double[] a, double[][] k) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            int j = 0;
            while (j < nbComponents) {
                am += x[i] * x[j] * Math.pow(a[i] * a[j], 0.5) * (1.0 - k[i][j]);
                ++j;
            }
            ++i;
        }
        return am;
    }

    protected double bmix(double[] x, double[] b) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            am += x[i] * b[i];
            ++i;
        }
        return am;
    }

    protected double saxi(double[] x, double[] a, int i, double[][] k) {
        int nbComponents = x.length;
        double ai = a[i];
        double am = 0.0;
        int j = 0;
        while (j < nbComponents) {
            am += x[j] * Math.pow(a[j] * ai, 0.5) * (1.0 - k[i][j]);
            ++j;
        }
        return am;
    }

    protected double[] dai(double T) {
        int nbComponents = this.tbs.compProp.length;
        double[] Zc = new double[nbComponents];
        double[] $a = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            double $Tr = T / this.tbs.compProp[i].Tc;
            Zc[i] = 0.329032 - 0.076799 * this.tbs.compProp[i].omega + 0.0211947 * this.tbs.compProp[i].omega * this.tbs.compProp[i].omega;
            GeneralizedCubicEOSparameters mod = this.cubicModel.modeleUtilise(this.tbs.compProp[i].Tc, this.tbs.compProp[i].Pc, Zc[i]);
            Alphas alphas = this.alphaFunction.alphaUtilise(this.tbs.compProp[i].omega, $Tr, this.cubicCompProp[i].c1, this.cubicCompProp[i].c2, this.cubicCompProp[i].c3);
            double $a0 = mod.omegaa * 69.13045247101685 * (this.tbs.compProp[i].Tc * this.tbs.compProp[i].Tc) / this.tbs.compProp[i].Pc * this.PaToBar;
            double $fw = 0.37464 + 1.54226 * this.tbs.compProp[i].omega - 0.26992 * (this.tbs.compProp[i].omega * this.tbs.compProp[i].omega);
            double $mu = ($fw * $fw - $fw * (1.0 + $fw) / Math.pow($Tr, 0.5)) / this.tbs.compProp[i].Tc;
            $a[i] = $a0 * $mu;
            ++i;
        }
        return $a;
    }

    protected double damix(double[] x, double[] a, double[] da, double[][] k) {
        int nbComponents = x.length;
        double am = 0.0;
        int i = 0;
        while (i < nbComponents) {
            int j = 0;
            while (j < nbComponents) {
                am += x[i] * x[j] / 2.0 / Math.pow(a[i] * a[j], 0.5) * (a[j] * da[i] + a[i] * da[j]) * (1.0 - k[i][j]);
                ++j;
            }
            ++i;
        }
        return am;
    }

    protected SolutionR r1r2(double u, double w) {
        SolutionR solR = new SolutionR();
        solR.r1 = (-u + Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        solR.r2 = (-u - Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        return solR;
    }

    protected EnthalpieEntropie mThs(int ii, int nbtrapezes, double x1, double x2, double P) {
        CpGeneralisee f1 = new CpGeneralisee();
        CpGeneralisee f2 = new CpGeneralisee();
        EnthalpieEntropie hs = new EnthalpieEntropie();
        double pas = (x2 - x1) / (double)nbtrapezes;
        double aireh = 0.0;
        double aires = 0.0;
        int i = 0;
        while (i < nbtrapezes) {
            double borneinf = x1 + (double)i * pas;
            double bornesup = borneinf + pas;
            f1.Cp = (this.tbs.compProp[ii].A + this.tbs.compProp[ii].B * Math.pow(this.tbs.compProp[ii].C / borneinf / this.sinh(this.tbs.compProp[ii].C / borneinf), 2.0) + this.tbs.compProp[ii].D * Math.pow(this.tbs.compProp[ii].E / borneinf / this.cosh(this.tbs.compProp[ii].E / borneinf), 2.0)) / 1000.0;
            f2.Cp = (this.tbs.compProp[ii].A + this.tbs.compProp[ii].B * Math.pow(this.tbs.compProp[ii].C / bornesup / this.sinh(this.tbs.compProp[ii].C / bornesup), 2.0) + this.tbs.compProp[ii].D * Math.pow(this.tbs.compProp[ii].E / bornesup / this.cosh(this.tbs.compProp[ii].E / bornesup), 2.0)) / 1000.0;
            f1.CpT = f1.Cp / borneinf;
            f2.CpT = f2.Cp / bornesup;
            aireh += pas * (f1.Cp + f2.Cp) / 2.0;
            aires += pas * (f1.CpT + f2.CpT) / 2.0;
            ++i;
        }
        hs.h = aireh;
        hs.s = aires - 8.314472471 * Math.log(P);
        return hs;
    }

    protected double[] getVlVv(double P, double T) {
        double[] res = new double[3];
        this.mod = this.cubicModel.modeleUtilise(this.tbs.mixTc, this.tbs.mixPc, this.tbs.mixZc);
        this.tbs.solR = this.r1r2(this.mod.u, this.mod.w);
        this.mixb = this.mod.omegab * 8.314472471 * this.tbs.mixTc / this.tbs.mixPc;
        this.tbs.Tr = T / this.tbs.mixTc;
        this.tbs.Trref = this.tbs.mixTref / this.tbs.mixTc;
        this.mixac = this.mod.omegaa * Math.pow(8.314472471, 2.0) * Math.pow(this.tbs.mixTc, 2.0) / this.tbs.mixPc;
        this.fonctionalphas = this.alphaFunction.alphaUtilise(this.tbs.mixomega, this.tbs.Tr, this.mixc1, this.mixc2, this.mixc3);
        this.mixalpha = this.fonctionalphas.alpha;
        this.mixa = this.mixac * this.mixalpha;
        this.mixdadt = this.mixac * this.fonctionalphas.dalpha;
        this.tbs.equationdEtat = this.equationdEtat(P, T, this.mod.u, this.mod.w, this.mixa, this.mixb);
        ResultatCardan resultat = this.cubique(this.tbs.equationdEtat.A, this.tbs.equationdEtat.B, this.tbs.equationdEtat.C, this.tbs.equationdEtat.D);
        res[0] = resultat.ZL;
        res[1] = resultat.ZV;
        return res;
    }

    protected EnthalpieEntropie getHsResidual(double P, double T, double x, double vL, double vV, double Psat) {
        EnthalpieEntropie hSRes = new EnthalpieEntropie();
        if (T <= this.tbs.mixTc && Psat * 0.999 < P && P < Psat * 1.001) {
            if (this.tbs.debug) {
                System.out.println("solR.r1 : " + this.tbs.solR.r1 + "\t");
            }
            double hl = P * vL - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((vL - this.mixb * this.tbs.solR.r1) / (vL - this.mixb * this.tbs.solR.r2));
            double hv = P * vV - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((vV - this.mixb * this.tbs.solR.r1) / (vV - this.mixb * this.tbs.solR.r2));
            hSRes.h = hl + x * (hv - hl);
            double sl = 8.314472471 * Math.log((vL - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((vL - this.mixb * this.tbs.solR.r1) / (vL - this.mixb * this.tbs.solR.r2)) + 8.314472471 * Math.log(this.tbs.mixPref);
            double sv = 8.314472471 * Math.log((vV - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((vV - this.mixb * this.tbs.solR.r1) / (vV - this.mixb * this.tbs.solR.r2)) + 8.314472471 * Math.log(this.tbs.mixPref);
            hSRes.s = sl + x * (sv - sl);
        } else {
            hSRes.h = P * this.tbs.v - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((this.tbs.v - this.mixb * this.tbs.solR.r1) / (this.tbs.v - this.mixb * this.tbs.solR.r2));
            hSRes.s = 8.314472471 * Math.log((this.tbs.v - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.tbs.solR.r1 - this.tbs.solR.r2)) * Math.log((this.tbs.v - this.mixb * this.tbs.solR.r1) / (this.tbs.v - this.mixb * this.tbs.solR.r2)) + 8.314472471 * Math.log(this.tbs.mixPref);
        }
        return hSRes;
    }

    protected double[] getDeviations(double P_bar, double T, double[] fractmol, double[][] k) {
        double p = P_bar;
        int nbComponents = fractmol.length;
        double[] $a1 = this.ai(T);
        double[] $b1 = this.bi(T);
        double[] $da1 = this.dai(T);
        double[] $saxi = new double[nbComponents];
        int i = 0;
        while (i < nbComponents) {
            $saxi[i] = this.saxi(fractmol, $a1, i, k);
            ++i;
        }
        double[] dev = new double[2 * nbComponents + 4];
        this.am1 = this.amix(fractmol, $a1, k);
        this.bm1 = this.bmix(fractmol, $b1);
        double dam1 = this.damix(fractmol, $a1, $da1, k);
        double $A1 = this.$AA(this.am1, p, T);
        double $B1 = this.$BB(this.bm1, p, T);
        this.ZZ = this.ZPeng($A1, $B1);
        this.tbs.solR = this.r1r2(this.mod.u, this.mod.w);
        int ii = 0;
        int jj = 0;
        while (jj < 2) {
            ii = jj * 2;
            double $Ds1 = 8.314472471 * Math.log(this.ZZ[ii] - $B1);
            double $g = (this.ZZ[ii] - $B1 * this.tbs.solR.r1) / (this.ZZ[ii] - $B1 * this.tbs.solR.r2);
            double $Ds2 = -dam1 / this.bm1 / (this.tbs.solR.r1 - this.tbs.solR.r2) * Math.log($g);
            double $Ds = $Ds1 + $Ds2;
            double $Dh1 = 8.314472471 * T * (this.ZZ[ii] - 1.0);
            double $Dh2 = 0.0;
            double $Dh3 = -(dam1 * T - this.am1) / (this.tbs.solR.r1 - this.tbs.solR.r2) / this.bm1 * Math.log($g);
            double $Dh = $Dh1 + $Dh2 + $Dh3;
            double hid = 0.0;
            double sid = 0.0;
            double Mvap = 0.0;
            int i2 = 0;
            while (i2 < nbComponents) {
                double $Df1 = $b1[i2] / this.bm1 * (this.ZZ[ii] - 1.0) - Math.log(this.ZZ[ii] - $B1);
                double $Df2 = $A1 / $B1 / (this.tbs.solR.r1 - this.tbs.solR.r2) * Math.log($g) * (2.0 * $saxi[i2] / this.am1 - $b1[i2] / this.bm1);
                double $Df = $Df1 + $Df2;
                dev[4 + i2 + nbComponents * jj] = $Df = p * fractmol[i2] * Math.exp($Df);
                if (this.tbs.compProp[i2].codeCp == 1) {
                    hid += fractmol[i2] * (this.tbs.compProp[i2].h_gaz_mol(T) / this.tbs.compProp[i2].M + this.tbs.compProp[i2].h0);
                    sid += fractmol[i2] * (this.tbs.compProp[i2].s_gaz_mol(T, p) / this.tbs.compProp[i2].M + this.tbs.compProp[i2].s0);
                } else {
                    this.tbs.hSIdeal = new EnthalpieEntropie();
                    double p_pascal = p;
                    this.tbs.hSIdeal = this.mThs(i2, 200, this.tbs.compProp[i2].Tref, T, p_pascal);
                    hid += fractmol[i2] * (this.tbs.hSIdeal.h / this.tbs.compProp[i2].M + this.tbs.compProp[i2].h0);
                    sid += fractmol[i2] * (this.tbs.hSIdeal.s / this.tbs.compProp[i2].M + this.tbs.compProp[i2].s0);
                }
                Mvap += fractmol[i2] * this.tbs.compProp[i2].M;
                ++i2;
            }
            dev[ii] = $Dh / Mvap + hid;
            dev[ii + 1] = $Ds / Mvap + sid;
            ++jj;
        }
        return dev;
    }

    protected double[] ZPeng(double $AA, double $BB) {
        double $b0 = $BB - 1.0;
        double $c0 = $AA - 3.0 * ($BB * $BB) - 2.0 * $BB;
        double $d0 = -$AA * $BB + $BB * $BB + $BB * $BB * $BB;
        double $mm = (3.0 * $c0 - $b0 * $b0) / 9.0;
        double $n = -(0.07407407407407407 * $b0 * $b0 * $b0 - $b0 * $c0 / 3.0 + $d0) / 2.0;
        double $m2 = Math.abs($mm);
        double $d = $mm * $mm * $mm + $n * $n;
        double[] Z = new double[3];
        if ($d < 0.0) {
            double $phi;
            double $rr = Math.pow($m2, 0.5);
            double $cosf = $n / ($rr * $rr * $rr);
            double $sinf = $cosf != 1.0 ? Math.pow(1.0 - $cosf * $cosf, 0.5) : 0.0;
            if ($cosf != 0.0) {
                double $tanf = $sinf / $cosf;
                $phi = Math.atan($tanf);
            } else {
                $phi = PI / 2.0;
            }
            double $teta = $phi;
            Z[0] = 2.0 * $rr * Math.cos($teta / 3.0) - $b0 / 3.0;
            Z[1] = 2.0 * $rr * Math.cos($teta / 3.0 + 4.0 * PI / 3.0) - $b0 / 3.0;
            Z[2] = 2.0 * $rr * Math.cos($teta / 3.0 + 8.0 * PI / 3.0) - $b0 / 3.0;
        } else if ($d == 0.0) {
            double $s = Math.pow($n, 0.3333333333333333);
            Z[0] = 2.0 * $s - $b0 / 3.0;
            Z[1] = -$s - $b0 / 3.0;
            Z[2] = -$s - $b0 / 3.0;
        } else {
            double $dum = $n + ($d = Math.pow($d, 0.5));
            double $s = $dum >= 0.0 ? Math.pow($dum, 0.3333333333333333) : -Math.pow(-$dum, 0.3333333333333333);
            $dum = $n - $d;
            double $t = $dum >= 0.0 ? Math.pow($dum, 0.3333333333333333) : -Math.pow(-$dum, 0.3333333333333333);
            Z[0] = $s + $t - $b0 / 3.0;
            Z[1] = Z[0];
            Z[2] = Z[0];
        }
        double[] Zs = new double[3];
        Vector<String> vZ = new Vector<String>();
        int k = 0;
        while (k < 3) {
            vZ.addElement(Util.aff_d((double)Z[k]));
            ++k;
        }
        Zs = CubicEOS.trie_d(vZ, false);
        return Zs;
    }

    protected double getFugacityResidual(double PP, double TT, double[] x) {
        this.mod = this.cubicModel.modeleUtilise(this.tbs.mixTc, this.tbs.mixPc, this.tbs.mixZc);
        this.tbs.solR = this.r1r2(this.mod.u, this.mod.w);
        this.mixb = this.mod.omegab * 8.314472471 * this.tbs.mixTc / this.tbs.mixPc;
        this.tbs.Tr = TT / this.tbs.mixTc;
        this.tbs.Trref = this.tbs.mixTref / this.tbs.mixTc;
        this.mixac = this.mod.omegaa * Math.pow(8.314472471, 2.0) * Math.pow(this.tbs.mixTc, 2.0) / this.tbs.mixPc;
        this.fonctionalphas = this.alphaFunction.alphaUtilise(this.tbs.mixomega, this.tbs.Tr, this.mixc1, this.mixc2, this.mixc3);
        this.mixalpha = this.fonctionalphas.alpha;
        this.tbs.m = this.fonctionalphas.m;
        this.mixa = this.mixac * this.mixalpha;
        Ede modele = this.equationdEtat(PP, TT, this.mod.u, this.mod.w, this.mixa, this.mixb);
        ResultatCardan Z = this.cubique(modele.A, modele.B, modele.C, modele.D);
        double fugaciteL = this.calculFugacite(PP, TT, this.tbs.solR.r1, this.tbs.solR.r2, this.mixa, this.mixb, Z.ZL);
        double fugaciteV = this.calculFugacite(PP, TT, this.tbs.solR.r1, this.tbs.solR.r2, this.mixa, this.mixb, Z.ZV);
        double critere = fugaciteL / fugaciteV - 1.0;
        if (this.tbs.debug) {
            System.out.println("temperature " + TT + " pression " + PP + "  critere " + critere);
        }
        this.tbs.satValue = x[1];
        return critere;
    }

    protected Ede equationdEtat(double P, double T, double u, double w, double a, double b) {
        Ede equation = new Ede();
        equation.A = P * Math.pow(8.314472471 * T / P, 3.0);
        equation.B = (P * b * u - b * P - 8.314472471 * T) * Math.pow(8.314472471 * T / P, 2.0);
        equation.C = (b * b * w * P - P * (b * b * u) - 8.314472471 * T * b * u + a) * (8.314472471 * T) / P;
        equation.D = -b * b * b * P * w - 8.314472471 * T * b * b * w - a * b;
        return equation;
    }

    protected double calculFugacite(double P, double T, double r1, double r2, double a, double b, double Z) {
        double v = Z * 8.314472471 * T / P;
        double lnphi = Z - 1.0 - Math.log(P * (v - b) / (8.314472471 * T)) + a / (b * 8.314472471 * T * (r1 - r2)) * Math.log((v - b * r1) / (v - b * r2));
        double phi = Math.exp(lnphi);
        return phi;
    }

    protected void listElements(Element el) {
        List attributes = el.getAttributes();
        Iterator ita = attributes.iterator();
        System.out.println("d\u00e9but d'analyse de " + el.getName());
        while (ita.hasNext()) {
            Attribute attr = (Attribute)ita.next();
            System.out.println("Dans Savexml() " + attr.getName() + " " + attr.getValue());
        }
        List listChildren = el.getChildren();
        Iterator itEtapes = listChildren.iterator();
        while (itEtapes.hasNext()) {
            Element courant = (Element)itEtapes.next();
            List courAttr = courant.getAttributes();
            ita = courAttr.iterator();
            System.out.println();
            System.out.println("Dans Savexml() " + courant.getName());
            while (ita.hasNext()) {
                Attribute attr = (Attribute)ita.next();
                System.out.println("Dans Savexml() " + attr.getName() + " " + attr.getValue());
            }
            System.out.println();
        }
        System.out.println("fin d'analyse de " + el.getName());
    }

    public void saveXml() {
        Element root = new Element("stylesheet", "xsl", "http://www.w3.org/1999/XSL/Transform");
        root.setAttribute("version", "1.0");
        Document doc = new Document(root);
        try {
            int i;
            Element seanceXml = new Element("MIXTURE");
            seanceXml.setAttribute("Name", this.tbs.systemName);
            seanceXml.setAttribute("Description", "TEP Library mixture data file");
            seanceXml.setAttribute("Model", this.name);
            seanceXml.setAttribute("Transport", Util.aff_i((int)this.tbs.nbTrapp));
            seanceXml.setAttribute("TransportModel", "Huber");
            this.fluid_Model = new Element("FLUID_MODEL");
            Element cubic = new Element("CUBIC");
            cubic.setAttribute("CubicModel", Util.aff_i((int)this.nbmodele));
            cubic.setAttribute("ModelType", this.cubicModel.type);
            cubic.setAttribute("Alpha", Util.aff_i((int)this.nbalpha));
            cubic.setAttribute("AlphaFunction", this.alphaFunction.type);
            this.fluid_Model.addContent((Content)cubic);
            seanceXml.addContent((Content)this.fluid_Model);
            this.mixRules = new Element("MIXRULES");
            if (this.tbs.nbComponents > 1) {
                i = 0;
                while (i < this.tbs.nbComponents) {
                    int j = 0;
                    while (j < this.tbs.nbComponents) {
                        this.mixRules.setAttribute("k" + Util.aff_i((int)i) + Util.aff_i((int)j), Util.aff_d((double)this.tbs.k[i][j]));
                        ++j;
                    }
                    ++i;
                }
            }
            seanceXml.addContent((Content)this.mixRules);
            this.component = new Element[this.tbs.nbComponents];
            i = 0;
            while (i < this.tbs.nbComponents) {
                this.component[i] = new Element("COMPONENT");
                this.component[i].setAttribute("Name", this.tbs.compProp[i].name);
                Element basic = new Element("GENERAL");
                basic.setAttribute("Tc", Util.aff_d((double)this.tbs.compProp[i].Tc));
                basic.setAttribute("Pc", Util.aff_d((double)this.tbs.compProp[i].Pc));
                basic.setAttribute("Vc", Util.aff_d((double)this.tbs.compProp[i].Vc));
                basic.setAttribute("M", Util.aff_d((double)this.tbs.compProp[i].M));
                basic.setAttribute("omega", Util.aff_d((double)this.tbs.compProp[i].omega));
                basic.setAttribute("dipole", Util.aff_d((double)this.tbs.compProp[i].dipole));
                basic.setAttribute("Tref", Util.aff_d((double)this.tbs.compProp[i].Tref));
                basic.setAttribute("Pref", Util.aff_d((double)this.tbs.compProp[i].Pref));
                basic.setAttribute("Tb", Util.aff_d((double)this.tbs.compProp[i].Tb));
                basic.setAttribute("Tmini", Util.aff_d((double)this.tbs.Tmini));
                basic.setAttribute("Tmaxi", Util.aff_d((double)this.tbs.Tmaxi));
                basic.setAttribute("Tmaxi", Util.aff_d((double)this.tbs.Pmaxi));
                this.component[i].addContent((Content)basic);
                Element fluid = new Element("MODEL");
                Element alpha = new Element("ALPHA");
                alpha.setAttribute("c1", Util.aff_d((double)this.cubicCompProp[i].c1));
                alpha.setAttribute("c2", Util.aff_d((double)this.cubicCompProp[i].c2));
                alpha.setAttribute("c3", Util.aff_d((double)this.cubicCompProp[i].c3));
                fluid.addContent((Content)alpha);
                this.component[i].addContent((Content)fluid);
                Element cp = new Element("CP");
                cp.setAttribute("Model", Util.aff_i((int)this.tbs.compProp[i].codeCp));
                cp.setAttribute("Cpa", Util.aff_d((double)this.tbs.compProp[i].A));
                cp.setAttribute("Cpb", Util.aff_d((double)this.tbs.compProp[i].B));
                cp.setAttribute("Cpc", Util.aff_d((double)this.tbs.compProp[i].C));
                cp.setAttribute("Cpd", Util.aff_d((double)this.tbs.compProp[i].D));
                cp.setAttribute("Cpe", Util.aff_d((double)this.tbs.compProp[i].E));
                cp.setAttribute("Cpg", Util.aff_d((double)this.tbs.compProp[i].G));
                cp.setAttribute("Cpk", Util.aff_d((double)this.tbs.compProp[i].K));
                this.component[i].addContent((Content)cp);
                Element psat = new Element("PSAT");
                psat.setAttribute("Model", Util.aff_i((int)this.tbs.compProp[i].codePsat));
                psat.setAttribute("psat_A", Util.aff_d((double)this.tbs.compProp[i].psat_A));
                psat.setAttribute("psat_B", Util.aff_d((double)this.tbs.compProp[i].psat_B));
                psat.setAttribute("psat_C", Util.aff_d((double)this.tbs.compProp[i].psat_C));
                psat.setAttribute("psat_D", Util.aff_d((double)this.tbs.compProp[i].psat_D));
                psat.setAttribute("psat_E", Util.aff_d((double)this.tbs.compProp[i].psat_E));
                this.component[i].addContent((Content)psat);
                Element tsat = new Element("TSAT");
                tsat.setAttribute("Model", Util.aff_i((int)this.tbs.compProp[i].codePsat));
                tsat.setAttribute("Tsat_A", Util.aff_d((double)this.tbs.compProp[i].Ts_A));
                tsat.setAttribute("Tsat_B", Util.aff_d((double)this.tbs.compProp[i].Ts_B));
                tsat.setAttribute("Tsat_C", Util.aff_d((double)this.tbs.compProp[i].Ts_C));
                tsat.setAttribute("Tsat_D", Util.aff_d((double)this.tbs.compProp[i].Ts_D));
                tsat.setAttribute("Tsat_E", Util.aff_d((double)this.tbs.compProp[i].Ts_E));
                this.component[i].addContent((Content)tsat);
                Element init = new Element("INIT");
                init.setAttribute("h0", Util.aff_d((double)this.tbs.compProp[i].h0));
                init.setAttribute("s0", Util.aff_d((double)this.tbs.compProp[i].s0));
                init.setAttribute("u0", Util.aff_d((double)this.tbs.compProp[i].u0));
                this.component[i].addContent((Content)init);
                seanceXml.addContent((Content)this.component[i]);
                ++i;
            }
            doc = new Document(seanceXml);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(doc, (OutputStream)new FileOutputStream(String.valueOf(this.tbs.systemName) + ".xml"));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    protected double sumx(double T, double P_bar) {
        double P = P_bar;
        double[] ZZ = this.getDeviations(P, T, this.tbs.zz, this.tbs.k);
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double sx = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            fugv[i] = ZZ[i + 4];
            ++i;
        }
        double sdx2 = 0.0;
        int kk = 0;
        while (kk < 15) {
            ZZ = this.getDeviations(P, T, this.tbs.xx, this.tbs.k);
            sx = 0.0;
            int i2 = 0;
            while (i2 < this.tbs.nbComponents) {
                fugl[i2] = ZZ[i2 + 4 + this.tbs.nbComponents];
                double xprime = this.tbs.xx[i2] * fugv[i2] / fugl[i2];
                sdx2 += (this.tbs.xx[i2] - xprime) * (this.tbs.xx[i2] - xprime);
                this.tbs.xx[i2] = xprime;
                sx += this.tbs.xx[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.tbs.nbComponents) {
                this.tbs.xx[i2] = this.tbs.xx[i2] / sx;
                ++i2;
            }
            if (sdx2 < 1.0E-7) break;
            ++kk;
        }
        return sx - 1.0;
    }

    protected double sumy(double T, double P_bar) {
        double P = P_bar;
        double[] ZZ = this.getDeviations(P, T, this.tbs.zz, this.tbs.k);
        double[] fugl = new double[this.tbs.nbComponents];
        double[] fugv = new double[this.tbs.nbComponents];
        double sy = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            fugl[i] = ZZ[i + 4 + this.tbs.nbComponents];
            ++i;
        }
        double sdy2 = 0.0;
        int kk = 0;
        while (kk < 15) {
            ZZ = this.getDeviations(P, T, this.tbs.yy, this.tbs.k);
            sy = 0.0;
            int i2 = 0;
            while (i2 < this.tbs.nbComponents) {
                fugv[i2] = ZZ[i2 + 4];
                double yprime = this.tbs.yy[i2] * fugl[i2] / fugv[i2];
                sdy2 += (this.tbs.yy[i2] - yprime) * (this.tbs.yy[i2] - yprime);
                this.tbs.yy[i2] = yprime;
                sy += this.tbs.yy[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.tbs.nbComponents) {
                this.tbs.yy[i2] = this.tbs.yy[i2] / sy;
                ++i2;
            }
            if (sdy2 < 1.0E-7) break;
            ++kk;
        }
        return sy - 1.0;
    }

    private double liqSplit(double L) {
        double somme = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            somme += (1.0 - this.tbs.KK[i]) * this.tbs.zz[i] / (L + this.tbs.KK[i] * (1.0 - L));
            ++i;
        }
        return somme;
    }
}

