/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.CompProperties;
import extThopt.Util;
import java.util.List;
import java.util.Vector;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;
import org.jdom.Element;

public class FluidModel
implements Lmdif_fcn {
    public CTPbibSubstance tbs;
    public String name = "";
    public static final double R = 8.314472471;
    static double PI = 3.141592654;
    double fact2 = 100000.0;
    double PaToBar = 100000.0;
    public boolean debug = false;
    int nfev = 0;
    int njev = 0;
    String callFunction = "";
    double epsiMinpack = 1.0E-6;
    public Element fluid_Model;
    public Element mixRules;
    public Element[] component;

    public FluidModel() {
    }

    public FluidModel(CTPbibSubstance tbs) {
        this.tbs = tbs;
    }

    public String getType() {
        return this.name;
    }

    public void init() {
    }

    public String getClassDescription() {
        return "";
    }

    public boolean isMolarFraction() {
        return true;
    }

    public double[] getMolarWeights() {
        double[] molarMasses = new double[4 + this.tbs.nbComponents];
        molarMasses[0] = this.tbs.mixM;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            molarMasses[1 + i] = this.tbs.compProp[i].M;
            ++i;
        }
        molarMasses[1 + this.tbs.nbComponents] = this.tbs.Tmini;
        molarMasses[2 + this.tbs.nbComponents] = this.tbs.Tmaxi;
        molarMasses[3 + this.tbs.nbComponents] = this.tbs.Pmaxi;
        return molarMasses;
    }

    private void linkCTPbib() {
        CompProperties[] cfr_ignored_0 = this.tbs.compProp;
    }

    public double[] calcSubstance(double T, double P_Pa, double quality) {
        double[] res = new double[6];
        return res;
    }

    public double getSatTemperature(double P_Pa, double quality) {
        return 0.0;
    }

    public double getSatPressure(double T, double quality) {
        return 0.0;
    }

    public void updateComp(String[] comp, double[] fract_mol) {
        this.tbs.comp = comp;
        this.tbs.fract_mol = fract_mol;
        this.tbs.calcMixProps();
    }

    public void calcMixProps() {
    }

    public void readXml() {
        String value;
        Element xmlFragment = this.fluid_Model;
        int i = 0;
        while (i < this.component.length) {
            xmlFragment = this.component[i];
            this.tbs.compProp[i] = new CompProperties();
            List listChildren = xmlFragment.getChildren("GENERAL");
            Element courant = (Element)listChildren.get(0);
            this.tbs.compProp[i].name = value = xmlFragment.getAttributeValue("Name");
            if (this.debug) {
                System.out.println("tbs.compProp[i].name: " + this.tbs.compProp[i].name);
            }
            value = courant.getAttributeValue("Tc");
            this.tbs.compProp[i].Tc = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("Tc: " + this.tbs.compProp[i].Tc);
            }
            value = courant.getAttributeValue("Pc");
            this.tbs.compProp[i].Pc = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("Pc: " + this.tbs.compProp[i].Pc);
            }
            value = courant.getAttributeValue("Vc");
            this.tbs.compProp[i].Vc = Util.lit_d((String)value);
            value = courant.getAttributeValue("M");
            this.tbs.initProp[1 + i] = this.tbs.mixM = Util.lit_d((String)value);
            this.tbs.compProp[i].M = this.tbs.mixM;
            value = courant.getAttributeValue("omega");
            this.tbs.compProp[i].omega = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("omega: " + this.tbs.compProp[i].omega);
            }
            value = courant.getAttributeValue("dipole");
            this.tbs.compProp[i].dipole = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("dipole " + this.tbs.compProp[i].dipole);
            }
            value = courant.getAttributeValue("Tref");
            this.tbs.compProp[i].Tref = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("Tref: " + this.tbs.compProp[i].Tref);
            }
            value = courant.getAttributeValue("Pref");
            this.tbs.compProp[i].Pref = Util.lit_d((String)value);
            if (this.debug) {
                System.out.println("Pref: " + this.tbs.compProp[i].Pref);
            }
            value = courant.getAttributeValue("Tb");
            this.tbs.compProp[i].Tb = Util.lit_d((String)value);
            value = courant.getAttributeValue("Tmini");
            this.tbs.initProp[i + 1 + this.tbs.nbComponents] = this.tbs.Tmini = Util.lit_d((String)value);
            value = courant.getAttributeValue("Tmaxi");
            this.tbs.initProp[i + 1 + 2 * this.tbs.nbComponents] = this.tbs.Tmaxi = Util.lit_d((String)value);
            value = courant.getAttributeValue("Pmaxi");
            if (value != null) {
                this.tbs.initProp[i + 1 + 3 * this.tbs.nbComponents] = this.tbs.Pmaxi = Util.lit_d((String)value) / 100000.0;
                if (this.debug) {
                    System.out.println("Pmaxi: " + value);
                }
            }
            if ((value = (courant = (Element)(listChildren = xmlFragment.getChildren("CP")).get(0)).getAttributeValue("Model")) != null) {
                if (this.debug) {
                    System.out.println("Model Cp " + value);
                }
                this.tbs.compProp[i].codeCp = Util.lit_i((String)value);
                if (this.tbs.compProp[i].codeCp == 1 || this.tbs.compProp[i].codeCp == 2) {
                    value = courant.getAttributeValue("Cpa");
                    if (this.debug) {
                        System.out.println("Cpa " + value);
                    }
                    this.tbs.compProp[i].A = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpb");
                    if (this.debug) {
                        System.out.println("Cpb " + value);
                    }
                    this.tbs.compProp[i].B = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpc");
                    if (this.debug) {
                        System.out.println("Cpc " + value);
                    }
                    this.tbs.compProp[i].C = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpd");
                    if (this.debug) {
                        System.out.println("Cpd " + value);
                    }
                    this.tbs.compProp[i].D = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpe");
                    if (this.debug) {
                        System.out.println("Cpe " + value);
                    }
                    this.tbs.compProp[i].E = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpg");
                    if (this.debug) {
                        System.out.println("Cpg " + value);
                    }
                    this.tbs.compProp[i].G = Util.lit_d((String)value);
                    value = courant.getAttributeValue("Cpk");
                    if (this.debug) {
                        System.out.println("Cpk " + value);
                    }
                    this.tbs.compProp[i].K = Util.lit_d((String)value);
                }
            }
            if ((listChildren = xmlFragment.getChildren("PSAT")).size() > 0) {
                courant = (Element)listChildren.get(0);
                value = courant.getAttributeValue("Model");
                if (this.debug) {
                    System.out.println("Model Psat " + value);
                }
                if (value != null) {
                    this.tbs.compProp[i].codePsat = Util.lit_i((String)value);
                }
                if ((value = courant.getAttributeValue("psat_A")) != null) {
                    this.tbs.compProp[i].psat_A = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("psat_B")) != null) {
                    this.tbs.compProp[i].psat_B = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("psat_C")) != null) {
                    this.tbs.compProp[i].psat_C = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("psat_D")) != null) {
                    this.tbs.compProp[i].psat_D = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("psat_E")) != null) {
                    this.tbs.compProp[i].psat_E = Util.lit_d((String)value);
                }
                if (this.debug) {
                    System.out.println("psat_E: " + this.tbs.compProp[i].psat_E);
                }
            }
            if ((listChildren = xmlFragment.getChildren("TSAT")).size() > 0) {
                courant = (Element)listChildren.get(0);
                value = courant.getAttributeValue("Model");
                if (this.debug) {
                    System.out.println("Model Tsat " + value);
                }
                if (value != null) {
                    this.tbs.compProp[i].codeTsat = Util.lit_i((String)value);
                }
                if ((value = courant.getAttributeValue("Tsat_A")) != null) {
                    this.tbs.compProp[i].Ts_A = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("Tsat_B")) != null) {
                    this.tbs.compProp[i].Ts_B = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("Tsat_C")) != null) {
                    this.tbs.compProp[i].Ts_C = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("Tsat_D")) != null) {
                    this.tbs.compProp[i].Ts_D = Util.lit_d((String)value);
                }
                if ((value = courant.getAttributeValue("Tsat_E")) != null) {
                    this.tbs.compProp[i].Ts_E = Util.lit_d((String)value);
                }
                if (this.debug) {
                    System.out.println("Tsat_E " + value);
                }
            }
            if ((value = (courant = (Element)(listChildren = xmlFragment.getChildren("INIT")).get(0)).getAttributeValue("h0")) != null) {
                this.tbs.compProp[i].h0 = Util.lit_d((String)value);
            }
            if (this.debug) {
                System.out.println("h0: " + this.tbs.compProp[i].h0);
            }
            if ((value = courant.getAttributeValue("s0")) != null) {
                this.tbs.compProp[i].s0 = Util.lit_d((String)value);
            }
            if (this.debug) {
                System.out.println("s0: " + this.tbs.compProp[i].s0);
            }
            if ((value = courant.getAttributeValue("u0")) != null) {
                this.tbs.compProp[i].u0 = Util.lit_d((String)value);
            }
            ++i;
        }
        if (this.tbs.nbComponents > 1) {
            i = 0;
            while (i < this.tbs.nbComponents) {
                int j = 0;
                while (j < this.tbs.nbComponents) {
                    String attName = "k" + Util.aff_i((int)i) + Util.aff_i((int)j);
                    value = this.mixRules.getAttributeValue(attName);
                    if (value != null) {
                        this.tbs.k[i][j] = Util.lit_d((String)value);
                    }
                    if (this.debug) {
                        System.out.println("k[i][j] " + this.tbs.k[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void fcn(int m, int n, double[] x, double[] fvec, int[] iflag) {
    }

    public void setParameters(Vector v) {
    }

    double getProp(int index, Vector v) {
        Double prop = (Double)v.elementAt(index);
        return prop;
    }

    double[] getPropArray(int index, Vector v) {
        double[] res = (double[])v.elementAt(index);
        return res;
    }

    public static double[] trie_d(Vector v, boolean increasing) {
        double[] a = new double[v.size()];
        int j = 0;
        while (j < v.size()) {
            a[j] = Util.lit_d((String)((String)v.elementAt(j)));
            ++j;
        }
        double[] b = new double[v.size()];
        int j2 = 0;
        while (j2 < v.size()) {
            double sup = a[0];
            int isup = 0;
            int k = 0;
            while (k < a.length) {
                if (increasing) {
                    if (sup > a[k]) {
                        sup = a[k];
                        isup = k;
                    }
                } else if (sup < a[k]) {
                    sup = a[k];
                    isup = k;
                }
                ++k;
            }
            double[] c = new double[a.length - 1];
            int i = -1;
            k = 0;
            while (k < a.length) {
                if (k != isup) {
                    c[++i] = a[k];
                }
                ++k;
            }
            a = new double[c.length];
            a = c;
            b[j2] = sup;
            ++j2;
        }
        return b;
    }

    public static double[] trie_d(double[] a, boolean increasing) {
        double[] b = new double[a.length];
        int j = 0;
        while (j < a.length) {
            double sup = a[0];
            int isup = 0;
            int k = 0;
            while (k < a.length) {
                if (increasing) {
                    if (sup > a[k]) {
                        sup = a[k];
                        isup = k;
                    }
                } else if (sup < a[k]) {
                    sup = a[k];
                    isup = k;
                }
                ++k;
            }
            double[] c = new double[a.length - 1];
            int i = -1;
            k = 0;
            while (k < a.length) {
                if (k != isup) {
                    c[++i] = a[k];
                }
                ++k;
            }
            a = new double[c.length];
            a = c;
            b[j] = sup;
            ++j;
        }
        return b;
    }

    protected double getMixMolarmass(double[] z) {
        double molarMass = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            molarMass += this.tbs.compProp[i].M * z[i];
            ++i;
        }
        return molarMass;
    }

    protected double[] solveWithMinPack(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec = new double[mm + 1];
        double[] x = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            x[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn(mm, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        this.nfev = 0;
        this.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)this, (int)mm, (int)n, (double[])x, (double[])fvec, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        if (this.debug) {
            System.out.println();
        }
        if (this.debug) {
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
        }
        if (this.debug) {
            System.out.println("Final L2 norm of the residuals: " + residu1);
        }
        if (this.debug) {
            System.out.println("Number of function evaluations: " + this.nfev);
        }
        if (this.debug) {
            System.out.println("Number of Jacobian evaluations: " + this.njev);
        }
        if (this.debug) {
            System.out.println("Info value: " + info[1]);
        }
        if (this.debug) {
            System.out.println("Final approximate solution: " + callFunction + "   " + x[1]);
        }
        if (this.debug) {
            System.out.println();
        }
        return x;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }
}

