/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.model.FluidModel;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LiBrH2O_mass
extends FluidModel {
    double x_LiBr;
    Vector vMixtures;
    String selectedSyst;
    double Pref;
    double Tmini;
    double Tmaxi;

    public LiBrH2O_mass() {
        this.Tmini = 278.15;
        this.Tmaxi = 448.15;
    }

    public LiBrH2O_mass(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "LiBrH2O_mass";
        this.Tmini = 278.15;
        this.Tmaxi = 448.15;
    }

    public String getClassDescription() {
        return "external mixture class\nThe LiBr composition is expressed as mass fractions";
    }

    public boolean isMolarFraction() {
        return false;
    }

    public String getType() {
        return "LiBrH2O_mass";
    }

    public void updateComp(String[] comp, double[] fract_mass) {
        this.x_LiBr = fract_mass[0];
        if (this.debug) {
            System.out.println("  x_LiBr: " + this.x_LiBr);
        }
        this.calcMixProps();
    }

    public void calcMixProps() {
        this.tbs.initProp[0] = 1.0;
        this.tbs.initProp[1 + this.tbs.nbComponents] = this.Tmini;
        this.tbs.initProp[1 + 2 * this.tbs.nbComponents] = this.Tmaxi;
        this.tbs.initProp[1 + 3 * this.tbs.nbComponents] = 1.0E8;
        this.tbs.initProp[2 + this.tbs.nbComponents] = this.Tmini;
        this.tbs.initProp[2 + 2 * this.tbs.nbComponents] = this.Tmaxi;
        this.tbs.initProp[2 + 3 * this.tbs.nbComponents] = 1.0E8;
        this.tbs.fract_mass[0] = this.x_LiBr;
        this.tbs.fract_mass[1] = 1.0 - this.x_LiBr;
        if (this.debug) {
            System.out.println("tbs.fract_mass[0] \t" + this.tbs.fract_mass[0]);
        }
    }

    public double[] getMolarWeights() {
        double[] molarMasses = new double[]{1.0, 1.0, 1.0, this.Tmini, this.Tmaxi, 1.0E8};
        return molarMasses;
    }

    public double[] calcSubstance(double T, double P_Pa, double quality) {
        double p = P_Pa / 100000.0;
        double[] val = new double[10];
        val[0] = this.calcH(T, p, this.x_LiBr);
        val[1] = this.calcV(T, p, this.x_LiBr);
        val[2] = 0.0;
        val[3] = this.calcXx(T, p, this.x_LiBr);
        val[4] = this.calcH(T, p, this.x_LiBr);
        val[5] = 0.0;
        int i = 0;
        while (i < 4) {
            val[6 + i] = 0.0;
            ++i;
        }
        return val;
    }

    public double getSatPressure(double T, double x) {
        return this.getP(this.x_LiBr, T) * 100000.0;
    }

    public double getSatTemperature(double P, double x) {
        double Tsat;
        double Pmin = 0.00106935586;
        double Pmax = 9.94628;
        this.Pref = P / 100000.0;
        if (this.debug) {
            System.out.println("Pref: " + this.Pref + "  x_LiBr: " + this.x_LiBr);
        }
        if (this.Pref >= Pmin && this.Pref <= Pmax) {
            Tsat = this.getTsat();
        } else if (this.Pref < Pmin) {
            Tsat = this.Tmini;
            String message = "Watch out! the pressure is too low ; Tsat is set to Tmini";
            JOptionPane.showMessageDialog(new JFrame(), message);
        } else {
            Tsat = this.Tmaxi;
            String message = "Watch out! the pressure is too high ; Tsat is set to Tmaxi";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Tsat;
    }

    protected double getTsat() {
        double[] init = new double[3];
        init[1] = 300.0;
        this.callFunction = "calcTsat";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        return result[1];
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("calcTsat")) {
            fvec[1] = (this.getP(this.x_LiBr, x[1]) - this.Pref) / this.Pref;
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    public double calcXx(double T, double P, double x_LiBr) {
        return 0.0;
    }

    public double calcV(double T, double P, double x_LiBr) {
        double X = 100.0 * this.x_LiBr;
        return 0.0010111 - 7.1622E-6 * X;
    }

    private double getCrystallizationLimitH(double x_LiBr) {
        double X = 100.0 * x_LiBr;
        return -139667.0 + 24000.0 * X;
    }

    private double getP(double x_LiBr, double T) {
        double X = 100.0 * x_LiBr;
        double t = T - 273.15;
        double[] A = new double[4];
        double[] B = new double[4];
        A[0] = -2.00755;
        A[1] = 0.16976;
        A[2] = -0.003133362;
        A[3] = 1.97668E-5;
        B[0] = 124.937;
        B[1] = -7.71649;
        B[2] = 0.152286;
        B[3] = -7.9509E-4;
        double C = 7.05;
        double D = -1596.49;
        double E = -104095.5;
        double sigAi = 0.0;
        double sigBi = 0.0;
        int i = 0;
        while (i < 4) {
            sigAi += A[i] * Math.pow(X, i);
            sigBi += B[i] * Math.pow(X, i);
            ++i;
        }
        double Tprime = (t - sigBi) / sigAi + 273.15;
        double logP = C + D / Tprime + E / Tprime / Tprime;
        return Math.exp(logP / 0.43429) / 100.0;
    }

    public double calcH(double T, double P, double x_LiBr) {
        return this.getH(x_LiBr, T);
    }

    private double getH(double x_LiBr, double T) {
        double X = 100.0 * x_LiBr;
        double[] A = new double[5];
        double[] B = new double[5];
        double[] C = new double[5];
        A[0] = -2024.33;
        A[1] = 163.309;
        A[2] = -4.88161;
        A[3] = 0.06302948;
        A[4] = -2.913705E-4;
        B[0] = 18.2829;
        B[1] = -1.1691757;
        B[2] = 0.03248041;
        B[3] = -4.034184E-4;
        B[4] = 1.8520569E-6;
        C[0] = -0.03700821;
        C[1] = 0.0028877666;
        C[2] = -8.1313015E-5;
        C[3] = 9.9116628E-7;
        C[4] = -4.4441207E-9;
        double sigAi = 0.0;
        double sigBi = 0.0;
        double sigCi = 0.0;
        int i = 0;
        while (i < 5) {
            sigAi += A[i] * Math.pow(X, i);
            sigBi += B[i] * Math.pow(X, i);
            sigCi += C[i] * Math.pow(X, i);
            ++i;
        }
        return sigAi + (T - 273.15) * sigBi + (T - 273.15) * (T - 273.15) * sigCi;
    }
}

