/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

public class NH3 {
    double[] AA = new double[8];
    double[] C = new double[8];
    double HF0;
    double SF0;
    double T0;
    double P0;
    double HG0;
    double SG0;
    public double gl;
    public double sl;
    public double hl;
    public double vl;
    public double gv;
    public double hv;
    public double sv;
    public double vv;

    public NH3() {
        this.init();
    }

    void init() {
        this.HF0 = 4.878573;
        this.SF0 = 1.644773;
        this.T0 = 3.2252;
        this.P0 = 2.0;
        this.HG0 = 26.468879;
        this.SG0 = 8.339026;
        this.AA[1] = 0.03971423;
        this.AA[2] = -1.790557E-5;
        this.AA[3] = -0.01308905;
        this.AA[4] = 0.003752836;
        this.AA[5] = 16.34519;
        this.AA[6] = -6.508119;
        this.AA[7] = 1.448937;
        this.C[1] = -0.01049377;
        this.C[2] = -8.288224;
        this.C[3] = -664.7257;
        this.C[4] = -3045.352;
        this.C[5] = 3.673647;
        this.C[6] = 0.09989629;
        this.C[7] = 0.03617622;
    }

    void liqProp(double PR, double TR) {
        double GL1 = this.HF0 - TR * this.SF0;
        double SCP = this.AA[5] * (TR - this.T0) + this.AA[6] * (TR * TR - this.T0 * this.T0) / 2.0 + this.AA[7] * (TR * TR * TR - this.T0 * this.T0 * this.T0) / 3.0;
        double SCP1 = this.AA[5] * Math.log(TR / this.T0) + this.AA[6] * (TR - this.T0) + this.AA[7] * (TR * TR - this.T0 * this.T0) / 2.0;
        double GL2 = SCP - TR * SCP1;
        double GL3 = (this.AA[1] + this.AA[3] * TR + this.AA[4] * TR * TR) * (PR - this.P0) + this.AA[2] * (PR * PR - this.P0 * this.P0) / 2.0;
        this.gl = GL1 + GL2 + GL3;
        this.hl = this.HF0 + SCP + (this.AA[1] - this.AA[4] * TR * TR) * (PR - this.P0) + this.AA[2] * (PR * PR - this.P0 * this.P0) / 2.0;
        this.sl = this.SF0 + SCP1 - (this.AA[3] + this.AA[4] * TR * 2.0) * (PR - this.P0);
        this.vl = this.AA[1] + this.AA[3] * TR + this.AA[4] * TR * TR + this.AA[2] * PR;
    }

    void vapProp(double PR, double TR) {
        double GV1 = this.HG0 - TR * this.SG0 + TR * Math.log(PR / this.P0);
        double SCP = this.C[5] * (TR - this.T0) + this.C[6] * (TR * TR - this.T0 * this.T0) / 2.0 + this.C[7] * (TR * TR * TR - this.T0 * this.T0 * this.T0) / 3.0;
        double SCP1 = this.C[5] * Math.log(TR / this.T0) + this.C[6] * (TR - this.T0) + this.C[7] * (TR * TR - this.T0 * this.T0) / 2.0;
        double GV2 = SCP - TR * SCP1;
        double GV3 = this.C[1] * (PR - this.P0) + this.C[2] * (PR / TR / TR / TR - 4.0 * this.P0 / this.T0 / this.T0 / this.T0 + 3.0 * this.P0 * TR / this.T0 / this.T0 / this.T0 / this.T0);
        double GV4 = this.C[3] * (PR / Math.pow(TR, 11.0) - 12.0 * this.P0 / Math.pow(this.T0, 11.0) + 11.0 * this.P0 * TR / Math.pow(this.T0, 12.0));
        double GV5 = this.C[4] / 3.0 * (PR * PR * PR / Math.pow(TR, 11.0) - 12.0 * this.P0 * this.P0 * this.P0 / Math.pow(this.T0, 11.0) + 11.0 * TR * this.P0 * this.P0 * this.P0 / Math.pow(this.T0, 12.0));
        this.gv = GV1 + GV2 + GV3 + GV4 + GV5;
        double Q1 = PR / TR / TR / TR - 4.0 * this.P0 / this.T0 / this.T0 / this.T0 + 3.0 * this.P0 * TR / this.T0 / this.T0 / this.T0 / this.T0;
        double DQ1 = -3.0 * PR / TR / TR / TR / TR + 3.0 * this.P0 / this.T0 / this.T0 / this.T0 / this.T0;
        double Q2 = PR / Math.pow(TR, 11.0) - 12.0 * this.P0 / Math.pow(this.T0, 11.0) + 11.0 * this.P0 * TR / Math.pow(this.T0, 12.0);
        double DQ2 = -11.0 * PR / Math.pow(TR, 12.0) + 11.0 * this.P0 / Math.pow(this.T0, 12.0);
        double Q3 = PR * PR * PR / Math.pow(TR, 11.0) - 12.0 * this.P0 * this.P0 * this.P0 / Math.pow(this.T0, 11.0) + 11.0 * this.P0 * this.P0 * this.P0 * TR / Math.pow(this.T0, 12.0);
        double DQ3 = -11.0 * PR * PR * PR / Math.pow(TR, 12.0) + 11.0 * this.P0 * this.P0 * this.P0 / Math.pow(this.T0, 12.0);
        this.hv = this.HG0 + SCP + this.C[1] * (PR - this.P0) + this.C[2] * (Q1 - TR * DQ1) + this.C[3] * (Q2 - TR * DQ2) + this.C[4] * (Q3 - TR * DQ3) / 3.0;
        this.sv = this.SG0 + SCP1 - this.C[2] * DQ1 - this.C[3] * DQ2 - this.C[4] * DQ3 / 3.0 - Math.log(PR / this.P0);
        this.vv = TR / PR + this.C[1] + this.C[2] / TR / TR / TR + this.C[3] / Math.pow(TR, 11.0) + this.C[4] * PR * PR / Math.pow(TR, 11.0);
    }
}

