/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.model.FluidModel;
import bibCTP.pcsaft.BubbleMethod;
import bibCTP.pcsaft.DewPointMethod;
import bibCTP.pcsaft.FlashMethodPCSaft_1Boucle;
import bibCTP.pcsaft.ThermoLib;
import extThopt.Util;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom.Element;

public class PCSaft
extends FluidModel {
    protected static final double constantR = 8.314472;
    protected static final double constantNav = 6.02214179E23;
    protected static double eps = 1.0E-6;
    protected double Pressure;
    public double[] TCritic;
    public double[] PCritic;
    public double[] w;
    public double[] m;
    public double[] sigmaPure;
    public double[] epsI;
    public double[][] kij;
    public int ncomp;
    public double hid = 0.0;
    public double sid = 0.0;
    public double hl = 0.0;
    public double sl = 0.0;
    public double hv = 0.0;
    public double sv = 0.0;
    String AnNum = "An";
    protected static final double[][] constantA = new double[][]{{0.9105631445, 0.6361281449, 2.6861347891, -26.547362491, 97.759208784, -159.59154087, 91.297774084}, {-0.3084016918, 0.1860531159, -2.5030047259, 21.419793629, -65.25588533, 83.318680481, -33.74692293}, {-0.0906148351, 0.4527842806, 0.5962700728, -1.7241829131, -4.1302112531, 13.77663187, -8.6728470368}};
    protected static final double[][] constantB = new double[][]{{0.7240946941, 2.2382791861, -4.0025849485, -21.003576815, 26.855641363, 206.55133841, -355.60235612}, {-0.5755498075, 0.6995095521, 3.892567339, -17.215471648, 192.67226447, -161.82646165, -165.20769346}, {0.0976883116, -0.2557574982, -9.155856153, 20.642075974, -38.804430052, 93.626774077, -29.666905585}};

    public PCSaft() {
    }

    public PCSaft(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "PCSaft";
        this.debug = false;
    }

    public String getType() {
        return "PCSaft";
    }

    public void readXml() {
        super.readXml();
        this.TCritic = new double[this.component.length];
        this.PCritic = new double[this.component.length];
        this.m = new double[this.component.length];
        this.sigmaPure = new double[this.component.length];
        this.epsI = new double[this.component.length];
        this.w = new double[this.component.length];
        this.ncomp = this.component.length;
        int i = 0;
        while (i < this.component.length) {
            Element xmlFragment = this.component[i];
            List listChildren = xmlFragment.getChildren("MODEL");
            Element el = (Element)listChildren.get(0);
            listChildren = el.getChildren("PCSaft");
            Element courant = (Element)listChildren.get(0);
            String value = courant.getAttributeValue("m");
            this.m[i] = Util.lit_d((String)value);
            System.out.println("m: " + value);
            value = courant.getAttributeValue("sigmaPure");
            System.out.println("sigmaPure: " + value);
            this.sigmaPure[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("epsI");
            System.out.println("epsI: " + value);
            this.epsI[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("w");
            System.out.println("w: " + value);
            this.w[i] = Util.lit_d((String)value);
            this.TCritic[i] = this.tbs.compProp[i].Tc;
            this.PCritic[i] = this.tbs.compProp[i].Pc;
            System.out.println("TCritic[i]: " + this.TCritic[i]);
            System.out.println("PCritic[i]: " + this.PCritic[i]);
            this.kij = this.tbs.k;
            ++i;
        }
    }

    public void setParameters(Vector v) {
        this.m = this.getPropArray(0, v);
        this.sigmaPure = this.getPropArray(1, v);
        this.epsI = this.getPropArray(2, v);
        if (v.size() > 3) {
            this.w = this.getPropArray(3, v);
        }
    }

    public double getSatPressure(double T, double x) {
        double Psat = 0.0;
        if (x == 0.0) {
            BubbleMethod exCPA1 = new BubbleMethod("T", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, this.tbs.fract_mol);
            Psat = exCPA1.getEquP();
        } else if (x == 1.0) {
            DewPointMethod exCPA1 = new DewPointMethod("T", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, this.tbs.fract_mol);
            Psat = exCPA1.getEquP();
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Psat;
    }

    public double getSatTemperature(double P, double quality) {
        double Tsat = 0.0;
        if (quality == 0.0) {
            BubbleMethod exCPA2 = new BubbleMethod("P", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P, this.tbs.fract_mol);
            Tsat = exCPA2.getEquT();
        } else if (quality == 1.0) {
            DewPointMethod exCPA2 = new DewPointMethod("P", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P, this.tbs.fract_mol);
            Tsat = exCPA2.getEquT();
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Tsat;
    }

    public double getBubblePointTemperature(String type, double P, double[] x) {
        BubbleMethod exCPA2 = new BubbleMethod("P", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P, x);
        double Tsat = exCPA2.getEquT();
        return Tsat;
    }

    public double getBubblePointPressure(String type, double T, double[] x) {
        BubbleMethod exCPA1 = new BubbleMethod("T", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, x);
        double Psat = exCPA1.getEquP();
        return Psat;
    }

    public double getDewPointTemperature(String type, double P, double[] y) {
        DewPointMethod exCPA2 = new DewPointMethod("P", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P, y);
        double Tsat = exCPA2.getEquT();
        return Tsat;
    }

    public double getDewPointPressure(String type, double T, double[] y) {
        DewPointMethod exCPA1 = new DewPointMethod("T", this.TCritic, this.PCritic, this.w, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, y);
        double Psat = exCPA1.getEquP();
        return Psat;
    }

    public double PsatEstimated(double TCritic, double PCritic, double w, double Temperature) {
        double Tr = Temperature / TCritic;
        return PCritic * Math.exp(5.92714 - 6.09648 / Tr - 1.28862 * Math.log(Tr) + 0.169347 * Math.pow(Tr, 6.0) + w * (15.2518 - 15.6875 / Tr - 13.4721 * Math.log(Tr) + 0.43577 * Math.pow(Tr, 6.0)));
    }

    public double calcRho(double T, double P_Pa, double quality, double[] x) {
        if (quality == 0.0) {
            return ThermoLib.RhoLiqPCSaft(this.AnNum, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P_Pa, T, x);
        }
        return ThermoLib.RhoVapPCSaft(this.AnNum, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, P_Pa, T, x);
    }

    public double[] calcSubstance(double T, double P_Pa, double quality) {
        this.tbs.zz = this.tbs.fract_mol;
        double p = P_Pa;
        double h = 0.0;
        double s = 0.0;
        double titre = quality;
        this.calcHsIdeal(T, P_Pa);
        double rho = 0.0;
        double hResL = 0.0;
        double sResL = 0.0;
        double hResV = 0.0;
        double sResV = 0.0;
        double[] res = new double[6 + 2 * this.tbs.nbComponents];
        double Tbulle = this.getSatTemperature(p, 0.0);
        double Trosee = this.getSatTemperature(p, 1.0);
        this.tbs.zz = this.tbs.fract_mol;
        if (this.debug) {
            System.out.println("Tbulle " + Tbulle + " Trosee " + Trosee);
        }
        if (T < Tbulle || T > Trosee) {
            if (T < Tbulle) {
                quality = 0.0;
                rho = this.calcRho(T, P_Pa, quality, this.tbs.fract_mol);
                double rhoL = 0.0;
                double[] HS_devL = this.getHSdeviations("SRK", T, P_Pa, rho, this.tbs.fract_mol);
                h = (HS_devL[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
                s = (HS_devL[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
                if (this.debug) {
                    System.out.println("hResL " + hResL + " sResL " + sResL + " rhoL " + rho + " rhoLdew " + rhoL + " h " + h + " s " + s);
                }
            } else {
                quality = 1.0;
                rho = this.calcRho(T, P_Pa, quality, this.tbs.fract_mol);
                double rhoV = 0.0;
                double[] HS_devV = this.getHSdeviations("SRK", T, P_Pa, rho, this.tbs.fract_mol);
                h = (HS_devV[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
                s = (HS_devV[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
                if (this.debug) {
                    System.out.println("hResV " + hResV + " sResV " + sResV + " rhoV " + rho + " rhoVbubble " + rhoV + " h " + h + " s " + s);
                }
            }
            this.tbs.v = 1.0 / PCSaft.rhoNbToMolar(rho);
        } else {
            double vv;
            double vl;
            double[] HS_devV;
            double[] HS_devL;
            if (this.component.length > 1) {
                FlashMethodPCSaft_1Boucle fm = new FlashMethodPCSaft_1Boucle(this, "SRK", T, P_Pa, this.tbs.fract_mol);
                titre = (fm.x[0] - this.tbs.fract_mol[0]) / (fm.x[0] - fm.y[0]);
                double qual = fm.L / this.tbs.mixM;
                if (this.debug) {
                    System.out.println("titre: " + titre + "  qual: " + qual);
                }
                int i = 0;
                while (i < this.tbs.nbComponents) {
                    res[6 + i] = fm.x[i];
                    res[6 + this.tbs.nbComponents + i] = fm.y[i];
                    ++i;
                }
                double liqM = this.getMixMolarmass(fm.x);
                double vapM = this.getMixMolarmass(fm.y);
                titre = (fm.x[0] * this.tbs.compProp[0].M / liqM - this.tbs.fract_mol[0] * this.tbs.compProp[0].M / this.tbs.mixM) / (fm.x[0] * this.tbs.compProp[0].M / liqM - fm.y[0] * this.tbs.compProp[0].M / vapM);
                if (this.debug) {
                    System.out.println("titre 2: " + titre);
                }
                HS_devL = this.getHSdeviations("SRK", T, P_Pa, fm.rhoL, fm.x);
                HS_devV = this.getHSdeviations("SRK", T, P_Pa, fm.rhoV, fm.y);
                vl = 1.0 / PCSaft.rhoNbToMolar(fm.rhoL);
                vv = 1.0 / PCSaft.rhoNbToMolar(fm.rhoV);
                if (this.debug) {
                    System.out.println("apr\u00e8s loi m\u00e9lange phases liqM " + liqM + " vapM " + vapM);
                }
            } else {
                titre = quality;
                rho = this.calcRho(T, P_Pa, 0.0, this.tbs.fract_mol);
                vl = 1.0 / PCSaft.rhoNbToMolar(rho);
                HS_devL = this.getHSdeviations("SRK", T, P_Pa, rho, this.tbs.fract_mol);
                rho = this.calcRho(T, P_Pa, 1.0, this.tbs.fract_mol);
                vv = 1.0 / PCSaft.rhoNbToMolar(rho);
                HS_devV = this.getHSdeviations("SRK", T, rho, P_Pa, this.tbs.fract_mol);
            }
            this.hl = (HS_devL[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
            this.sl = (HS_devL[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
            this.hv = (HS_devV[0] - this.tbs.mixh0) / this.tbs.mixM + this.hid;
            this.sv = (HS_devV[1] - this.tbs.mixs0) / this.tbs.mixM + this.sid;
            h = this.hv * titre + (1.0 - titre) * this.hl;
            s = this.sv * titre + (1.0 - titre) * this.sl;
            this.tbs.v = vv * titre + (1.0 - titre) * vl;
            quality = titre;
        }
        res[0] = h;
        res[1] = this.tbs.v / this.tbs.mixM * 1000.0;
        res[2] = 0.0;
        res[3] = quality;
        res[4] = res[0] - (p / 100000.0 * res[1] - this.tbs.mixu0);
        res[5] = s;
        return res;
    }

    void calcHsIdeal(double T, double P_Pa) {
        double p = P_Pa;
        this.hid = 0.0;
        this.sid = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.hid += this.tbs.fract_mol[i] * (this.tbs.compProp[i].h_gaz_mol(T) / this.tbs.compProp[i].M + this.tbs.compProp[i].h0);
            this.sid += this.tbs.fract_mol[i] * (this.tbs.compProp[i].s_gaz_mol(T, p) / this.tbs.compProp[i].M + this.tbs.compProp[i].s0);
            ++i;
        }
    }

    public double[] getHSdeviations(String type, double T, double P, double rho, double[] x) {
        double[] res = new double[2];
        double H_Dev = 0.0;
        double S_Dev = 0.0;
        double Z = P / T / PCSaft.rhoNbToMolar(rho) / 8.314472;
        double aRHC = 8.314472 * T * PCSaft.aRHC(this.m, this.sigmaPure, this.epsI, this.ncomp, T, rho, x);
        double aRHC_T = 8.314472 * T * PCSaft.aRHC_T(this.AnNum, this.m, this.sigmaPure, this.epsI, this.ncomp, T, rho, x);
        double aRDisp = 8.314472 * T * PCSaft.aRDisp(this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, rho, x);
        double aRDisp_T = 8.314472 * T * PCSaft.aRDisp_T(this.AnNum, this.m, this.sigmaPure, this.epsI, this.kij, this.ncomp, T, rho, x);
        H_Dev = -T * (aRHC_T + aRDisp_T) + 8.314472 * T * (Z - 1.0);
        S_Dev = 8.314472 * Math.log(Z) + H_Dev / T - 8.314472 * (Z - 1.0) - (aRHC + aRDisp) / T;
        res[0] = H_Dev;
        res[1] = S_Dev;
        return res;
    }

    public static double aR(double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        return PCSaft.aRHC(m, sigmaPure, epsI, ncomp, Temperature, rho, x) + PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
    }

    public static double aR_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An" || AnNum == "Num") {
            double aRhcRho = PCSaft.aRHC_rho(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double aRdispRho = PCSaft.aRDisp_rho(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
            return aRhcRho + aRdispRho;
        }
        System.out.println("aR_rho error!");
        return 0.0;
    }

    public static double aR_T(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An" || AnNum == "Num") {
            return PCSaft.aRHC_T(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x) + PCSaft.aRDisp_T(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
        }
        System.out.println("aR_rho error!");
        return 0.0;
    }

    public static double[] aR_xi(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        if (AnNum == "An" || AnNum == "Num") {
            double[] daRHC = PCSaft.aRHC_xi(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] daRDisp = PCSaft.aRDisp_xi(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
            int i = 0;
            while (i < ncomp) {
                res[i] = daRHC[i] + daRDisp[i];
                ++i;
            }
            return res;
        }
        System.out.println("aR_xi error!");
        return res;
    }

    public static double[] d(double[] sigmaPure, double[] epsI, int ncomp, double Temperature) {
        double[] d = new double[ncomp];
        int i = 0;
        while (i < ncomp) {
            d[i] = sigmaPure[i] * (1.0 - 0.12 * Math.exp(-3.0 * epsI[i] / Temperature));
            ++i;
        }
        return d;
    }

    public static double[] d_T(double[] sigmaPure, double[] epsI, int ncomp, double Temperature) {
        double[] dd = new double[ncomp];
        int i = 0;
        while (i < ncomp) {
            dd[i] = sigmaPure[i] * (3.0 * epsI[i] / Temperature / Temperature) * (-0.12 * Math.exp(-3.0 * epsI[i] / Temperature));
            ++i;
        }
        return dd;
    }

    public static double[] zeta(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] zeta = new double[4];
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < 4) {
            double sum = 0.0;
            int j = 0;
            while (j < ncomp) {
                sum += x[j] * m[j] * Math.pow(dBis[j], i);
                ++j;
            }
            zeta[i] = 0.5235987755982988 * rho * sum;
            ++i;
        }
        return zeta;
    }

    public static double[] zeta_T(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] dzeta = new double[4];
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double[] d_TBis = PCSaft.d_T(sigmaPure, epsI, ncomp, Temperature);
        dzeta[0] = 0.0;
        int n = 1;
        while (n < 4) {
            double sum = 0.0;
            int i = 0;
            while (i < ncomp) {
                sum += x[i] * m[i] * (double)n * d_TBis[i] * Math.pow(dBis[i], (double)n - 1.0);
                ++i;
            }
            dzeta[n] = 0.5235987755982988 * rho * sum;
            ++n;
        }
        return dzeta;
    }

    public static double[][] zeta_xi(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho) {
        double[][] res = new double[4][ncomp];
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < 4) {
                res[j][i] = 0.5235987755982988 * rho * m[i] * Math.pow(dBis[i], j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] RdfHS(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[][] g = new double[ncomp][ncomp];
        double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                g[i][j] = 1.0 / (1.0 - zetaBis[3]) + dBis[i] * dBis[j] / (dBis[i] + dBis[j]) * 3.0 * zetaBis[2] / Math.pow(1.0 - zetaBis[3], 2.0) + Math.pow(dBis[i] * dBis[j] / (dBis[i] + dBis[j]), 2.0) * 2.0 * Math.pow(zetaBis[2], 2.0) / Math.pow(1.0 - zetaBis[3], 3.0);
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static double[][] RdfHS_rho(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[][] res = new double[ncomp][ncomp];
        double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                res[i][j] = (zetaBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + dBis[i] * dBis[j] / (dBis[i] + dBis[j]) * (3.0 * zetaBis[2] / Math.pow(1.0 - zetaBis[3], 2.0) + 6.0 * zetaBis[2] * zetaBis[3] / Math.pow(1.0 - zetaBis[3], 3.0)) + Math.pow(dBis[i] * dBis[j] / (dBis[i] + dBis[j]), 2.0) * (4.0 * Math.pow(zetaBis[2], 2.0) / Math.pow(1.0 - zetaBis[3], 3.0) + 6.0 * Math.pow(zetaBis[2], 2.0) * zetaBis[3] / Math.pow(1.0 - zetaBis[3], 4.0))) / rho;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] RdfHS_T(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] zeta_TBis = PCSaft.zeta_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double[] d_TBis = PCSaft.d_T(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            res[i] = zeta_TBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + 0.5 * d_TBis[i] * 3.0 * zetaBis[2] / Math.pow(1.0 - zetaBis[3], 2.0) + 0.5 * dBis[i] * (3.0 * zeta_TBis[2] / Math.pow(1.0 - zetaBis[3], 2.0) + 6.0 * zetaBis[2] * zeta_TBis[3] / Math.pow(1.0 - zetaBis[3], 3.0)) + 0.5 * dBis[i] * d_TBis[i] * 2.0 * Math.pow(zetaBis[2], 2.0) / Math.pow(1.0 - zetaBis[3], 3.0) + Math.pow(0.5 * dBis[i], 2.0) * (4.0 * zetaBis[2] * zeta_TBis[2] / Math.pow(1.0 - zetaBis[3], 3.0) + 6.0 * Math.pow(zetaBis[2], 2.0) * zeta_TBis[3] / Math.pow(1.0 - zetaBis[3], 4.0));
            ++i;
        }
        return res;
    }

    public static double[][][] RdfHS_xi(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double[][] zeta_xiBis = PCSaft.zeta_xi(m, sigmaPure, epsI, ncomp, Temperature, rho);
        double[][][] res = new double[ncomp][ncomp][ncomp];
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                int k = 0;
                while (k < ncomp) {
                    res[i][j][k] = zeta_xiBis[3][k] / Math.pow(1.0 - zetaBis[3], 2.0) + dBis[i] * dBis[j] / (dBis[i] + dBis[j]) * (3.0 * zeta_xiBis[2][k] / Math.pow(1.0 - zetaBis[3], 2.0) + 6.0 * zetaBis[2] * zeta_xiBis[3][k] / Math.pow(1.0 - zetaBis[3], 3.0)) + Math.pow(dBis[i] * dBis[j] / (dBis[i] + dBis[j]), 2.0) * (4.0 * zetaBis[2] * zeta_xiBis[2][k] / Math.pow(1.0 - zetaBis[3], 3.0) + 6.0 * Math.pow(zetaBis[2], 2.0) * zeta_xiBis[3][k] / Math.pow(1.0 - zetaBis[3], 4.0));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double aRHS(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        return 1.0 / zetaBis[0] * (3.0 * zetaBis[1] * zetaBis[2] / (1.0 - zetaBis[3]) + Math.pow(zetaBis[2], 3.0) / zetaBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + (Math.pow(zetaBis[2] / zetaBis[3], 2.0) * zetaBis[2] - zetaBis[0]) * Math.log(1.0 - zetaBis[3]));
    }

    public static double aRHS_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            return (zetaBis[3] / (1.0 - zetaBis[3]) + 3.0 * zetaBis[1] * zetaBis[2] / zetaBis[0] / Math.pow(1.0 - zetaBis[3], 2.0) + (3.0 * Math.pow(zetaBis[2], 3.0) - zetaBis[3] * Math.pow(zetaBis[2], 3.0)) / zetaBis[0] / Math.pow(1.0 - zetaBis[3], 3.0)) / rho;
        }
        if (AnNum == "Num") {
            double h = rho * 1.0E-5;
            double rhoUp = rho + h;
            double rhoDown = rho - h;
            return (PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rhoUp, x) - PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rhoDown, x)) / 2.0 / h;
        }
        System.out.println("aRHS_rho error!");
        return 0.0;
    }

    public static double aRHS_T(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] zeta_TBis = PCSaft.zeta_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            return (3.0 * (zeta_TBis[1] * zetaBis[2] + zetaBis[1] * zeta_TBis[2]) / (1.0 - zetaBis[3]) + 3.0 * zetaBis[1] * zetaBis[2] * zeta_TBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + 3.0 * Math.pow(zetaBis[2], 2.0) * zeta_TBis[2] / zetaBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + Math.pow(zetaBis[2], 3.0) * zeta_TBis[3] * (3.0 * zetaBis[3] - 1.0) / Math.pow(zetaBis[3], 2.0) / Math.pow(1.0 - zetaBis[3], 3.0) + (3.0 * Math.pow(zetaBis[2], 2.0) * zeta_TBis[2] * zetaBis[3] - 2.0 * Math.pow(zetaBis[2], 3.0) * zeta_TBis[3]) / Math.pow(zetaBis[3], 3.0) * Math.log(1.0 - zetaBis[3]) + (zetaBis[0] - Math.pow(zetaBis[2], 3.0) / Math.pow(zetaBis[3], 2.0)) * zeta_TBis[3] / (1.0 - zetaBis[3])) / zetaBis[0];
        }
        if (AnNum == "Num") {
            double h = 0.01;
            double TUp = Temperature + h;
            double TDown = Temperature - h;
            return (PCSaft.aRHS(m, sigmaPure, epsI, ncomp, TUp, rho, x) - PCSaft.aRHS(m, sigmaPure, epsI, ncomp, TDown, rho, x)) / 2.0 / h;
        }
        System.out.println("aRHS_T error!");
        return 0.0;
    }

    public static double[] aRHS_xi(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        if (AnNum == "An") {
            double aRHSBis = PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] zetaBis = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][] zeta_xiBis = PCSaft.zeta_xi(m, sigmaPure, epsI, ncomp, Temperature, rho);
            int i = 0;
            while (i < ncomp) {
                res[i] = -zeta_xiBis[0][i] * aRHSBis / zetaBis[0] + (3.0 * (zeta_xiBis[1][i] * zetaBis[2] + zetaBis[1] * zeta_xiBis[2][i]) / (1.0 - zetaBis[3]) + 3.0 * zetaBis[1] * zetaBis[2] * zeta_xiBis[3][i] / Math.pow(1.0 - zetaBis[3], 2.0) + 3.0 * Math.pow(zetaBis[2], 2.0) * zeta_xiBis[2][i] / zetaBis[3] / Math.pow(1.0 - zetaBis[3], 2.0) + Math.pow(zetaBis[2], 3.0) * zeta_xiBis[3][i] * (3.0 * zetaBis[3] - 1.0) / Math.pow(zetaBis[3], 2.0) / Math.pow(1.0 - zetaBis[3], 3.0) + ((3.0 * Math.pow(zetaBis[2], 2.0) * zeta_xiBis[2][i] * zetaBis[3] - 2.0 * Math.pow(zetaBis[2], 3.0) * zeta_xiBis[3][i]) / Math.pow(zetaBis[3], 3.0) - zeta_xiBis[0][i]) * Math.log(1.0 - zetaBis[3]) + (zetaBis[0] - Math.pow(zetaBis[2], 3.0) / Math.pow(zetaBis[3], 2.0)) * zeta_xiBis[3][i] / (1.0 - zetaBis[3])) / zetaBis[0];
                ++i;
            }
            return res;
        }
        if (AnNum == "Num") {
            int i = 0;
            while (i < ncomp) {
                double[] xUp = (double[])x.clone();
                double[] xDown = (double[])x.clone();
                xUp[i] = x[i] * 1.0001;
                xDown[i] = x[i] * 0.9999;
                res[i] = (PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rho, xUp) - PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rho, xDown)) / 2.0 / (x[i] * 1.0E-4);
                ++i;
            }
            return res;
        }
        System.out.println("aRHS_xi error!");
        return res;
    }

    public static double aRChain(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[][] g = PCSaft.RdfHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum -= x[i] * (m[i] - 1.0) * Math.log(g[i][i]);
            ++i;
        }
        return sum;
    }

    public static double aRChain_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double[][] g = PCSaft.RdfHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][] g_rho = PCSaft.RdfHS_rho(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double sum = 0.0;
            int i = 0;
            while (i < ncomp) {
                sum -= x[i] * (m[i] - 1.0) * g_rho[i][i] / g[i][i];
                ++i;
            }
            return sum;
        }
        if (AnNum == "Num") {
            double h = rho * 1.0E-5;
            double rhoUp = rho + h;
            double rhoDown = rho - h;
            return (PCSaft.aRChain(m, sigmaPure, epsI, ncomp, Temperature, rhoUp, x) - PCSaft.aRChain(m, sigmaPure, epsI, ncomp, Temperature, rhoDown, x)) / 2.0 / h;
        }
        System.out.println("aRChain_rho error!");
        return 0.0;
    }

    public static double aRChain_T(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double[] g_T = PCSaft.RdfHS_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][] g = PCSaft.RdfHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double sum = 0.0;
            int i = 0;
            while (i < ncomp) {
                sum -= x[i] * (m[i] - 1.0) * g_T[i] / g[i][i];
                ++i;
            }
            return sum;
        }
        if (AnNum == "Num") {
            double h = 0.01;
            double TUp = Temperature + h;
            double TDown = Temperature - h;
            return (PCSaft.aRChain(m, sigmaPure, epsI, ncomp, TUp, rho, x) - PCSaft.aRChain(m, sigmaPure, epsI, ncomp, TDown, rho, x)) / 2.0 / h;
        }
        System.out.println("aRChain_T error!");
        return 0.0;
    }

    public static double[] aRChain_xi(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        if (AnNum == "An") {
            double sum = 0.0;
            double[][] g = PCSaft.RdfHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][][] g_xi = PCSaft.RdfHS_xi(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            int k = 0;
            while (k < ncomp) {
                sum = 0.0;
                int i = 0;
                while (i < ncomp) {
                    sum -= x[i] * (m[i] - 1.0) * g_xi[i][i][k] / g[i][i];
                    ++i;
                }
                res[k] = sum - (m[k] - 1.0) * Math.log(g[k][k]);
                ++k;
            }
            return res;
        }
        if (AnNum == "Num") {
            int i = 0;
            while (i < ncomp) {
                double[] xUp = (double[])x.clone();
                double[] xDown = (double[])x.clone();
                xUp[i] = x[i] * 1.0001;
                xDown[i] = x[i] * 0.9999;
                res[i] = (PCSaft.aRChain(m, sigmaPure, epsI, ncomp, Temperature, rho, xUp) - PCSaft.aRChain(m, sigmaPure, epsI, ncomp, Temperature, rho, xDown)) / 2.0 / (x[i] * 1.0E-4);
                ++i;
            }
            return res;
        }
        System.out.println("aRChain_xi error!");
        return res;
    }

    public static double aRHC(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double aRChainBis = PCSaft.aRChain(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double aRHSBis = PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double mMean = 0.0;
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        return mMean * aRHSBis + aRChainBis;
    }

    public static double aRHC_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double aRChain_rhoBis = PCSaft.aRChain_rho(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double aRHS_rhoBis = PCSaft.aRHS_rho(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double mMean = 0.0;
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            return mMean * aRHS_rhoBis + aRChain_rhoBis;
        }
        if (AnNum == "Num") {
            double h = rho * 1.0E-5;
            double rhoUp = rho + h;
            double rhoDown = rho - h;
            return (PCSaft.aRHC(m, sigmaPure, epsI, ncomp, Temperature, rhoUp, x) - PCSaft.aRHC(m, sigmaPure, epsI, ncomp, Temperature, rhoDown, x)) / 2.0 / h;
        }
        System.out.println("aRHC_rho error!");
        return 0.0;
    }

    public static double aRHC_T(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double aRChain_TBis = PCSaft.aRChain_T(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double aRHS_TBis = PCSaft.aRHS_T(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double mMean = 0.0;
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            return mMean * aRHS_TBis + aRChain_TBis;
        }
        if (AnNum == "Num") {
            double h = 0.01;
            double TUp = Temperature + h;
            double TDown = Temperature - h;
            return (PCSaft.aRHC(m, sigmaPure, epsI, ncomp, TUp, rho, x) - PCSaft.aRHC(m, sigmaPure, epsI, ncomp, TDown, rho, x)) / 2.0 / h;
        }
        System.out.println("aRHC_T error!");
        return 0.0;
    }

    public static double[] aRHC_xi(String AnNum, double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        if (AnNum == "An") {
            double aRHSBis = PCSaft.aRHS(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double mMean = 0.0;
            double[] aRHS_xiBis = PCSaft.aRHS_xi(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] aRChain_xiBis = PCSaft.aRChain_xi(AnNum, m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            i = 0;
            while (i < ncomp) {
                res[i] = m[i] * aRHSBis + mMean * aRHS_xiBis[i] + aRChain_xiBis[i];
                ++i;
            }
            return res;
        }
        if (AnNum == "Num") {
            int i = 0;
            while (i < ncomp) {
                double[] xUp = (double[])x.clone();
                double[] xDown = (double[])x.clone();
                xUp[i] = x[i] * 1.0001;
                xDown[i] = x[i] * 0.9999;
                res[i] = (PCSaft.aRHC(m, sigmaPure, epsI, ncomp, Temperature, rho, xUp) - PCSaft.aRHC(m, sigmaPure, epsI, ncomp, Temperature, rho, xDown)) / 2.0 / (x[i] * 1.0E-4);
                ++i;
            }
            return res;
        }
        System.out.println("aRHC_xi error!");
        return res;
    }

    public static double[][] sigmaij(double[] sigmaPure, int ncomp) {
        double[][] sigmaMix = new double[ncomp][ncomp];
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                sigmaMix[i][j] = (sigmaPure[i] + sigmaPure[j]) / 2.0;
                ++j;
            }
            ++i;
        }
        return sigmaMix;
    }

    public static double[][] epsIij(double[] epsI, double[][] kij, int ncomp) {
        double[][] epsIMix = new double[ncomp][ncomp];
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                epsIMix[i][j] = (1.0 - kij[i][j]) * Math.sqrt(epsI[i] * epsI[j]);
                ++j;
            }
            ++i;
        }
        return epsIMix;
    }

    public static double eta(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double sum = 0.0;
        int j = 0;
        while (j < ncomp) {
            sum += x[j] * m[j] * Math.pow(dBis[j], 3.0);
            ++j;
        }
        double eta = 0.5235987755982988 * rho * sum;
        return eta;
    }

    public static double eta_rho(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double[] x) {
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double sum = 0.0;
        int j = 0;
        while (j < ncomp) {
            sum += x[j] * m[j] * Math.pow(dBis[j], 3.0);
            ++j;
        }
        double res = 0.5235987755982988 * sum;
        return res;
    }

    public static double eta_T(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        double[] d_TBis = PCSaft.d_T(sigmaPure, epsI, ncomp, Temperature);
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += x[i] * m[i] * 3.0 * d_TBis[i] * Math.pow(dBis[i], 2.0);
            ++i;
        }
        return 0.5235987755982988 * rho * sum;
    }

    public static double[] eta_xi(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            res[i] = 0.5235987755982988 * rho * m[i] * Math.pow(dBis[i], 3.0);
            ++i;
        }
        return res;
    }

    public static double[] PerInt(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double mMean = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] am = new double[7];
        double[] bm = new double[7];
        double[] I = new double[2];
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            am[i] = constantA[0][i] + (mMean - 1.0) / mMean * constantA[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantA[2][i];
            bm[i] = constantB[0][i] + (mMean - 1.0) / mMean * constantB[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantB[2][i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            sum1 += am[i] * Math.pow(etaBis, i);
            sum2 += bm[i] * Math.pow(etaBis, i);
            ++i;
        }
        I[0] = sum1;
        I[1] = sum2;
        return I;
    }

    public static double[] PerInt_T(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double eta_TBis = PCSaft.eta_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double mMean = 0.0;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double[] am = new double[7];
        double[] bm = new double[7];
        double[] I = new double[2];
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            am[i] = constantA[0][i] + (mMean - 1.0) / mMean * constantA[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantA[2][i];
            bm[i] = constantB[0][i] + (mMean - 1.0) / mMean * constantB[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantB[2][i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            sum1 += am[i] * (double)i * Math.pow(etaBis, i - 1) * eta_TBis;
            sum2 += bm[i] * (double)i * Math.pow(etaBis, i - 1) * eta_TBis;
            ++i;
        }
        I[0] = sum1;
        I[1] = sum2;
        return I;
    }

    public static double[][] PerInt_xi(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double mMean = 0.0;
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] am = new double[7];
        double[] bm = new double[7];
        double[][] res = new double[2][ncomp];
        double[][] am_xi = new double[7][ncomp];
        double[][] bm_xi = new double[7][ncomp];
        double[][] zeta_xiBis = PCSaft.zeta_xi(m, sigmaPure, epsI, ncomp, Temperature, rho);
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        i = 0;
        while (i < 7) {
            am[i] = constantA[0][i] + (mMean - 1.0) / mMean * constantA[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantA[2][i];
            bm[i] = constantB[0][i] + (mMean - 1.0) / mMean * constantB[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantB[2][i];
            int k = 0;
            while (k < ncomp) {
                am_xi[i][k] = m[k] / Math.pow(mMean, 2.0) * constantA[1][i] + m[k] / Math.pow(mMean, 2.0) * constantA[2][i] * (3.0 - 4.0 / mMean);
                bm_xi[i][k] = m[k] / Math.pow(mMean, 2.0) * constantB[1][i] + m[k] / Math.pow(mMean, 2.0) * constantB[2][i] * (3.0 - 4.0 / mMean);
                ++k;
            }
            ++i;
        }
        int k = 0;
        while (k < ncomp) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            int i2 = 0;
            while (i2 < 7) {
                sum1 = sum1 + am[i2] * (double)i2 * Math.pow(etaBis, i2 - 1) * zeta_xiBis[3][k] + am_xi[i2][k] * Math.pow(etaBis, i2);
                sum2 = sum2 + bm[i2] * (double)i2 * Math.pow(etaBis, i2 - 1) * zeta_xiBis[3][k] + bm_xi[i2][k] * Math.pow(etaBis, i2);
                ++i2;
            }
            res[0][k] = sum1;
            res[1][k] = sum2;
            ++k;
        }
        return res;
    }

    public static double[] MEpsSigma(double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double[] x) {
        double[] res = new double[]{0.0, 0.0};
        double[][] sigmaMix = PCSaft.sigmaij(sigmaPure, ncomp);
        double[][] epsIMix = PCSaft.epsIij(epsI, kij, ncomp);
        int i = 0;
        while (i < ncomp) {
            int j = 0;
            while (j < ncomp) {
                res[0] = res[0] + x[i] * x[j] * m[i] * m[j] * epsIMix[i][j] / Temperature * Math.pow(sigmaMix[i][j], 3.0);
                res[1] = res[1] + x[i] * x[j] * m[i] * m[j] * Math.pow(epsIMix[i][j] / Temperature, 2.0) * Math.pow(sigmaMix[i][j], 3.0);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] MEpsSigma_xi(double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double[] x) {
        double[][] res = new double[2][ncomp];
        double[][] sigmaMix = PCSaft.sigmaij(sigmaPure, ncomp);
        double[][] epsIMix = PCSaft.epsIij(epsI, kij, ncomp);
        int k = 0;
        while (k < ncomp) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            int j = 0;
            while (j < ncomp) {
                sum1 += x[j] * m[j] * epsIMix[k][j] / Temperature * Math.pow(sigmaMix[k][j], 3.0);
                sum2 += x[j] * m[j] * Math.pow(epsIMix[k][j] / Temperature, 2.0) * Math.pow(sigmaMix[k][j], 3.0);
                ++j;
            }
            res[0][k] = 2.0 * m[k] * sum1;
            res[1][k] = 2.0 * m[k] * sum2;
            ++k;
        }
        return res;
    }

    public static double C1(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double mMean = 0.0;
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        return 1.0 / (1.0 + mMean * (8.0 * etaBis - 2.0 * Math.pow(etaBis, 2.0)) / Math.pow(1.0 - etaBis, 4.0) + (1.0 - mMean) * (20.0 * etaBis - 27.0 * Math.pow(etaBis, 2.0) + 12.0 * Math.pow(etaBis, 3.0) - 2.0 * Math.pow(etaBis, 4.0)) / Math.pow((1.0 - etaBis) * (2.0 - etaBis), 2.0));
    }

    public static double C2(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double mMean = 0.0;
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        return -Math.pow(C1Bis, 2.0) * (mMean * (-4.0 * Math.pow(etaBis, 2.0) + 20.0 * etaBis + 8.0) / Math.pow(1.0 - etaBis, 5.0) + (1.0 - mMean) * (2.0 * Math.pow(etaBis, 3.0) + 12.0 * Math.pow(etaBis, 2.0) - 48.0 * etaBis + 40.0) / Math.pow((1.0 - etaBis) * (2.0 - etaBis), 3.0));
    }

    public static double[] C1_xi(double[] m, double[] sigmaPure, double[] epsI, int ncomp, double Temperature, double rho, double[] x) {
        double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double C2Bis = PCSaft.C2(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] res = new double[ncomp];
        double[][] zeta_xiBis = PCSaft.zeta_xi(m, sigmaPure, epsI, ncomp, Temperature, rho);
        int k = 0;
        while (k < ncomp) {
            res[k] = C2Bis * zeta_xiBis[3][k] - Math.pow(C1Bis, 2.0) * (m[k] * (8.0 * etaBis - 2.0 * Math.pow(etaBis, 2.0)) / Math.pow(1.0 - etaBis, 4.0) - m[k] * (20.0 * etaBis - 27.0 * Math.pow(etaBis, 2.0) + 12.0 * Math.pow(etaBis, 3.0) - 2.0 * Math.pow(etaBis, 4.0)) / Math.pow((1.0 - etaBis) * (2.0 - etaBis), 2.0));
            ++k;
        }
        return res;
    }

    public static double aRDisp(double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        double mMean = 0.0;
        double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] I = PCSaft.PerInt(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
        double[] mes = PCSaft.MEpsSigma(m, sigmaPure, epsI, kij, ncomp, Temperature, x);
        int i = 0;
        while (i < ncomp) {
            mMean += x[i] * m[i];
            ++i;
        }
        double a1 = Math.PI * -2 * rho * I[0] * mes[0];
        double a2 = -Math.PI * mMean * mes[1] * rho * C1Bis * I[1];
        return a1 + a2;
    }

    public static double aRDisp_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double mMean = 0.0;
            double etaBis = PCSaft.eta(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double C2Bis = PCSaft.C2(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double I2 = PCSaft.PerInt(m, sigmaPure, epsI, ncomp, Temperature, rho, x)[1];
            double zet = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x)[3];
            double[] mes = PCSaft.MEpsSigma(m, sigmaPure, epsI, kij, ncomp, Temperature, x);
            double[] ami = new double[7];
            double[] bmi = new double[7];
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            i = 0;
            while (i < 7) {
                ami[i] = constantA[0][i] + (mMean - 1.0) / mMean * constantA[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantA[2][i];
                bmi[i] = constantB[0][i] + (mMean - 1.0) / mMean * constantB[1][i] + (mMean - 1.0) * (mMean - 2.0) / (mMean * mMean) * constantB[2][i];
                ++i;
            }
            double sum1 = 0.0;
            int i2 = 0;
            while (i2 < 7) {
                sum1 += ami[i2] * (double)(i2 + 1) * Math.pow(etaBis, i2);
                ++i2;
            }
            double sum2 = 0.0;
            int i3 = 0;
            while (i3 < 7) {
                sum2 += bmi[i3] * (double)(i3 + 1) * Math.pow(etaBis, i3);
                ++i3;
            }
            return Math.PI * -2 * sum1 * mes[0] - Math.PI * mMean * mes[1] * (C1Bis * sum2 + C2Bis * etaBis * I2);
        }
        if (AnNum == "Num") {
            double h = rho * 1.0E-5;
            double rhoUp = rho + h;
            double rhoDown = rho - h;
            return (PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, Temperature, rhoUp, x) - PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, Temperature, rhoDown, x)) / 2.0 / h;
        }
        System.out.println("aRDisp_rho error!");
        return 0.0;
    }

    public static double molar_rho(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        double zet = PCSaft.zeta(m, sigmaPure, epsI, ncomp, Temperature, rho, x)[3];
        return rho * 6.0 / Math.PI / zet / 6.02214179E23 * 1.0E30;
    }

    public static double aRDisp_T(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An") {
            double mMean = 0.0;
            double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double C2Bis = PCSaft.C2(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double eta_TBis = PCSaft.eta_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] mes = PCSaft.MEpsSigma(m, sigmaPure, epsI, kij, ncomp, Temperature, x);
            double[] I = PCSaft.PerInt(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] dI = PCSaft.PerInt_T(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            return Math.PI * -2 * rho * (dI[0] - I[0] / Temperature) * mes[0] - Math.PI * rho * mMean * mes[1] * (eta_TBis * C2Bis * I[1] + C1Bis * dI[1] - 2.0 * C1Bis * I[1] / Temperature);
        }
        if (AnNum == "Num") {
            double h = 0.001;
            double TUp = Temperature + h;
            double TDown = Temperature - h;
            return (PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, TUp, rho, x) - PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, TDown, rho, x)) / 2.0 / h;
        }
        System.out.println("aRDisp_T error!");
        return 0.0;
    }

    public static double[] aRDisp_xi(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        double[] res = new double[ncomp];
        if (AnNum == "An") {
            double mMean = 0.0;
            double C1Bis = PCSaft.C1(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] I = PCSaft.PerInt(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[] mes = PCSaft.MEpsSigma(m, sigmaPure, epsI, kij, ncomp, Temperature, x);
            double[] C1_xiBis = PCSaft.C1_xi(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][] I_xi = PCSaft.PerInt_xi(m, sigmaPure, epsI, ncomp, Temperature, rho, x);
            double[][] mes_xi = PCSaft.MEpsSigma_xi(m, sigmaPure, epsI, kij, ncomp, Temperature, x);
            int i = 0;
            while (i < ncomp) {
                mMean += x[i] * m[i];
                ++i;
            }
            int k = 0;
            while (k < ncomp) {
                res[k] = Math.PI * -2 * rho * (I_xi[0][k] * mes[0] + I[0] * mes_xi[0][k]) - Math.PI * rho * ((m[k] * C1Bis * I[1] + mMean * C1_xiBis[k] * I[1] + mMean * C1Bis * I_xi[1][k]) * mes[1] + mMean * C1Bis * I[1] * mes_xi[1][k]);
                ++k;
            }
            return res;
        }
        if (AnNum == "Num") {
            int i = 0;
            while (i < ncomp) {
                double[] xUp = (double[])x.clone();
                double[] xDown = (double[])x.clone();
                xUp[i] = x[i] * 1.0001;
                xDown[i] = x[i] * 0.9999;
                res[i] = (PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, Temperature, rho, xUp) - PCSaft.aRDisp(m, sigmaPure, epsI, kij, ncomp, Temperature, rho, xDown)) / 2.0 / (x[i] * 1.0E-4);
                ++i;
            }
            return res;
        }
        System.out.println("aRDisp_xi error!");
        return res;
    }

    public static double rhoNbToMolar(double rho) {
        return rho / 6.02214179E23 * 1.0E30;
    }

    public static double rhoMolarToNb(double rho) {
        return rho * 6.02214179E23 / 1.0E30;
    }
}

