/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.model.FluidModel;
import extThopt.Util;
import java.util.List;
import org.jdom.Element;

public class PCSaftDortmund
extends FluidModel {
    double[][] ap = new double[8][4];
    double[][] bp = new double[8][4];
    double PI = 3.14159265359;
    double RGAS = 8.31441;
    double NA = 6.022045E23;
    double KBOL;
    double TAU;
    int nc = 20;
    int nph = 2;
    public double[] TCritic;
    public double[] PCritic;
    public double[] w;
    public double[] mseg;
    public double[] sig;
    public double[] u0k;
    public double[][] kij;
    public double[][] gij;
    int ncomp;
    double[] sig_t;
    double[] apar;
    double[] bpar;
    double[] d_sta;
    double z0t;
    double z1t;
    double z2t;
    double z3t;
    double[][] dij_ab;
    double[][] uij;
    double[][] sig_ij;
    double[][] dap_dx;
    double[][] dbp_dx;
    double h_res;
    double s_res;
    double g_res;
    double den;
    double dense;
    double densta;
    double pges;
    double pgesdz;
    double fres;
    double z0;
    double z1;
    double z2;
    double z3;
    double order1;
    double order2;

    public PCSaftDortmund() {
    }

    public PCSaftDortmund(CTPbibSubstance tbs) {
        super(tbs);
        this.init();
        this.name = "PCSaftDortmund";
    }

    public String getType() {
        return "PCSaftDortmund";
    }

    public void init() {
        this.KBOL = this.RGAS / this.NA;
        this.TAU = this.PI / 3.0 / Math.sqrt(2.0);
        this.ap[1][1] = 0.91056314451539;
        this.ap[1][2] = -0.3084016918272;
        this.ap[1][3] = -0.09061483509767;
        this.ap[2][1] = 0.63612814494991;
        this.ap[2][2] = 0.18605311591713;
        this.ap[2][3] = 0.4527842806392;
        this.ap[3][1] = 2.68613478913903;
        this.ap[3][2] = -2.50300472586548;
        this.ap[3][3] = 0.59627007280101;
        this.ap[4][1] = -26.5473624914884;
        this.ap[4][2] = 21.4197936296668;
        this.ap[4][3] = -1.72418291311787;
        this.ap[5][1] = 97.7592087835073;
        this.ap[5][2] = -65.2558853303492;
        this.ap[5][3] = -4.13021125311661;
        this.ap[6][1] = -159.5915408656;
        this.ap[6][2] = 83.3186804808856;
        this.ap[6][3] = 13.7766318697211;
        this.ap[7][1] = 91.2977740839123;
        this.ap[7][2] = -33.7469229297323;
        this.ap[7][3] = -8.67284703679646;
        this.bp[1][1] = 0.72409469413165;
        this.bp[1][2] = -0.5755498075345;
        this.bp[1][3] = 0.09768831158356;
        this.bp[2][1] = 2.2382791860938;
        this.bp[2][2] = 0.69950955214436;
        this.bp[2][3] = -0.255757498161;
        this.bp[3][1] = -4.0025849484634195;
        this.bp[3][2] = 3.8925673389530697;
        this.bp[3][3] = -9.155856152973211;
        this.bp[4][1] = -21.00357681484648;
        this.bp[4][2] = -17.21547164777212;
        this.bp[4][3] = 20.64207597439724;
        this.bp[5][1] = 26.8556413626615;
        this.bp[5][2] = 192.6722644652495;
        this.bp[5][3] = -38.80443005206285;
        this.bp[6][1] = 206.5513384066188;
        this.bp[6][2] = -161.8264616487648;
        this.bp[6][3] = 93.6267740770146;
        this.bp[7][1] = -355.60235612207947;
        this.bp[7][2] = -165.2076934555607;
        this.bp[7][3] = -29.66690558514725;
    }

    public void readXml() {
        super.readXml();
        this.TCritic = new double[this.component.length];
        this.PCritic = new double[this.component.length];
        this.mseg = new double[this.component.length];
        this.sig = new double[this.component.length];
        this.u0k = new double[this.component.length];
        this.w = new double[this.component.length];
        this.ncomp = this.component.length;
        int i = 0;
        while (i < this.component.length) {
            Element xmlFragment = this.component[i];
            List listChildren = xmlFragment.getChildren("MODEL");
            Element el = (Element)listChildren.get(0);
            listChildren = el.getChildren("PCSaft");
            Element courant = (Element)listChildren.get(0);
            String value = courant.getAttributeValue("m");
            this.mseg[i] = Util.lit_d((String)value);
            System.out.println("m: " + value);
            value = courant.getAttributeValue("sigmaPure");
            System.out.println("sigmaPure: " + value);
            this.sig[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("epsI");
            System.out.println("epsI: " + value);
            this.u0k[i] = Util.lit_d((String)value);
            value = courant.getAttributeValue("w");
            System.out.println("w: " + value);
            this.w[i] = Util.lit_d((String)value);
            this.TCritic[i] = this.tbs.compProp[i].Tc;
            this.PCritic[i] = this.tbs.compProp[i].Pc;
            this.kij = this.tbs.k;
            ++i;
        }
        this.sig_t = new double[this.ncomp];
        this.sig_ij = new double[this.ncomp][this.ncomp];
        this.dij_ab = new double[this.ncomp][this.ncomp];
        this.uij = new double[this.ncomp][this.ncomp];
        this.gij = new double[this.ncomp][this.ncomp];
        this.apar = new double[8];
        this.bpar = new double[8];
        this.dap_dx = new double[this.ncomp][8];
        this.dbp_dx = new double[this.ncomp][8];
    }

    void PERTPAR(double[] x, double t, double p) {
        int j;
        int i = 1;
        while (i <= this.ncomp) {
            this.sig_t[i] = this.sig[i] * (1.0 - 0.12 * Math.exp(-3.0 * this.u0k[i] / t));
            ++i;
        }
        i = 1;
        while (i <= this.ncomp) {
            j = 1;
            while (j <= this.ncomp) {
                this.sig_ij[i][j] = 0.5 * (this.sig[i] + this.sig[j]);
                this.uij[i][j] = (1.0 - this.kij[i][j]) * Math.pow(this.u0k[i] * this.u0k[j], 0.5);
                ++j;
            }
            ++i;
        }
        this.z0t = 0.0;
        this.z1t = 0.0;
        this.z2t = 0.0;
        this.z3t = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            this.z0t += x[i] * this.mseg[i];
            this.z1t += x[i] * this.mseg[i] * this.sig_t[i];
            this.z2t += x[i] * this.mseg[i] * this.sig_t[i] * this.sig_t[i];
            this.z3t += x[i] * this.mseg[i] * this.sig_t[i] * this.sig_t[i] * this.sig_t[i];
            ++i;
        }
        double m_mean = this.z0t;
        this.z0t = this.PI / 6.0 * this.z0t;
        this.z1t = this.PI / 6.0 * this.z1t;
        this.z2t = this.PI / 6.0 * this.z2t;
        this.z3t = this.PI / 6.0 * this.z3t;
        i = 1;
        while (i <= this.ncomp) {
            j = 1;
            while (j <= this.ncomp) {
                this.dij_ab[i][j] = this.sig_t[i] * this.sig_t[j] / (this.sig_t[i] + this.sig_t[j]);
                ++j;
            }
            ++i;
        }
        int m = 1;
        while (m <= 7) {
            this.apar[m] = this.ap[m][1] + (1.0 - 1.0 / m_mean) * this.ap[m][2] + (1.0 - 1.0 / m_mean) * (1.0 - 2.0 / m_mean) * this.ap[m][3];
            this.bpar[m] = this.bp[m][1] + (1.0 - 1.0 / m_mean) * this.bp[m][2] + (1.0 - 1.0 / m_mean) * (1.0 - 2.0 / m_mean) * this.bp[m][3];
            ++m;
        }
        int k = 1;
        while (k <= this.ncomp) {
            m = 1;
            while (m <= 7) {
                this.dap_dx[k][m] = this.mseg[k] / m_mean / m_mean * this.ap[m][2] + (3.0 * this.mseg[k] / m_mean / m_mean - 4.0 * this.mseg[k] / m_mean / m_mean / m_mean) * this.ap[m][3];
                this.dbp_dx[k][m] = this.mseg[k] / m_mean / m_mean * this.bp[m][2] + (3.0 * this.mseg[k] / m_mean / m_mean - 4.0 * this.mseg[k] / m_mean / m_mean / m_mean) * this.bp[m][3];
                ++m;
            }
            ++k;
        }
        this.order1 = 0.0;
        this.order2 = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            j = 1;
            while (j <= this.ncomp) {
                this.order1 += x[i] * x[j] * this.mseg[i] * this.mseg[j] * this.sig_ij[i][j] * this.sig_ij[i][j] * this.sig_ij[i][j] * this.uij[i][j] / t;
                this.order2 += x[i] * x[j] * this.mseg[i] * this.mseg[j] * this.sig_ij[i][j] * this.sig_ij[i][j] * this.sig_ij[i][j] * (this.uij[i][j] / t) * (this.uij[i][j] / t);
                ++j;
            }
            ++i;
        }
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
    }

    void PC_SAFT_PROP(double[][] phi, int nphas, int ncomp, double t, double p) {
        double[] densys = new double[this.nph];
        double[][] x_sys = new double[this.nph][this.nc];
        double[][] parame = new double[this.nc][5];
        double[][] kij = new double[this.nc][this.nc];
        double[] enthal = new double[this.nph];
        double[] entrop = new double[this.nph];
        double[] gibbs = new double[this.nph];
        double[] d_sta = new double[this.nph];
        double[] xtrans = new double[this.nc];
        double[][] parsys = new double[this.nc][25];
        double[] fugcoe = new double[this.nc];
        int ph = 1;
        while (ph <= nphas) {
            double dstart = d_sta[ph];
            int i = 1;
            while (i <= ncomp) {
                xtrans[i] = x_sys[ph][i];
                parsys[i][1] = parame[i][1];
                parsys[i][2] = parame[i][2];
                parsys[i][3] = parame[i][3];
                ++i;
            }
            this.PHIEOS(fugcoe, xtrans, t, p);
            densys[ph] = this.den;
            i = 1;
            while (i <= ncomp) {
                phi[ph][i] = fugcoe[i];
                ++i;
            }
            enthal[ph] = this.h_res;
            entrop[ph] = this.s_res;
            gibbs[ph] = this.g_res;
            ++ph;
        }
    }

    void PHIEOS(double[] phi, double[] x, double t, double p) {
        int i;
        int nc = 20;
        double[] mhs = new double[nc];
        double[] mhc = new double[nc];
        double[] mdsp = new double[nc];
        double[] mpart = new double[nc];
        double[] myres = new double[nc];
        double[] lnphi = new double[nc];
        double[][][] dgijdx = new double[nc][nc][nc];
        double[] m_mndx = new double[nc];
        this.PERTPAR(x, t, p);
        this.DENSITR(x, t, p);
        this.F_EOS(x, t, p);
        this.H_EOS(x, t, p);
        double rho = this.dense / this.z3t;
        this.z0 = this.z0t * rho;
        this.z1 = this.z1t * rho;
        this.z2 = this.z2t * rho;
        this.z3 = this.z3t * rho;
        double zms = 1.0 - this.dense;
        double m_mean = this.z0t / (this.PI / 6.0);
        double zges = this.pges * 1.0E-30 / (this.KBOL * t * rho);
        double zres = zges - 1.0;
        int k = 1;
        while (k <= this.ncomp) {
            double z0dx = rho * this.PI / 6.0 * this.mseg[k];
            double z1dx = rho * this.PI / 6.0 * this.mseg[k] * this.sig_t[k];
            double z2dx = rho * this.PI / 6.0 * this.mseg[k] * this.sig_t[k] * this.sig_t[k];
            double z3dx = rho * this.PI / 6.0 * this.mseg[k] * this.sig_t[k] * this.sig_t[k] * this.sig_t[k];
            m_mndx[k] = this.mseg[k];
            double fhs_sg = (3.0 * this.z1 * this.z2 / zms + this.z2 * this.z2 * this.z2 / this.z3 / zms / zms + (this.z2 * this.z2 * this.z2 / this.z3 / this.z3 - this.z0) * Math.log(zms)) / this.z0;
            double fhs_sx = -z0dx / this.z0 * fhs_sg + (3.0 * (z1dx * this.z2 + this.z1 * z2dx) / zms + 3.0 * this.z1 * this.z2 * z3dx / zms / zms + 3.0 * this.z2 * this.z2 * z2dx / this.z3 / zms / zms + this.z2 * this.z2 * this.z2 * z3dx * (3.0 * this.z3 - 1.0) / this.z3 / this.z3 / zms / zms / zms + ((3.0 * this.z2 * this.z2 * z2dx * this.z3 - 2.0 * this.z2 * this.z2 * this.z2 * z3dx) / this.z3 * this.z3 * this.z3 - z0dx) * Math.log(zms) + (this.z0 - this.z2 * this.z2 * this.z2 / this.z3 / this.z3) * z3dx / zms) / this.z0;
            mhs[k] = m_mndx[k] * fhs_sg + m_mean * fhs_sx;
            i = 1;
            while (i <= this.ncomp) {
                int j = 1;
                while (j <= this.ncomp) {
                    dgijdx[i][j][k] = z3dx / zms / zms + 3.0 * this.dij_ab[i][j] * (z2dx + 2.0 * this.z2 * z3dx / zms) / zms / zms + this.dij_ab[i][j] * this.dij_ab[i][j] * this.z2 / zms / zms / zms * (4.0 * z2dx + 6.0 * this.z2 * z3dx / zms);
                    ++j;
                }
                ++i;
            }
            mhc[k] = 0.0;
            i = 1;
            while (i <= this.ncomp) {
                mhc[k] = mhc[k] + x[i] * (1.0 - this.mseg[i]) * (1.0 / this.gij[i][i]) * dgijdx[i][i][k];
                ++k;
            }
            mhc[k] = mhc[k] + (1.0 - this.mseg[k]) * Math.log(this.gij[k][k]);
            double I1 = 0.0;
            double I2 = 0.0;
            double I1_dx = 0.0;
            double I2_dx = 0.0;
            int m = 0;
            while (m <= 6) {
                I1 += this.apar[m + 1] * Math.pow(this.dense, m);
                I2 += this.bpar[m + 1] * Math.pow(this.dense, m);
                I1_dx = I1_dx + this.apar[m + 1] * (double)m * Math.pow(this.dense, m - 1) * z3dx + this.dap_dx[k][m + 1] * Math.pow(this.dense, m);
                I2_dx = I2_dx + this.bpar[m + 1] * (double)m * Math.pow(this.dense, m - 1) * z3dx + this.dbp_dx[k][m + 1] * Math.pow(this.dense, m);
                ++m;
            }
            double ord1dx = 0.0;
            double ord2dx = 0.0;
            i = 1;
            while (i <= this.ncomp) {
                ord1dx += 2.0 * this.mseg[k] * x[i] * this.mseg[i] * this.sig_ij[i][k] * this.sig_ij[i][k] * this.sig_ij[i][k] * this.uij[i][k] / t;
                ord2dx += 2.0 * this.mseg[k] * x[i] * this.mseg[i] * this.sig_ij[i][k] * this.sig_ij[i][k] * this.sig_ij[i][k] * (this.uij[i][k] / t) * (this.uij[i][k] / t);
                ++i;
            }
            double c1_con = 1.0 / (1.0 + m_mean * (8.0 * this.z3 - 2.0 * this.z3 * this.z3) / zms / zms / zms / zms + (1.0 - m_mean) * (20.0 * this.z3 - 27.0 * this.z3 * this.z3 + 12.0 * this.z3 * this.z3 * this.z3 - 2.0 * this.z3 * this.z3 * this.z3 * this.z3) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)));
            double c2_con = -c1_con * c1_con * (m_mean * (-4.0 * this.z3 * this.z3 + 20.0 * this.z3 + 8.0) / zms / zms / zms / zms / zms + (1.0 - m_mean) * (2.0 * this.z3 * this.z3 * this.z3 + 12.0 * this.z3 * this.z3 - 48.0 * this.z3 + 40.0) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)));
            double c1_dx = c2_con * z3dx - c1_con * c1_con * this.mseg[k] * ((8.0 * this.z3 - 2.0 * this.z3 * this.z3) / zms / zms / zms / zms - (-2.0 * this.z3 * this.z3 * this.z3 * this.z3 + 12.0 * this.z3 * this.z3 * this.z3 - 27.0 * this.z3 * this.z3 + 20.0 * this.z3) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)));
            mdsp[k] = -2.0 * this.PI * rho * (this.order1 * I1_dx + ord1dx * I1) - this.PI * rho * c1_con * m_mean * (this.order2 * I2_dx + ord2dx * I2) - this.PI * rho * (c1_con * this.mseg[k] + c1_dx * m_mean) * this.order2 * I2;
            mpart[k] = mhs[k] + mhc[k] + mdsp[k];
            ++k;
        }
        double myresq = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            myresq -= x[i] * mpart[i];
            ++i;
        }
        k = 1;
        while (k <= this.ncomp) {
            myres[k] = myresq + mpart[k] + this.fres + zres;
            lnphi[k] = myres[k] - Math.log(zges);
            phi[k] = Math.exp(lnphi[k]);
            ++k;
        }
    }

    void P_EOS(double[] x, double t, double p) {
        double[][] dgijdz = new double[this.nc][this.nc];
        double[][] dgijd2 = new double[this.nc][this.nc];
        double rho = this.dense / this.z3t;
        this.z0 = this.z0t * rho;
        this.z1 = this.z1t * rho;
        this.z2 = this.z2t * rho;
        this.z3 = this.z3t * rho;
        double zms = 1.0 - this.dense;
        double m_mean = this.z0t / (this.PI / 6.0);
        int i = 1;
        while (i <= this.ncomp) {
            int j = 1;
            while (j <= this.ncomp) {
                this.gij[i][j] = 1.0 / zms + 3.0 * this.dij_ab[i][j] * this.z2 / zms / zms + 2.0 * (this.dij_ab[i][j] * this.z2) * (this.dij_ab[i][j] * this.z2) / zms / zms / zms;
                dgijdz[i][j] = 1.0 / zms / zms + 3.0 * this.dij_ab[i][j] * this.z2 * (1.0 + this.z3) / this.z3 / zms / zms / zms + this.dij_ab[i][j] * this.z2 / zms / zms * (this.dij_ab[i][j] * this.z2 / zms / zms) * (4.0 + 2.0 * this.z3) / this.z3;
                dgijd2[i][j] = 2.0 / zms / zms / zms + 6.0 * this.dij_ab[i][j] * this.z2 / this.z3 / zms / zms / zms / zms * (2.0 + this.z3) + 2.0 * this.dij_ab[i][j] * this.z2 / this.z3 * (2.0 * this.dij_ab[i][j] * this.z2 / this.z3) / zms / zms / zms / zms / zms * (1.0 + 4.0 * this.z3 + this.z3 * this.z3);
                ++j;
            }
            ++i;
        }
        double zhs = m_mean * (this.z3 / zms + 3.0 * this.z1 * this.z2 / this.z0 / zms / zms + this.z2 * this.z2 * this.z2 / this.z0 * (3.0 - this.z3) / zms / zms / zms);
        double zhsdz = m_mean * (1.0 / zms / zms + 3.0 * this.z1 * this.z2 / this.z0 / this.z3 * (1.0 + this.z3) / zms / zms / zms + 6.0 * this.z2 * this.z2 * this.z2 / this.z0 / this.z3 / zms / zms / zms / zms);
        double zhc = 0.0;
        double zhcdz = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            zhc += x[i] * (1.0 - this.mseg[i]) * this.dense / this.gij[i][i] * dgijdz[i][i];
            zhcdz += x[i] * (1.0 - this.mseg[i]) * (-this.dense * (dgijdz[i][i] / this.gij[i][i]) * (dgijdz[i][i] / this.gij[i][i]) + dgijdz[i][i] / this.gij[i][i] + this.dense / this.gij[i][i] * dgijd2[i][i]);
            ++i;
        }
        double I2 = 0.0;
        double edI1dz = 0.0;
        double edI2dz = 0.0;
        double edI1d2 = 0.0;
        double edI2d2 = 0.0;
        int m = 1;
        while (m <= 6) {
            I2 += this.bpar[m + 1] * Math.pow(this.dense, m);
            edI1dz += this.apar[m + 1] * (double)(m + 1) * Math.pow(this.dense, m);
            edI2dz += this.bpar[m + 1] * (double)(m + 1) * Math.pow(this.dense, m);
            edI1d2 += this.apar[m + 1] * (double)(m + 1) * (double)m * Math.pow(this.dense, m - 1);
            edI2d2 += this.bpar[m + 1] * (double)(m + 1) * (double)m * Math.pow(this.dense, m - 1);
            ++m;
        }
        double c1_con = 1.0 / (1.0 + m_mean * (8.0 * this.dense - 2.0 * this.dense * this.dense) / zms / zms / zms / zms + (1.0 - m_mean) * (20.0 * this.dense - 27.0 * this.dense * this.dense + 12.0 * this.dense * this.dense * this.dense - 2.0 * this.dense * this.dense * this.dense * this.dense) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)));
        double c2_con = -c1_con * c1_con * (m_mean * (-4.0 * this.dense * this.dense + 20.0 * this.dense + 8.0) / zms / zms / zms / zms / zms + (1.0 - m_mean) * (2.0 * this.dense * this.dense * this.dense + 12.0 * this.dense * this.dense - 48.0 * this.dense + 40.0) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)));
        double c3_con = 2.0 * c2_con * c2_con / c1_con - c1_con * c1_con * (m_mean * (-12.0 * this.dense * this.dense + 72.0 * this.dense + 60.0) / zms / zms / zms / zms / zms / zms + (1.0 - m_mean) * (-6.0 * this.dense * this.dense * this.dense * this.dense - 48.0 * this.dense * this.dense * this.dense + 288.0 * this.dense * this.dense - 480.0 * this.dense + 264.0) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)));
        double zdsp = -2.0 * this.PI * rho * edI1dz * this.order1 - this.PI * rho * this.order2 * m_mean * (c2_con * I2 * this.dense + c1_con * edI2dz);
        double zdspdz = zdsp / this.dense - 2.0 * this.PI * rho * edI1d2 * this.order1 - this.PI * rho * this.order2 * m_mean * (c3_con * I2 * this.dense + 2.0 * c2_con * edI2dz + c1_con * edI2d2);
        double zges = 1.0 + zhs + zhc + zdsp;
        this.pges = zges * rho * (this.KBOL * t) / 1.0E-30;
        double zgesdz = zhsdz + zhcdz + zdspdz;
        this.pgesdz = (zgesdz * rho + zges * rho / this.z3) * (this.KBOL * t) / 1.0E-30;
    }

    void DENSITR(double[] x, double t, double p) {
        double acc_i = 1.0E-10;
        int max_i = 200;
        int i = 0;
        double x1 = this.densta;
        boolean start = true;
        while (start) {
            ++i;
            this.dense = x1;
            this.P_EOS(x, t, p);
            double y1 = this.pges / p - 1.0;
            double dydx = this.pgesdz / p;
            x1 -= y1 / dydx;
            if (x1 > 0.9) {
                x1 = 0.6;
            }
            if (x1 <= 0.0) {
                x1 = -9.0;
            }
            start = true;
            if (Math.abs(y1) < acc_i) {
                start = false;
            }
            if (i <= max_i) continue;
            start = false;
            System.out.println("density iteration failed");
        }
        this.dense = x1;
    }

    void F_EOS(double[] x, double t, double p) {
        double rho = this.dense / this.z3t;
        this.z0 = this.z0t * rho;
        this.z1 = this.z1t * rho;
        this.z2 = this.z2t * rho;
        this.z3 = this.z3t * rho;
        double zms = 1.0 - this.dense;
        double m_mean = this.z0t / (this.PI / 6.0);
        double fhs = m_mean * (3.0 * this.z1 * this.z2 / zms + this.z2 * this.z2 * this.z2 / this.z3 / zms / zms + (this.z2 * this.z2 * this.z2 / this.z3 / this.z3 - this.z0) * Math.log(zms)) / this.z0;
        double fhc = 0.0;
        int i = 1;
        while (i <= this.ncomp) {
            fhc += x[i] * (1.0 - this.mseg[i]) * Math.log(this.gij[i][i]);
            ++i;
        }
        double I1 = 0.0;
        double I2 = 0.0;
        int m = 1;
        while (m <= 6) {
            I1 += this.apar[m + 1] * Math.pow(this.dense, m);
            I2 += this.bpar[m + 1] * Math.pow(this.dense, m);
            ++m;
        }
        double c1_con = 1.0 / (1.0 + m_mean * (8.0 * this.dense - 2.0 * this.dense * this.dense) / zms / zms / zms / zms + (1.0 - m_mean) * (20.0 * this.dense - 27.0 * this.dense * this.dense + 12.0 * this.dense * this.dense * this.dense - 2.0 * this.dense * this.dense * this.dense * this.dense) / (zms * (2.0 - this.dense)) / (zms * (2.0 - this.dense)));
        double fdsp = -2.0 * this.PI * rho * I1 * this.order1 - this.PI * rho * c1_con * m_mean * I2 * this.order2;
        this.fres = fhs + fhc + fdsp;
    }

    void H_EOS(double[] x, double t, double p) {
        int j;
        double[] sigtdt = new double[this.nc];
        double[][] dijabdt = new double[this.nc][this.nc];
        double[][] gijdt = new double[this.nc][this.nc];
        double rho = this.dense / this.z3t;
        this.z0 = this.z0t * rho;
        this.z1 = this.z1t * rho;
        this.z2 = this.z2t * rho;
        this.z3 = this.z3t * rho;
        double zms = 1.0 - this.dense;
        double m_mean = this.z0t / (this.PI / 6.0);
        double zres = this.pges * 1.0E-30 / (this.KBOL * t * rho) - 1.0;
        double dfdr = this.pges / (this.dense * rho * (this.KBOL * t) / 1.0E-30);
        double ddfdrdr = this.pgesdz / (this.dense * rho * (this.KBOL * t) / 1.0E-30) - dfdr * 2.0 / this.dense - 1.0 / this.dense * this.dense;
        int i = 1;
        while (i <= this.ncomp) {
            sigtdt[i] = this.sig[i] * (-3.0 * this.u0k[i] / t / t) * 0.12 * Math.exp(-3.0 * this.u0k[i] / t);
            ++i;
        }
        i = 1;
        while (i <= this.ncomp) {
            j = 1;
            while (j <= this.ncomp) {
                dijabdt[i][j] = this.dij_ab[i][j] * (sigtdt[i] / this.sig_t[i] + sigtdt[j] / this.sig_t[j] - (sigtdt[i] + sigtdt[j]) / (this.sig_t[i] + this.sig_t[j]));
                ++j;
            }
            ++i;
        }
        double z1dt = 0.0;
        double z2dt = 0.0;
        double z3dt = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            z1dt += x[i] * this.mseg[i] * sigtdt[i];
            z2dt += x[i] * this.mseg[i] * 2.0 * this.sig_t[i] * sigtdt[i];
            z3dt += x[i] * this.mseg[i] * 3.0 * this.sig_t[i] * this.sig_t[i] * sigtdt[i];
            ++i;
        }
        z1dt = this.PI / 6.0 * z1dt * rho;
        z2dt = this.PI / 6.0 * z2dt * rho;
        z3dt = this.PI / 6.0 * z3dt * rho;
        i = 1;
        while (i <= this.ncomp) {
            j = 1;
            while (j <= this.ncomp) {
                gijdt[i][j] = z3dt / zms / zms + 3.0 * (dijabdt[i][j] * this.z2 + this.dij_ab[i][j] * z2dt) / zms / zms + 4.0 * this.dij_ab[i][j] * this.z2 * (1.5 * z3dt + dijabdt[i][j] * this.z2 + this.dij_ab[i][j] * z2dt) / zms / zms / zms + 6.0 * (this.dij_ab[i][j] * this.z2) * (this.dij_ab[i][j] * this.z2) * z3dt / zms / zms / zms / zms;
                ++j;
            }
            ++i;
        }
        double fhsdt = 6.0 / this.PI / rho * (3.0 * (z1dt * this.z2 + this.z1 * z2dt) / zms + 3.0 * this.z1 * this.z2 * z3dt / zms / zms + 3.0 * this.z2 * this.z2 * z2dt / this.z3 / zms / zms + this.z2 * this.z2 * this.z2 * (2.0 * this.z3 * z3dt - z3dt * zms) / (this.z3 * this.z3 * zms * zms * zms) + (3.0 * this.z2 * this.z2 * z2dt * this.z3 - 2.0 * this.z2 * this.z2 * this.z2 * z3dt) / this.z3 / this.z3 / this.z3 * Math.log(zms) + (this.PI / 6.0 * rho * m_mean - this.z2 * this.z2 * this.z2 / this.z3 / this.z3) * z3dt / zms);
        double fhcdt = 0.0;
        i = 1;
        while (i <= this.ncomp) {
            fhcdt += x[i] * (1.0 - this.mseg[i]) * gijdt[i][i] / this.gij[i][i];
            ++i;
        }
        double I1 = 0.0;
        double I2 = 0.0;
        double I1dt = 0.0;
        double I2dt = 0.0;
        int m = 1;
        while (m <= 6) {
            I1 += this.apar[m + 1] * Math.pow(this.z3, m);
            I2 += this.bpar[m + 1] * Math.pow(this.z3, m);
            I1dt += this.apar[m + 1] * z3dt * (double)m * Math.pow(this.z3, -1.0);
            I2dt += this.bpar[m + 1] * z3dt * (double)m * Math.pow(this.z3, -1.0);
            ++m;
        }
        double c1_con = 1.0 / (1.0 + m_mean * (8.0 * this.z3 - 2.0 * this.z3 * this.z3) / zms / zms / zms / zms + (1.0 - m_mean) * (20.0 * this.z3 - 27.0 * this.z3 * this.z3 + 12.0 * this.z3 * this.z3 * this.z3 - 2.0 * this.z3 * this.z3 * this.z3 * this.z3) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)));
        double c2_con = -c1_con * c1_con * (m_mean * (-4.0 * this.z3 * this.z3 + 20.0 * this.z3 + 8.0) / zms / zms / zms / zms / zms + (1.0 - m_mean) * (2.0 * this.z3 * this.z3 * this.z3 + 12.0 * this.z3 * this.z3 - 48.0 * this.z3 + 40.0) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)) / (zms * (2.0 - this.z3)));
        double c1_dt = c2_con * z3dt;
        double fdspdt = -2.0 * this.PI * rho * (I1dt - I1 / t) * this.order1 - this.PI * rho * m_mean * (c1_dt * I2 + c1_con * I2dt - 2.0 * c1_con * I2 / t) * this.order2;
        double df_dt = fhsdt + fhcdt + fdspdt;
        this.s_res = (-df_dt - this.fres / t) * this.RGAS * t + this.RGAS * Math.log(zres + 1.0);
        this.h_res = (-t * df_dt + zres) * this.RGAS * t;
        this.g_res = this.h_res - t * this.s_res;
    }
}

