/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.CompProperties;
import bibCTP.model.FluidModel;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class SpanWagnerCO2
extends FluidModel
implements Lmdif_fcn {
    double Tc = 304.1282;
    double RhoC = 467.6;
    double R = 188.9241;
    double Mw = 44.0098;
    double Pc = 7377300.0;
    double T;
    double P;
    public double RHO;
    double s;
    double u;
    double h;
    double v;
    double Phi0;
    double Phi0d;
    double Phi0dd;
    double Phi0dt;
    double Phi0t;
    double Phi0tt;
    double Phir;
    double Phird;
    double Phirdd;
    double Phirdt;
    double Phirt;
    double Phirtt;
    double TObj;
    double PObj;
    double RHOl;
    double sl;
    double ul;
    double hl;
    double RHOv;
    double sv;
    double uv;
    double hv;
    double[] NI = new double[42];
    double[] DI = new double[39];
    double[] TI = new double[39];
    double[] CI = new double[27];
    double[] AlphaI = new double[5];
    double[] BetaI = new double[8];
    double[] GammaI = new double[5];
    double[] EpsilonI = new double[5];
    double[] aI = new double[3];
    double[] bI = new double[3];
    double[] AaI = new double[3];
    double[] BBI = new double[3];
    double[] CCI = new double[3];
    double[] DDI = new double[3];
    double[] AI0 = new double[8];
    double[] ThetaI0 = new double[5];
    double PP = 1.0;
    double TT = 300.0;

    public SpanWagnerCO2() {
    }

    public SpanWagnerCO2(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "SpanWagnerCO2";
        this.init();
    }

    public String getType() {
        return "SpanWagnerCO2";
    }

    public void init() {
        this.debug = false;
        this.NI[0] = 0.38856823203161;
        this.NI[1] = 2.938547594274;
        this.NI[2] = -5.5867188534934;
        this.NI[3] = -0.76753199592477;
        this.NI[4] = 0.31729005580416;
        this.NI[5] = 0.54803315897767;
        this.NI[6] = 0.12279411220335;
        this.NI[7] = 2.165896154322;
        this.NI[8] = 1.5841735109724;
        this.NI[9] = -0.23132705405503;
        this.NI[10] = 0.058116916431436;
        this.NI[11] = -0.55369137205382;
        this.NI[12] = 0.48946615909422;
        this.NI[13] = -0.024275739843501;
        this.NI[14] = 0.062494790501678;
        this.NI[15] = -0.12175860225246;
        this.NI[16] = -0.37055685270086;
        this.NI[17] = -0.016775879700426;
        this.NI[18] = -0.11960736637987;
        this.NI[19] = -0.045619362508778;
        this.NI[20] = 0.035612789270346;
        this.NI[21] = -0.0074427727132052;
        this.NI[22] = -0.0017395704902432;
        this.NI[23] = -0.021810121289527;
        this.NI[24] = 0.024332166559236;
        this.NI[25] = -0.037440133423463;
        this.NI[26] = 0.14338715756878;
        this.NI[27] = -0.13491969083286;
        this.NI[28] = -0.02315122505348;
        this.NI[29] = 0.012363125492901;
        this.NI[30] = 0.002105832197294;
        this.NI[31] = -3.3958519026368E-4;
        this.NI[32] = 0.0055993651771592;
        this.NI[33] = -3.0335118055646E-4;
        this.NI[34] = -213.6548868832;
        this.NI[35] = 26641.569149272;
        this.NI[36] = -24027.212204557;
        this.NI[37] = -283.41603423999;
        this.NI[38] = 212.47284400179;
        this.NI[39] = -0.66642276540751;
        this.NI[40] = 0.72608632349897;
        this.NI[41] = 0.055068668612842;
        this.DI[0] = 1.0;
        this.DI[1] = 1.0;
        this.DI[2] = 1.0;
        this.DI[3] = 1.0;
        this.DI[4] = 2.0;
        this.DI[5] = 2.0;
        this.DI[6] = 3.0;
        this.DI[7] = 1.0;
        this.DI[8] = 2.0;
        this.DI[9] = 4.0;
        this.DI[10] = 5.0;
        this.DI[11] = 5.0;
        this.DI[12] = 5.0;
        this.DI[13] = 6.0;
        this.DI[14] = 6.0;
        this.DI[15] = 6.0;
        this.DI[16] = 1.0;
        this.DI[17] = 1.0;
        this.DI[18] = 4.0;
        this.DI[19] = 4.0;
        this.DI[20] = 4.0;
        this.DI[21] = 7.0;
        this.DI[22] = 8.0;
        this.DI[23] = 2.0;
        this.DI[24] = 3.0;
        this.DI[25] = 3.0;
        this.DI[26] = 5.0;
        this.DI[27] = 5.0;
        this.DI[28] = 6.0;
        this.DI[29] = 7.0;
        this.DI[30] = 8.0;
        this.DI[31] = 10.0;
        this.DI[32] = 4.0;
        this.DI[33] = 8.0;
        this.DI[34] = 2.0;
        this.DI[35] = 2.0;
        this.DI[36] = 2.0;
        this.DI[37] = 3.0;
        this.DI[38] = 3.0;
        this.TI[0] = 0.0;
        this.TI[1] = 0.75;
        this.TI[2] = 1.0;
        this.TI[3] = 2.0;
        this.TI[4] = 0.75;
        this.TI[5] = 2.0;
        this.TI[6] = 0.75;
        this.TI[7] = 1.5;
        this.TI[8] = 1.5;
        this.TI[9] = 2.5;
        this.TI[10] = 0.0;
        this.TI[11] = 1.5;
        this.TI[12] = 2.0;
        this.TI[13] = 0.0;
        this.TI[14] = 1.0;
        this.TI[15] = 2.0;
        this.TI[16] = 3.0;
        this.TI[17] = 6.0;
        this.TI[18] = 3.0;
        this.TI[19] = 6.0;
        this.TI[20] = 8.0;
        this.TI[21] = 6.0;
        this.TI[22] = 0.0;
        this.TI[23] = 7.0;
        this.TI[24] = 12.0;
        this.TI[25] = 16.0;
        this.TI[26] = 22.0;
        this.TI[27] = 24.0;
        this.TI[28] = 16.0;
        this.TI[29] = 24.0;
        this.TI[30] = 8.0;
        this.TI[31] = 2.0;
        this.TI[32] = 28.0;
        this.TI[33] = 14.0;
        this.TI[34] = 1.0;
        this.TI[35] = 0.0;
        this.TI[36] = 1.0;
        this.TI[37] = 3.0;
        this.TI[38] = 3.0;
        this.CI[0] = 1.0;
        this.CI[1] = 1.0;
        this.CI[2] = 1.0;
        this.CI[3] = 1.0;
        this.CI[4] = 1.0;
        this.CI[5] = 1.0;
        this.CI[6] = 1.0;
        this.CI[7] = 1.0;
        this.CI[8] = 1.0;
        this.CI[9] = 2.0;
        this.CI[10] = 2.0;
        this.CI[11] = 2.0;
        this.CI[12] = 2.0;
        this.CI[13] = 2.0;
        this.CI[14] = 2.0;
        this.CI[15] = 2.0;
        this.CI[16] = 3.0;
        this.CI[17] = 3.0;
        this.CI[18] = 3.0;
        this.CI[19] = 4.0;
        this.CI[20] = 4.0;
        this.CI[21] = 4.0;
        this.CI[22] = 4.0;
        this.CI[23] = 4.0;
        this.CI[24] = 4.0;
        this.CI[25] = 5.0;
        this.CI[26] = 6.0;
        this.AlphaI[0] = 25.0;
        this.AlphaI[1] = 25.0;
        this.AlphaI[2] = 25.0;
        this.AlphaI[3] = 15.0;
        this.AlphaI[4] = 20.0;
        this.BetaI[0] = 325.0;
        this.BetaI[1] = 300.0;
        this.BetaI[2] = 300.0;
        this.BetaI[3] = 275.0;
        this.BetaI[4] = 275.0;
        this.BetaI[5] = 0.3;
        this.BetaI[6] = 0.3;
        this.BetaI[7] = 0.3;
        this.GammaI[0] = 1.16;
        this.GammaI[1] = 1.19;
        this.GammaI[2] = 1.19;
        this.GammaI[3] = 1.25;
        this.GammaI[4] = 1.22;
        this.EpsilonI[0] = 1.0;
        this.EpsilonI[1] = 1.0;
        this.EpsilonI[2] = 1.0;
        this.EpsilonI[3] = 1.0;
        this.EpsilonI[4] = 1.0;
        this.aI[0] = 3.5;
        this.aI[1] = 3.5;
        this.aI[2] = 3.0;
        this.bI[0] = 0.875;
        this.bI[1] = 0.925;
        this.bI[2] = 0.875;
        this.AaI[0] = 0.7;
        this.AaI[1] = 0.7;
        this.AaI[2] = 0.7;
        this.BBI[0] = 0.3;
        this.BBI[1] = 0.3;
        this.BBI[2] = 1.0;
        this.CCI[0] = 10.0;
        this.CCI[1] = 10.0;
        this.CCI[2] = 12.5;
        this.DDI[0] = 275.0;
        this.DDI[1] = 275.0;
        this.DDI[2] = 275.0;
        this.AI0[0] = 8.37304456;
        this.AI0[1] = -3.70454304;
        this.AI0[2] = 2.5;
        this.AI0[3] = 1.99427042;
        this.AI0[4] = 0.62105248;
        this.AI0[5] = 0.41195293;
        this.AI0[6] = 1.04028922;
        this.AI0[7] = 0.08327678;
        this.ThetaI0[0] = 3.15163;
        this.ThetaI0[1] = 6.1119;
        this.ThetaI0[2] = 6.77708;
        this.ThetaI0[3] = 11.32384;
        this.ThetaI0[4] = 27.08792;
        if (this.tbs.compProp != null) {
            this.tbs.compProp[0].Tc = this.Tc;
            this.tbs.compProp[0].Pc = this.Pc;
            this.tbs.compProp[0].Vc = 1.0 / this.RhoC;
            this.tbs.compProp[0].M = this.Mw;
        }
    }

    public double getSatTemperature(double P, double x) {
        return this.Tsat(P);
    }

    public double getSatPressure(double T, double x) {
        return this.Psat(T);
    }

    public String getClassDescription() {
        return "Equation du CO2, mod\u00e8le Span & Wagner, 1996";
    }

    private void linkCTPbib() {
        if (this.tbs.compProp != null) {
            this.tbs.compProp[0].Tc = this.Tc;
            this.tbs.compProp[0].Pc = this.Pc;
            this.tbs.compProp[0].Vc = 1.0 / this.RhoC;
            this.tbs.compProp[0].M = this.Mw;
        }
    }

    public double[] calcSubstance(double T, double P_Pa, double x) {
        double v;
        double p = P_Pa;
        double[] res = new double[6];
        double h = 0.0;
        double s = 0.0;
        double u = 0.0;
        this.linkCTPbib();
        double Tsat = this.getSatTemperature(p, 0.0);
        if (T < Tsat * 0.9999 || T > Tsat * 1.0001) {
            this.RhoFuncPT(p, T);
            double[] resCO2 = this.getFunctionsRhoT(this.RHO, T);
            if (T < Tsat * 0.9999) {
                v = 1.0 / this.RHO;
                u = resCO2[0];
                h = resCO2[1];
                s = resCO2[2];
                x = 0.0;
            } else {
                v = 1.0 / this.RHO;
                u = resCO2[0];
                h = resCO2[1];
                s = resCO2[2];
                x = 1.0;
            }
        } else {
            double rhoL = this.RhoSatL(Tsat);
            double[] resCO2 = this.getFunctionsRhoT(rhoL, Tsat);
            double vl = 1.0 / rhoL;
            double ul = resCO2[0];
            double hl = resCO2[1];
            double sl = resCO2[2];
            double rhoV = this.RhoSatV(Tsat);
            resCO2 = this.getFunctionsRhoT(rhoV, Tsat);
            double vv = 1.0 / rhoV;
            double uv = resCO2[0];
            double hv = resCO2[1];
            double sv = resCO2[2];
            v = vv * x + (1.0 - x) * vl;
            u = uv * x + (1.0 - x) * ul;
            h = hv * x + (1.0 - x) * hl;
            s = sv * x + (1.0 - x) * sl;
            this.tbs.v = v / this.Mw;
        }
        res[0] = h;
        res[1] = v;
        res[2] = 0.0;
        res[3] = x;
        res[4] = u;
        res[5] = s;
        return res;
    }

    public void readXml() {
        this.tbs.compProp[0] = new CompProperties();
    }

    public void updateComp(String[] comp, double[] fract_mol) {
        this.tbs.fract_mass[0] = 1.0;
        this.tbs.initProp[0] = this.Mw;
        this.tbs.initProp[1 + this.tbs.nbComponents] = 216.7;
        this.tbs.initProp[1 + 2 * this.tbs.nbComponents] = 1100.0;
        this.tbs.initProp[1 + 3 * this.tbs.nbComponents] = 8000000.0;
    }

    public double[] getMolarWeights() {
        double[] molarMasses = new double[]{this.Mw, this.Mw, 216.7, 1100.0, 800.0};
        return molarMasses;
    }

    protected void C_Phi0(double delta, double tau) {
        this.Phi0 = Math.log(delta) + this.AI0[0] + this.AI0[1] * tau + this.AI0[2] * Math.log(tau);
        int i = 0;
        while (i <= 4) {
            this.Phi0 += this.AI0[i + 3] * Math.log(1.0 - Math.exp(-this.ThetaI0[i] * tau));
            ++i;
        }
    }

    protected void C_Phi0d(double delta, double tau) {
        this.Phi0d = 1.0 / delta;
    }

    protected void C_Phi0dd(double delta, double tau) {
        this.Phi0dd = -1.0 / delta / delta;
    }

    protected void C_Phi0dt(double delta, double tau) {
        this.Phi0dt = 0.0;
    }

    protected void C_Phi0t(double delta, double tau) {
        this.Phi0t = this.AI0[1] + this.AI0[2] / tau;
        int i = 0;
        while (i <= 4) {
            this.Phi0t += this.AI0[i + 3] * this.ThetaI0[i] * (Math.pow(1.0 - Math.exp(-this.ThetaI0[i] * tau), -1.0) - 1.0);
            ++i;
        }
    }

    protected void C_Phi0tt(double delta, double tau) {
        this.Phi0tt = -this.AI0[2] / tau / tau;
        int i = 0;
        while (i <= 4) {
            this.Phi0tt -= this.AI0[i + 3] * this.ThetaI0[i] * this.ThetaI0[i] * Math.exp(-this.ThetaI0[i] * tau) * Math.pow(1.0 - Math.exp(-this.ThetaI0[i] * tau), -2.0);
            ++i;
        }
    }

    protected void C_Phir(double delta, double tau) {
        this.Phir = 0.0;
        int i = 0;
        while (i <= 6) {
            this.Phir += this.NI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i]);
            ++i;
        }
        i = 7;
        while (i <= 33) {
            this.Phir += this.NI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i]) * Math.exp(-Math.pow(delta, this.CI[i - 7]));
            ++i;
        }
        i = 34;
        while (i <= 38) {
            this.Phir += this.NI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i]) * Math.exp(-this.AlphaI[i - 34] * Math.pow(delta - this.EpsilonI[i - 34], 2.0) - this.BetaI[i - 34] * Math.pow(tau - this.GammaI[i - 34], 2.0));
            ++i;
        }
        i = 39;
        while (i <= 41) {
            double psi = Math.exp(-this.CCI[i - 39] * (delta - 1.0) * (delta - 1.0) - this.DDI[i - 39] * (tau - 1.0) * (tau - 1.0));
            double theta = 1.0 - tau + this.AaI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), 1.0 / (2.0 * this.BetaI[i - 34]));
            double Sdelta = theta * theta + this.BBI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), this.aI[i - 39]);
            this.Phir += this.NI[i] * Math.pow(Sdelta, this.bI[i - 39]) * delta * psi;
            ++i;
        }
    }

    protected void C_Phird(double delta, double tau) {
        this.Phird = 0.0;
        int i = 0;
        while (i <= 6) {
            this.Phird += this.NI[i] * this.DI[i] * Math.pow(delta, this.DI[i] - 1.0) * Math.pow(tau, this.TI[i]);
            ++i;
        }
        i = 7;
        while (i <= 33) {
            this.Phird += this.NI[i] * Math.exp(-Math.pow(delta, this.CI[i - 7])) * (Math.pow(delta, this.DI[i] - 1.0) * Math.pow(tau, this.TI[i]) * (this.DI[i] - this.CI[i - 7] * Math.pow(delta, this.CI[i - 7])));
            ++i;
        }
        i = 34;
        while (i <= 38) {
            this.Phird += this.NI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i]) * Math.exp(-this.AlphaI[i - 34] * Math.pow(delta - this.EpsilonI[i - 34], 2.0) - this.BetaI[i - 34] * Math.pow(tau - this.GammaI[i - 34], 2.0)) * (this.DI[i] / delta - 2.0 * this.AlphaI[i - 34] * (delta - this.EpsilonI[i - 34]));
            ++i;
        }
        i = 39;
        while (i <= 41) {
            double psi = Math.exp(-this.CCI[i - 39] * (delta - 1.0) * (delta - 1.0) - this.DDI[i - 39] * (tau - 1.0) * (tau - 1.0));
            double theta = 1.0 - tau + this.AaI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), 1.0 / (2.0 * this.BetaI[i - 34]));
            double Sdelta = theta * theta + this.BBI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), this.aI[i - 39]);
            double dPsi = -2.0 * this.CCI[i - 39] * (delta - 1.0) * psi;
            double dSdelta = this.bI[i - 39] * Math.pow(Sdelta, this.bI[i - 39] - 1.0) * (delta - 1.0) * (this.AaI[i - 39] * theta * 2.0 / this.BetaI[i - 34] * Math.pow((delta - 1.0) * (delta - 1.0), 0.0 / this.BetaI[i - 34] - 1.0) + 2.0 * this.BBI[i - 39] * this.aI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), this.aI[i - 39] - 1.0));
            double delta2 = 0.99 * delta;
            double theta2 = 1.0 - tau + this.AaI[i - 39] * Math.pow((delta2 - 1.0) * (delta2 - 1.0), 1.0 / (2.0 * this.BetaI[i - 34]));
            double Sdelta2 = theta2 * theta2 + this.BBI[i - 39] * Math.pow((delta2 - 1.0) * (delta2 - 1.0), this.aI[i - 39]);
            double dSdelta_num = 10.0 * (Math.pow(Sdelta, this.bI[i - 39]) - Math.pow(Sdelta2, this.bI[i - 39]));
            if (tau < 1.02) {
                dSdelta = dSdelta_num;
            }
            this.Phird += this.NI[i] * (Math.pow(Sdelta, this.bI[i - 39]) * (psi + delta * dPsi) + dSdelta * psi * delta);
            ++i;
        }
    }

    protected void C_Phirt(double delta, double tau) {
        this.Phirt = 0.0;
        int i = 0;
        while (i <= 6) {
            this.Phirt += this.NI[i] * this.TI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i] - 1.0);
            ++i;
        }
        i = 7;
        while (i <= 33) {
            this.Phirt += this.NI[i] * this.TI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i] - 1.0) * Math.exp(-Math.pow(delta, this.CI[i - 7]));
            ++i;
        }
        i = 34;
        while (i <= 38) {
            this.Phirt += this.NI[i] * Math.pow(delta, this.DI[i]) * Math.pow(tau, this.TI[i]) * Math.exp(-this.AlphaI[i - 34] * Math.pow(delta - this.EpsilonI[i - 34], 2.0) - this.BetaI[i - 34] * Math.pow(tau - this.GammaI[i - 34], 2.0)) * (this.TI[i] / tau - 2.0 * this.BetaI[i - 34] * (tau - this.GammaI[i - 34]));
            ++i;
        }
        i = 39;
        while (i <= 41) {
            double psi = Math.exp(-this.CCI[i - 39] * (delta - 1.0) * (delta - 1.0) - this.DDI[i - 39] * (tau - 1.0) * (tau - 1.0));
            double theta = 1.0 - tau + this.AaI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), 1.0 / (2.0 * this.BetaI[i - 34]));
            double Sdelta = theta * theta + this.BBI[i - 39] * Math.pow((delta - 1.0) * (delta - 1.0), this.aI[i - 39]);
            double dPsi = -2.0 * this.DDI[i - 39] * (tau - 1.0) * psi;
            double dSdelta = -2.0 * theta * this.bI[i - 39] * Math.pow(Sdelta, this.bI[i - 39] - 1.0);
            this.Phirt += this.NI[i] * delta * (dSdelta * psi + Math.pow(Sdelta, this.bI[i - 39]) * dPsi);
            ++i;
        }
    }

    protected void C_Phirdd(double delta, double tau) {
    }

    protected void C_Phirdt(double delta, double tau) {
    }

    protected void C_Phirtt(double delta, double tau) {
    }

    protected double[] getFunctionsRhoT(double Rho1, double T1) {
        double[] res = new double[3];
        double tau = this.Tc / T1;
        double delta = Rho1 / this.RhoC;
        this.C_Phi0t(delta, tau);
        this.C_Phirt(delta, tau);
        this.C_Phi0(delta, tau);
        this.C_Phir(delta, tau);
        this.C_Phird(delta, tau);
        res[0] = tau * this.R * T1 * (this.Phi0t + this.Phirt) / 1000.0;
        res[1] = res[0] + this.R * T1 * (1.0 + delta * this.Phird) / 1000.0;
        res[2] = this.R * (tau * (this.Phi0t + this.Phirt) - this.Phi0 - this.Phir) / 1000.0;
        return res;
    }

    protected double PFuncRhoT(double Rho1, double T1) {
        double tau = this.Tc / T1;
        double delta = Rho1 / this.RhoC;
        this.C_Phird(delta, tau);
        return Rho1 * this.R * T1 * (1.0 + delta * this.Phird);
    }

    protected double uFuncRhoT(double Rho1, double T1) {
        double tau = this.Tc / T1;
        double delta = Rho1 / this.RhoC;
        this.C_Phi0t(delta, tau);
        this.C_Phirt(delta, tau);
        return tau * this.R * T1 * (this.Phi0t + this.Phirt);
    }

    protected double hFuncRhoT(double Rho1, double T1) {
        double tau = this.Tc / T1;
        double delta = Rho1 / this.RhoC;
        this.C_Phi0t(delta, tau);
        this.C_Phirt(delta, tau);
        this.C_Phird(delta, tau);
        return this.R * T1 * (tau * (this.Phi0t + this.Phirt) + 1.0 + delta * this.Phird);
    }

    protected double SFuncRhoT(double Rho1, double T1) {
        double tau = this.Tc / T1;
        double delta = Rho1 / this.RhoC;
        this.C_Phi0t(delta, tau);
        this.C_Phirt(delta, tau);
        this.C_Phi0(delta, tau);
        this.C_Phir(delta, tau);
        return this.R * (tau * (this.Phi0t + this.Phirt) - this.Phi0 - this.Phir);
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("RhoFuncPT")) {
            fvec[1] = this.resRhoFuncPT(this.PP, this.TT, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("Tsat")) {
            this.TT = x[1];
            fvec[1] = this.Psat(this.TT) - this.tbs.Pparam;
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    protected double resRhoFuncPT(double P1, double T1, double[] x) {
        this.RHO = x[1];
        return P1 - this.PFuncRhoT(this.RHO, T1);
    }

    protected double RhoFuncPT(double P1, double T1) {
        double[] res = new double[1];
        double[] init = new double[3];
        double Psat = this.Psat(T1);
        if (P1 < this.Pc) {
            if (T1 < this.Tc && P1 > Psat) {
                init[1] = this.RhoSatL(T1);
                if (this.debug) {
                    System.out.println("T1 " + T1 + " RhoSatL " + " P1 " + P1 + " rho " + init[1]);
                }
            } else {
                init[1] = P1 / T1 / this.R;
                if (this.debug) {
                    System.out.println("T1 " + T1 + " ideal " + " P1 " + P1 + " rho " + init[1]);
                }
            }
        } else {
            init[1] = -1153.0 * Math.log(T1) + 7413.4;
            init[1] = -1.04853E-5 * T1 * T1 * T1 + 0.022224345 * T1 * T1 - 15.65452826 * T1 + 3814.257362;
            init[1] = -2.24997E-5 * T1 * T1 * T1 + 0.043404963 * T1 * T1 - 26.87072752 * T1 + 5426.1299;
            if (this.debug) {
                System.out.println("T1 " + T1 + " P1>Pc " + " P1 " + P1 + " rho " + init[1]);
            }
        }
        this.PP = P1;
        this.TT = T1;
        this.callFunction = "RhoFuncPT";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-7);
        res[0] = result[0];
        return res[0];
    }

    protected double RhoSatL(double T) {
        if (T > this.Tc) {
            return this.RhoC;
        }
        double Rosat = 0.0;
        double[] ai = new double[]{1.9245108, -0.62385555, -0.32731127, 0.39245142};
        double[] ti = new double[]{0.34, 0.5, 1.6666667, 1.833333};
        int i = 0;
        while (i < 4) {
            Rosat += ai[i] * Math.pow(1.0 - T / this.Tc, ti[i]);
            ++i;
        }
        return this.RhoC * Math.exp(Rosat);
    }

    protected double RhoSatV(double T) {
        if (T > this.Tc) {
            return this.RhoC;
        }
        double Rosat = 0.0;
        double[] ai = new double[]{-1.7074879, -0.8227467, -4.6008549, -10.111178, -29.742252};
        double[] ti = new double[]{0.34, 0.5, 1.0, 2.33333, 4.6666667};
        int i = 0;
        while (i < 5) {
            Rosat += ai[i] * Math.pow(1.0 - T / this.Tc, ti[i]);
            ++i;
        }
        return this.RhoC * Math.exp(Rosat);
    }

    protected double Psat(double T) {
        if (T > this.Tc) {
            return this.Pc;
        }
        double Psat = 0.0;
        double[] ai = new double[]{-7.0602087, 1.9391218, -1.6463597, -3.2995634};
        double[] ti = new double[]{1.0, 1.5, 2.0, 4.0};
        int i = 0;
        while (i < 4) {
            double t = 1.0 - T / this.Tc;
            Psat += this.Tc / T * ai[i] * Math.pow(t, ti[i]);
            ++i;
        }
        double P = Psat;
        double rhov = this.RhoSatV(T);
        double rhol = this.RhoSatL(T);
        return this.Pc * Math.exp(P);
    }

    protected double Tsat(double P) {
        if (P > this.Pc) {
            return this.Tc;
        }
        double Tsat = 300.0;
        double[] res = new double[1];
        double[] init = new double[3];
        this.tbs.Pparam = P;
        init[1] = 300.0;
        this.callFunction = "Tsat";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-7);
        res[0] = result[1];
        Tsat = res[0];
        return Tsat;
    }

    protected double[] solveWithMinPack(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec = new double[mm + 1];
        double[] x = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            x[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn(mm, n, x, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        this.nfev = 0;
        this.njev = 0;
        double epsfcn = 1.0E-9;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)this, (int)mm, (int)n, (double[])x, (double[])fvec, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        if (this.debug) {
            System.out.println();
        }
        if (this.debug) {
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
        }
        if (this.debug) {
            System.out.println("Final L2 norm of the residuals: " + residu1);
        }
        if (this.debug) {
            System.out.println("Number of function evaluations: " + this.nfev);
        }
        if (this.debug) {
            System.out.println("Number of Jacobian evaluations: " + this.njev);
        }
        if (this.debug) {
            System.out.println("Info value: " + info[1]);
        }
        if (this.debug) {
            System.out.println("Final approximate solution: " + callFunction + "   " + x[1]);
        }
        if (this.debug) {
            System.out.println();
        }
        return x;
    }
}

