/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.model;

import bibCTP.CTPbibSubstance;
import bibCTP.model.FluidModel;
import bibCTP.model.H2O;
import bibCTP.model.NH3;
import extThopt.Util;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn2;
import optimization.Minpack2_f77;
import org.jdom.Element;

public class ZieglerTreppNH3H2O
extends FluidModel
implements Lmdif_fcn2 {
    double[] E = new double[17];
    double F1;
    double F2;
    double F3;
    public NH3 nh3;
    public H2O h2o;
    public double NH3 = 0.99999999;
    public double H2O = 1.0E-8;
    public double TEST = 1.0E-10;
    public double testy = 1.0E-5;
    public double test_temp = 0.01;
    public double TMIN = 210.0;
    public double TMAX = 1000.0;
    public double PMIN = 0.02;
    public double PMAX = 70.0;
    public double TB = 100.0;
    public double PB = 10.0;
    public double N = 7.0;
    public double Mnh3 = 17.0;
    public double Mh2o = 18.0;
    public double TK = 273.15;
    public double R = 8.314;
    double hlm;
    double hvm;
    double slm;
    double svm;
    double vlm;
    double vvm;
    double pr;
    double tr;
    public double glc;
    public double hlc;
    public double slc;
    public double vlc;
    public double gvc;
    public double hvc;
    public double svc;
    public double vvc;
    double PR;
    double TR;
    double zmel;
    double ymel;
    double xmel;
    double GLM;
    double HLM;
    double SLM;
    double VLM;
    double GVM;
    double HVM;
    double SVM;
    double VVM;
    double UEL;
    double UAL;
    double alfa;
    double xm;
    double ym;
    double hm;
    double sm;
    double vm;
    double tsatl;
    double xlsat;
    double hlsat;
    double slsat;
    double vlsat;
    double hvsat;
    double yvsat;
    double svsat;
    double vvsat;
    double tsatnh3;
    double tsath2o;
    double psatnh3;
    double psath2o;
    public double Tbulle = 0.0;
    public double Pbulle = 0.0;
    public double Trosee = 0.0;
    public double Prosee = 0.0;
    double Tentree;
    double Pentree;
    double TitreEntree;
    double Tinit;
    double deltaTr1;
    double deltaTr2;
    double deltaPr1;
    double deltaPr2;
    double yXliquid;
    double y2Xliquid;
    double xmelBulle;
    double xmelRosee;
    public double[] qi = new double[]{1.11, 0.53, 0.8, 1.08, 0.55, 0.35, 0.6, 0.1, 0.1, 0.85, 0.9, 1.0, 0.76, 1.1, 1.5, 0.0};
    public double[] ri = new double[]{0.0, 0.66, 1.02, 1.4, 1.1, 2.0, 1.0, 1.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 13.0, 1.12};
    public double[] si = new double[]{0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 0.0, 1.0, 2.0, 3.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0};
    public double[] ai = new double[]{0.0, 0.6862, -0.1223, 0.03215, -0.001288, -3.355E-5, -1.181, -0.005287, 0.001947, 8.481E-4, -2.888, 13.89, -0.07483, -12.01, -0.1027, 0.0};
    public double[] qdi = new double[]{4.3, 6.0, 3.03, 3.05, 37.0, 2.7, 5.0, 4.0, 3.1, 3.01, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.1, 3.0, 0.0};
    public double[] rdi = new double[]{0.0, 1.1, 2.2, 2.2, 2.7, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0, 6.0, 7.0, 1.05};
    public double[] sdi = new double[]{0.0, 0.0, 1.0, 2.0, 3.0, 0.0, 1.0, 2.0, 0.0, 1.0, 0.0, 1.0, 0.0, 2.0, 0.0, 2.0, 0.0, 2.0, 0.0};
    public double[] adi = new double[]{0.0, 2.822, -17.05, -1.592, 0.04388, -6.151, 0.2648, 0.2028, -7.961, 14.27, 46.96, 2.699, -91.9, 5.545, 81.52, -5.084, -24.18, 0.9451, 0.0};
    int nfev2 = 0;
    int njev2 = 0;
    String callFunction2 = "";
    boolean calculPrecis = true;

    public ZieglerTreppNH3H2O() {
        this.name = "ZieglerTreppNH3H2O";
        this.init();
    }

    public ZieglerTreppNH3H2O(CTPbibSubstance tbs) {
        super(tbs);
        this.name = "ZieglerTreppNH3H2O";
        this.init();
    }

    public String getType() {
        return "ZieglerTreppNH3H2O";
    }

    public void init() {
        this.debug = false;
        this.E[1] = -46.26129;
        this.E[2] = 0.02060225;
        this.E[3] = 7.292369;
        this.E[4] = -0.01032613;
        this.E[5] = 80.74824;
        this.E[6] = -84.61214;
        this.E[7] = 24.52882;
        this.E[8] = 0.009598767;
        this.E[9] = -1.475383;
        this.E[10] = -0.005038107;
        this.E[11] = -96.40398;
        this.E[12] = 122.6973;
        this.E[13] = -7.582637;
        this.E[14] = 6.012445E-4;
        this.E[15] = 54.87018;
        this.E[16] = -76.67596;
        this.nh3 = new NH3();
        this.h2o = new H2O();
    }

    public String getClassDescription() {
        return "Syst\u00e8me NH3-H2O mod\u00e8le Ziegler & Trepp, 1984, fractions molaires";
    }

    public double[] getMolarWeights() {
        double[] molarMasses = new double[]{this.molarMass(this.getZmel()), this.Mnh3, this.Mh2o, this.TMIN, this.TMAX, this.PMAX};
        return molarMasses;
    }

    public boolean isMolarFraction() {
        return true;
    }

    public double getSatPressure(double T, double x) {
        double Psat = 0.0;
        if (x == 0.0) {
            Psat = this.Pbulle(T, this.getZmel()) * 100000.0;
        } else if (x == 1.0) {
            Psat = this.Prosee(T, this.getZmel()) * 100000.0;
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Psat;
    }

    public double getSatTemperature(double P, double quality) {
        double Tsat = 0.0;
        if (quality == 0.0) {
            Tsat = this.Tbulle(P / 100000.0, this.getZmel());
        } else if (quality == 1.0) {
            Tsat = this.Trosee(P / 100000.0, this.getZmel());
        } else {
            String message = "Watch out! the quality must be 0 or 1";
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        return Tsat;
    }

    public void updateComp(String[] comp, double[] fract_mol) {
        this.setZmel(fract_mol[0]);
        this.calcMixProps();
    }

    public void calcMixProps() {
        double mixM;
        this.tbs.initProp[0] = mixM = this.molarMass(this.getZmel());
        this.tbs.initProp[1 + this.tbs.nbComponents] = this.TMIN;
        this.tbs.initProp[1 + 2 * this.tbs.nbComponents] = this.TMAX;
        this.tbs.initProp[1 + 3 * this.tbs.nbComponents] = this.PMAX * 100000.0;
        this.tbs.initProp[2 + this.tbs.nbComponents] = this.TMIN;
        this.tbs.initProp[2 + 2 * this.tbs.nbComponents] = this.TMAX;
        this.tbs.initProp[2 + 3 * this.tbs.nbComponents] = this.PMAX * 100000.0;
        this.tbs.fract_mass[0] = this.Mnh3 * this.getZmel() / mixM;
        this.tbs.fract_mass[1] = this.Mh2o * (1.0 - this.getZmel()) / mixM;
    }

    private void linkCTPbib() {
        if (this.tbs.compProp != null) {
            this.tbs.compProp[0].Tc = 405.4;
            this.tbs.compProp[0].Pc = 1.13336E7;
            this.tbs.compProp[0].Vc = 0.0044444444444444444;
            this.tbs.compProp[0].M = this.Mnh3;
            this.tbs.compProp[1].Tc = 647.14;
            this.tbs.compProp[1].Pc = 2.2064E7;
            this.tbs.compProp[1].Vc = 0.003105590062111801;
            this.tbs.compProp[1].M = this.Mh2o;
            this.tbs.zz[0] = this.getZmel();
            this.tbs.zz[1] = 1.0 - this.getZmel();
        }
    }

    public double[] calcSubstance(double T, double P_Pa, double quality) {
        double x = this.getZmel();
        double p = P_Pa / 100000.0;
        double[] res = new double[10];
        double h = 0.0;
        double s = 0.0;
        double v = 0.0;
        this.Pentree = p;
        this.Tentree = T;
        this.relativePT(this.Pentree, this.Tentree);
        this.linkCTPbib();
        double Tbulle = this.getSatTemperature(P_Pa, 0.0);
        double Trosee = this.getSatTemperature(P_Pa, 1.0);
        double tBulle = Tbulle - 273.15;
        double mixM = this.molarMass(x);
        if (T < Tbulle || T > Trosee) {
            this.relativePT(this.Pentree, this.Tentree);
            this.corpsPurs(this.PR, this.TR);
            this.calcMelange(this.PR, this.TR, x, x);
            if (T < Tbulle) {
                v = this.vlc;
                h = this.hlc;
                s = this.slc;
                quality = 0.0;
            } else if (T > Trosee) {
                v = this.vvc;
                h = this.hvc;
                s = this.svc;
                quality = 1.0;
            }
        } else {
            this.xlsat = this.getXl(this.Pentree, x);
            double Tl = this.Tbulle(this.Pentree, this.xlsat);
            double xsatMass = this.massFraction(this.xlsat);
            System.out.println("xlsat: " + this.xlsat + "  xsatMass: " + xsatMass + "  Tl: " + Tl);
            this.relativePT(this.Pentree, Tl);
            this.corpsPurs(this.PR, this.TR);
            this.calcMelange(this.PR, this.TR, this.xlsat, x);
            double liqM = this.molarMass(this.xlsat);
            this.hlsat = this.R * this.TB * this.HLM / liqM;
            this.slsat = this.R * this.SLM / liqM;
            this.vlsat = this.R * this.TB * this.VLM / liqM;
            System.out.println("hlsat: " + this.hlsat + "  slsat: " + this.slsat + "  vlsat: " + this.vlsat);
            this.yvsat = this.getYv(this.Pentree, x);
            double Tv = this.Trosee(this.Pentree, this.yvsat);
            double ysatMass = this.massFraction(this.yvsat);
            System.out.println("yvsat: " + this.yvsat + "  ysatMass: " + ysatMass + "  Tv: " + Tv);
            this.relativePT(this.Pentree, Tv);
            this.corpsPurs(this.PR, this.TR);
            this.calcMelange(this.PR, this.TR, x, this.yvsat);
            double vapM = this.molarMass(this.yvsat);
            this.hvsat = this.R * this.TB * this.HVM / vapM;
            this.svsat = this.R * this.SVM / vapM;
            this.vvsat = this.R * this.TB * this.VVM / vapM;
            System.out.println("hvsat: " + this.hvsat + "  svsat: " + this.svsat + "  vvsat: " + this.vvsat);
            this.relativePT(this.Pentree, this.Tentree);
            mixM = this.molarMass(this.getZmel());
            quality = (this.xlsat * this.Mnh3 / liqM - this.getZmel() * this.Mnh3 / mixM) / (this.xlsat * this.Mnh3 / liqM - this.yvsat * this.Mnh3 / vapM);
            System.out.println("titre 2: " + quality + "  Tentree: " + this.Tentree);
            if (quality < 1.0E-5) {
                quality = 0.0;
            }
            if (quality > 0.99999) {
                quality = 1.0;
            }
            v = this.vvsat * quality + (1.0 - quality) * this.vlsat;
            h = this.hvsat * quality + (1.0 - quality) * this.hlsat;
            s = this.svsat * quality + (1.0 - quality) * this.slsat;
            if (this.isMolarFraction()) {
                res[6] = this.xlsat;
                res[8] = this.yvsat;
                res[7] = 1.0 - this.xlsat;
                res[9] = 1.0 - this.yvsat;
            } else {
                res[6] = xsatMass;
                res[8] = ysatMass;
                res[7] = 1.0 - xsatMass;
                res[9] = 1.0 - ysatMass;
            }
        }
        res[0] = h;
        res[1] = v / 1000.0;
        res[2] = 0.0;
        res[3] = quality;
        res[4] = res[0] - p * res[1] / 100.0;
        res[5] = s;
        return res;
    }

    protected double getTdewFitted(double P, double x) {
        double TroseeEst = 0.0;
        double T0 = 100.0;
        double P0 = 20.0;
        int i = 1;
        while (i < 18) {
            TroseeEst += T0 * (this.adi[i] * Math.pow(x, this.qdi[i] / 4.0) * Math.pow(1.0 - x, this.rdi[i] / 4.0) * Math.pow(Math.log(P0 / P), this.sdi[i]));
            ++i;
        }
        double a0 = (177.9 * Math.pow(P / 10.0, 0.09397) + 40.28 * Math.pow(P / 10.0, 0.3898) + 79.83) / 100.0;
        double a18 = (269.8 * Math.pow(P / 10.0, 0.08939) + 52.79 * Math.pow(P / 10.0, 0.3663) + 130.4) / 100.0;
        TroseeEst += T0 * (a0 * Math.pow(x, this.qdi[0] / 4.0) * Math.pow(1.0 - x, this.rdi[0] / 4.0) * Math.pow(Math.log(P0 / P), this.sdi[0]));
        return TroseeEst += T0 * (a18 * Math.pow(x, this.qdi[18] / 4.0) * Math.pow(1.0 - x, this.rdi[18] / 4.0) * Math.pow(Math.log(P0 / P), this.sdi[18]));
    }

    protected double getTbubbleFitted(double P, double x) {
        double TbulleEst = 0.0;
        double T0 = 100.0;
        double P0 = 20.0;
        int i = 1;
        while (i < 15) {
            TbulleEst += T0 * (this.ai[i] * Math.pow(x, this.qi[i]) * Math.pow(1.0 - x, this.ri[i]) * Math.pow(Math.log(P0 / P), this.si[i]));
            ++i;
        }
        double a0 = (177.9 * Math.pow(P / 10.0, 0.09397) + 40.28 * Math.pow(P / 10.0, 0.3898) + 79.83) / 100.0;
        double a15 = (269.8 * Math.pow(P / 10.0, 0.08939) + 52.79 * Math.pow(P / 10.0, 0.3663) + 130.4) / 100.0;
        TbulleEst += T0 * (a0 * Math.pow(x, this.qi[0]) * Math.pow(1.0 - x, this.ri[0]) * Math.pow(Math.log(P0 / P), this.si[0]));
        return TbulleEst += T0 * (a15 * Math.pow(x, this.qi[15]) * Math.pow(1.0 - x, this.ri[15]) * Math.pow(Math.log(P0 / P), this.si[15]));
    }

    protected double getPdew(double T, double x) {
        this.Tentree = T;
        double[] init = new double[3];
        init[1] = 10.0;
        this.TitreEntree = x;
        this.callFunction = "getPdew";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        this.Prosee = result[1];
        return result[1];
    }

    protected double getPbubble(double T, double x) {
        this.Tentree = T;
        this.Tinit = T;
        double[] init = new double[3];
        init[1] = 10.0;
        this.TitreEntree = x;
        this.callFunction = "getPbubble";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        this.Pbulle = result[1];
        return result[1];
    }

    protected double resPBulle(double[] x) {
        double p = x[1];
        double T = this.getTbubbleFitted(p, this.TitreEntree);
        System.out.println("getTbubbleFitted " + T + "  Tentree " + this.Tentree);
        double res = T - this.Tentree;
        return res;
    }

    protected double resProsee(double[] x) {
        double p = x[1];
        double T = this.getTdewFitted(p, this.TitreEntree);
        double res = T - this.Tentree;
        return res;
    }

    protected void fiFunctions(double TR, double PR) {
        this.F1 = this.E[1] + this.E[2] * PR + (this.E[3] + this.E[4] * PR) * TR + this.E[5] / TR + this.E[6] / TR / TR;
        this.F2 = this.E[7] + this.E[8] * PR + (this.E[9] + this.E[10] * PR) * TR + this.E[11] / TR + this.E[12] / TR / TR;
        this.F3 = this.E[13] + this.E[14] * PR + this.E[15] / TR + this.E[16] / TR / TR;
    }

    protected double molFraction(double ZM) {
        return ZM / this.Mnh3 / (ZM / this.Mnh3 + (1.0 - ZM) / this.Mh2o);
    }

    protected double molarMass(double ZM) {
        return ZM * this.Mnh3 + (1.0 - ZM) * this.Mh2o;
    }

    protected double massFraction(double ZM) {
        return ZM * this.Mnh3 / (this.Mh2o - ZM);
    }

    protected void potentielChimique(double pr, double tr, double X) {
        this.calculF(pr, tr);
        double DF1DX = X * X * (this.F1 + this.F2 * (2.0 * X - 1.0) + this.F3 * (2.0 * X - 1.0) * (2.0 * X - 1.0));
        this.UEL = X >= 1.0 ? -1.0E200 : this.h2o.gl + tr * Math.log(1.0 - X) + (DF1DX -= X * X * (1.0 - X) * (2.0 * this.F2 + 4.0 * this.F3 * (2.0 * X - 1.0)));
        double DF2DX = (1.0 - X) * (1.0 - X) * (this.F1 + this.F2 * (2.0 * X - 1.0) + this.F3 * (2.0 * X - 1.0) * (2.0 * X - 1.0));
        this.UAL = X <= 0.0 ? -1.0E200 : this.nh3.gl + tr * Math.log(X) + (DF2DX += (1.0 - X) * (1.0 - X) * X * (2.0 * this.F2 + 4.0 * this.F3 * (2.0 * X - 1.0)));
    }

    protected void conversions(double x, double y, double p, double t, double gl, double hl, double sl, double vl, double gv, double hv, double sv, double vv) {
        this.xm = this.massFraction(x);
        this.ym = this.massFraction(y);
        if (x >= this.NH3) {
            this.ym = 1.0;
        }
        if (x <= this.H2O) {
            this.ym = 0.0;
        }
        p = this.pr * this.PB;
        t = this.tr * this.TB - this.TK;
        this.glc = this.R * this.TB * gl / this.molarMass(x);
        this.hlc = this.R * this.TB * hl / this.molarMass(x);
        this.slc = this.R * sl / this.molarMass(x);
        this.vlc = this.R * this.TB * vl / this.molarMass(x);
        this.gvc = this.R * this.TB * gv / this.molarMass(y);
        this.hvc = this.R * this.TB * hv / this.molarMass(y);
        this.svc = this.R * sv / this.molarMass(y);
        this.vvc = this.R * this.TB * vv / this.molarMass(y);
    }

    protected void calculF(double PR, double TR) {
        this.F1 = this.E[1] + this.E[2] * PR + (this.E[3] + this.E[4] * PR) * TR + this.E[5] / TR + this.E[6] / TR / TR;
        this.F2 = this.E[7] + this.E[8] * PR + (this.E[9] + this.E[10] * PR) * TR + this.E[11] / TR + this.E[12] / TR / TR;
        this.F3 = this.E[13] + this.E[14] * PR + this.E[15] / TR + this.E[16] / TR / TR;
    }

    protected void liquidMelange(double TR, double PR, double X) {
        double F = X * (1.0 - X) * (this.F1 + this.F2 * (2.0 * X - 1.0) + this.F3 * (2.0 * X - 1.0) * (2.0 * X - 1.0));
        double DF1DTR = this.E[3] + this.E[4] * PR - this.E[5] / TR / TR - 2.0 * this.E[6] / TR / TR / TR;
        double DF2DTR = this.E[9] + this.E[10] * PR - this.E[11] / TR / TR - 2.0 * this.E[12] / TR / TR / TR;
        double DF3DTR = -this.E[15] / TR / TR - 2.0 * this.E[16] / TR / TR / TR;
        double Z1 = this.F1 - TR * DF1DTR;
        double Z2 = this.F2 - TR * DF2DTR;
        double Z3 = this.F3 - TR * DF3DTR;
        double DF1DP = this.E[2] + this.E[4] * TR;
        double DF2DP = (this.E[8] + this.E[10] * TR) * (2.0 * X - 1.0);
        double DF3DP = this.E[14] * (2.0 * X - 1.0) * (2.0 * X - 1.0);
        this.GLM = (1.0 - X) * this.h2o.gl + X * this.nh3.gl + TR * ((1.0 - X) * Math.log(1.0 - X) + X * Math.log(X)) + F;
        double HEXE = X * (1.0 - X) * (Z1 + (2.0 * X - 1.0) * Z2 + (2.0 * X - 1.0) * (2.0 * X - 1.0) * Z3);
        this.HLM = (1.0 - X) * this.h2o.hl + X * this.nh3.hl + HEXE;
        double SEXE = X * (1.0 - X) * (DF1DTR + DF2DTR * (2.0 * X - 1.0) + DF3DTR * (2.0 * X - 1.0) * (2.0 * X - 1.0));
        this.SLM = (1.0 - X) * this.h2o.sl + X * this.nh3.sl - (1.0 - X) * Math.log(1.0 - X) - X * Math.log(X) - SEXE;
        this.VLM = (1.0 - X) * this.h2o.vl + X * this.nh3.vl + X * (1.0 - X) * (DF1DP + DF2DP + DF3DP);
    }

    protected void vapeurMelange(double TR, double y) {
        if (y <= 0.0) {
            y = this.H2O;
        }
        if (y >= 1.0) {
            y = this.NH3;
        }
        this.GVM = (1.0 - y) * this.h2o.gv + y * this.nh3.gv + TR * ((1.0 - y) * Math.log(1.0 - y) + y * Math.log(y));
        this.HVM = (1.0 - y) * this.h2o.hv + y * this.nh3.hv;
        this.SVM = (1.0 - y) * this.h2o.sv + y * this.nh3.sv - (1.0 - y) * Math.log(1.0 - y) - y * Math.log(y);
        this.VVM = (1.0 - y) * this.h2o.vv + y * this.nh3.vv;
    }

    protected void calcMelange(double pr, double tr, double X, double Y) {
        this.calculF(pr, tr);
        this.liquidMelange(tr, pr, X);
        this.vapeurMelange(tr, Y);
        this.conversions(X, Y, pr, tr, this.GLM, this.HLM, this.SLM, this.VLM, this.GVM, this.HVM, this.SVM, this.VVM);
    }

    protected void relativePT(double p, double t) {
        this.PR = p / this.PB;
        this.TR = t / this.TB;
    }

    public void fcn2(int m, int n, double[] x, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev2;
        }
        if (iflag[1] == 2) {
            ++this.njev2;
        }
        if (this.callFunction2.equals("resXliquid")) {
            fvec[1] = this.resXliquid(this.PR * this.PB, x);
            if (this.debug) {
                System.out.println("resXliquid 2 fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction2.equals("resYvapor")) {
            fvec[1] = this.resYvapor(this.PR * this.PB, x);
            if (this.debug) {
                System.out.println("resYvapor 2 fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    protected double getYv(double P, double z) {
        double yv = 0.0;
        double[] init = new double[3];
        init[1] = z;
        this.callFunction2 = "resYvapor";
        double[] result = this.solveWithMinPack2(1, this.callFunction2, init, 1.0E-6);
        yv = result[1];
        return yv;
    }

    protected double resYvapor(double P, double[] x) {
        double xl = x[1];
        double T = this.Trosee(this.Pentree, xl);
        double res = T - this.Tentree;
        return res;
    }

    protected double getXl(double P, double z) {
        double xl = 0.0;
        this.relativePT(P, this.Tentree);
        this.PR = P / this.PB;
        this.TR = this.Tentree / this.TB;
        double[] init = new double[4];
        init[1] = 0.5;
        init[2] = 0.95;
        this.callFunction2 = "resXliquid";
        double[] result = this.solveWithMinPack2(1, this.callFunction2, init, 1.0E-6);
        xl = result[1];
        return xl;
    }

    protected double resXliquid(double P, double[] x) {
        if (x[1] < 0.0) {
            x[1] = 0.001;
        }
        if (x[1] > 1.0) {
            x[1] = 0.999;
        }
        double xl = x[1];
        double T = this.Tbulle(this.Pentree, xl);
        double res = T - this.Tentree;
        return res;
    }

    protected double Tbulle(double P, double z) {
        if (!this.calculPrecis) {
            return this.getTbubbleFitted(P, z);
        }
        this.relativePT(P, 300.0);
        double[] init = new double[3];
        init[1] = this.getTbubbleFitted(P, this.TitreEntree);
        this.ymel = this.getZmel();
        this.xmelBulle = z;
        this.callFunction = "resBulle";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        this.Tbulle = result[1];
        return result[1];
    }

    protected double Pbulle(double T, double z) {
        if (!this.calculPrecis) {
            return this.getPbubble(T, z);
        }
        this.relativePT(100000.0, T);
        double[] init = new double[3];
        init[1] = this.getPbubble(T, this.TitreEntree);
        this.ymel = this.getZmel();
        this.callFunction = "resPrBulle";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        this.Pbulle = result[1];
        return result[1];
    }

    protected double Trosee(double P, double z) {
        if (!this.calculPrecis) {
            return this.getTdewFitted(P, z);
        }
        this.relativePT(P, 300.0);
        double[] init = new double[4];
        this.xmelRosee = z;
        init[1] = this.getTdewFitted(P, this.xmelRosee);
        init[2] = 0.5;
        this.callFunction = "resRosee";
        double[] result = this.solveWithMinPack(2, this.callFunction, init, 1.0E-6);
        this.Trosee = result[1];
        return result[1];
    }

    protected double Prosee(double T, double z) {
        if (!this.calculPrecis) {
            return this.getPdew(T, z);
        }
        this.relativePT(100000.0, T);
        double[] init = new double[4];
        init[1] = this.getPdew(T, this.getZmel());
        init[2] = 0.5;
        this.callFunction = "resPrRosee";
        double[] result = this.solveWithMinPack(2, this.callFunction, init, 1.0E-6);
        this.Prosee = result[1];
        return result[1];
    }

    protected void corpsPurs(double PR, double TR) {
        this.nh3.liqProp(PR, TR);
        this.h2o.liqProp(PR, TR);
        this.nh3.vapProp(PR, TR);
        this.h2o.vapProp(PR, TR);
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("resBulle")) {
            fvec[1] = this.resBulle(this.PR, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("resPrBulle")) {
            fvec[1] = this.resPrBulle(this.TR, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("resRosee")) {
            fvec[1] = this.resRosee(this.PR, x);
            fvec[2] = this.resRosee2(this.PR, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1] + "  x[2]: " + x[2] + "  fvec[2]: " + fvec[2]);
            }
        }
        if (this.callFunction.equals("resPrRosee")) {
            fvec[1] = this.resPrRosee(this.TR, x);
            fvec[2] = this.resPrRosee2(this.TR, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1] + "  x[2]: " + x[2] + "  fvec[2]: " + fvec[2]);
            }
        }
        if (this.callFunction.equals("getPbubble")) {
            fvec[1] = this.resPBulle(x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("getPdew")) {
            fvec[1] = this.resProsee(x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
    }

    protected double resBulle(double P, double[] x) {
        this.TR = x[1] / this.TB;
        this.corpsPurs(this.PR, this.TR);
        this.calcMelange(this.PR, this.TR, this.xmelBulle, this.ymel);
        this.potentielChimique(this.PR, this.TR, this.xmelBulle);
        double y1 = Math.exp((this.UAL - this.nh3.gv) / this.TR);
        double y2 = 1.0 - Math.exp((this.UEL - this.h2o.gv) / this.TR);
        if (y1 < 0.0) {
            y1 = 0.0;
        }
        if (y2 < 0.0) {
            y2 = 0.0;
        }
        if (y1 > 1.0) {
            y1 = 1.0;
        }
        if (y2 > 1.0) {
            y2 = 1.0;
        }
        double dy = y2 - y1;
        this.ymel = y1;
        return dy;
    }

    protected double resPrBulle(double T, double[] x) {
        this.PR = x[1] / this.PB;
        this.corpsPurs(this.PR, this.TR);
        this.calcMelange(this.PR, this.TR, this.getZmel(), this.ymel);
        this.potentielChimique(this.PR, this.TR, this.getZmel());
        double y1 = Math.exp((this.UAL - this.nh3.gv) / this.TR);
        double y2 = 1.0 - Math.exp((this.UEL - this.h2o.gv) / this.TR);
        if (y1 < 0.0) {
            y1 = 0.0;
        }
        if (y2 < 0.0) {
            y2 = 0.0;
        }
        if (y1 > 1.0) {
            y1 = 1.0;
        }
        if (y2 > 1.0) {
            y2 = 1.0;
        }
        double dy = y2 - y1;
        this.ymel = y1;
        return dy;
    }

    protected double resRosee(double P, double[] x) {
        this.TR = x[1] / this.TB;
        if (x[2] < 0.0) {
            x[2] = 0.001;
        }
        if (x[2] > 1.0) {
            x[2] = 0.999;
        }
        this.corpsPurs(this.PR, this.TR);
        this.calcMelange(this.PR, this.TR, x[2], this.xmelRosee);
        this.potentielChimique(this.PR, this.TR, x[2]);
        this.xmel = x[2];
        this.deltaTr1 = this.xmelRosee - Math.exp((this.UAL - this.nh3.gv) / this.TR);
        this.deltaTr2 = this.xmelRosee - 1.0 + Math.exp((this.UEL - this.h2o.gv) / this.TR);
        return this.deltaTr1;
    }

    protected double resRosee2(double P, double[] x) {
        return this.deltaTr2;
    }

    protected double resPrRosee(double T, double[] x) {
        this.PR = x[1] / this.PB;
        if (x[2] < 0.0) {
            x[2] = 0.001;
        }
        if (x[2] > 1.0) {
            x[2] = 0.999;
        }
        this.corpsPurs(this.PR, this.TR);
        this.calcMelange(this.PR, this.TR, x[2], this.getZmel());
        this.potentielChimique(this.PR, this.TR, x[2]);
        this.xmel = x[2];
        this.deltaPr1 = this.getZmel() - Math.exp((this.UAL - this.nh3.gv) / this.TR);
        this.deltaPr2 = this.getZmel() - 1.0 + Math.exp((this.UEL - this.h2o.gv) / this.TR);
        return this.deltaPr1;
    }

    protected double resPrRosee2(double T, double[] x) {
        return this.deltaPr2;
    }

    protected double[] solveWithMinPack2(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec2 = new double[mm + 1];
        double[] x = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction2 = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            x[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn2(mm, n, x, fvec2, iflag);
        double residu0 = Minpack2_f77.enorm_f77((int)mm, (double[])fvec2);
        double epsfcn = 1.0E-6;
        this.nfev2 = 0;
        this.njev2 = 0;
        Minpack2_f77.lmdif2_f77((Lmdif_fcn2)this, (int)mm, (int)n, (double[])x, (double[])fvec2, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack2_f77.enorm_f77((int)mm, (double[])fvec2);
        if (this.debug) {
            System.out.println();
        }
        if (this.debug) {
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
        }
        if (this.debug) {
            System.out.println("Final L2 norm of the residuals: " + residu1);
        }
        if (this.debug) {
            System.out.println("Number of function evaluations: " + this.nfev);
        }
        if (this.debug) {
            System.out.println("Number of Jacobian evaluations: " + this.njev);
        }
        if (this.debug) {
            System.out.println("Info value: " + info[1]);
        }
        if (this.debug) {
            System.out.println("Final approximate solution: " + this.callFunction2 + "   " + x[1]);
        }
        if (this.debug) {
            System.out.println();
        }
        return x;
    }

    public void readXml() {
        super.readXml();
        Element xmlFragment = this.fluid_Model;
        String value = xmlFragment.getAttributeValue("calculPrecis");
        if (value != null) {
            this.calculPrecis = Util.lit_b((String)value);
        }
    }

    public void setZmel(double zmel) {
        this.zmel = zmel;
    }

    public double getZmel() {
        return this.zmel;
    }
}

