/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.pcsaft;

import bibCTP.pcsaft.ThermoLib;

public class BubbleMethod {
    protected double Y1;
    protected double EquP;
    protected double EquT;
    protected String AnNum = "An";

    public BubbleMethod() {
        System.out.println("I can calculate bullble pressure or bubble temperature");
        this.EquP = 0.0;
        this.Y1 = 0.0;
        System.out.println("Equilibrium Pressure=" + this.EquP + " y1=" + this.Y1);
    }

    public BubbleMethod(String IsoPT, double[] TCritic, double[] PCritic, double[] w, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double indptProp, double[] x) {
        double rhoV = 0.0;
        double rhoL = 0.0;
        double eps = 1.0E-6;
        double[] y = new double[ncomp];
        double[] phiV = new double[ncomp];
        double[] phiL = new double[ncomp];
        if (IsoPT.equals("T")) {
            double Temperature = indptProp;
            double[] Psat = new double[ncomp];
            int i = 0;
            while (i < ncomp) {
                Psat[i] = ThermoLib.PsatEstimated(TCritic[i], PCritic[i], w[i], Temperature);
                ++i;
            }
            double P = 0.0;
            double PInt = 10000.0;
            int i2 = 0;
            while (i2 < ncomp) {
                P += x[i2] * Psat[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < ncomp) {
                y[i2] = x[i2] * ThermoLib.KeqWil(TCritic[i2], PCritic[i2], w[i2], P, Temperature);
                ++i2;
            }
            do {
                rhoV = ThermoLib.RhoVapPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, P, Temperature, y);
                phiV = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoV, y);
                rhoL = ThermoLib.RhoLiqPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, P, Temperature, x);
                phiL = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoL, x);
                PInt = P;
                P *= BubbleMethod.sumY(phiL, phiV, x, ncomp);
                i2 = 0;
                while (i2 < ncomp) {
                    y[i2] = x[i2] * phiL[i2] / phiV[i2] / BubbleMethod.sumY(phiL, phiV, x, ncomp);
                    ++i2;
                }
            } while (BubbleMethod.equalF(phiL, phiV, x, y, ncomp) > eps || Math.abs(PInt - P) / P > eps);
            this.Y1 = y[0];
            this.EquP = P;
            double Z = ThermoLib.CompFacPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoL, x);
            rhoL = P / Z / 8.314472 / Temperature;
            Z = ThermoLib.CompFacPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoV, y);
            rhoV = P / Z / 8.314472 / Temperature;
        } else if (IsoPT.equals("P")) {
            double Pressure = indptProp;
            double[] Tboiling = new double[ncomp];
            int i = 0;
            while (i < ncomp) {
                Tboiling[i] = ThermoLib.TsatEstimated(TCritic[i], PCritic[i], w[i], Pressure);
                ++i;
            }
            double T = 0.0;
            double TInt = 0.0;
            int i3 = 0;
            while (i3 < ncomp) {
                T += x[i3] * Tboiling[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < ncomp) {
                y[i3] = x[i3] * ThermoLib.KeqWil(TCritic[i3], PCritic[i3], w[i3], Pressure, T);
                ++i3;
            }
            do {
                rhoV = ThermoLib.RhoVapPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Pressure, T, y);
                phiV = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, T, rhoV, y);
                rhoL = ThermoLib.RhoLiqPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Pressure, T, x);
                phiL = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, T, rhoL, x);
                TInt = T;
                T *= Math.pow(BubbleMethod.sumY(phiL, phiV, x, ncomp), -0.0625);
                i3 = 0;
                while (i3 < ncomp) {
                    y[i3] = x[i3] * phiL[i3] / phiV[i3] / BubbleMethod.sumY(phiL, phiV, x, ncomp);
                    ++i3;
                }
            } while (BubbleMethod.equalF(phiL, phiV, x, y, ncomp) > eps || Math.abs(TInt - T) / T > eps);
            this.Y1 = y[0];
            this.EquT = T;
        } else {
            System.out.println("Please chose the independent property: T or P");
        }
    }

    protected static double equalF(double[] phiL, double[] phiV, double[] x, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += Math.abs(x[i] * phiL[i] - y[i] * phiV[i]);
            ++i;
        }
        return sum;
    }

    protected static double sumY(double[] phiL, double[] phiV, double[] x, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += x[i] * phiL[i] / phiV[i];
            ++i;
        }
        return sum;
    }

    public double getY1() {
        return this.Y1;
    }

    public double getEquP() {
        return this.EquP;
    }

    public double getEquT() {
        return this.EquT;
    }
}

