/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.pcsaft;

import bibCTP.model.PCSaft;
import bibCTP.pcsaft.ThermoLib;

public class DewPointMethod {
    protected double Y1;
    protected double EquP;
    protected double EquT;
    protected String AnNum = "An";

    public DewPointMethod() {
        System.out.println("I can calculate dew point pressure or dew point temperature");
        this.EquP = 0.0;
        this.Y1 = 0.0;
        System.out.println("Equilibrium Pressure=" + this.EquP + " y1=" + this.Y1);
    }

    public DewPointMethod(String IsoPT, double[] TCritic, double[] PCritic, double[] w, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double indptProp, double[] y) {
        double rhoV = 0.0;
        double rhoL = 0.0;
        double eps = 1.0E-6;
        double[] x = new double[ncomp];
        double[] phiV = new double[ncomp];
        double[] phiL = new double[ncomp];
        if (IsoPT.equals("T")) {
            double Temperature = indptProp;
            double[] Psat = new double[ncomp];
            int i = 0;
            while (i < ncomp) {
                Psat[i] = ThermoLib.PsatEstimated(TCritic[i], PCritic[i], w[i], Temperature);
                ++i;
            }
            double P = 0.0;
            double PInt = 10000.0;
            int i2 = 0;
            while (i2 < ncomp) {
                P += y[i2] * Psat[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < ncomp) {
                x[i2] = y[i2];
                ++i2;
            }
            do {
                rhoV = ThermoLib.RhoVapPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, P, Temperature, y);
                phiV = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoV, y);
                rhoL = ThermoLib.RhoLiqPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, P, Temperature, x);
                phiL = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoL, x);
                PInt = P;
                P *= DewPointMethod.sumX(phiL, phiV, x, ncomp);
                i2 = 0;
                while (i2 < ncomp) {
                    x[i2] = y[i2] * phiV[i2] / phiL[i2] / DewPointMethod.sumY(phiL, phiV, y, ncomp);
                    ++i2;
                }
            } while (DewPointMethod.equalF(phiL, phiV, x, y, ncomp) > eps);
            this.Y1 = x[0];
            this.EquP = P;
            double rho = rhoL;
            double Z = ThermoLib.CompFacPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoL, x);
            rhoL = P / Z / 8.314472 / Temperature;
            rhoL = PCSaft.rhoNbToMolar(rho);
            rho = rhoV;
            Z = ThermoLib.CompFacPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rhoV, y);
            rhoV = P / Z / 8.314472 / Temperature;
            rhoV = PCSaft.rhoNbToMolar(rho);
        } else if (IsoPT.equals("P")) {
            double Pressure = indptProp;
            double[] Tboiling = new double[ncomp];
            int i = 0;
            while (i < ncomp) {
                Tboiling[i] = ThermoLib.TsatEstimated(TCritic[i], PCritic[i], w[i], Pressure);
                ++i;
            }
            double T = 0.0;
            double TInt = 0.0;
            int i3 = 0;
            while (i3 < ncomp) {
                T += y[i3] * Tboiling[i3];
                ++i3;
            }
            i3 = 0;
            while (i3 < ncomp) {
                x[i3] = y[i3];
                ++i3;
            }
            do {
                rhoV = ThermoLib.RhoVapPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Pressure, T, y);
                phiV = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, T, rhoV, y);
                rhoL = ThermoLib.RhoLiqPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, Pressure, T, x);
                phiL = ThermoLib.PhiPCSaft(this.AnNum, m, sigmaPure, epsI, kij, ncomp, T, rhoL, x);
                TInt = T;
                double sumX = DewPointMethod.sumX(phiL, phiV, x, ncomp);
                double sumY = DewPointMethod.sumY(phiL, phiV, y, ncomp);
                T *= Math.pow(sumX, -0.0625);
                int i4 = 0;
                while (i4 < ncomp) {
                    x[i4] = y[i4] * phiV[i4] / phiL[i4] / sumY;
                    ++i4;
                }
            } while (DewPointMethod.equalF(phiL, phiV, x, y, ncomp) > eps || Math.abs(TInt - T) / T > eps);
            this.Y1 = x[0];
            this.EquT = T;
        } else {
            System.out.println("Please chose the independent property: T or P");
        }
    }

    protected static double equalF(double[] phiL, double[] phiV, double[] x, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += Math.abs(x[i] * phiL[i] - y[i] * phiV[i]);
            ++i;
        }
        return sum;
    }

    protected static double sumY(double[] phiL, double[] phiV, double[] y, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += y[i] * phiV[i] / phiL[i];
            ++i;
        }
        return sum;
    }

    protected static double sumX(double[] phiL, double[] phiV, double[] x, int ncomp) {
        double sum = 0.0;
        int i = 0;
        while (i < ncomp) {
            sum += x[i] * phiL[i] / phiV[i];
            ++i;
        }
        return sum;
    }

    public double getY1() {
        return this.Y1;
    }

    public double getEquP() {
        return this.EquP;
    }

    public double getEquT() {
        return this.EquT;
    }
}

