/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.pcsaft;

import bibCTP.model.PCSaft;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import optimization.Lmdif_fcn;
import optimization.Minpack_f77;

public class FlashMethodPCSaft_base
implements Lmdif_fcn {
    protected String AnNum = "An";
    public double rhoV = 0.0;
    public double rhoL = 0.0;
    public double L = 0.0;
    int ncomp;
    public double[] zz;
    public double[] x;
    public double[] y;
    PCSaft pcSaft;
    int nfev = 0;
    int njev = 0;
    String callFunction = "";
    double epsiMinpack = 1.0E-6;
    int count = 0;
    double[] TCritic;
    double[] PCritic;
    double Temperature;
    double P_Pa;
    String type;
    double[] xBubble;
    double[] yDew;
    double[] Ki;
    double[] phiV;
    double[] phiL;
    double[] w;

    public FlashMethodPCSaft_base(PCSaft cpa, String type, double Temperature, double P_Pa, double[] zz) {
        this.pcSaft = cpa;
        this.ncomp = cpa.ncomp;
        this.TCritic = cpa.TCritic;
        this.PCritic = cpa.PCritic;
        this.zz = zz;
        this.Temperature = Temperature;
        this.P_Pa = P_Pa;
        this.type = type;
        this.x = new double[this.ncomp];
        this.y = new double[this.ncomp];
        this.xBubble = new double[this.ncomp];
        this.yDew = new double[this.ncomp];
    }

    public void fcn(int mm, int n, double[] xx, double[] fvec, int[] iflag) {
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
    }

    protected double[] solveWithMinPack(int pbSize, String callFunction, double[] init, double epsi) {
        int mm = pbSize;
        int n = pbSize;
        double[] fvec = new double[mm + 1];
        double[] xx = new double[n + 1];
        int[] info = new int[2];
        int[] iflag = new int[2];
        this.callFunction = callFunction;
        int i = 0;
        while (i < pbSize + 1) {
            xx[i] = init[i];
            ++i;
        }
        iflag[1] = 0;
        this.fcn(mm, n, xx, fvec, iflag);
        double residu0 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        this.nfev = 0;
        this.njev = 0;
        double epsfcn = 1.0E-6;
        Minpack_f77.lmdif2_f77((Lmdif_fcn)this, (int)mm, (int)n, (double[])xx, (double[])fvec, (double)epsi, (double)epsfcn, (int[])info);
        double residu1 = Minpack_f77.enorm_f77((int)mm, (double[])fvec);
        if (residu1 > 0.01) {
            String message = "Watch out! The Flash algorithm did not converge\nThe residu value is: " + residu1;
            JOptionPane.showMessageDialog(new JFrame(), message);
        }
        if (this.pcSaft.debug) {
            System.out.println();
            System.out.println(" Initial L2 norm of the residuals: " + residu0);
            System.out.println("Final L2 norm of the residuals: " + residu1);
            System.out.println("Number of function evaluations: " + this.nfev);
            System.out.println("Number of Jacobian evaluations: " + this.njev);
            System.out.println("Info value: " + info[1]);
            System.out.println("Final approximate solution: " + callFunction + "   " + xx[1]);
            System.out.println();
        }
        return xx;
    }
}

