/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.pcsaft;

import bibCTP.model.PCSaft;

public class ThermoLib {
    protected static final double constantR = 8.314472;
    protected static final double eps = 1.0E-6;
    protected static final double constantNav = 6.02214179E23;

    public static double CompFacPCSaft(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        if (AnNum == "An" || AnNum == "Num") {
            return 1.0 + rho * PCSaft.aR_rho(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
        }
        System.out.println("CompFacPCSaft error!");
        return 0.0;
    }

    public static double RhoLiqPCSaft(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Pn, double Temperature, double[] x) {
        double etaNew = 0.5;
        double etaOld = 0.499;
        double etaMin = 0.0;
        double etaMax = 0.7405;
        double b = 0.0;
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            b += 0.5235987755982988 * x[i] * m[i] * Math.pow(dBis[i], 3.0);
            ++i;
        }
        double FetaNew = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaNew / b, x) * PCSaft.rhoNbToMolar(etaNew / b) * 8.314472 * Temperature - Pn;
        double FetaOld = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaOld / b, x) * PCSaft.rhoNbToMolar(etaOld / b) * 8.314472 * Temperature - Pn;
        double dFeta = (FetaNew - FetaOld) / (etaNew - etaOld);
        while (Math.abs(FetaNew) > 1.0E-6) {
            if (FetaNew > 0.0) {
                etaMax = etaNew;
            } else {
                etaMin = etaNew;
            }
            etaOld = etaNew;
            if ((etaNew -= FetaNew / dFeta) >= etaMax || etaNew <= etaMin) {
                etaNew = (etaMax + etaMin) / 2.0;
            }
            FetaNew = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaNew / b, x) * PCSaft.rhoNbToMolar(etaNew / b) * 8.314472 * Temperature - Pn;
            FetaOld = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaOld / b, x) * PCSaft.rhoNbToMolar(etaOld / b) * 8.314472 * Temperature - Pn;
            dFeta = (FetaNew - FetaOld) / (etaNew - etaOld);
        }
        return etaNew / b;
    }

    public static double RhoVapPCSaft(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Pn, double Temperature, double[] x) {
        double etaNew = 1.0E-10;
        double etaOld = 1.0E-9;
        double etaMin = 0.0;
        double etaMax = 0.7405;
        double b = 0.0;
        double[] dBis = PCSaft.d(sigmaPure, epsI, ncomp, Temperature);
        int i = 0;
        while (i < ncomp) {
            b += 0.5235987755982988 * x[i] * m[i] * Math.pow(dBis[i], 3.0);
            ++i;
        }
        double FetaNew = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaNew / b, x) * PCSaft.rhoNbToMolar(etaNew / b) * 8.314472 * Temperature - Pn;
        double FetaOld = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaOld / b, x) * PCSaft.rhoNbToMolar(etaOld / b) * 8.314472 * Temperature - Pn;
        double dFeta = (FetaNew - FetaOld) / (etaNew - etaOld);
        while (Math.abs(FetaNew) > 1.0E-4) {
            if (FetaNew > 0.0) {
                etaMax = etaNew;
            } else {
                etaMin = etaNew;
            }
            etaOld = etaNew;
            if ((etaNew -= FetaNew / dFeta) >= etaMax || etaNew <= etaMin) {
                etaNew = (etaMax + etaMin) / 2.0;
            }
            FetaNew = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaNew / b, x) * PCSaft.rhoNbToMolar(etaNew / b) * 8.314472 * Temperature - Pn;
            FetaOld = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, etaOld / b, x) * PCSaft.rhoNbToMolar(etaOld / b) * 8.314472 * Temperature - Pn;
            dFeta = (FetaNew - FetaOld) / (etaNew - etaOld);
        }
        return etaNew / b;
    }

    public static double[] PhiPCSaft(String AnNum, double[] m, double[] sigmaPure, double[] epsI, double[][] kij, int ncomp, double Temperature, double rho, double[] x) {
        double[] phi = new double[ncomp];
        if (AnNum == "An" || AnNum == "Num") {
            double aRBis = PCSaft.aR(m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
            double Z = ThermoLib.CompFacPCSaft(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
            double[] aR_xiBis = PCSaft.aR_xi(AnNum, m, sigmaPure, epsI, kij, ncomp, Temperature, rho, x);
            int i = 0;
            while (i < ncomp) {
                double sum = 0.0;
                int j = 0;
                while (j < ncomp) {
                    sum += x[j] * aR_xiBis[j];
                    ++j;
                }
                phi[i] = Math.exp(aRBis + (Z - 1.0) + aR_xiBis[i] - sum - Math.log(Z));
                ++i;
            }
            return phi;
        }
        System.out.println("PhiPCSaft error!");
        return phi;
    }

    public static double EnthalpyVaporizationPCSaft(String AnNum, double TCritic, double PCritic, double w, double m, double sigmaPure, double epsI, double Temperature) {
        if (AnNum == "An" || AnNum == "Num") {
            double Ps = ThermoLib.PsatEstimated(TCritic, PCritic, w, Temperature);
            double rhoV = 0.0;
            double rhoL = 0.0;
            double phiV = 0.9;
            double phiL = 1.0;
            int ncomp = 1;
            double[][] k = new double[][]{{0.0}};
            double[] mBis = new double[]{m};
            double[] sigmaPureBis = new double[]{sigmaPure};
            double[] epsIBis = new double[]{epsI};
            double[] x = new double[]{1.0};
            while (Math.abs(phiV - phiL) > 1.0E-6) {
                rhoV = ThermoLib.RhoVapPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Ps, Temperature, x);
                rhoL = ThermoLib.RhoLiqPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Ps, Temperature, x);
                phiV = ThermoLib.PhiPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoV, x)[0];
                phiL = ThermoLib.PhiPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoL, x)[0];
                Ps = Ps * phiL / phiV;
            }
            double hV = -Temperature * PCSaft.aR_T(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoV, x) + rhoV * PCSaft.aR_rho(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoV, x);
            double hL = -Temperature * PCSaft.aR_T(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoL, x) + rhoL * PCSaft.aR_rho(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoL, x);
            return (hV - hL) * 8.314472 * Temperature;
        }
        System.out.println("EnthalpyVaporizationPCSaft erreur");
        return 0.0;
    }

    public static double PsatPCSaft(String AnNum, double TCritic, double PCritic, double w, double m, double sigmaPure, double epsI, double Temperature) {
        if (AnNum == "An" || AnNum == "Num") {
            double Ps = ThermoLib.PsatEstimated(TCritic, PCritic, w, Temperature);
            double rhoV = 0.0;
            double rhoL = 0.0;
            double phiV = 0.9;
            double phiL = 1.0;
            int ncomp = 1;
            double[][] k = new double[][]{{0.0}};
            double[] mBis = new double[]{m};
            double[] sigmaPureBis = new double[]{sigmaPure};
            double[] epsIBis = new double[]{epsI};
            double[] x = new double[]{1.0};
            while (Math.abs(phiV - phiL) > 1.0E-6) {
                rhoV = ThermoLib.RhoVapPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Ps, Temperature, x);
                rhoL = ThermoLib.RhoLiqPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Ps, Temperature, x);
                phiV = ThermoLib.PhiPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoV, x)[0];
                phiL = ThermoLib.PhiPCSaft(AnNum, mBis, sigmaPureBis, epsIBis, k, ncomp, Temperature, rhoL, x)[0];
                Ps = Ps * phiL / phiV;
            }
            return Ps;
        }
        System.out.println("PsatPCSaft erreur");
        return 0.0;
    }

    public static double KeqWil(double TCritic, double PCritic, double w, double P, double Temperature) {
        return Math.exp(Math.log(PCritic / P) + 5.3727 * (1.0 + w) * (1.0 - TCritic / Temperature));
    }

    public static double PsatEstimated(double TCritic, double PCritic, double w, double Temperature) {
        double Tr = Temperature / TCritic;
        return PCritic * Math.exp(5.92714 - 6.09648 / Tr - 1.28862 * Math.log(Tr) + 0.168347 * Math.pow(Tr, 6.0) + w * (15.2518 - 15.6875 / Tr - 13.4721 * Math.log(Tr) + 0.43577 * Math.pow(Tr, 6.0)));
    }

    public static double TsatEstimated(double TCritic, double PCritic, double w, double Pressure) {
        double Tmax = 0.99 * TCritic;
        double Tmin = 0.01 * TCritic;
        double Tmid = (Tmax + Tmin) / 2.0;
        while (Tmax - Tmin > 0.1) {
            Tmid = (Tmax + Tmin) / 2.0;
            if ((ThermoLib.PsatEstimated(TCritic, PCritic, w, Tmid) - Pressure) * (ThermoLib.PsatEstimated(TCritic, PCritic, w, Tmax) - Pressure) > 0.0) {
                Tmax = Tmid;
                continue;
            }
            Tmin = Tmid;
        }
        return (Tmax + Tmin) / 2.0;
    }
}

