/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.trapp;

import bibCTP.CTPbibSubstance;
import bibCTP.util.CpGeneralisee;
import extThopt.Util;
import java.util.List;
import org.jdom.Element;

public abstract class Huber {
    CTPbibSubstance tbs;
    double[] liqViscCorr = new double[4];
    double[] vapViscCorr = new double[4];
    double[] liqCondCorr = new double[4];
    double[] vapCondCorr = new double[4];

    public Huber(CTPbibSubstance tbs) {
        this.tbs = tbs;
        this.liqViscCorr[0] = 1.0;
        this.vapViscCorr[0] = 1.0;
        this.liqCondCorr[0] = 1.0;
        this.vapCondCorr[0] = 1.0;
        int i = 1;
        while (i < 4) {
            this.liqViscCorr[i] = 0.0;
            this.vapViscCorr[i] = 0.0;
            this.liqCondCorr[i] = 0.0;
            this.vapCondCorr[i] = 0.0;
            ++i;
        }
        this.readXml();
    }

    public void readXml() {
        String value;
        Element courant;
        Element xmlFragment = this.tbs.fluidModel.fluid_Model;
        List listChildren = xmlFragment.getChildren("LIQ_VISC");
        if (listChildren.size() > 0) {
            courant = (Element)listChildren.get(0);
            value = courant.getAttributeValue("A");
            if (value != null) {
                this.liqViscCorr[0] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("B")) != null) {
                this.liqViscCorr[1] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("C")) != null) {
                this.liqViscCorr[2] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("D")) != null) {
                this.liqViscCorr[3] = Util.lit_d((String)value);
            }
        }
        if ((listChildren = xmlFragment.getChildren("VAP_VISC")).size() > 0) {
            courant = (Element)listChildren.get(0);
            value = courant.getAttributeValue("A");
            if (value != null) {
                this.vapViscCorr[0] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("B")) != null) {
                this.vapViscCorr[1] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("C")) != null) {
                this.vapViscCorr[2] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("D")) != null) {
                this.vapViscCorr[3] = Util.lit_d((String)value);
            }
        }
        if ((listChildren = xmlFragment.getChildren("LIQ_COND")).size() > 0) {
            courant = (Element)listChildren.get(0);
            value = courant.getAttributeValue("A");
            if (value != null) {
                this.liqCondCorr[0] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("B")) != null) {
                this.liqCondCorr[1] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("C")) != null) {
                this.liqCondCorr[2] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("D")) != null) {
                this.liqCondCorr[3] = Util.lit_d((String)value);
            }
        }
        if ((listChildren = xmlFragment.getChildren("VAP_COND")).size() > 0) {
            courant = (Element)listChildren.get(0);
            value = courant.getAttributeValue("A");
            if (value != null) {
                this.vapCondCorr[0] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("B")) != null) {
                this.vapCondCorr[1] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("C")) != null) {
                this.vapCondCorr[2] = Util.lit_d((String)value);
            }
            if ((value = courant.getAttributeValue("D")) != null) {
                this.vapCondCorr[3] = Util.lit_d((String)value);
            }
        }
    }

    public double[] CalcViscosityConductivity(double TT, double rho) {
        double[] res = new double[2];
        return res;
    }

    public double Lucas(double T, double Tc, double Fp0, double E) {
        double Tr = T / Tc;
        double viscosity0 = 0.0;
        viscosity0 = (0.807 * Math.pow(Tr, 0.618) - 0.357 * Math.exp(-0.449 * Tr) + 0.34 * Math.exp(-4.058 * Tr) + 0.018) * Fp0 / E;
        return viscosity0 / 10.0;
    }

    public double ChapmanEnskog(double T, double M, double Tc, double Vc) {
        double res = 0.0;
        double Boltzmann = 1.3806488E-23;
        double LennardJonesPotentialR134a = 299.363;
        double LennardJonesPotential = Tc / 374.21 * LennardJonesPotentialR134a;
        double TStar = T / LennardJonesPotential;
        double LennardJonesCollisionDiameter = 4.6893E-10 * Math.pow(1.99316E-4 / Vc, 0.333333333);
        double CollisionIntegral = 1.16145 * Math.pow(TStar, -0.14874) + 0.52487 * Math.exp(-0.7732 * TStar) + 2.16178 * Math.exp(-2.43787 * TStar);
        res = 2.6693 * Math.pow(M * T, 0.5) / (Math.pow(LennardJonesCollisionDiameter / 1.0E-10, 2.0) * CollisionIntegral);
        return res;
    }

    public double Lamda0(double T, double viscosity0, double M, int i) {
        double Cp = 0.0;
        if (this.tbs.compProp[i].codeCp == 1) {
            double TT = T / 1000.0;
            Cp = this.tbs.compProp[i].A + this.tbs.compProp[i].B * TT + this.tbs.compProp[i].C * Math.pow(TT, 2.0) + this.tbs.compProp[i].D * Math.pow(TT, 3.0) + this.tbs.compProp[i].E * Math.pow(TT, 4.0) + this.tbs.compProp[i].G / Math.pow(TT, 2.0) + this.tbs.compProp[i].K / TT;
        } else if (this.tbs.compProp[0].codeCp == 2) {
            double TT = T;
            Cp = (this.tbs.compProp[i].A + this.tbs.compProp[i].B * Math.pow(this.tbs.compProp[i].C / TT / this.sinh(this.tbs.compProp[i].C / TT), 2.0) + this.tbs.compProp[i].D * Math.pow(this.tbs.compProp[i].E / TT / this.cosh(this.tbs.compProp[i].E / TT), 2.0)) / 1000.0;
        } else {
            double TT = T;
            int casException = this.tbs.numeroCas(this.tbs.compProp[i].name);
            CpGeneralisee CpGeneralized = this.tbs.fonctionCp(casException, TT);
            Cp = CpGeneralized.Cp;
        }
        double lamda0 = (1.32 * Cp + 3.741) * (viscosity0 * 1.0E-6 / (M * 0.001));
        return lamda0;
    }

    public double Fp0(double Zc, double T, double Tc, double Pc, double dipole) {
        double Tr = T / Tc;
        double Fp0 = 0.0;
        double Pc_bar = Pc / 100000.0;
        double dipoleR = 52.46 * Math.pow(dipole, 2.0) * Pc_bar / Math.pow(Tc, 2.0);
        Fp0 = dipoleR < 0.022 ? 1.0 : (dipoleR > 0.075 ? 1.0 + 30.55 * Math.pow(0.292 - Zc, 1.72) * Math.abs(0.96 + 0.1 * (Tr - 0.7)) : 1.0 + 30.55 * Math.pow(0.292 - Zc, 1.72));
        return Fp0;
    }

    public double E(double Tc, double Pc, double M) {
        double E = 0.0;
        double Pc_bar = Pc / 100000.0;
        E = 0.176 * Math.pow(Tc / (Math.pow(M, 3.0) * Math.pow(Pc_bar, 4.0)), 0.166666666666667);
        return E;
    }

    public double VFR(double T0, double rho, double h) {
        double VcR = 2.0E-4;
        double G1 = Math.exp(-14.113294896 + 968.22940153 / T0);
        double G2 = 13.686545032 - 12511.628378 / Math.pow(T0, 1.5);
        double G3 = 0.0168910864 + 43.527109444 / T0 + 7659.4543472 / Math.pow(T0, 2.0);
        double rho0 = rho * h * 0.001;
        double rhoR_r = rho0 * 1000.0 * VcR;
        double res = G1 * Math.exp(Math.pow(rho0, 0.1) * G2 + Math.pow(rho0, 0.5) * (rhoR_r - 1.0) * G3) - G1;
        return res;
    }

    public double VFR2003(double T0, double rho, double h) {
        double PcR = 4059300.0;
        double TcR = 374.21;
        double omegaR = 0.32684;
        double VcR = 1.99316E-4;
        double ZcR = PcR * VcR / (8.314472471 * TcR);
        double dipoleR = 2.058;
        double M0 = 102.03;
        double rhoR = rho * VcR * h;
        double Tr = T0 / TcR;
        double c1 = -0.0206900719;
        double c2 = 3.56029549E-4;
        double c3 = 0.00211101816;
        double c4 = 0.0139601415;
        double c5 = -0.0045643502;
        double c6 = -0.00351593275;
        double c7 = 0.21476332;
        double c8 = -0.0890173375;
        double c9 = 0.100035295;
        double c10 = 3.163695636;
        double delta0 = c10 / (1.0 + c8 * Tr + c9 * Tr * Tr);
        double VFR2003 = (c1 * rhoR + (c2 / Math.pow(Tr, 6.0) + c3 / Tr / Tr + c4 / Math.pow(Tr, 0.5) + c5 * Tr * Tr) * rhoR * rhoR + c6 * rhoR * rhoR * rhoR + c7 / (delta0 - rhoR) - c7 / delta0) * 1000.0;
        double NA = 602.214078;
        double LennardJonesCollisionDiameter = 0.50647;
        double b0 = -1.7999496;
        double b1 = 46.692621;
        double b2 = -534.60794;
        double b3 = 3360.4074;
        double b4 = -13019.164;
        double b5 = 33414.23;
        double b6 = -58711.743;
        double b7 = 71426.686;
        double b8 = -59834.012;
        double b9 = 33652.741;
        double b10 = -12027.35;
        double b11 = 2434.8205;
        double b12 = -208.07957;
        double Tstar = T0 / 288.82;
        double B = NA * Math.pow(LennardJonesCollisionDiameter, 3.0) * (b0 * Math.pow(Math.pow(Tstar, 0.5), 0.0) + b1 * Math.pow(Math.pow(Tstar, 0.5), 1.0) + b2 * Math.pow(Math.pow(Tstar, 0.5), 2.0) + b3 * Math.pow(Math.pow(Tstar, 0.5), 3.0) + b4 * Math.pow(Math.pow(Tstar, 0.5), 4.0) + b5 * Math.pow(Math.pow(Tstar, 0.5), 5.0) + b6 * Math.pow(Math.pow(Tstar, 0.5), 6.0) + b7 * Math.pow(Math.pow(Tstar, 0.5), 7.0) + b8 * Math.pow(Math.pow(Tstar, 0.5), 8.0) + b9 * Math.pow(Math.pow(Tstar, 0.5), 9.0) + b10 * Math.pow(Math.pow(Tstar, 0.5), 10.0) + b11 * Math.pow(Math.pow(Tstar, 0.5), 11.0) + b12 * Math.pow(Math.pow(Tstar, 0.5), 12.0)) / 1000.0;
        double a0 = 0.355404;
        double a1 = -0.464337;
        double a2 = 0.0257353;
        Tstar = T0 / 299.363;
        double lnv = a0 + a1 * Math.log(Tstar) + a2 * Math.log(Tstar) * Math.log(Tstar);
        double visco0R134a = 0.021357 * Math.pow(M0 * T0, 0.5) / (Math.exp(lnv) * Math.pow(LennardJonesCollisionDiameter, 2.0));
        double viscoR134aB = B * visco0R134a * rhoR;
        return VFR2003 += viscoR134aB;
    }

    public double LamdaFR(double T0, double rho, double h) {
        double VcR = 2.0E-4;
        double TcR = 369.89;
        double C1 = 15.2583985944;
        double C2 = 5.29917319127;
        double C3 = -3.05330414748;
        double C4 = 0.450477583739;
        double C5 = 1.03144050679;
        double C6 = -0.185480417707;
        double rho0 = rho * h * 0.001;
        double rhoR_r = rho * h * VcR;
        double TR_r = T0 / TcR;
        double res = C1 * rhoR_r + C2 * Math.pow(rhoR_r, 3.0) + (C3 + C4 / TR_r) * Math.pow(rhoR_r, 4.0) + (C5 + C6 / TR_r) * Math.pow(rhoR_r, 5.0);
        return res;
    }

    public double LamdaFR2003(double T0, double rho, double h) {
        double PcR = 4059300.0;
        double TcR = 374.21;
        double omegaR = 0.32684;
        double VcR = 1.99316E-4;
        double ZcR = PcR * VcR / (8.314472471 * TcR);
        double dipoleR = 2.058;
        double M0 = 102.03;
        double rhoR = rho * VcR * h;
        double Tr = T0 / TcR;
        double a1 = -1.568403;
        double a2 = 16.7153;
        double a3 = -12.56456;
        double a4 = 3.371808;
        double a5 = 2.982238;
        double a6 = -1.180252;
        double lamdaFRR134a = rhoR * (a1 + a2 * Math.pow(rhoR, 2.0) + (a3 + a4 * Tr) * Math.pow(rhoR, 3.0) + (a5 + a6 * Tr) * Math.pow(rhoR, 4.0));
        return lamdaFRR134a;
    }

    public double FVisco(double M, double f, double h) {
        double M0 = 102.03;
        double res = Math.pow(M / M0 * f, 0.5) * Math.pow(h, -0.66666666667);
        return res;
    }

    public double FVisco(double M1, double M2, double[] fh, double hmix, double z) {
        double M0 = 102.03;
        double f12 = Math.pow(fh[0] * fh[2], 0.5);
        double M12 = 2.0 * M1 * M2 / (M1 + M2);
        double res = Math.pow(1.0 / M0, 0.5) * Math.pow(hmix, -2.0) * (z * z * Math.pow(fh[0] * M1, 0.5) * Math.pow(fh[1], 1.333333) + (1.0 - z) * (1.0 - z) * Math.pow(fh[2] * M2, 0.5) * Math.pow(fh[3], 1.333333) + z * (1.0 - z) * Math.pow(f12 * M12, 0.5) * Math.pow(Math.pow(Math.pow(fh[1], 0.33333) + Math.pow(fh[3], 0.33333), 3.0) / 8.0, 1.333333));
        return res;
    }

    public double FVisco1996(double M, double f, double h) {
        double M0 = 44.094;
        double res = Math.pow(M / M0 * f, 0.5) * Math.pow(h, -0.66666666667);
        return res;
    }

    public double FLamda(double M, double f, double h) {
        double M0 = 102.03;
        double res = Math.pow(M0 / M * f, 0.5) * Math.pow(h, -0.66666666667);
        return res;
    }

    public double FLamda1996(double M, double f, double h) {
        double M0 = 44.094;
        double res = Math.pow(M0 / M * f, 0.5) * Math.pow(h, -0.66666666667);
        return res;
    }

    public double XLamda(double omega) {
        double omegaFluidRef = 0.32684;
        double xLamda = Math.pow(1.0 + 2.1866 * (omega - omegaFluidRef) / (1.0 - 0.505 * (omega - omegaFluidRef)), 0.5);
        return xLamda;
    }

    public double XLamda1996(double omega) {
        double omegaFluidRef = 0.1521;
        double xLamda = Math.pow(1.0 + 2.1866 * (omega - omegaFluidRef) / (1.0 - 0.505 * (omega - omegaFluidRef)), 0.5);
        return xLamda;
    }

    public double Huber1996v(double vLucas, double fVisco, double vFR) {
        double res = vLucas + fVisco * vFR;
        return res;
    }

    public double Huber2003v(double vLucas, double fVisco, double vFR) {
        double res = vLucas + fVisco * vFR;
        return res;
    }

    public double Huber1996c(double lamda0, double fLamda, double lamdaFR, double xLamda) {
        double res = lamda0 + fLamda * lamdaFR * xLamda;
        return res;
    }

    public double Huber2003c(double lamda0, double fLamda, double lamdaFR, double xLamda) {
        double res = lamda0 + fLamda * lamdaFR;
        return res;
    }

    public double[] SearchForFH(double TT, double VV) {
        double PcR = 4059300.0;
        double TcR = 374.21;
        double omegaR = 0.32684;
        double VcR = 1.99316E-4;
        double ZcR = PcR * VcR / (8.314472471 * TcR);
        double dipoleR = 2.058;
        double M0 = 102.03;
        double[] fh = new double[4];
        fh[0] = this.tbs.compProp[0].Tc / TcR;
        fh[1] = this.tbs.compProp[0].Vc / VcR;
        return fh;
    }

    double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }
}

