/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.trapp;

import bibCTP.CTPbibSubstance;
import bibCTP.trapp.Huber;

public class Huber96_mix
extends Huber {
    double Tcm;
    double Pcm;
    double vcm;
    double eta_m;
    double Zcm;
    double Mm;
    double fm;
    double hm;
    double Fqm;
    double Fpm;
    double epsilonVisco;
    double sigmaX;
    double Mx;
    double gx;
    double Bx;
    double[] Fqi;
    double[] Fpi;
    double[] beta_i;
    double[] Yi;
    double[] sigma_i;
    double[][] gij;
    double[][] hij;
    double[][] fij;
    double[][] Mij;
    double[][] Bij;
    double[][] sigma_ij;
    double[][] theta_ij;
    double[][] eta_ij;
    double[][] Aij;
    double[][] Kroenecker2 = new double[2][2];
    double PcR;
    double TcR;
    double omegaR;
    double VcR;
    double ZcR;
    double dipoleR;
    double M0;

    public Huber96_mix(CTPbibSubstance tbs) {
        super(tbs);
    }

    public double[] CalcViscosityConductivity(double TT, double rho) {
        double[] res = new double[2];
        if (this.tbs.nbTrapp == 1) {
            this.PcR = 4247660.0;
            this.TcR = 369.85;
            this.omegaR = 0.1523;
            this.VcR = 2.0E-4;
            this.ZcR = this.PcR * this.VcR / (8.314472471 * this.TcR);
            this.dipoleR = 0.084;
            this.M0 = 44.096;
            res[0] = this.CalcViscosityMixture1996(TT, rho);
            System.out.println("TRAPP viscosity: rho: " + rho);
            res[1] = this.CalcConductivityMixture1996(TT, rho);
            System.out.println("TRAPP Conductivity: rho: " + rho);
        } else {
            this.PcR = 4059300.0;
            this.TcR = 374.21;
            this.omegaR = 0.32684;
            this.VcR = 1.99316E-4;
            this.ZcR = this.PcR * this.VcR / (8.314472471 * this.TcR);
            this.dipoleR = 2.058;
            this.M0 = 102.03;
            res[0] = this.CalcViscosityMixture(TT, rho);
            System.out.println("TRAPP viscosity: rho: " + rho);
            res[1] = this.CalcConductivityMixture(TT, rho);
            System.out.println("TRAPP Conductivity: rho: " + rho);
        }
        double T_r = TT / this.Tcm;
        if (rho < 1.0) {
            res[0] = res[0] * (this.vapViscCorr[0] + this.vapViscCorr[1] * T_r + this.vapViscCorr[2] * T_r * T_r + this.vapViscCorr[3] / (1.0 - T_r));
            res[1] = res[1] * (this.vapCondCorr[0] + this.vapCondCorr[1] * T_r + this.vapCondCorr[2] * T_r * T_r + this.vapCondCorr[3] / (1.0 - T_r));
        } else {
            res[0] = res[0] * (this.liqViscCorr[0] + this.liqViscCorr[1] * T_r + this.liqViscCorr[2] * T_r * T_r + this.liqViscCorr[3] / (1.0 - T_r));
            res[1] = res[1] * (this.liqCondCorr[0] + this.liqCondCorr[1] * T_r + this.liqCondCorr[2] * T_r * T_r + this.liqCondCorr[3] / (1.0 - T_r));
        }
        res[0] = res[0] * 1.0E-6;
        return res;
    }

    public void CalcTcm() {
        this.Tcm = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.Tcm += this.tbs.compProp[i].Tc * this.tbs.zz[i];
            ++i;
        }
    }

    public void CalcFpm0(double TT) {
        this.Fpm = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            double Zc = this.tbs.compProp[i].Pc * this.tbs.compProp[i].Vc / (this.tbs.compProp[i].Tc * 8.314472471);
            double Fpi = 0.0;
            Fpi = this.Fp0(Zc, TT, this.tbs.compProp[i].Tc, this.tbs.compProp[i].Pc, this.tbs.compProp[i].dipole);
            this.Fpm += Fpi * this.tbs.zz[i];
            ++i;
        }
    }

    public void CalcFqm0() {
        this.Fqm = 1.0;
    }

    public void CalcPcm() {
        this.Pcm = 0.0;
        double sommeZc = 0.0;
        double sommeVc = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            double Zci = this.tbs.compProp[i].Pc * this.tbs.compProp[i].Vc / (this.tbs.compProp[i].Tc * 8.314472471);
            sommeZc += this.tbs.zz[i] * Zci;
            sommeVc += this.tbs.zz[i] * this.tbs.compProp[i].Vc;
            ++i;
        }
        this.CalcTcm();
        this.Pcm = 8.314472471 * this.Tcm * sommeZc / sommeVc;
    }

    public void CalcMm() {
        this.Mm = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.Mm += this.tbs.compProp[i].M * this.tbs.zz[i];
            ++i;
        }
    }

    public void CalcEtaMixture() {
        this.CalcTcm();
        this.CalcPcm();
        this.CalcMm();
        this.eta_m = 0.176 * Math.pow(this.Tcm / (this.Mm * this.Mm * this.Mm * this.Pcm / 100000.0 * this.Pcm / 100000.0 * this.Pcm / 100000.0 * this.Pcm / 100000.0), 0.1666666666);
    }

    public double viscosityM0(double TT) {
        this.CalcTcm();
        this.CalcPcm();
        this.CalcMm();
        this.CalcEtaMixture();
        this.CalcFpm0(TT);
        this.CalcFqm0();
        double Tr = TT / this.Tcm;
        double viscosity0 = 0.0;
        viscosity0 = (0.807 * Math.pow(Tr, 0.618) - 0.357 * Math.exp(-0.449 * Tr) + 0.34 * Math.exp(-4.058 * Tr) + 0.018) * this.Fpm / this.eta_m;
        return viscosity0 / 10.0;
    }

    public void CalcFij() {
        this.fij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.fij[i][j] = Math.pow(this.tbs.compProp[i].Tc / this.TcR * this.tbs.compProp[j].Tc / this.TcR, 0.5);
                ++j;
            }
            ++i;
        }
    }

    public void CalcHij() {
        this.hij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.hij[i][j] = Math.pow(Math.pow(this.tbs.compProp[i].Vc / this.VcR, 0.3333333) + Math.pow(this.tbs.compProp[j].Vc / this.VcR, 0.3333333), 3.0) / 8.0;
                ++j;
            }
            ++i;
        }
    }

    public void CalcHm() {
        this.CalcHij();
        this.hm = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.hm += this.tbs.zz[i] * this.tbs.zz[j] * this.hij[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void CalcFm() {
        this.CalcFij();
        this.CalcHm();
        double sumFH = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                sumFH += this.tbs.zz[i] * this.tbs.zz[j] * this.hij[i][j] * this.fij[i][j];
                ++j;
            }
            ++i;
        }
        this.fm = sumFH / this.hm;
    }

    public void CalcMij() {
        this.Mij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.Mij[i][j] = 2.0 * this.tbs.compProp[i].M * this.tbs.compProp[j].M / (this.tbs.compProp[i].M + this.tbs.compProp[j].M);
                ++j;
            }
            ++i;
        }
    }

    public double CalcFViscoM() {
        this.CalcFij();
        this.CalcHij();
        this.CalcHm();
        this.CalcMij();
        double fEtaM = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                fEtaM += this.tbs.zz[i] * this.tbs.zz[j] * Math.pow(this.fij[i][j] * this.Mij[i][j], 0.5) * Math.pow(this.hij[i][j], 1.3333333333);
                ++j;
            }
            ++i;
        }
        fEtaM = fEtaM / this.hm / this.hm * Math.pow(this.M0, -0.5);
        return fEtaM;
    }

    public void CalcSigma_i() {
        this.sigma_i = new double[this.tbs.nbComponents];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            this.sigma_i[i] = 4.771 * Math.pow(this.tbs.compProp[i].Vc / this.VcR, 0.3333333);
            ++i;
        }
    }

    public void CalcEpsilon(double rho) {
        double sumZsigma = 0.0;
        this.CalcSigma_i();
        int i = 0;
        while (i < this.tbs.nbComponents) {
            sumZsigma += this.tbs.zz[i] * Math.pow(this.sigma_i[i], 3.0);
            ++i;
        }
        this.epsilonVisco = 3.1536353716333333E-4 * rho * sumZsigma;
    }

    public void CalcTheta_ij() {
        this.theta_ij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        this.CalcSigma_i();
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                double num = 0.0;
                double den = 0.0;
                int k = 0;
                while (k < this.tbs.nbComponents) {
                    num += this.tbs.zz[k] * this.sigma_i[k] * this.sigma_i[k];
                    den += this.tbs.zz[k] * this.sigma_i[k] * this.sigma_i[k] * this.sigma_i[k];
                    ++k;
                }
                this.theta_ij[i][j] = this.sigma_i[i] * this.sigma_i[j] / (this.sigma_i[i] + this.sigma_i[j]) * num / den;
                ++j;
            }
            ++i;
        }
    }

    public void CalcG_ij(double rho) {
        this.gij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        this.CalcTheta_ij();
        this.CalcEpsilon(rho);
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.gij[i][j] = 1.0 / (1.0 - this.epsilonVisco) + 3.0 * this.epsilonVisco / Math.pow(1.0 - this.epsilonVisco, 2.0) * this.theta_ij[i][j] + 2.0 * this.epsilonVisco * this.epsilonVisco / Math.pow(1.0 - this.epsilonVisco, 3.0) * this.theta_ij[i][j] * this.theta_ij[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void CalcEta_ij(double T) {
        this.eta_ij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        this.CalcMij();
        this.CalcSigma_i();
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                this.eta_ij[i][j] = 26.69 * Math.pow(this.Mij[i][j] * T, 0.5) / Math.pow((this.sigma_i[i] + this.sigma_i[j]) / 2.0, 2.0);
                ++j;
            }
            ++i;
        }
    }

    public void CalcBij(double TT, double rho) {
        this.CalcG_ij(rho);
        this.CalcEta_ij(TT);
        this.Bij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        this.Kroenecker2[0][0] = 1.0;
        this.Kroenecker2[1][1] = 1.0;
        double sum = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                int k = 0;
                while (k < this.tbs.nbComponents) {
                    sum += this.tbs.zz[i] * this.tbs.zz[k] * this.gij[i][k] / this.eta_ij[i][k] * Math.pow(this.tbs.compProp[k].M / (this.tbs.compProp[i].M + this.tbs.compProp[k].M), 2.0) * ((1.0 + 1.0 * this.tbs.compProp[i].M / this.tbs.compProp[k].M) * this.Kroenecker2[i][j] - 0.0 * this.tbs.compProp[i].M / this.tbs.compProp[k].M * this.Kroenecker2[i][k]);
                    ++k;
                }
                this.Bij[i][j] = sum * 2.0;
                sum = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public void CalcYi(double rho) {
        this.CalcSigma_i();
        this.CalcG_ij(rho);
        this.Yi = new double[this.tbs.nbComponents];
        int i = 0;
        while (i < this.tbs.nbComponents) {
            double sum = 0.0;
            int j = 0;
            while (j < this.tbs.nbComponents) {
                sum += this.tbs.zz[j] * this.tbs.compProp[j].M / (this.tbs.compProp[j].M + this.tbs.compProp[i].M) * Math.pow((this.sigma_i[i] + this.sigma_i[j]) / 2.0, 3.0) * this.gij[i][j];
                ++j;
            }
            this.Yi[i] = this.tbs.zz[i] * (1.0 + 0.0010091633189226665 * rho * sum);
            ++i;
        }
    }

    public void CalcBeta_i(double TT, double rho) {
        this.CalcBij(TT, rho);
        this.CalcYi(rho);
        this.beta_i = new double[2];
        this.beta_i[0] = (this.Bij[1][1] * this.Yi[0] - this.Bij[0][1] * this.Yi[1]) / (this.Bij[0][0] * this.Bij[1][1] - this.Bij[1][0] * this.Bij[0][1]);
        this.beta_i[1] = (this.Bij[0][0] * this.Yi[1] - this.Bij[1][0] * this.Yi[0]) / (this.Bij[0][0] * this.Bij[1][1] - this.Bij[1][0] * this.Bij[0][1]);
    }

    public double CalcDeltaViscoEnskog(double TT, double rho) {
        this.CalcBeta_i(TT, rho);
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                sum2 += this.tbs.zz[i] * this.tbs.zz[j] * Math.pow((this.sigma_i[i] + this.sigma_i[j]) / 2.0, 6.0) * this.eta_ij[i][j] * this.gij[i][j];
                ++j;
            }
            sum1 += this.beta_i[i] * this.Yi[i];
            ++i;
        }
        sum1 += sum2 * 9.725E-7 * rho * rho;
        this.CalcSigmaX();
        this.CalcGx(rho);
        double Yx = this.CalcYx(rho);
        double Bx = this.CalcBx(TT, rho);
        double betaX = Yx / Bx;
        double enskogZero = this.CalcViscoEnskogXZero(TT);
        double enskogX = betaX * Yx + 9.725E-7 * rho * rho * Math.pow(this.sigmaX, 6.0) * enskogZero * this.gx;
        return (sum1 - enskogX) / 10.0;
    }

    public void CalcSigmaX() {
        this.CalcSigma_i();
        double sum = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                sum += this.tbs.zz[i] * this.tbs.zz[j] * Math.pow((this.sigma_i[i] + this.sigma_i[j]) / 2.0, 3.0);
                ++j;
            }
            ++i;
        }
        this.sigmaX = Math.pow(sum, 0.333333333);
    }

    public void CalcMx() {
        this.CalcMij();
        this.CalcSigmaX();
        double sum = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                sum += this.tbs.zz[i] * this.tbs.zz[j] * Math.pow((this.sigma_i[i] + this.sigma_i[j]) / 2.0, 4.0) * Math.pow(this.Mij[i][j], 0.5);
                ++j;
            }
            ++i;
        }
        this.Mx = Math.pow(sum, 2.0) * Math.pow(this.sigmaX, -8.0);
    }

    public double CalcViscoEnskogXZero(double TT) {
        this.CalcMx();
        double res = 0.0;
        res = 26.69 * Math.pow(this.Mx * TT, 0.5) / this.sigmaX / this.sigmaX;
        return res;
    }

    public void CalcGx(double rho) {
        this.CalcSigmaX();
        double e = 3.1536353716333333E-4 * rho * Math.pow(this.sigmaX, 3.0);
        this.gx = 1.0 / (1.0 - e) + 3.0 * e / (1.0 - e) / (1.0 - e) / 2.0 + e * e / (2.0 * (1.0 - e) * (1.0 - e) * (1.0 - e));
    }

    public double CalcBx(double TT, double rho) {
        this.CalcGx(rho);
        double eta = this.CalcViscoEnskogXZero(TT);
        double res = this.gx / eta;
        return res;
    }

    public double CalcYx(double rho) {
        this.CalcSigmaX();
        this.CalcGx(rho);
        double Yx = 1.0 + 0.0010091633189226665 * rho * Math.pow(this.sigmaX, 3.0) * this.gx / 2.0;
        return Yx;
    }

    public double WilkeMethode(double TT) {
        this.CalcAij(TT);
        double res = 0.0;
        double den = 0.0;
        double[] eta0 = new double[this.tbs.nbComponents];
        int ii = 0;
        while (ii < this.tbs.nbComponents) {
            eta0[ii] = this.ChapmanEnskog(TT, this.tbs.compProp[ii].M, this.tbs.compProp[ii].Tc, this.tbs.compProp[ii].Vc);
            ++ii;
        }
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                den += this.tbs.zz[j] * this.Aij[i][j];
                ++j;
            }
            res += this.tbs.zz[i] * eta0[i] / den;
            den = 0.0;
            ++i;
        }
        return res;
    }

    public double CalcViscosityMixture(double TT, double rho) {
        double res = 0.0;
        this.CalcFpm0(TT);
        this.CalcHm();
        this.CalcFm();
        double ideal = 0.0;
        double test = 1.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            test *= this.tbs.compProp[i].dipole;
            ++i;
        }
        ideal = test == 0.0 ? this.WilkeMethode(TT) : this.viscosityM0(TT);
        double rhoEnL = rho / 1000.0;
        double enskog = this.CalcDeltaViscoEnskog(TT, rhoEnL);
        double TT0 = TT / this.fm;
        double eta_R = this.VFR2003(TT0, rho, this.hm);
        double Fvisco = this.CalcFViscoM();
        res = ideal + eta_R * Fvisco + enskog;
        return res;
    }

    public double CalcViscosityMixture1996(double TT, double rho) {
        double res = 0.0;
        this.CalcFpm0(TT);
        this.CalcHm();
        this.CalcFm();
        double ideal = 0.0;
        double test = 1.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            test *= this.tbs.compProp[i].dipole;
            ++i;
        }
        ideal = test == 0.0 ? this.WilkeMethode(TT) : this.viscosityM0(TT);
        double rhoEnL = rho / 1000.0;
        double enskog = this.CalcDeltaViscoEnskog(TT, rhoEnL);
        double TT0 = TT / this.fm;
        double eta_R = this.VFR(TT0, rho, this.hm);
        double Fvisco = this.CalcFViscoM();
        res = ideal + eta_R * Fvisco + enskog;
        return res;
    }

    public void CalcAij(double TT) {
        this.Aij = new double[this.tbs.nbComponents][this.tbs.nbComponents];
        double RTTC = 0.0;
        double e = 1.0;
        double viscosity0 = 0.0;
        double[] lamda0 = new double[this.tbs.nbComponents];
        int ii = 0;
        while (ii < this.tbs.nbComponents) {
            if (this.tbs.compProp[ii].dipole == 0.0) {
                viscosity0 = this.ChapmanEnskog(TT, this.tbs.compProp[ii].M, this.tbs.compProp[ii].Tc, this.tbs.compProp[ii].Vc);
            } else {
                double Fp0 = this.Fp0(this.tbs.compProp[ii].Zc, TT, this.tbs.compProp[ii].Tc, this.tbs.compProp[ii].Pc, this.tbs.compProp[ii].dipole);
                double E = this.E(this.tbs.compProp[ii].Tc, this.tbs.compProp[ii].Pc, this.tbs.compProp[ii].M);
                viscosity0 = this.Lucas(TT, this.tbs.compProp[ii].Tc, Fp0, E);
            }
            lamda0[ii] = this.Lamda0(TT, viscosity0, this.tbs.compProp[ii].M, ii);
            ++ii;
        }
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                double coeff = Math.pow(this.tbs.compProp[j].Tc * Math.pow(this.tbs.compProp[j].M, 3.0) / Math.pow(this.tbs.compProp[j].Pc, 4.0), 0.1666666667) / Math.pow(this.tbs.compProp[i].Tc * Math.pow(this.tbs.compProp[i].M, 3.0) / Math.pow(this.tbs.compProp[i].Pc, 4.0), 0.1666666667);
                RTTC = coeff * (Math.exp(0.0464 * TT / this.tbs.compProp[i].Tc) - Math.exp(-0.2412 * TT / this.tbs.compProp[i].Tc)) / (Math.exp(0.0464 * TT / this.tbs.compProp[j].Tc) - Math.exp(-0.2412 * TT / this.tbs.compProp[j].Tc));
                this.Aij[i][j] = e * Math.pow(1.0 + Math.pow(RTTC, 0.5) * Math.pow(this.tbs.compProp[i].M / this.tbs.compProp[j].M, 0.25), 2.0) / Math.pow(8.0 * (1.0 + this.tbs.compProp[i].M / this.tbs.compProp[j].M), 0.5);
                ++j;
            }
            ++i;
        }
    }

    public double CalcLamdaMixtureZero(double TT) {
        this.CalcAij(TT);
        double res = 0.0;
        double den = 0.0;
        double[] lamda0 = new double[this.tbs.nbComponents];
        int ii = 0;
        while (ii < this.tbs.nbComponents) {
            double eta = this.ChapmanEnskog(TT, this.tbs.compProp[ii].M, this.tbs.compProp[ii].Tc, this.tbs.compProp[ii].Vc);
            lamda0[ii] = this.Lamda0(TT, eta, this.tbs.compProp[ii].M, ii);
            ++ii;
        }
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                den += this.tbs.zz[j] * this.Aij[i][j];
                ++j;
            }
            res += this.tbs.zz[i] * lamda0[i] / den;
            den = 0.0;
            ++i;
        }
        return res;
    }

    public double CalcFLamdaM() {
        this.CalcFij();
        this.CalcHij();
        this.CalcHm();
        this.CalcMij();
        double fLamdaM = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            int j = 0;
            while (j < this.tbs.nbComponents) {
                fLamdaM += this.tbs.zz[i] * this.tbs.zz[j] * Math.pow(this.fij[i][j] / this.Mij[i][j], 0.5) * Math.pow(this.hij[i][j], 1.3333333333);
                ++j;
            }
            ++i;
        }
        fLamdaM = fLamdaM / this.hm / this.hm * Math.pow(this.M0, 0.5);
        return fLamdaM;
    }

    public double AcentricFactorM() {
        double acentricFactorM = 0.0;
        int i = 0;
        while (i < this.tbs.nbComponents) {
            acentricFactorM += this.tbs.zz[i] * this.tbs.compProp[i].omega;
            ++i;
        }
        return acentricFactorM;
    }

    public double CalcXLamdaM1996() {
        double omegaM = 0.0;
        omegaM = this.AcentricFactorM();
        double XLamdaM = Math.pow(1.0 + 2.1866 * (omegaM - this.omegaR) / (1.0 - 0.505 * (omegaM - this.omegaR)), 0.5);
        return XLamdaM;
    }

    public double CalcConductivityMixture(double TT, double rho) {
        double res = 0.0;
        this.CalcHm();
        this.CalcFm();
        double ideal = this.CalcLamdaMixtureZero(TT);
        double T0 = TT / this.fm;
        double lamdaR = this.LamdaFR2003(T0, rho, this.hm) * 0.001;
        double FLamdaM = this.CalcFLamdaM();
        res = ideal + lamdaR * FLamdaM;
        return res;
    }

    public double CalcConductivityMixture1996(double TT, double rho) {
        double res = 0.0;
        this.CalcHm();
        this.CalcFm();
        double ideal = this.CalcLamdaMixtureZero(TT);
        double T0 = TT / this.fm;
        double lamdaR = this.LamdaFR(T0, rho, this.hm) * 0.001;
        double FLamdaM = this.CalcFLamdaM();
        double XLamdaM = this.CalcXLamdaM1996();
        res = ideal + lamdaR * FLamdaM * XLamdaM;
        return res;
    }
}

