/*
 * Decompiled with CFR 0.152.
 */
package bibCTP.trapp;

import bibCTP.CTPbibSubstance;
import bibCTP.trapp.Huber;

public class Huber96_pur
extends Huber {
    public Huber96_pur(CTPbibSubstance tbs) {
        super(tbs);
    }

    public double[] CalcViscosityConductivity(double TT, double rho) {
        double[] res = new double[2];
        double v = 1.0 / rho;
        res = this.tbs.nbTrapp == 1 ? this.HUBER1996(TT, v) : this.HUBER2003(TT, v);
        double T_r = TT / this.tbs.compProp[0].Tc;
        if (rho < 1.0) {
            res[0] = res[0] * (this.vapViscCorr[0] + this.vapViscCorr[1] * T_r + this.vapViscCorr[2] * T_r * T_r + this.vapViscCorr[3] / (1.0 - T_r));
            res[1] = res[1] * (this.vapCondCorr[0] + this.vapCondCorr[1] * T_r + this.vapCondCorr[2] * T_r * T_r + this.vapCondCorr[3] / (1.0 - T_r));
        } else {
            res[0] = res[0] * (this.liqViscCorr[0] + this.liqViscCorr[1] * T_r + this.liqViscCorr[2] * T_r * T_r + this.liqViscCorr[3] / (1.0 - T_r));
            res[1] = res[1] * (this.liqCondCorr[0] + this.liqCondCorr[1] * T_r + this.liqCondCorr[2] * T_r * T_r + this.liqCondCorr[3] / (1.0 - T_r));
        }
        res[0] = res[0] * 1.0E-6;
        return res;
    }

    public double[] HUBER2003(double T, double v) {
        double[] res = new double[2];
        double[] fh = this.SearchForFH(T, v);
        double rho = 1.0 / v;
        double T0 = T / fh[0];
        double viscosity0 = 0.0;
        double Fp0 = 0.0;
        double E = 0.0;
        if (this.tbs.compProp[0].dipole == 0.0) {
            viscosity0 = this.ChapmanEnskog(T, this.tbs.compProp[0].M, this.tbs.compProp[0].Tc, this.tbs.compProp[0].Vc);
        } else {
            Fp0 = this.Fp0(this.tbs.compProp[0].Zc, T, this.tbs.compProp[0].Tc, this.tbs.compProp[0].Pc, this.tbs.compProp[0].dipole);
            E = this.E(this.tbs.compProp[0].Tc, this.tbs.compProp[0].Pc, this.tbs.compProp[0].M);
            viscosity0 = this.Lucas(T, this.tbs.compProp[0].Tc, Fp0, E);
        }
        double vFR2003 = this.VFR2003(T0, rho, fh[1]);
        double fVisco = this.FVisco(this.tbs.compProp[0].M, fh[0], fh[1]);
        double viscosityHuber = this.Huber2003v(viscosity0, fVisco, vFR2003);
        double conductivity0 = this.Lamda0(T, viscosity0, this.tbs.compProp[0].M, this.tbs.nbComponents - 1);
        double lamdaFR2003 = this.LamdaFR2003(T0, rho, fh[1]) * 0.001;
        double xlamda = this.XLamda(this.tbs.compProp[0].omega);
        double fLamda = this.FLamda(this.tbs.compProp[0].M, fh[0], fh[1]);
        double lamdaHuber = this.Huber2003c(conductivity0, fLamda, lamdaFR2003, xlamda);
        res[0] = viscosityHuber;
        res[1] = lamdaHuber;
        return res;
    }

    public double[] HUBER1996(double T, double v) {
        double viscosity0;
        double[] res = new double[2];
        double[] fh = this.SearchForFH(T, v);
        double rho = 1.0 / v;
        double T0 = T / fh[0];
        if (this.tbs.compProp[0].dipole == 0.0) {
            viscosity0 = this.ChapmanEnskog(T, this.tbs.compProp[0].M, this.tbs.compProp[0].Tc, this.tbs.compProp[0].Vc);
        } else {
            double Fp0 = this.Fp0(this.tbs.compProp[0].Zc, T, this.tbs.compProp[0].Tc, this.tbs.compProp[0].Pc, this.tbs.compProp[0].dipole);
            double E = this.E(this.tbs.compProp[0].Tc, this.tbs.compProp[0].Pc, this.tbs.compProp[0].M);
            viscosity0 = this.Lucas(T, this.tbs.compProp[0].Tc, Fp0, E);
        }
        double vFR = this.VFR(T0, rho, fh[1]);
        double fVisco = this.FVisco1996(this.tbs.compProp[0].M, fh[0], fh[1]);
        double viscosityHuber = this.Huber2003v(viscosity0, fVisco, vFR);
        double conductivity0 = this.Lamda0(T, viscosity0, this.tbs.compProp[0].M, this.tbs.nbComponents - 1);
        double lamdaFR = this.LamdaFR(T0, rho, fh[1]) * 0.001;
        double xlamda = this.XLamda(this.tbs.compProp[0].omega);
        double fLamda1996 = this.FLamda(this.tbs.compProp[0].M, fh[0], fh[1]);
        double lamdaHuber = this.Huber1996c(conductivity0, fLamda1996, lamdaFR, xlamda);
        res[0] = viscosityHuber;
        res[1] = lamdaHuber;
        return res;
    }
}

