/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPainter;

public class LayerManager
implements Serializable {
    protected Vector _layers = new Vector();
    protected Layer _activeLayer;
    public Editor _editor = null;

    public void addLayer(Layer layer) {
        if (this.findLayerNamed(layer.getName()) == null) {
            this._layers.addElement(layer);
            layer.addEditor(this._editor);
            this.setActiveLayer(layer);
        }
    }

    public void removeAllLayers() {
        this._layers.removeAllElements();
        this._activeLayer = null;
    }

    public void replaceActiveLayer(Layer layer) {
        this._activeLayer.removeEditor(this._editor);
        int n = this._layers.indexOf(this._activeLayer);
        this._layers.setElementAt(layer, n);
        layer.addEditor(this._editor);
        this.setActiveLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this._layers.removeElement(layer);
        layer.removeEditor(this._editor);
        if (this._activeLayer == layer) {
            this._activeLayer = this._layers.size() >= 1 ? (Layer)this._layers.elementAt(0) : null;
        }
    }

    public Layer findLayerNamed(String string) {
        Enumeration enumeration = this._layers.elements();
        while (enumeration.hasMoreElements()) {
            Layer layer = (Layer)enumeration.nextElement();
            Layer layer2 = layer.findLayerNamed(string);
            if (layer2 == null) continue;
            return layer2;
        }
        return null;
    }

    public void setActiveLayer(Layer layer) {
        if (this._layers.contains(layer)) {
            this._activeLayer = layer;
        } else {
            System.out.println("That layer is not one of my layers");
        }
    }

    public Layer getActiveLayer() {
        return this._activeLayer;
    }

    public Vector getContents() {
        return this._activeLayer == null ? null : this._activeLayer.getContents();
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, FigPainter figPainter) {
        Enumeration enumeration = this._layers.elements();
        while (enumeration.hasMoreElements()) {
            ((Layer)enumeration.nextElement()).paint(graphics, figPainter);
        }
    }

    public void add(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.add(fig);
        }
    }

    public void remove(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.remove(fig);
        }
    }

    public void removeAll() {
        if (this._activeLayer != null) {
            this._activeLayer.removeAll();
        }
    }

    public Enumeration elements() {
        return this._activeLayer == null ? null : this._activeLayer.elements();
    }

    public Fig hit(Rectangle rectangle) {
        return this._activeLayer == null ? null : this._activeLayer.hit(rectangle);
    }

    public Fig presentationFor(Object object) {
        Fig fig = null;
        Enumeration enumeration = this._layers.elements();
        while (enumeration.hasMoreElements()) {
            Layer layer = (Layer)enumeration.nextElement();
            fig = layer.presentationFor(object);
            if (fig == null) continue;
            return fig;
        }
        return null;
    }

    public void sendToBack(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.sendToBack(fig);
        }
    }

    public void bringForward(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.bringForward(fig);
        }
    }

    public void sendBackward(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.sendBackward(fig);
        }
    }

    public void bringToFront(Fig fig) {
        if (this._activeLayer != null) {
            this._activeLayer.bringToFront(fig);
        }
    }

    public void reorder(Fig fig, int n) {
        if (this._activeLayer != null) {
            this._activeLayer.reorder(fig, n);
        }
    }

    public void setEditor(Editor editor) {
        this._editor = editor;
        Enumeration enumeration = this._layers.elements();
        while (enumeration.hasMoreElements()) {
            ((Layer)enumeration.nextElement()).addEditor(editor);
        }
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void preSave() {
        int n = 0;
        while (n < this._layers.size()) {
            ((Layer)this._layers.elementAt(n)).preSave();
            ++n;
        }
    }

    public void postSave() {
        int n = 0;
        while (n < this._layers.size()) {
            ((Layer)this._layers.elementAt(n)).postSave();
            ++n;
        }
    }

    public void postLoad() {
        int n = 0;
        while (n < this._layers.size()) {
            ((Layer)this._layers.elementAt(n)).postLoad();
            ++n;
        }
    }

    public LayerManager(Editor editor) {
        this._editor = editor;
    }
}

