/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class ModeCreateFigPoly
extends ModeCreate {
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);

    public String instructions() {
        return "Click to add a point; Double-click to finish";
    }

    public Fig createNewItem(MouseEvent mouseEvent, int n, int n2) {
        FigPoly figPoly = new FigPoly(n, n2);
        figPoly.addPoint(n, n2);
        this._startX = this._lastX = n;
        this._startY = this._lastY = n2;
        this._npoints = 2;
        return figPoly;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._npoints == 0) {
            super.mousePressed(mouseEvent);
        }
        if (!this.nearLast(n, n2)) {
            this._editor.damaged(this._newItem);
            Point point = new Point(n, n2);
            this._editor.snap(point);
            ((FigPoly)this._newItem).addPoint(point.x, point.y);
            ++this._npoints;
            this._editor.damaged(this._newItem);
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._npoints > 2 && this.nearLast(n, n2)) {
            FigPoly figPoly = (FigPoly)this._newItem;
            this._editor.damaged(this._newItem);
            this._handle.index = figPoly.getNumPoints() - 1;
            figPoly.moveVertex(this._handle, this._startX, this._startY, true);
            this._npoints = 0;
            this._editor.damaged(figPoly);
            this._editor.add(figPoly);
            this._editor.getSelectionManager().select(figPoly);
            this._newItem = null;
            this.done();
            mouseEvent.consume();
            return;
        }
        this._lastX = n;
        this._lastY = n2;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._npoints == 0) {
            mouseEvent.consume();
            return;
        }
        FigPoly figPoly = (FigPoly)this._newItem;
        this._editor.damaged(this._newItem);
        Point point = new Point(n, n2);
        this._editor.snap(point);
        this._handle.index = figPoly.getNumPoints() - 1;
        figPoly.moveVertex(this._handle, point.x, point.y, true);
        this._editor.damaged(this._newItem);
        mouseEvent.consume();
    }

    protected boolean nearLast(int n, int n2) {
        return n > this._lastX - 8 && n < this._lastX + 8 && n2 > this._lastY - 8 && n2 < this._lastY + 8;
    }
}

