/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeBroom;
import org.tigris.gef.base.ModeModify;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public class ModeSelect
extends Mode {
    private Point _selectAnchor = new Point(0, 0);
    private Rectangle _selectRect = new Rectangle(0, 0, 0, 0);
    private boolean _showSelectRect = false;
    private boolean _toggleSelection = false;

    public boolean canExit() {
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getModifiers() == 4) {
            return;
        }
        if (mouseEvent.isControlDown()) {
            this.gotoBroomMode(mouseEvent);
            return;
        }
        if (mouseEvent.isAltDown()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this._selectAnchor = new Point(n, n2);
        this._selectRect.setBounds(n, n2, 0, 0);
        this._toggleSelection = mouseEvent.isShiftDown();
        SelectionManager selectionManager = this._editor.getSelectionManager();
        Rectangle rectangle = new Rectangle(n - 4, n2 - 4, 8, 8);
        Fig fig = this._editor.hit(this._selectAnchor);
        if (fig == null && !selectionManager.hit(rectangle)) {
            return;
        }
        Handle handle = new Handle(-1);
        selectionManager.hitHandle(new Rectangle(n - 4, n2 - 4, 8, 8), handle);
        if (handle.index >= 0) {
            this.gotoModifyMode(mouseEvent);
            mouseEvent.consume();
            return;
        }
        if (fig != null) {
            if (this._toggleSelection) {
                selectionManager.toggle(fig);
            } else if (!selectionManager.containsFig(fig)) {
                selectionManager.select(fig);
            }
        }
        if (selectionManager.hit(rectangle)) {
            this.gotoModifyMode(mouseEvent);
        }
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isAltDown()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this._showSelectRect = true;
        int n3 = Math.min(this._selectAnchor.x, n);
        int n4 = Math.min(this._selectAnchor.y, n2);
        int n5 = Math.max(this._selectAnchor.x, n) - n3;
        int n6 = Math.max(this._selectAnchor.y, n2) - n4;
        this._editor.damaged(this._selectRect);
        this._selectRect.setBounds(n3, n4, n5, n6);
        this._editor.damaged(this._selectRect);
        this._editor.scrollToShow(n, n2);
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Fig fig;
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this._showSelectRect = false;
        Vector<Fig> vector = new Vector<Fig>();
        Rectangle rectangle = new Rectangle(n - 4, n2 - 4, 8, 8);
        Enumeration enumeration = this._editor.figs();
        while (enumeration.hasMoreElements()) {
            fig = (Fig)enumeration.nextElement();
            if ((this._toggleSelection || !this._selectRect.isEmpty() || !fig.hit(rectangle)) && (this._selectRect.isEmpty() || !fig.within(this._selectRect))) continue;
            vector.addElement(fig);
        }
        if (!this._selectRect.isEmpty() && vector.isEmpty()) {
            enumeration = this._editor.figs();
            while (enumeration.hasMoreElements()) {
                fig = (Fig)enumeration.nextElement();
                if (!fig.intersects(this._selectRect)) continue;
                vector.addElement(fig);
            }
        }
        if (this._toggleSelection) {
            this._editor.getSelectionManager().toggle(vector);
        } else {
            this._editor.getSelectionManager().select(vector);
        }
        this._selectRect.grow(1, 1);
        this._editor.damaged(this._selectRect);
        if (mouseEvent.getModifiers() == 4) {
            return;
        }
        mouseEvent.consume();
    }

    public String instructions() {
        return "  ";
    }

    public void paint(Graphics graphics) {
        if (this._showSelectRect) {
            Color color = Globals.getPrefs().getRubberbandColor();
            graphics.setColor(color);
            graphics.drawRect(this._selectRect.x, this._selectRect.y, this._selectRect.width, this._selectRect.height);
        }
    }

    protected void gotoModifyMode(MouseEvent mouseEvent) {
        ModeModify modeModify = new ModeModify(this._editor);
        this._editor.mode(modeModify);
        ((Mode)modeModify).mousePressed(mouseEvent);
    }

    protected void gotoBroomMode(MouseEvent mouseEvent) {
        ModeBroom modeBroom = new ModeBroom(this._editor);
        this._editor.mode(modeBroom);
        ((Mode)modeBroom).mousePressed(mouseEvent);
    }

    public ModeSelect(Editor editor) {
        super(editor);
    }

    public ModeSelect() {
    }
}

