/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public class SelectionResize
extends Selection {
    private int cx;
    private int cy;
    private int cw;
    private int ch;

    public void hitHandle(Rectangle rectangle, Handle handle) {
        this.updateHandleBox();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.setBounds(this.cx - 3, this.cy - 3, 6, this.ch + 3);
        boolean bl = rectangle.intersects(rectangle2);
        rectangle2.setBounds(this.cx + this.cw - 3, this.cy - 3, 6, this.ch + 3);
        boolean bl2 = rectangle.intersects(rectangle2);
        rectangle2.setBounds(this.cx - 3, this.cy - 3, this.cw + 3, 6);
        boolean bl3 = rectangle.intersects(rectangle2);
        rectangle2.setBounds(this.cx - 3, this.cy + this.ch - 3, this.cw + 3, 6);
        boolean bl4 = rectangle.intersects(rectangle2);
        if (bl && bl3) {
            handle.index = 0;
            handle.instructions = "Resize top left";
        } else if (bl2 && bl3) {
            handle.index = 2;
            handle.instructions = "Resize top right";
        } else if (bl && bl4) {
            handle.index = 5;
            handle.instructions = "Resize bottom left";
        } else if (bl2 && bl4) {
            handle.index = 7;
            handle.instructions = "Resize bottom right";
        } else {
            handle.index = -1;
            handle.instructions = "Move object(s)";
        }
    }

    private void updateHandleBox() {
        Rectangle rectangle = this._content.getHandleBox();
        this.cx = rectangle.x;
        this.cy = rectangle.y;
        this.cw = rectangle.width;
        this.ch = rectangle.height;
    }

    public void paint(Graphics graphics) {
        this.updateHandleBox();
        graphics.setColor(Globals.getPrefs().handleColorFor(this._content));
        graphics.fillRect(this.cx - 3, this.cy - 3, 6, 6);
        graphics.fillRect(this.cx + this.cw - 3, this.cy - 3, 6, 6);
        graphics.fillRect(this.cx - 3, this.cy + this.ch - 3, 6, 6);
        graphics.fillRect(this.cx + this.cw - 3, this.cy + this.ch - 3, 6, 6);
        super.paint(graphics);
    }

    public void dragHandle(int n, int n2, int n3, int n4, Handle handle) {
        this.updateHandleBox();
        int n5 = this.cx;
        int n6 = this.cy;
        int n7 = this.cw;
        int n8 = this.ch;
        int n9 = n5;
        int n10 = n6;
        int n11 = n7;
        int n12 = n8;
        Dimension dimension = this._content.getMinimumSize();
        int n13 = dimension.width;
        int n14 = dimension.height;
        switch (handle.index) {
            case -1: {
                this._content.translate(n3 - n, n4 - n2);
                return;
            }
            case 0: {
                n11 = n5 + n7 - n;
                n11 = n11 < n13 ? n13 : n11;
                n12 = n6 + n8 - n2;
                n12 = n12 < n14 ? n14 : n12;
                n9 = n5 + n7 - n11;
                n10 = n6 + n8 - n12;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                n11 = n - n5;
                n11 = n11 < n13 ? n13 : n11;
                n12 = n6 + n8 - n2;
                n12 = n12 < n14 ? n14 : n12;
                n10 = n6 + n8 - n12;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                n11 = n5 + n7 - n;
                n11 = n11 < n13 ? n13 : n11;
                n12 = n2 - n6;
                n12 = n12 < n14 ? n14 : n12;
                n9 = n5 + n7 - n11;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                n11 = n - n5;
                n11 = n11 < n13 ? n13 : n11;
                n12 = n2 - n6;
                n12 = n12 < n14 ? n14 : n12;
                break;
            }
            default: {
                System.out.println("invalid handle number");
                break;
            }
        }
        this._content.setHandleBox(n9, n10, n11, n12);
    }

    public SelectionResize(Fig fig) {
        super(fig);
    }
}

