/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.demo;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class EventMeter
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static EventMeter SINGLETON = new EventMeter();
    public int clicks = 0;
    public int drags = 0;
    public int keys = 0;
    public int exits = 0;
    public boolean dragging = false;
    public int distance = 0;
    public int dragDistance = 0;
    public boolean counting = false;
    public int lastX = -1;
    public int lastY = -1;

    public void reset() {
        this.clicks = 0;
        this.drags = 0;
        this.keys = 0;
        this.exits = 0;
        this.dragging = false;
        this.distance = 0;
        this.dragDistance = 0;
        this.counting = true;
    }

    public void dump() {
        System.out.println("clicks = " + this.clicks);
        System.out.println("drags = " + this.drags);
        System.out.println("keys = " + this.keys);
        System.out.println("exits = " + this.exits);
        System.out.println("distance = " + this.distance);
        System.out.println("dragDistance = " + this.dragDistance);
    }

    public void setCounting(boolean bl) {
        this.counting = bl;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.counting) {
            return;
        }
        if (this.lastY != -1) {
            int n = mouseEvent.getX() - this.lastX;
            int n2 = mouseEvent.getY() - this.lastY;
            this.distance = (int)((double)this.distance + Math.sqrt(n * n + n2 * n2));
        }
        this.dragging = false;
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.counting) {
            return;
        }
        if (this.lastY != -1) {
            int n = mouseEvent.getX() - this.lastX;
            int n2 = mouseEvent.getY() - this.lastY;
            this.dragDistance = (int)((double)this.dragDistance + Math.sqrt(n * n + n2 * n2));
        }
        if (!this.dragging) {
            ++this.drags;
        }
        this.dragging = true;
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.counting) {
            return;
        }
        ++this.clicks;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.counting) {
            return;
        }
        ++this.exits;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this.counting) {
            return;
        }
        ++this.keys;
    }

    private EventMeter() {
    }
}

