/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.graph.MutableGraphSupport;

public abstract class AdjacencyListGraphModel
extends MutableGraphSupport
implements Serializable {
    public static String UNLABELED = "Unlabeled";
    protected Vector _nodes = new Vector();
    protected Vector _edges = new Vector();

    public boolean OK() {
        if (this._nodes == null) {
            return false;
        }
        if (this._edges == null) {
            return false;
        }
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (this.containsPort(objectArray[0]) && this.containsPort(objectArray[1])) continue;
            return false;
        }
        return true;
    }

    public Vector getNodes() {
        return this._nodes;
    }

    public Vector getEdges() {
        return this._edges;
    }

    public abstract Vector getPorts(Object var1);

    public abstract Object getOwner(Object var1);

    public Object getSourcePort(Object object) {
        Object[] objectArray = (Object[])object;
        return objectArray[0];
    }

    public Object getDestPort(Object object) {
        Object[] objectArray = (Object[])object;
        return objectArray[1];
    }

    public Vector getInEdges(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != objectArray[1]) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }

    public Vector getOutEdges(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != objectArray[0]) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }

    public boolean canAddNode(Object object) {
        return true;
    }

    public boolean canAddEdge(Object object) {
        return object instanceof Object[] && ((Object[])object).length == 3;
    }

    public void addNode(Object object) {
        this._nodes.addElement(object);
    }

    public void addEdge(Object object) {
        if (this.canAddEdge(object)) {
            this._edges.addElement(object);
        }
    }

    public void removeNode(Object object) {
        this._nodes.removeElement(object);
    }

    public void removeEdge(Object object) {
        this._edges.removeElement(object);
    }

    public boolean canConnect(Object object, Object object2) {
        return true;
    }

    public Object connect(Object object, Object object2) {
        return this.addLabeledEdge(object, object2, UNLABELED);
    }

    public Object getEdgeLabel(Object object) {
        Object[] objectArray = (Object[])object;
        return objectArray[2];
    }

    public Object addLabeledEdge(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        this.addEdge(objectArray);
        return objectArray;
    }

    public Vector getEdgesLabeled(Object object) {
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (object != this.getEdgeLabel(objectArray)) continue;
            vector.addElement(objectArray);
        }
        return vector;
    }

    public abstract void addNodeRelatedEdges(Object var1);
}

