/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.ui.Highlightable;

public class FigNode
extends FigGroup
implements MouseListener,
PropertyChangeListener,
Highlightable {
    public static final double ang45 = 0.7853981633974483;
    public static final double ang135 = 2.356194490192345;
    public static final double ang225 = 3.9269908169872414;
    public static final double ang315 = 5.497787143782138;
    protected boolean _blinkPorts = false;
    protected boolean _highlight = false;
    protected Vector _figEdges = new Vector();

    public Object clone() {
        FigNode figNode = (FigNode)super.clone();
        figNode._figEdges = (Vector)this._figEdges.clone();
        return figNode;
    }

    public void setBlinkPorts(boolean bl) {
        this._blinkPorts = bl;
        this.hidePorts();
    }

    public boolean getBlinkPorts() {
        return this._blinkPorts;
    }

    public void addFigEdge(FigEdge figEdge) {
        this._figEdges.addElement(figEdge);
    }

    public void removeFigEdge(FigEdge figEdge) {
        this._figEdges.removeElement(figEdge);
    }

    public Vector getFigEdges() {
        return this._figEdges;
    }

    public void setOwner(Object object) {
        Object object2 = this.getOwner();
        if (object2 instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object2).removePropertyChangeListener(this);
        } else if (object2 instanceof Highlightable) {
            ((Highlightable)object2).removePropertyChangeListener(this);
        }
        if (object instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object).addPropertyChangeListener(this);
        } else if (object instanceof Highlightable) {
            ((Highlightable)object).addPropertyChangeListener(this);
        }
        super.setOwner(object);
    }

    public boolean hit(Rectangle rectangle) {
        int n = this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this._filled) {
            return n > 0;
        }
        return n > 0 && n < 4;
    }

    public boolean contains(int n, int n2) {
        return this._x <= n && n <= this._x + this._w && this._y <= n2 && n2 <= this._y + this._h;
    }

    public void setEnclosingFig(Fig fig) {
        if (fig != null && fig != this.getEnclosingFig() && this._layer != null) {
            Enumeration enumeration = this._figEdges.elements();
            while (enumeration.hasMoreElements()) {
                Fig fig2 = (Fig)enumeration.nextElement();
                this._layer.bringInFrontOf(fig2, fig);
            }
        }
        super.setEnclosingFig(fig);
    }

    public void startTrans() {
        Enumeration enumeration = this._figEdges.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.startTrans();
        }
        super.startTrans();
    }

    public void endTrans() {
        Enumeration enumeration = this._figEdges.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.endTrans();
        }
        super.endTrans();
    }

    public void delete() {
        Enumeration enumeration = ((Vector)this._figEdges.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.delete();
        }
        super.delete();
    }

    public void dispose() {
        Enumeration enumeration = this._figEdges.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig.dispose();
        }
        super.dispose();
    }

    public void bindPort(Object object, Fig fig) {
        Fig fig2 = this.getPortFig(object);
        if (fig2 != null) {
            fig2.setOwner(null);
        }
        fig.setOwner(object);
    }

    public void removePort(Fig fig) {
        if (fig.getOwner() != null) {
            fig.setOwner(null);
        }
    }

    public final Object hitPort(Point point) {
        return this.hitPort(point.x, point.y);
    }

    public Object hitPort(int n, int n2) {
        Fig fig = this.hitFig(new Rectangle(n, n2, 1, 1));
        if (fig != null) {
            return fig.getOwner();
        }
        return null;
    }

    public Object deepHitPort(int n, int n2) {
        Object object;
        Cloneable cloneable;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Fig)enumeration.nextElement();
            object = cloneable.getOwner();
            if (!cloneable.contains(n, n2) || object == null) continue;
            return object;
        }
        cloneable = new Rectangle(n - 16, n2 - 16, 32, 32);
        enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            object = (Fig)enumeration.nextElement();
            Object object2 = ((Fig)object).getOwner();
            if (!((Fig)object).hit((Rectangle)cloneable) || object2 == null) continue;
            return object2;
        }
        return null;
    }

    public Fig getPortFig(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() != object) continue;
            return fig;
        }
        return null;
    }

    public Vector getPortFigs() {
        Vector<Fig> vector = new Vector<Fig>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() == null) continue;
            vector.addElement(fig);
        }
        return vector;
    }

    public int getPortSector(Fig fig) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = fig.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        int n3 = rectangle2.x + rectangle2.width / 2;
        int n4 = rectangle2.y + rectangle2.height / 2;
        if (fig != null) {
            int n5 = (n3 - n) * rectangle.height;
            int n6 = (n4 - n2) * rectangle.width;
            double d = Math.sqrt(n5 * n5 + n6 * n6);
            double d2 = n6 > 0 ? Math.acos((double)n5 / d) : Math.acos((double)n5 / d) + Math.PI;
            if (d2 < 0.7853981633974483) {
                return 2;
            }
            if (d2 < 2.356194490192345) {
                return 1;
            }
            if (d2 < 3.9269908169872414) {
                return -2;
            }
            if (d2 < 5.497787143782138) {
                return -1;
            }
            return 2;
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._highlight) {
            graphics.setColor(Globals.getPrefs().getHighlightColor());
            graphics.drawRect(this._x - 5, this._y - 5, this._w + 9, this._h + 8);
            graphics.drawRect(this._x - 4, this._y - 4, this._w + 7, this._h + 6);
            graphics.drawRect(this._x - 3, this._y - 3, this._w + 5, this._h + 4);
        }
    }

    public void setHighlight(boolean bl) {
        this._highlight = bl;
        this.damage();
    }

    public boolean getHighlight() {
        return this._highlight;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("dispose") && object == this.getOwner()) {
            this.delete();
        }
        if (string.equals("highlight") && object == this.getOwner()) {
            this.setHighlight((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public void showPorts() {
        this.startTrans();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() == null) continue;
            fig.setLineWidth(1);
            fig.setFilled(true);
        }
        this.endTrans();
    }

    public void hidePorts() {
        this.startTrans();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() == null) continue;
            fig.setLineWidth(0);
            fig.setFilled(false);
        }
        this.endTrans();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._blinkPorts) {
            this.showPorts();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this._blinkPorts) {
            this.hidePorts();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.updateEdges();
    }

    public void superTranslate(int n, int n2) {
        super.translate(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateEdges();
    }

    public void updateEdges() {
        Enumeration enumeration = this._figEdges.elements();
        while (enumeration.hasMoreElements()) {
            FigEdge figEdge = (FigEdge)enumeration.nextElement();
            figEdge.computeRoute();
        }
    }

    public void postLoad() {
        this.setOwner(this.getOwner());
    }

    public void cleanUp() {
        Enumeration enumeration = this._figEdges.elements();
        while (enumeration.hasMoreElements()) {
            FigEdge figEdge = (FigEdge)enumeration.nextElement();
            figEdge.cleanUp();
        }
    }

    public FigNode() {
    }

    public FigNode(Object object) {
        this.setOwner(object);
    }

    public FigNode(Object object, Vector vector) {
        this(object);
        this.setFigs(vector);
    }
}

