/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.util.Dbg;

public class FigPoly
extends Fig {
    protected static final double FUDGEFACTOR = 0.11;
    private static Handle _TempHandle = new Handle(0);
    protected int _npoints = 0;
    protected int[] _xpoints = new int[4];
    protected int[] _ypoints = new int[4];
    protected boolean _rectilinear = false;
    public boolean _isComplete = false;
    protected boolean _isSelfLoop = false;
    protected int _fixedHandles = -1;

    public Object clone() {
        FigPoly figPoly = (FigPoly)super.clone();
        figPoly._xpoints = (int[])this._xpoints.clone();
        figPoly._ypoints = (int[])this._ypoints.clone();
        return figPoly;
    }

    public boolean OK() {
        return super.OK() && this._npoints > 0 && this._xpoints != null && this._ypoints != null;
    }

    public Polygon getPolygon() {
        return new Polygon(this._xpoints, this._ypoints, this._npoints);
    }

    public void setPolygon(Polygon polygon) {
        this._npoints = polygon.npoints;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        System.arraycopy(polygon.xpoints, 0, this._xpoints, 0, this._npoints);
        System.arraycopy(polygon.ypoints, 0, this._ypoints, 0, this._npoints);
        this.calcBounds();
    }

    public void setSelfLoop(boolean bl) {
        this._isSelfLoop = bl;
    }

    public int getNumPoints() {
        return this._npoints;
    }

    public boolean getRectilinear() {
        return this._rectilinear;
    }

    public void setRectilinear(boolean bl) {
        this._rectilinear = bl;
    }

    public int getFixedHandles() {
        return this._fixedHandles;
    }

    public void setFixedHandles(int n) {
        this._fixedHandles = n;
    }

    public boolean isSelfLoop() {
        return this._isSelfLoop;
    }

    public void setEndPoints(Point point, Point point2) {
        while (this._npoints < 2) {
            this.addPoint(point);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigPoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, point.x, point.y, true);
            FigPoly._TempHandle.index = this._npoints - 1;
            this.moveVertex(_TempHandle, point2.x, point2.y, true);
        }
    }

    public void translate(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        int n3 = 0;
        while (n3 < this._npoints) {
            int n4 = n3;
            this._xpoints[n4] = this._xpoints[n4] + n;
            int n5 = n3++;
            this._ypoints[n5] = this._ypoints[n5] + n2;
        }
        this._x += n;
        this._y += n2;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void addPoint(int n, int n2) {
        this.growIfNeeded();
        this._xpoints[this._npoints] = n;
        this._ypoints[this._npoints] = n2;
        ++this._npoints;
        Rectangle rectangle = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public final void addPoint(Point point) {
        this.addPoint(point.x, point.y);
    }

    protected boolean canMoveVertex(int n, boolean bl) {
        return n >= 0 && n < this._npoints && (bl || n >= this._fixedHandles && n < this._npoints - this._fixedHandles);
    }

    public void moveVertex(Handle handle, int n, int n2, boolean bl) {
        int n3 = handle.index;
        if (!this._rectilinear) {
            this._xpoints[n3] = n;
            this._ypoints[n3] = n2;
        } else {
            if (bl) {
                this._xpoints[n3] = n;
                this._ypoints[n3] = n2;
            }
            if (n3 == this._fixedHandles) {
                this.prependTwoPoints();
                handle.index += 2;
                n3 += 2;
            }
            if (n3 == this._npoints - this._fixedHandles - 1) {
                this.appendTwoPoints();
            }
            if (n3 % 2 == 0) {
                if (this.canMoveVertex(n3 - 1, bl)) {
                    this._xpoints[n3 - 1] = n;
                    this._xpoints[n3] = n;
                }
                if (this.canMoveVertex(n3 + 1, bl)) {
                    this._ypoints[n3 + 1] = n2;
                    this._ypoints[n3] = n2;
                }
            } else {
                if (this.canMoveVertex(n3 - 1, bl)) {
                    this._ypoints[n3 - 1] = n2;
                    this._ypoints[n3] = n2;
                }
                if (this.canMoveVertex(n3 + 1, bl)) {
                    this._xpoints[n3 + 1] = n;
                    this._xpoints[n3] = n;
                }
            }
        }
        Rectangle rectangle = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    protected void prependTwoPoints() {
        int[] nArray = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, nArray, 2, this._npoints);
        this._xpoints = nArray;
        nArray = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, nArray, 2, this._npoints);
        this._ypoints = nArray;
        this._xpoints[0] = this._xpoints[1] = this._xpoints[2];
        this._ypoints[0] = this._ypoints[1] = this._ypoints[2];
        this._npoints += 2;
    }

    protected void appendTwoPoints() {
        int[] nArray = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
        this._xpoints = nArray;
        nArray = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
        this._ypoints = nArray;
        this._xpoints[this._npoints + 1] = this._xpoints[this._npoints] = this._xpoints[this._npoints - 1];
        this._ypoints[this._npoints + 1] = this._ypoints[this._npoints] = this._ypoints[this._npoints - 1];
        this._npoints += 2;
    }

    public void removePoint(int n) {
        Dbg.assert(n >= 0 && n < this._npoints, "point not found");
        if (this._npoints < 3) {
            return;
        }
        int[] nArray = new int[this._npoints];
        if (this._rectilinear && n != 0 && n != this._npoints - 1) {
            if (n % 2 == 0) {
                this._xpoints[n] = this._xpoints[n + 1];
                this._ypoints[n] = this._ypoints[n - 1];
            } else {
                this._xpoints[n] = this._xpoints[n - 1];
                this._ypoints[n] = this._ypoints[n + 1];
            }
        } else {
            System.arraycopy(this._xpoints, n + 1, nArray, 0, this._npoints - n - 1);
            System.arraycopy(nArray, 0, this._xpoints, n, this._npoints - n - 1);
            System.arraycopy(this._ypoints, n + 1, nArray, 0, this._npoints - n - 1);
            System.arraycopy(nArray, 0, this._ypoints, n, this._npoints - n - 1);
            --this._npoints;
        }
        Rectangle rectangle = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public void insertPoint(int n, int n2, int n3) {
        this.growIfNeeded();
        int[] nArray = new int[this._npoints];
        System.arraycopy(this._xpoints, n + 1, nArray, 0, this._npoints - n - 1);
        this._xpoints[n + 1] = n2;
        System.arraycopy(nArray, 0, this._xpoints, n + 2, this._npoints - n - 1);
        System.arraycopy(this._ypoints, n + 1, nArray, 0, this._npoints - n - 1);
        this._ypoints[n + 1] = n3;
        System.arraycopy(nArray, 0, this._ypoints, n + 2, this._npoints - n - 1);
        ++this._npoints;
        this.calcBounds();
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] nArray = new int[this._npoints * 2];
            System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
            this._xpoints = nArray;
            nArray = new int[this._npoints * 2];
            System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
            this._ypoints = nArray;
        }
    }

    public Point getPoints(int n) {
        return new Point(this._xpoints[n], this._ypoints[n]);
    }

    public Vector getPointsVector() {
        Vector<Point> vector = new Vector<Point>();
        int n = 0;
        while (n < this._npoints) {
            vector.addElement(new Point(this._xpoints[n], this._ypoints[n]));
            ++n;
        }
        return vector;
    }

    public Vector getPointsVectorNotFirst() {
        Vector<Point> vector = new Vector<Point>();
        int n = 1;
        while (n < this._npoints) {
            vector.addElement(new Point(this._xpoints[n], this._ypoints[n]));
            ++n;
        }
        return vector;
    }

    public Point getFirstPoint() {
        return this.getPoints(0);
    }

    public Point getLastPoint() {
        return this.getPoints(this._npoints - 1);
    }

    public void setPoints(Handle handle, int n, int n2) {
        this.moveVertex(handle, n, n2, false);
    }

    public void cleanUp() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 1;
        while (n < this._npoints - 1) {
            double d3;
            Point point = new Point(this._xpoints[n - 1], this._ypoints[n - 1]);
            Point point2 = new Point(this._xpoints[n], this._ypoints[n]);
            Point point3 = new Point(this._xpoints[n + 1], this._ypoints[n + 1]);
            if (point.equals(point2) || point3.equals(point2)) {
                this.removePoint(n);
                break;
            }
            double d4 = Geometry.segmentAngle(point, point2);
            double d5 = Math.abs(d4 - (d3 = Geometry.segmentAngle(point2, point3)));
            if (d5 < 0.11) {
                this.removePoint(n);
            }
            ++n;
        }
        this.calcBounds();
    }

    public Point getClosestPoint(Point point) {
        return Geometry.ptClosestTo(this._xpoints, this._ypoints, this._npoints, point);
    }

    public Vector getGravityPoints() {
        return this.getPointsVector();
    }

    public void paint(Graphics graphics) {
        if (this._filled && this._fillColor != null) {
            graphics.setColor(this._fillColor);
            graphics.fillPolygon(this._xpoints, this._ypoints, this._npoints);
        }
        if (this._lineWidth > 0 && this._lineColor != null) {
            graphics.setColor(this._lineColor);
            if (!this.getDashed()) {
                graphics.drawPolyline(this._xpoints, this._ypoints, this._npoints);
            } else {
                this.drawDashedPerimeter(graphics);
            }
        }
    }

    protected void drawDashedPerimeter(Graphics graphics) {
        int n = 0;
        int n2 = 1;
        while (n2 < this._npoints) {
            n = this.drawDashedLine(graphics, n, this._xpoints[n2 - 1], this._ypoints[n2 - 1], this._xpoints[n2], this._ypoints[n2]);
            ++n2;
        }
    }

    protected int findHandle(int n, int n2) {
        int n3 = 6;
        int[] nArray = this._xpoints;
        int[] nArray2 = this._ypoints;
        int n4 = 0;
        while (n4 < this._npoints) {
            if (n >= nArray[n4] - n3 / 2 && n2 >= nArray2[n4] - n3 / 2 && n <= nArray[n4] + n3 / 2 && n2 <= nArray2[n4] + n3 / 2) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public boolean contains(int n, int n2) {
        Polygon polygon = this.getPolygon();
        return polygon.contains(n, n2);
    }

    public int[] getXs() {
        return this._xpoints;
    }

    public int[] getYs() {
        return this._ypoints;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        if (n3 > 0 && n4 > 0) {
            int n5 = 0;
            while (n5 < this._npoints) {
                this._xpoints[n5] = n + (this._xpoints[n5] - this._x) * n3 / this._w;
                this._ypoints[n5] = n2 + (this._ypoints[n5] - this._y) * n4 / this._h;
                ++n5;
            }
            this._x = n;
            this._y = n2;
            this._w = n3;
            this._h = n4;
            this.firePropChange("bounds", rectangle, this.getBounds());
        }
    }

    public int getPerimeterLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._npoints - 1) {
            int n3 = this._xpoints[n2 + 1] - this._xpoints[n2];
            int n4 = this._ypoints[n2 + 1] - this._ypoints[n2];
            n += (int)Math.sqrt(n3 * n3 + n4 * n4);
            ++n2;
        }
        return n;
    }

    public void stuffPointAlongPerimeter(int n, Point point) {
        int n2 = 0;
        while (n2 < this._npoints - 1) {
            int n3 = this._xpoints[n2 + 1] - this._xpoints[n2];
            int n4 = this._ypoints[n2 + 1] - this._ypoints[n2];
            int n5 = (int)Math.sqrt(n3 * n3 + n4 * n4);
            if (n < n5) {
                if (n5 != 0) {
                    point.x = this._xpoints[n2] + n3 * n / n5;
                    point.y = this._ypoints[n2] + n4 * n / n5;
                    return;
                }
                point.x = this._xpoints[n2];
                point.y = this._ypoints[n2];
                return;
            }
            n -= n5;
            ++n2;
        }
        point.x = this._xpoints[0];
        point.y = this._ypoints[0];
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isReshapable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    protected int countCornersContained(int n, int n2, int n3, int n4) {
        Polygon polygon = this.getPolygon();
        int n5 = 0;
        if (polygon.contains(n, n2)) {
            ++n5;
        }
        if (polygon.contains(n + n3, n2)) {
            ++n5;
        }
        if (polygon.contains(n, n2 + n4)) {
            ++n5;
        }
        if (polygon.contains(n + n3, n2 + n4)) {
            ++n5;
        }
        return n5;
    }

    public boolean hit(Rectangle rectangle) {
        if (super.hit(rectangle)) {
            return true;
        }
        int n = 1;
        while (n < this._npoints) {
            if (Geometry.intersects(rectangle, this._xpoints[n - 1], this._ypoints[n - 1], this._xpoints[n], this._ypoints[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void calcBounds() {
        Rectangle rectangle = this.getPolygon().getBounds();
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height;
    }

    public FigPoly(Color color) {
        this.setLineColor(color);
    }

    public FigPoly(Color color, Color color2) {
        this.setLineColor(color);
        this.setFillColor(color2);
    }

    public FigPoly() {
    }

    public FigPoly(int n, int n2) {
        this();
        this.addPoint(n, n2);
    }
}

